/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.HealpixKey;
import cds.aladin.PlanBG;
import cds.tools.Util;
import cds.tools.pixtools.Hpix;
import java.io.File;

class HealpixAllsky
extends HealpixKey {
    protected int nbPix;
    protected HealpixKey[] pixList;
    private int mem;

    protected HealpixAllsky(PlanBG planBG, int order) {
        this(planBG, order, (int)planBG.getZ());
    }

    protected HealpixAllsky(PlanBG planBG, int order, int z) {
        this(planBG, order, z, 1);
    }

    protected HealpixAllsky(PlanBG planBG, int order, int z, int mode) {
        block3: {
            this.mem = 0;
            this.planBG = planBG;
            this.order = order;
            this.npix = -1L;
            this.z = z;
            this.allSky = true;
            this.resetTimer();
            String sZ = z <= 0 ? "" : "_" + z;
            String nameNet = "Norder" + order + "/Allsky" + sZ;
            String nameCache = planBG.getCacheName() + "/" + "Norder" + order + "/Allsky" + sZ;
            this.extCache = this.extNet = planBG.getTileMode();
            this.fileCache = nameCache + EXT[this.extCache];
            this.fileNet = nameNet + EXT[this.extNet];
            this.alreadyCached = false;
            this.priority = -1;
            this.nbPix = 12 * (int)Math.pow(4.0, order);
            this.pixList = null;
            this.setStatus(1);
            try {
                if (mode == 2 || mode == 3 && (planBG.useCache && this.isCached() || planBG.isLocalAllSky())) {
                    this.loadNow();
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block3;
                e.printStackTrace();
            }
        }
    }

    @Override
    protected long getLiveTime() {
        return this.planBG.aladin.enoughMemory() ? -1L : 3000L;
    }

    HealpixKey createOneKey(int npix, int width, byte[] pix) {
        HealpixKey h = new HealpixKey();
        h.allSky = true;
        h.planBG = this.planBG;
        h.order = this.order;
        h.z = this.z;
        h.npix = npix;
        h.hpix = new Hpix(this.order, npix, this.planBG.frameOrigin);
        h.resetTimer();
        h.width = h.height = width;
        h.pixels = pix;
        h.alreadyCached = true;
        h.setStatus(6);
        return h;
    }

    HealpixKey createOneKeyRGB(int npix, int width, int[] rgb) {
        HealpixKey h = new HealpixKey();
        h.allSky = true;
        h.planBG = this.planBG;
        h.order = this.order;
        h.npix = npix;
        h.z = this.z;
        h.hpix = new Hpix(this.order, npix, this.planBG.frameOrigin);
        h.resetTimer();
        h.width = h.height = width;
        h.rgb = rgb;
        h.alreadyCached = true;
        h.setStatus(6);
        return h;
    }

    static boolean isCached(PlanBG planBG, int order) {
        String pathName = planBG.getCacheDir();
        if (pathName == null) {
            return false;
        }
        String name = planBG.getCacheName() + "/" + "Norder" + order + "/Allsky" + EXT[planBG.getTileMode()];
        File f = new File(pathName = pathName + Util.FS + name);
        return f.exists() && f.canRead();
    }

    protected void createPixList() {
        if (this.getStatus() != 6) {
            return;
        }
        try {
            if (this.planBG.color) {
                this.createPixListRGB1();
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        int nbLosangeWidth = (int)Math.sqrt(this.nbPix);
        int nbLosangeHeight = this.nbPix / nbLosangeWidth;
        if ((double)(this.nbPix / nbLosangeWidth) != (double)this.nbPix / (double)nbLosangeWidth) {
            ++nbLosangeHeight;
        }
        int w = this.width / nbLosangeWidth;
        this.pixList = new HealpixKey[this.nbPix];
        for (int i = 0; i < this.nbPix; ++i) {
            byte[] pix = new byte[w * w];
            int yLosange = i / nbLosangeWidth * w;
            int xLosange = i % nbLosangeWidth * w;
            if (i % 100 == 0) {
                Util.pause(10);
            }
            for (int y = 0; y < w; ++y) {
                for (int x = 0; x < w; ++x) {
                    int offset = (yLosange + y) * this.width + (xLosange + x);
                    if (offset >= this.pixels.length) {
                        System.err.println("offset=" + offset + " pixels.length=" + this.pixels.length + " x,y=" + x + "," + y);
                        offset = this.pixels.length - 1;
                    }
                    int pos = y * w + x;
                    pix[pos] = this.pixels[offset];
                }
            }
            this.pixList[i] = this.createOneKey(i, w, pix);
            this.mem += this.pixList[i].getMem();
        }
        this.pixels = null;
    }

    @Override
    protected int getMem() {
        return this.mem;
    }

    private void createPixListRGB1() throws Exception {
        int nbLosangeWidth = (int)Math.sqrt(this.nbPix);
        int nbLosangeHeight = this.nbPix / nbLosangeWidth;
        if ((double)(this.nbPix / nbLosangeWidth) != (double)this.nbPix / (double)nbLosangeWidth) {
            ++nbLosangeHeight;
        }
        int w = this.width / nbLosangeWidth;
        this.pixList = new HealpixKey[this.nbPix];
        for (int npix = 0; npix < this.nbPix; ++npix) {
            int[] pix = new int[w * w];
            int yLosange = npix / nbLosangeWidth * w;
            int xLosange = npix % nbLosangeWidth * w;
            if (npix % 100 == 0) {
                Util.pause(10);
            }
            for (int y = 0; y < w; ++y) {
                for (int x = 0; x < w; ++x) {
                    pix[y * w + x] = this.rgb[(yLosange + y) * this.width + (xLosange + x)];
                }
            }
            this.pixList[npix] = this.createOneKeyRGB(npix, w, pix);
            this.mem += this.pixList[npix].getMem();
        }
        this.rgb = null;
    }

    @Override
    protected int free() {
        int n = 0;
        if (this.pixList != null) {
            n = this.pixList.length;
            for (int j = 0; j < this.pixList.length; ++j) {
                if (this.pixList[j] == null) continue;
                this.pixList[j].free();
            }
        }
        this.pixList = null;
        this.mem = 0;
        return n;
    }

    @Override
    protected void clearBuf() {
        if (this.pixList == null) {
            return;
        }
        for (int j = 0; j < this.pixList.length; ++j) {
            if (this.pixList[j] == null) continue;
            this.pixList[j].clearBuf();
        }
    }

    @Override
    HealpixKey[] getPixList() {
        if (this.pixList == null) {
            this.createPixList();
        }
        return this.pixList;
    }
}

