/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Chaine;
import cds.aladin.Glu;
import cds.aladin.GluApp;
import cds.aladin.VOToolDescription;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class FrameVOTool
extends JFrame
implements ActionListener,
KeyListener {
    private Aladin aladin;
    private VOToolDescription voForm;
    private JList voList;
    private JButton install;
    private JButton run;
    private JButton remove;
    protected JButton apply;
    protected static String INSTALL;
    protected static String NEWINSTALL;
    protected static String REINSTALL;
    protected static String REMOVE;
    protected static String INTERRUPT;
    protected static String NEW;
    protected static String __NEW__;
    protected static String WARNING;
    protected static String DELCONF;
    protected static String DOWNLOADMAN;
    protected static String DISCARD;
    protected static String NOYET;
    protected static String CANNOT;
    protected static String APPLY;
    protected static String RUN;
    protected static String CLOSE;
    protected static String JARMAN;

    static void display(Aladin aladin) {
        if (aladin.frameVOTool == null) {
            aladin.frameVOTool = new FrameVOTool(aladin);
        }
        aladin.frameVOTool.setVisible(true);
    }

    protected void createChaine(Chaine chaine) {
        INSTALL = "Install...";
        NEWINSTALL = "Install new release...";
        REINSTALL = "Re-install...";
        REMOVE = "Delete...";
        INTERRUPT = "Interrupt!";
        __NEW__ = "__New__";
        NEW = "New...";
        APPLY = "Apply";
        RUN = "Run...";
        CLOSE = "Close";
        WARNING = "This list shows a selection of VO tools compatible with Aladin. These softwares are able to cooperate with Aladin by exchanging data, cross selecting sources...\nSelect, install if required, or define yourself (Running directory + Command line) the VO applications  directly runnable from the Aladin menu.\nContact directly the authors for any questions, bugs...";
        DELCONF = "You are going to delete local description of this VO tool.\nDo you want to continue ?";
        DOWNLOADMAN = "This application requires a dedicated installation method.\nFollow the author instructions and after you successfully installed\nthe application, specify manually the command line\nand the running directory.";
        JARMAN = "Aladin is going to download this following jar file\n Do you want to continue ?\n \n";
        DISCARD = "Discard your modifications ?";
        NOYET = "This installation method is not supported\nby your Aladin version";
        CANNOT = "Cannot install this application";
    }

    private FrameVOTool(Aladin aladin) {
        Aladin.setIcon(this);
        this.createChaine(Aladin.chaine);
        this.setTitle("VOTool Application installer & controller");
        this.aladin = aladin;
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FrameVOTool.this.close();
            }
        });
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getContentPane().add((Component)this.createPanel(), "Center");
        this.setLocation(50, 100);
        this.pack();
    }

    private JPanel createPanel() {
        JButton b;
        JPanel p = new JPanel(new BorderLayout(5, 5));
        this.voList = new JList(new VOList());
        this.voList.setVisibleRowCount(10);
        this.voList.setFixedCellWidth(100);
        this.voList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                FrameVOTool.this.selectionne();
            }
        });
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JTextArea t = new JTextArea(WARNING);
        p.add((Component)t, "North");
        t.setWrapStyleWord(true);
        t.setLineWrap(true);
        t.setEditable(false);
        t.setFont(Aladin.ITALIC);
        t.setBackground(this.getContentPane().getBackground());
        p.add((Component)new JScrollPane(this.voList), "West");
        this.voForm = new VOToolDescription(this.aladin, this);
        p.add((Component)this.voForm, "Center");
        JPanel p1 = new JPanel();
        this.install = b = new JButton(INSTALL);
        p1.add(b);
        b.setFont(b.getFont().deriveFont(1));
        b.setEnabled(false);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameVOTool.this.install();
            }
        });
        this.apply = b = new JButton(APPLY);
        p1.add(b);
        b.setEnabled(false);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameVOTool.this.apply();
            }
        });
        this.run = b = new JButton(RUN);
        p1.add(b);
        b.setEnabled(false);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameVOTool.this.run();
            }
        });
        this.remove = b = new JButton(REMOVE);
        p1.add(b);
        b.setEnabled(false);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameVOTool.this.remove();
            }
        });
        p1.add(new JLabel("      "));
        b = new JButton(NEW);
        p1.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameVOTool.this.nouveau();
            }
        });
        b = new JButton(CLOSE);
        p1.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameVOTool.this.close();
            }
        });
        p.add((Component)p1, "South");
        return p;
    }

    protected void setButtonMode(GluApp ap) {
        this.install.setEnabled(ap != null && ap.canBeInstall());
        this.run.setEnabled(ap != null && ap.canBeRun());
        if (ap != null) {
            if (ap.isDownloading()) {
                this.install.setText(INTERRUPT);
            } else {
                this.install.setText(ap.hasNewRelease() ? NEWINSTALL : (ap.dir != null ? REINSTALL : INSTALL));
            }
        }
        this.apply.setEnabled(ap != null && this.voForm.hasBeenChanged());
        this.remove.setEnabled(ap != null && !ap.isDownloading());
    }

    private void apply() {
        GluApp ap = this.voForm.apply();
        this.setButtonMode(ap);
        if (ap.tagGlu.equals(__NEW__)) {
            int i = ap.aladinLabel.indexOf(32);
            if (i == -1) {
                i = ap.aladinLabel.indexOf(58);
            }
            if (i == -1) {
                i = ap.aladinLabel.indexOf(45);
            }
            if (i == -1) {
                i = ap.aladinLabel.length();
            }
            ap.tagGlu = ap.aladinLabel.substring(0, i);
            this.listUpdate();
        }
        this.aladin.glu.writeGluAppDic();
        this.aladin.VOReload();
    }

    private void close() {
        if (!this.discard()) {
            return;
        }
        this.setVisible(false);
    }

    protected void downloadEnd() {
        this.aladin.glu.writeGluAppDic();
        this.aladin.VOReload();
        this.selectionne();
    }

    private boolean discard() {
        if (this.voForm.hasBeenChanged()) {
            return Aladin.confirmation(this, DISCARD);
        }
        return true;
    }

    protected void selectionne() {
        String name = (String)this.voList.getSelectedValue();
        GluApp ap = this.aladin.glu.getGluApp(this.aladin.glu.findGluApp(name));
        this.voForm.setEditable(false);
        if (this.voForm.vo != ap && !this.discard()) {
            return;
        }
        this.voForm.setVOtool(ap);
        if (ap.tagGlu.equals(__NEW__)) {
            this.voForm.setEditable(true);
        }
        this.setButtonMode(ap);
    }

    protected void selectionne(GluApp ap) {
        int i = this.aladin.glu.findGluApp(ap.tagGlu);
        if (i < 0) {
            return;
        }
        this.voList.setSelectedIndex(i);
        this.voForm.setVOtool(ap);
        this.setButtonMode(ap);
    }

    private void nouveau() {
        if (!this.discard()) {
            return;
        }
        GluApp ap = this.aladin.glu.addApplication(__NEW__);
        this.listUpdate();
        this.selectionne(ap);
        this.voForm.setEditable(true);
    }

    private void install() {
        GluApp ap = this.voForm.vo;
        if (ap.isDownloading()) {
            ap.interrupt();
            return;
        }
        if (ap.getInstallMode() == 1) {
            if (!Aladin.confirmation(this, JARMAN + "\n - Url: " + ap.jarUrl + "\n - Target: " + this.aladin.getVOPath() + "\n")) {
                return;
            }
        }
        int rep = ap.install();
        switch (rep) {
            case 0: {
                Aladin.warning(this, CANNOT);
                break;
            }
            case -1: {
                Util.pause(1000);
                Aladin.info(this, DOWNLOADMAN);
                break;
            }
            case -2: {
                Aladin.warning(this, NOYET);
            }
        }
        this.aladin.glu.writeGluAppDic();
        this.aladin.log("VOinstall", ap.tagGlu + " " + (rep == 1 ? "Ok" : "Error"));
        this.voForm.setVOtool(ap);
        this.setButtonMode(ap);
    }

    private void run() {
        GluApp ap = this.voForm.vo;
        ap.exec();
    }

    private void listUpdate() {
        Glu cfr_ignored_0 = this.aladin.glu;
        ((VOList)this.voList.getModel()).listListener.contentsChanged(new ListDataEvent(this, 0, 0, Glu.vGluApp.size()));
    }

    private void remove() {
        String name = (String)this.voList.getSelectedValue();
        if (!Aladin.confirmation(this, DELCONF)) {
            return;
        }
        this.aladin.glu.removeGluApp(name);
        this.voList.setSelectedIndex(0);
        this.listUpdate();
        this.selectionne();
        this.aladin.glu.writeGluAppDic();
        this.aladin.VOReload();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setButtonMode(this.voForm.vo);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.setButtonMode(this.voForm.vo);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    class VOList
    implements ListModel {
        protected ListDataListener listListener;

        VOList() {
        }

        public Object getElementAt(int index) {
            Glu cfr_ignored_0 = ((FrameVOTool)FrameVOTool.this).aladin.glu;
            return ((GluApp)Glu.vGluApp.elementAt((int)index)).tagGlu;
        }

        @Override
        public int getSize() {
            Glu cfr_ignored_0 = ((FrameVOTool)FrameVOTool.this).aladin.glu;
            return Glu.vGluApp.size();
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listListener = l;
        }
    }
}

