/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MetaDataTree;
import cds.aladin.MyByteArrayStream;
import cds.aladin.Server;
import cds.aladin.ServerAllVO;
import cds.aladin.ServerGlu;
import cds.aladin.VOResource;
import cds.tools.TwoColorJTable;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public final class FrameServer
extends JFrame
implements ActionListener,
KeyListener {
    static String TITLE;
    static String INFO;
    static String CHECK;
    static String UNCHECK;
    static String SUBMIT;
    static String CLOSE;
    static String CHECKUNCHECK;
    static String IMGSRV;
    static String CATSRC;
    static String SPECSRV;
    static String TIPSUBMIT;
    static String TIPCLOSE;
    static String FILTER;
    static String RESET;
    static String GO;
    Aladin aladin;
    ServerAllVO discoveryServer;
    JTextField filter = null;
    private JPanel panelScroll;
    private static final String QUERY_NVO = "Query NVO registry";
    private static final String QUERY_WORKSHOP_REGISTRY = "Query workshop registry";
    private static final String REFRESH = "Refresh";
    private static final String MODIFY_ENDPOINT = "Modify registry endpoint";
    private ButtonGroup registryCbg;
    GridBagLayout g;
    GridBagConstraints c;
    protected static String REGISTRY_BASE_URL;
    private static final String URL_RESOLVE_IVORN = "http://esavo.esa.int/registry/GetResource.jsp?identifier=";

    protected void createChaine() {
        TITLE = Aladin.chaine.getString("FSTITLE");
        CHECK = Aladin.chaine.getString("FSCHECK");
        UNCHECK = Aladin.chaine.getString("FSUNCHECK");
        GO = Aladin.chaine.getString("FSGO");
        RESET = Aladin.chaine.getString("RESET");
        FILTER = Aladin.chaine.getString("FSFILTER");
        SUBMIT = Aladin.chaine.getString("FSSUBMIT");
        CLOSE = Aladin.chaine.getString("CLOSE");
        CHECKUNCHECK = Aladin.chaine.getString("FSCHECKUNCHECK");
        IMGSRV = Aladin.chaine.getString("FSIMGSRV");
        CATSRC = Aladin.chaine.getString("FSCATSRC");
        SPECSRV = Aladin.chaine.getString("FSSPECSRV");
        TIPSUBMIT = Aladin.chaine.getString("TIPSUBMIT");
        TIPCLOSE = Aladin.chaine.getString("TIPCLOSE");
    }

    protected FrameServer(Aladin aladin, ServerAllVO discoveryServer) {
        this.aladin = aladin;
        Aladin.setIcon(this);
        this.createChaine();
        this.setTitle(TITLE);
        this.discoveryServer = discoveryServer;
        this.aladin = aladin;
        this.setLocation(Aladin.computeLocation(this));
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        this.getContentPane().add((Component)this.createPanel(), "Center");
        this.pack();
        this.setVisible(true);
        discoveryServer.clearStepLabel();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(600, 800);
    }

    private JPanel createPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(0, 0));
        int scrollWidth = 650;
        int scrollHeight = 500;
        JPanel check = new JPanel();
        JButton b = new JButton(CHECK);
        check.add(b);
        b.addActionListener(this);
        b = new JButton(UNCHECK);
        check.add(b);
        b.addActionListener(this);
        check.add(new JLabel("      " + FILTER + ": "));
        this.filter = new JTextField(15);
        check.add(this.filter);
        this.filter.addKeyListener(this);
        b = new JButton(GO);
        check.add(b);
        b.addActionListener(this);
        b = new JButton(RESET);
        check.add(b);
        b.addActionListener(this);
        JPanel header = new JPanel(new BorderLayout());
        header.add((Component)new JLabel(CHECKUNCHECK, 0), "North");
        header.add((Component)check, "Center");
        JPanel foo = new JPanel(new FlowLayout());
        this.registryCbg = new ButtonGroup();
        JRadioButton r = new JRadioButton(QUERY_NVO);
        foo.add(r);
        this.registryCbg.add(r);
        r.setSelected(true);
        r.setActionCommand(QUERY_NVO);
        r = new JRadioButton(QUERY_WORKSHOP_REGISTRY);
        foo.add(r);
        this.registryCbg.add(r);
        r.setActionCommand(QUERY_WORKSHOP_REGISTRY);
        b = new JButton(REFRESH);
        foo.add(b);
        b.addActionListener(this);
        b = new JButton(MODIFY_ENDPOINT);
        foo.add(b);
        b.addActionListener(this);
        if (Aladin.PROTO) {
            header.add((Component)foo, "South");
        }
        p.add((Component)header, "North");
        this.g = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.c.fill = 2;
        this.panelScroll = new JPanel(this.g);
        JScrollPane scroll = new JScrollPane(this.panelScroll);
        scroll.setSize(scrollWidth, scrollHeight);
        scroll.setBackground(Color.white);
        scroll.getVerticalScrollBar().setUnitIncrement(70);
        this.fillWithServers();
        Aladin.makeAdd(p, scroll, "Center");
        JPanel submit = new JPanel();
        b = new JButton(SUBMIT);
        submit.add(b);
        b.addActionListener(this);
        b.setToolTipText(TIPSUBMIT);
        b = new JButton(CLOSE);
        submit.add(b);
        b.addActionListener(this);
        b.setToolTipText(TIPCLOSE);
        p.add((Component)submit, "South");
        return p;
    }

    private void fillWithServers() {
        this.panelScroll.removeAll();
        for (int j = 0; j < 3; ++j) {
            int type = j == 0 ? 1 : (j == 1 ? 2 : 4);
            this.c.gridx = 0;
            this.c.gridwidth = 4;
            ++this.c.gridy;
            this.c.weightx = 1.0;
            this.c.weighty = 0.1;
            int gapy = this.c.insets.top;
            this.c.insets.top = 15;
            JLabel t = new JLabel(j == 0 ? IMGSRV : (j == 1 ? CATSRC : SPECSRV));
            t.setFont(Aladin.LITALIC);
            JPanel p = new JPanel(new BorderLayout(0, 0));
            p.add(t);
            p.setBackground(j == 0 ? MetaDataTree.LABEL_COL[1] : (j == 1 ? MetaDataTree.LABEL_COL[2] : MetaDataTree.LABEL_COL[3]));
            this.g.setConstraints(p, this.c);
            this.panelScroll.add(p);
            this.c.insets.top = gapy;
            int h = 0;
            String mask = this.filter.getText().trim();
            if (mask.length() == 0) {
                mask = null;
            }
            for (int i = 0; i < this.aladin.dialog.server.length; ++i) {
                Color bg;
                Server s = this.aladin.dialog.server[i];
                if (!s.isDiscovery() || s.type != type) continue;
                if (mask != null && Util.indexOfIgnoreCase(s.description, mask) < 0) {
                    s.filterAllVO = false;
                    continue;
                }
                s.filterAllVO = true;
                ++h;
                if (s.cbAllVO == null) {
                    s.cbAllVO = new JCheckBox(s.description);
                    s.cbAllVO.setSelected(true);
                    s.cbAllVO.setOpaque(true);
                }
                int height = s.cbAllVO.getPreferredSize().height;
                s.cbAllVO.setPreferredSize(new Dimension(330, height));
                s.statusAllVO.setFont(Aladin.ITALIC);
                s.statusAllVO.setOpaque(true);
                s.statusAllVO.setPreferredSize(new Dimension(50, height));
                Color color = bg = h % 2 == 0 ? TwoColorJTable.DEFAULT_ALTERNATE_COLOR : this.getBackground();
                if (s.statusReport == null) {
                    s.statusReport = new JButton(INFO);
                    s.statusReport.setMargin(new Insets(0, 0, 0, 0));
                    s.statusReport.setPreferredSize(new Dimension(20, height));
                    s.statusReport.addActionListener(this);
                    s.statusReport.setOpaque(true);
                }
                this.c.gridx = 0;
                ++this.c.gridy;
                this.c.gridwidth = 1;
                this.c.weightx = 0.1;
                JLabel l = new JLabel((h < 10 ? "  " : "") + h + ")");
                l.setOpaque(true);
                l.setBackground(bg);
                l.setPreferredSize(new Dimension(l.getPreferredSize().width, height));
                this.g.setConstraints(l, this.c);
                this.panelScroll.add(l);
                ++this.c.gridx;
                this.c.weightx = 0.6;
                s.cbAllVO.setBackground(bg);
                this.g.setConstraints(s.cbAllVO, this.c);
                this.panelScroll.add(s.cbAllVO);
                this.c.weightx = 0.2;
                ++this.c.gridx;
                s.statusAllVO.setBackground(bg);
                this.g.setConstraints(s.statusAllVO, this.c);
                this.panelScroll.add(s.statusAllVO);
                this.c.weightx = 0.05;
                ++this.c.gridx;
                int gap = this.c.insets.left;
                this.c.insets.left = 5;
                if (s.statusReport == null) {
                    l = new JLabel("");
                    l.setOpaque(true);
                    l.setBackground(bg);
                    this.g.setConstraints(l, this.c);
                    this.panelScroll.add(l);
                } else {
                    s.statusReport.setBackground(bg);
                    this.g.setConstraints(s.statusReport, this.c);
                    this.panelScroll.add(s.statusReport);
                }
                this.c.insets.left = gap;
                if (s instanceof ServerGlu && ((ServerGlu)s).actionName.startsWith("IVOA")) continue;
                s.cbAllVO.setFont(s.cbAllVO.getFont().deriveFont(1));
            }
        }
        ++this.c.gridy;
        this.c.gridwidth = 4;
        this.c.weighty = 0.9;
        JLabel l1 = new JLabel(" ");
        this.g.setConstraints(l1, this.c);
        this.panelScroll.add(l1);
        this.panelScroll.invalidate();
        this.panelScroll.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (!(o instanceof JButton)) {
            return;
        }
        String s = ((JButton)o).getActionCommand();
        if (s.equals(INFO)) {
            for (int i = 0; i < this.aladin.dialog.server.length; ++i) {
                if (o != this.aladin.dialog.server[i].statusReport) continue;
                this.aladin.dialog.server[i].showStatusReport();
            }
        } else if (s.equals(CHECK) || s.equals(UNCHECK)) {
            boolean flag = s.equals(CHECK);
            this.check(-1, flag);
        } else if (s.equals(CLOSE)) {
            this.setVisible(false);
        } else if (s.equals(GO)) {
            this.go();
        } else if (s.equals(RESET)) {
            this.reset();
        } else if (s.equals(REFRESH)) {
            this.refresh();
        } else if (s.equals(SUBMIT)) {
            this.discoveryServer.tree.clear();
            this.discoveryServer.submit();
        } else if (s.equals(MODIFY_ENDPOINT)) {
            this.modifyEndpoint();
        }
    }

    private void go() {
        this.fillWithServers();
        this.pack();
    }

    private void reset() {
        this.filter.setText("");
        for (int i = 0; i < this.aladin.dialog.server.length; ++i) {
            this.aladin.dialog.server[i].statusError = null;
            if (this.aladin.dialog.server[i].statusAllVO == null) continue;
            this.aladin.dialog.server[i].statusAllVO.setText(" ");
        }
        this.fillWithServers();
        this.check(-1, true);
    }

    protected void check(int type, boolean flag) {
        for (int i = 0; i < this.aladin.dialog.server.length; ++i) {
            if (!this.aladin.dialog.server[i].filterAllVO || this.aladin.dialog.server[i].cbAllVO == null || type != -1 && this.aladin.dialog.server[i].type != type) continue;
            this.aladin.dialog.server[i].cbAllVO.setSelected(flag);
        }
    }

    private void modifyEndpoint() {
        String endpoint = (String)JOptionPane.showInputDialog(this, "Enter OAI endpoint (eg http://myserver.org/oai.pl) :", "Registry OAI endpoint", 3, null, null, REGISTRY_BASE_URL);
        if (endpoint != null) {
            REGISTRY_BASE_URL = endpoint;
        }
    }

    private void refresh() {
        Aladin.makeCursor(this, 1);
        this.panelScroll.removeAll();
        this.removeIVOA();
        if (this.registryCbg.getSelection().getActionCommand().equals(QUERY_NVO)) {
            this.aladin.dialog.ivoaServersLoaded = false;
            this.aladin.dialog.appendIVOAServer();
        } else {
            this.appendWorkshopRegistryServers(REGISTRY_BASE_URL, null);
        }
        this.fillWithServers();
        Aladin.makeCursor(this, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendWorkshopRegistryServers(String registry, String resToken) {
        URL url;
        try {
            String suffix = resToken != null ? "resumptionToken=" + URLEncoder.encode(resToken) : "metadataPrefix=ivo_vor";
            url = new URL(registry + "&verb=ListRecords&" + suffix);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return;
        }
        FilterInputStream dis = null;
        try {
            dis = new DataInputStream(new BufferedInputStream(url.openStream()));
            MyByteArrayStream bas = new MyByteArrayStream();
            String type = null;
            String actionName = null;
            String institute = null;
            String baseUrl = null;
            String desc = null;
            String identifier = null;
            String resumptionToken = null;
            String status = null;
            KXmlParser parser = new KXmlParser();
            parser.setInput(new InputStreamReader(dis));
            int event = 0;
            while ((event = parser.next()) != 1) {
                boolean endTag;
                if (event != 2 && event != 3) continue;
                String tagName = parser.getName();
                boolean startTag = event == 2;
                boolean bl = endTag = event == 3;
                if (startTag && (tagName.indexOf("ri:Resource") >= 0 || tagName.indexOf("vr:Resource") >= 0 || tagName.equalsIgnoreCase("resource"))) {
                    status = parser.getAttributeValue(null, "status");
                    if (status == null || !status.equals("active") || (type = parser.getAttributeValue(null, "xsi:type")) == null) continue;
                    type = type.trim();
                    continue;
                }
                if (startTag && tagName.equalsIgnoreCase("capability")) {
                    if (type != null && FrameServer.supportType(type) != null || status != null && !status.equals("active") || (type = parser.getAttributeValue(null, "xsi:type")) == null) continue;
                    type = type.trim();
                    continue;
                }
                if (startTag && (tagName.indexOf("vr:shortName") >= 0 || tagName.equalsIgnoreCase("shortName"))) {
                    parser.next();
                    actionName = parser.getText();
                    if (actionName == null) continue;
                    actionName = actionName.trim();
                    continue;
                }
                if (startTag && (tagName.indexOf("vr:publisher") >= 0 || tagName.equalsIgnoreCase("publisher"))) {
                    parser.next();
                    institute = parser.getText();
                    if (institute == null) continue;
                    institute = institute.trim();
                    continue;
                }
                if (startTag && tagName.indexOf("vr:accessURL") >= 0) {
                    parser.next();
                    baseUrl = parser.getText();
                    if (baseUrl == null) continue;
                    baseUrl = baseUrl.trim();
                    continue;
                }
                if (startTag && tagName.toLowerCase().indexOf("accessurl") >= 0 && baseUrl == null) {
                    parser.next();
                    baseUrl = parser.getText();
                    if (baseUrl == null) continue;
                    baseUrl = baseUrl.trim();
                    continue;
                }
                if (startTag && (tagName.indexOf("vr:title") >= 0 || tagName.equalsIgnoreCase("title"))) {
                    parser.next();
                    desc = parser.getText();
                    if (desc == null) continue;
                    desc = desc.trim();
                    continue;
                }
                if (startTag && (tagName.indexOf("vr:identifier") >= 0 || tagName.equalsIgnoreCase("identifier"))) {
                    parser.next();
                    identifier = parser.getText();
                    if (identifier == null) continue;
                    identifier = identifier.trim();
                    continue;
                }
                if (endTag && (tagName.indexOf("oai:record") >= 0 || tagName.equalsIgnoreCase("resource"))) {
                    String t = FrameServer.supportType(type);
                    if (t != null) {
                        FrameServer.createRecord(bas, t, actionName, institute, baseUrl, desc, identifier);
                    }
                    identifier = null;
                    desc = null;
                    baseUrl = null;
                    institute = null;
                    actionName = null;
                    type = null;
                    status = null;
                    continue;
                }
                if (!startTag || tagName.indexOf("resumptionToken") < 0) continue;
                parser.next();
                resumptionToken = parser.getText();
            }
            if (resumptionToken != null) {
                this.appendWorkshopRegistryServers(registry, resumptionToken);
            }
            this.aladin.dialog.appendServersFromStream(bas.getInputStream());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (XmlPullParserException xppe) {
            xppe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                dis.close();
            }
            catch (IOException ioe) {
                System.out.println("can't close");
            }
        }
    }

    protected static VOResource[] getGluStreamFromIvornList(String[] uri) {
        ArrayList l = new ArrayList();
        for (int i = 0; i < uri.length; ++i) {
            VOResource ivorn = FrameServer.getIvorn(uri[i]);
            if (ivorn == null) continue;
            System.out.println(ivorn.desc);
        }
        return l.toArray(new VOResource[l.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static VOResource getIvorn(String uri) {
        URL url;
        try {
            String urlSuffix = "";
            url = new URL(URL_RESOLVE_IVORN + URLEncoder.encode(uri) + urlSuffix);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        FilterInputStream dis = null;
        try {
            dis = new DataInputStream(new BufferedInputStream(url.openStream()));
            String type = null;
            String actionName = null;
            String institute = null;
            String baseUrl = null;
            String desc = null;
            String identifier = null;
            String resumptionToken = null;
            String status = null;
            KXmlParser parser = new KXmlParser();
            parser.setInput(new InputStreamReader(dis));
            int event = 0;
            while ((event = parser.next()) != 1) {
                boolean endTag;
                if (event != 2 && event != 3) continue;
                String tagName = parser.getName();
                boolean startTag = event == 2;
                boolean bl = endTag = event == 3;
                if (startTag && (tagName.indexOf("ri:Resource") >= 0 || tagName.indexOf("vr:Resource") >= 0 || tagName.equalsIgnoreCase("resource"))) {
                    status = parser.getAttributeValue(null, "status");
                    if (status == null || !status.equals("active") || (type = parser.getAttributeValue(null, "xsi:type")) == null) continue;
                    type = type.trim();
                    continue;
                }
                if (startTag && tagName.equalsIgnoreCase("capability")) {
                    if (type != null && FrameServer.supportType(type) != null || status != null && !status.equals("active") || (type = parser.getAttributeValue(null, "xsi:type")) == null) continue;
                    type = type.trim();
                    continue;
                }
                if (startTag && (tagName.indexOf("vr:shortName") >= 0 || tagName.equalsIgnoreCase("shortName"))) {
                    parser.next();
                    actionName = parser.getText();
                    if (actionName == null) continue;
                    actionName = actionName.trim();
                    continue;
                }
                if (startTag && (tagName.indexOf("vr:publisher") >= 0 || tagName.equalsIgnoreCase("publisher"))) {
                    parser.next();
                    institute = parser.getText();
                    if (institute == null) continue;
                    institute = institute.trim();
                    continue;
                }
                if (startTag && tagName.indexOf("vr:accessURL") >= 0 && (baseUrl == null || baseUrl.length() == 0)) {
                    parser.next();
                    baseUrl = parser.getText();
                    if (baseUrl == null) continue;
                    baseUrl = baseUrl.trim();
                    continue;
                }
                if (startTag && tagName.toLowerCase().indexOf("accessurl") >= 0 && (baseUrl == null || baseUrl.length() == 0)) {
                    parser.next();
                    baseUrl = parser.getText();
                    if (baseUrl == null) continue;
                    baseUrl = baseUrl.trim();
                    continue;
                }
                if (startTag && (tagName.indexOf("vr:title") >= 0 || tagName.equalsIgnoreCase("title"))) {
                    parser.next();
                    desc = parser.getText();
                    if (desc == null) continue;
                    desc = desc.trim();
                    continue;
                }
                if (startTag && (tagName.indexOf("vr:identifier") >= 0 || tagName.equalsIgnoreCase("identifier"))) {
                    parser.next();
                    identifier = parser.getText();
                    if (identifier == null) continue;
                    identifier = identifier.trim();
                    continue;
                }
                if (endTag && (tagName.indexOf("oai:record") >= 0 || tagName.indexOf("Resource") >= 0 && tagName.toLowerCase().indexOf("related") < 0)) {
                    String t = FrameServer.supportType(type);
                    VOResource ivorn = new VOResource();
                    ivorn.type = t != null ? t : type;
                    ivorn.actionName = actionName;
                    ivorn.baseUrl = baseUrl;
                    ivorn.desc = desc;
                    ivorn.identifier = identifier;
                    VOResource vOResource = ivorn;
                    return vOResource;
                }
                if (!startTag || tagName.indexOf("resumptionToken") < 0) continue;
                parser.next();
                resumptionToken = parser.getText();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (XmlPullParserException xppe) {
            xppe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                dis.close();
            }
            catch (IOException ioe) {
                System.out.println("can't close");
            }
        }
        return null;
    }

    protected static void createRecord(MyByteArrayStream bas, String type, String actionName, String institute, String baseUrl, String desc, String identifier) {
        FrameServer.createRecord(bas, type, actionName, institute, baseUrl, desc, identifier, "IVOA");
    }

    protected static void createRecord(MyByteArrayStream bas, String type, String actionName, String institute, String baseUrl, String desc, String identifier, String prefix) {
        bas.write("%ActionName\t" + prefix + "-" + type + "-" + identifier);
        bas.write("\n");
        bas.write("%Identifier\t" + identifier);
        bas.write("\n");
        bas.write("%Institute\t" + institute);
        bas.write("\n");
        bas.write("%Description\t" + desc.substring(0, Math.min(60, desc.length())));
        bas.write("\n");
        bas.write("%Owner\tCDS'aladin");
        bas.write("\n");
        if (baseUrl != null) {
            if ((baseUrl = baseUrl.trim()).indexOf(63) < 0) {
                baseUrl = baseUrl + "?";
            }
            if (!(baseUrl.endsWith("?") || baseUrl.endsWith("/") || baseUrl.endsWith("&"))) {
                baseUrl = baseUrl + "&";
            }
        }
        if (baseUrl != null && type.equals("ssap")) {
            baseUrl = baseUrl + "REQUEST=queryData&";
        }
        if (type.equals("siap")) {
            bas.write("%Url\t" + baseUrl + "POS=$1,$2&SIZE=$3");
            bas.write("\n");
        } else if (type.equals("ssap")) {
            bas.write("%Url\t" + baseUrl + "POS=$1,$2&SIZE=$3");
            bas.write("\n");
        } else if (type.equals("cs")) {
            bas.write("%Url\t" + baseUrl + "RA=$1&DEC=$2&SR=$3&VERB=2");
            bas.write("\n");
        }
        bas.write("%Param.Description\t$1=Right Ascension");
        bas.write("\n");
        bas.write("%Param.Description\t$2=Declination");
        bas.write("\n");
        bas.write("%Param.Description\t$3=Radius in deg");
        bas.write("\n");
        bas.write("%Param.DataType\t$1=Target(RAd)");
        bas.write("\n");
        bas.write("%Param.DataType\t$2=Target(DEd)");
        bas.write("\n");
        bas.write("%Param.DataType\t$3=Field(RADIUSd)");
        bas.write("\n");
        bas.write("%Param.Value\t$3=0.17");
        bas.write("\n");
        if (type.equals("cs")) {
            bas.write("%ResultDataType\tMime(text/xml)");
            bas.write("\n");
        } else if (type.equals("ssap")) {
            bas.write("%ResultDataType\tMime(ssa/xml)");
            bas.write("\n");
        } else if (type.equals("siap")) {
            bas.write("%ResultDataType\tMime(sia/xml)");
            bas.write("\n");
        }
        bas.write("%Aladin.Label\t" + desc.substring(0, Math.min(60, desc.length())));
        bas.write("\n");
        bas.write("%Aladin.Menu\tIVOA...");
        bas.write("\n");
        bas.write("%Aladin.LabelPlane\t" + type + actionName + " $1");
        bas.write("\n");
        bas.write("%DistribDomain\tALADIN");
        bas.write("\n");
    }

    private static String supportType(String type) {
        if (type == null) {
            return null;
        }
        if ((type = type.toLowerCase()).indexOf("simpleimageaccess") >= 0) {
            return "siap";
        }
        if (type.indexOf("simplespec") >= 0) {
            return "ssap";
        }
        if (type.indexOf("conesearch") >= 0 || type.indexOf("tabularskyservice") >= 0) {
            return "cs";
        }
        return null;
    }

    private String getServiceType(String s) {
        if (s.indexOf("\"active\"") < 0) {
            return null;
        }
        int i = s.indexOf("xsi:type=");
        if (i < 0) {
            return null;
        }
        if ((i = (s = s.substring(i + 10)).indexOf("\"")) >= 0) {
            s = s.substring(0, i);
        }
        return s;
    }

    private String getActionName(String s) {
        int i = s.indexOf("<vr:shortName>");
        if (i < 0) {
            return null;
        }
        s = s.substring(i + 14);
        i = s.indexOf(32);
        int j = s.indexOf(60);
        if (i < 0) {
            return s.substring(0, j);
        }
        if (j < 0) {
            return s.substring(0, i);
        }
        return s.substring(0, Math.min(i, j));
    }

    private String getInstitute(String s) {
        int i = s.indexOf("<vr:publisher>");
        if (i < 0) {
            return null;
        }
        int j = (s = s.substring(i + 14)).indexOf(60);
        if (j >= 0) {
            return s.substring(0, j);
        }
        return s;
    }

    private String getBaseUrl(String s) {
        int i = s.indexOf(">");
        if (i < 0) {
            return null;
        }
        if ((i = (s = s.substring(i + 1)).indexOf(60)) < 0) {
            return s;
        }
        return s.substring(0, i);
    }

    private String getDesc(String s) {
        int i = s.indexOf(">");
        if (i < 0) {
            return null;
        }
        if ((i = (s = s.substring(i + 1)).indexOf(60)) < 0) {
            return s;
        }
        return s.substring(0, i);
    }

    private String getIdentifier(String s) {
        int i = s.indexOf(">");
        if (i < 0) {
            return null;
        }
        if ((i = (s = s.substring(i + 1)).indexOf(60)) < 0) {
            return s;
        }
        return s.substring(0, i);
    }

    private String getResumptionToken(String s) {
        int i = s.indexOf(">");
        if (i < 0) {
            return null;
        }
        if ((i = (s = s.substring(i + 1)).indexOf(60)) < 0) {
            return s;
        }
        return s.substring(0, i);
    }

    private void removeIVOA() {
        int i;
        Server[] servers = this.aladin.dialog.server;
        for (i = 0; !(i >= servers.length || servers[i] instanceof ServerGlu && ((ServerGlu)servers[i]).actionName.startsWith("IVOA")); ++i) {
        }
        Server[] newServers = new Server[i];
        System.arraycopy(servers, 0, newServers, 0, i);
        this.aladin.dialog.server = newServers;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.go();
        }
    }

    static {
        INFO = " ? ";
        REGISTRY_BASE_URL = "http://manaslu.star.le.ac.uk/astrogrid-registry/OAIHandlerv1_0?set=ivo_managed";
    }
}

