/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AladinData;
import cds.aladin.Coord;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.Projection;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FramePixelExtraction
extends JFrame {
    private Aladin aladin;
    private PlanImage pimg;

    protected FramePixelExtraction(Aladin aladin) {
        this.aladin = aladin;
        Aladin.setIcon(this);
        this.setTitle("Pixel extraction");
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        JPanel pgen = (JPanel)this.getContentPane();
        pgen.setBorder(BorderFactory.createEmptyBorder(10, 10, 15, 10));
        pgen.setLayout(new BorderLayout());
        pgen.add((Component)this.createPanel(), "Center");
        this.setLocation(Aladin.computeLocation(this));
        this.pack();
        this.setVisible(true);
    }

    private JPanel createPanel() {
        JPanel p = new JPanel(new BorderLayout(5, 5));
        this.pimg = (PlanImage)this.aladin.calque.getPlanBase();
        String s = "<center>" + Aladin.chaine.getString("PIXEXTRINFO1") + "<br> <b>Reference image : " + this.pimg.label + "\nNumber of pixels: " + this.pimg.naxis1 * this.pimg.naxis2 + "</b></center>";
        JLabel img = new JLabel(Util.fold(s, 40, true));
        p.add((Component)img, "North");
        s = Aladin.chaine.getString("PIXEXTRINFO2");
        JLabel info = new JLabel(Util.fold(s, 40, true), 0);
        p.add((Component)info, "Center");
        JPanel confirm = new JPanel();
        JButton b = new JButton(Aladin.chaine.getString("PIXELEXTRSUBMIT"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FramePixelExtraction.this.pixelExtraction();
                FramePixelExtraction.this.dispose();
            }
        });
        confirm.add(b);
        b = new JButton(Aladin.chaine.getString("SFCANCEL"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FramePixelExtraction.this.dispose();
            }
        });
        confirm.add(b);
        p.add((Component)confirm, "South");
        return p;
    }

    protected void pixelExtraction() {
        try {
            Vector<Plan> v = this.aladin.calque.getPlanImg();
            int naxis1 = this.pimg.naxis1;
            int naxis2 = this.pimg.naxis2;
            PlanImage[] p = null;
            int n = 0;
            int j = 0;
            for (int tour = 0; tour < 2; ++tour) {
                if (tour == 1) {
                    p = new PlanImage[n + 1];
                    p[j++] = this.pimg;
                }
                for (int i = v.size() - 1; i >= 0; --i) {
                    PlanImage p1 = (PlanImage)v.elementAt(i);
                    if (p1 == this.pimg || !p1.selected || !p1.hasAvailablePixels() || p1 instanceof PlanBG) continue;
                    if (tour == 0) {
                        ++n;
                        continue;
                    }
                    p[j++] = p1;
                }
            }
            final PlanImage[] p1 = p;
            final AladinData cat = this.aladin.createAladinCatalog("Pixels");
            cat.plan.flagProcessing = true;
            this.aladin.calque.repaintAll();
            new Thread(){

                @Override
                public void run() {
                    try {
                        FramePixelExtraction.this.pixelExtraction(cat, p1);
                    }
                    catch (Exception e1) {
                        FramePixelExtraction.this.aladin;
                        if (Aladin.levelTrace >= 3) {
                            e1.printStackTrace();
                        }
                        cat.plan.error = "Pixel extraction error !";
                        FramePixelExtraction.this.aladin;
                        Aladin.warning(cat.plan.error);
                    }
                    finally {
                        cat.plan.flagProcessing = false;
                    }
                }
            }.start();
        }
        catch (Exception e2) {
            if (Aladin.levelTrace >= 3) {
                e2.printStackTrace();
            }
            Aladin.warning("Pixel extraction error !");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pixelExtraction(AladinData cat, PlanImage[] p) throws Exception {
        int i;
        int n = p.length + 4;
        String[] name = new String[n];
        String[] dataType = new String[n];
        for (i = 0; i < p.length; ++i) {
            name[i] = p[i].label;
            dataType[i] = "double";
        }
        name[n - 4] = "X";
        dataType[n - 4] = "integer";
        name[n - 3] = "Y";
        dataType[n - 3] = "integer";
        name[n - 2] = "RAJ2000";
        dataType[n - 2] = "double";
        name[n - 1] = "DEJ2000";
        dataType[n - 1] = "double";
        cat.setName(name);
        cat.setDatatype(dataType);
        for (i = 0; i < p.length; ++i) {
            p[i].setLockCacheFree(true);
            p[i].pixelsOriginFromCache();
        }
        try {
            double ra = Double.NaN;
            double dec = Double.NaN;
            Coord coo = new Coord();
            String[] row = new String[n];
            int height = p[0].naxis2;
            int width = p[0].naxis1;
            int shape = width * height > 10000 ? 9 : 8;
            int m = 1;
            boolean flagCoo = Projection.isOk(p[0].projd);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (flagCoo) {
                        coo.x = (double)x + 0.5;
                        coo.y = (double)y + 0.5;
                        p[0].projd.getCoord(coo);
                        ra = coo.al;
                        dec = coo.del;
                    }
                    row[n - 2] = ra + "";
                    row[n - 1] = dec + "";
                    coo.x = x;
                    coo.y = y;
                    if (flagCoo) {
                        p[0].projd.getCoord(coo);
                    }
                    for (int i2 = 0; i2 < p.length; ++i2) {
                        int y1;
                        int x1;
                        row[i2] = " ";
                        if (flagCoo && i2 > 0) {
                            if (!Projection.isOk(p[i2].projd)) continue;
                            p[i2].projd.getXY(coo);
                        }
                        if (!p[i2].isInside(x1 = (int)Math.round(coo.x), y1 = p[i2].naxis2 - (int)Math.round(coo.y) - 1)) continue;
                        row[i2] = p[i2].getPixel(x1, y1) + "";
                    }
                    row[n - 4] = x + 1 + "";
                    row[n - 3] = height - y + "";
                    cat.addSource("Pix_" + m++, ra, dec, row).setShape(shape);
                }
            }
            cat.objModified();
            cat.plan.flagProcessing = false;
        }
        finally {
            for (int i3 = 0; i3 < p.length; ++i3) {
                p[i3].setLockCacheFree(false);
            }
        }
    }
}

