/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameRGBBlink;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageAlgo;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public final class FrameArithmetic
extends FrameRGBBlink {
    String TITLE;
    String INFO;
    String HELP1;
    String ADD;
    String SUB;
    String MUL;
    String DIV;
    String NORM;
    String PPV;
    String BIL;
    String METHOD;
    String PLANE;
    String PLANEVALUE;
    private ButtonGroup cbg;
    private JCheckBox cbNorm;
    private ButtonGroup cbMethod;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.TITLE = Aladin.chaine.getString("ARITHTITLE");
        this.INFO = Aladin.chaine.getString("ARITHINFO");
        this.HELP1 = Aladin.chaine.getString("ARITHHELP");
        this.ADD = Aladin.chaine.getString("ARITHADD");
        this.SUB = Aladin.chaine.getString("ARITHSUB");
        this.MUL = Aladin.chaine.getString("ARITHMUL");
        this.DIV = Aladin.chaine.getString("ARITHDIV");
        this.NORM = Aladin.chaine.getString("ARITHNORM");
        this.PPV = Aladin.chaine.getString("RSPPPV");
        this.BIL = Aladin.chaine.getString("RSPBIL");
        this.METHOD = Aladin.chaine.getString("ARITHMETHOD");
        this.PLANE = Aladin.chaine.getString("ARITHPLANE");
        this.PLANEVALUE = Aladin.chaine.getString("ARITHPLANEVALUE");
    }

    protected FrameArithmetic(Aladin aladin) {
        super(aladin);
        Aladin.setIcon(this);
    }

    @Override
    protected String getTitre() {
        return this.TITLE;
    }

    @Override
    protected String getInformation() {
        return this.INFO;
    }

    @Override
    protected String getHelp() {
        return this.HELP1;
    }

    @Override
    protected int getToolNumber() {
        return -2;
    }

    @Override
    protected int getNb() {
        return 2;
    }

    @Override
    protected String getLabelSelector(int i) {
        return i == 0 ? this.PLANE : this.PLANEVALUE;
    }

    @Override
    protected Plan[] getPlan() {
        Vector<Plan> v = this.a.calque.getPlans(1);
        if (v == null) {
            return new PlanImage[0];
        }
        Object[] pi = new PlanImage[v.size()];
        v.copyInto(pi);
        return pi;
    }

    @Override
    protected Color getColorLabel(int i) {
        return Color.black;
    }

    @Override
    protected JPanel getAddPanel() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        JPanel p = new JPanel();
        p.setLayout(g);
        this.cbg = new ButtonGroup();
        JPanel pp = new JPanel();
        JRadioButton cb = new JRadioButton(this.ADD);
        cb.setActionCommand(this.ADD);
        this.cbg.add(cb);
        pp.add(cb);
        cb.setSelected(true);
        cb = new JRadioButton(this.SUB);
        cb.setActionCommand(this.SUB);
        this.cbg.add(cb);
        pp.add(cb);
        cb = new JRadioButton(this.MUL);
        cb.setActionCommand(this.MUL);
        this.cbg.add(cb);
        pp.add(cb);
        cb = new JRadioButton(this.DIV);
        cb.setActionCommand(this.DIV);
        this.cbg.add(cb);
        pp.add(cb);
        c.gridwidth = 0;
        c.weightx = 10.0;
        g.setConstraints(pp, c);
        p.add(pp);
        this.cbNorm = new JCheckBox(this.NORM);
        c.fill = 0;
        g.setConstraints(this.cbNorm, c);
        p.add(this.cbNorm);
        c.fill = 1;
        JPanel p2 = new JPanel();
        p2.add(new JLabel(this.METHOD));
        this.cbMethod = new ButtonGroup();
        cb = new JRadioButton(this.PPV);
        cb.setActionCommand(this.PPV);
        this.cbMethod.add(cb);
        cb.setSelected(true);
        p2.add(cb);
        cb = new JRadioButton(this.BIL);
        cb.setActionCommand(this.BIL);
        this.cbMethod.add(cb);
        p2.add(cb);
        c.fill = 0;
        g.setConstraints(p2, c);
        p.add(p2);
        c.fill = 1;
        return p;
    }

    private int getOperation(String s) {
        if (s.equals(this.ADD)) {
            return 0;
        }
        if (s.equals(this.SUB)) {
            return 1;
        }
        if (s.equals(this.MUL)) {
            return 2;
        }
        return 3;
    }

    @Override
    protected void submit() {
        try {
            PlanImage p1 = (PlanImage)this.getPlan(this.ch[0]);
            PlanImage p2 = (PlanImage)this.getPlan(this.ch[1]);
            double coef = 0.0;
            if (p2 == null) {
                coef = Double.parseDouble(((String)this.ch[1].getSelectedItem()).trim());
            }
            int methode = this.cbMethod.getSelection().getActionCommand().equals(this.PPV) ? 0 : 1;
            String s = this.cbg.getSelection().getActionCommand();
            int fct = this.getOperation(s);
            if (this.cbNorm.isSelected()) {
                if (p1 != null) {
                    p1 = PlanImageAlgo.normalise(p1);
                }
                if (p2 != null) {
                    p2 = PlanImageAlgo.normalise(p2);
                }
            }
            this.a.calque.newPlanImageAlgo(s.substring(0, 3), p1, p2, fct, coef, null, methode);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.warning("Arithmetic operation failed !");
        }
    }

    @Override
    protected void adjustWidgets() {
        this.ch[1].setEditable(true);
    }
}

