/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.PlanMoc;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.RectangleD;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;

public class CropTool {
    static final int IN = 0;
    static final int HG = 1;
    static final int HD = 2;
    static final int BD = 3;
    static final int BG = 4;
    static final int H = 5;
    static final int D = 6;
    static final int B = 7;
    static final int G = 8;
    static final int START = 9;
    static final int[] CURSOR = new int[]{12, 6, 4, 5, 7, 8, 11, 9, 10, 5};
    private static final int OK = 0;
    private static final int CLOSE = 1;
    private static final int LABEL_POS = 2;
    private static final int LABEL_RES = 3;
    private static final int LABEL_WIDTH = 4;
    private static final int LABEL_HEIGHT = 5;
    private static final int CHECKBOX_RES = 6;
    static final int W = 20;
    private Aladin aladin;
    private Color color = Color.red;
    private Plan plan;
    private RectangleD r;
    private double resMult;
    private boolean withFullRes;
    private boolean fullRes;
    private boolean visible = false;
    private int edit = -1;
    private StringBuffer stringEdit = null;
    private int moveLabel = -1;
    private int movePoignee = -1;
    private int dragPoignee = -1;
    private double dragX = -1.0;
    private double dragY = -1.0;
    private RectangleD[] rectButton = new RectangleD[7];
    private boolean hasButton = false;
    private int oCursor = -1;

    public CropTool(Aladin aladin, ViewSimple v, Plan plan, double xview, double yview, boolean withFullRes) {
        this.aladin = aladin;
        this.plan = plan;
        PointD p = v.getPosition(xview, yview);
        this.r = new RectangleD(p.x, p.y, 1.0 / v.zoom, 1.0 / v.zoom);
        this.dragX = p.x;
        this.dragY = p.y;
        this.dragPoignee = 9;
        this.visible = true;
        this.withFullRes = withFullRes;
        this.fullRes = false;
        this.resMult = 1.0;
    }

    public void deltaXY(double x, double y) {
        this.r.x += x;
        this.r.y += y;
    }

    public boolean submit(ViewSimple v, double xview, double yview) {
        if (!this.hasButton) {
            return false;
        }
        this.edit = -1;
        if (this.rectButton[0].contains(xview, yview)) {
            this.doCrop(v);
            return true;
        }
        if (this.rectButton[1].contains(xview, yview)) {
            return true;
        }
        for (int i = 2; i < 6; ++i) {
            if (this.rectButton[i] == null || !this.rectButton[i].contains(xview, yview)) continue;
            this.startEdit(i, v);
        }
        if (this.rectButton[6] != null && this.rectButton[6].contains(xview, yview)) {
            this.switchCheckFullRes(v);
        }
        return false;
    }

    public void doCrop(ViewSimple v) {
        if (this.doMocCrop(v)) {
            return;
        }
        this.aladin.calque.newPlanImageByCrop(v, this.getRectangle(), this.getResMult(), this.fullRes);
        this.aladin.log("Crop", v.pref.getLogInfo());
    }

    public boolean doMocCrop(ViewSimple v) {
        Plan p = this.plan;
        if (!(p instanceof PlanMoc)) {
            return false;
        }
        Projection proj = v.getProj();
        Coord[] coo = new Coord[4];
        for (int i = 0; i < 4; ++i) {
            Coord c = new Coord();
            c.x = this.r.x + (i == 1 || i == 2 ? this.r.width : 0.0);
            c.y = this.r.y + (i > 1 ? this.r.height : 0.0);
            proj.getCoord(c);
            coo[i] = c;
        }
        this.aladin.calque.newPlanMoc("Crop " + p.label, (PlanMoc)p, coo);
        return true;
    }

    public void switchCheckFullRes(ViewSimple v) {
        this.fullRes = !this.fullRes;
        this.resMult = this.computeResMult(v);
        this.aladin.view.repaintAll();
    }

    private double getPixelSizeInView(ViewSimple v) {
        Coord coo1 = new Coord();
        Coord coo2 = new Coord();
        Projection proj = v.getProj();
        coo1.x = this.r.x + this.r.width / 2.0;
        coo1.y = this.r.y + this.r.height / 2.0;
        coo2.x = this.r.x + this.r.width / 2.0;
        coo2.y = this.r.y + this.r.height;
        proj.getCoord(coo1);
        proj.getCoord(coo2);
        double tailleDE = Coord.getDist(coo1, coo2) * 2.0;
        return tailleDE / (this.r.height * v.zoom);
    }

    private double computeResMult(ViewSimple v) {
        if (!this.fullRes) {
            return 1.0;
        }
        double resPixelView = this.getPixelSizeInView(v);
        double resPixelSurvey = ((PlanBG)v.pref).getPixelResolution();
        return resPixelView / resPixelSurvey;
    }

    public void startEdit(int i, ViewSimple v) {
        this.edit = i;
        this.stringEdit = new StringBuffer("" + (i == 2 ? Util.myRound(this.r.x + "", 0) + "," + Util.myRound((double)((PlanImage)v.pref).naxis2 - (this.r.y + this.r.height) + "", 0) : (i == 5 ? Util.myRound("" + this.getHeight(v), 0) : (i == 4 ? Util.myRound("" + this.getWidth(v)) : Double.valueOf(this.getResMult())))));
        this.aladin.view.startTimer(500);
    }

    public boolean keyPress(ViewSimple v, KeyEvent e) {
        if (!this.isEditing()) {
            return false;
        }
        int key = e.getKeyCode();
        char k = e.getKeyChar();
        if (key == 27) {
            this.stopEditing();
            return true;
        }
        if (key == 10) {
            try {
                switch (this.edit) {
                    case 2: {
                        int i = this.stringEdit.indexOf(",");
                        if (i <= 0) break;
                        this.r.x = Double.parseDouble(this.stringEdit.substring(0, i).trim());
                        this.r.y = Double.parseDouble(this.stringEdit.substring(i + 1).trim());
                        this.r.y = (double)((PlanImage)v.pref).naxis2 - this.r.y - this.r.height;
                        break;
                    }
                    case 4: {
                        this.r.width = Double.parseDouble(this.stringEdit.toString().trim());
                        if (!(v.pref instanceof PlanBG)) break;
                        this.r.width /= v.zoom * this.getResMult();
                        break;
                    }
                    case 5: {
                        this.r.height = Double.parseDouble(this.stringEdit.toString().trim());
                        if (!(v.pref instanceof PlanBG)) break;
                        this.r.height /= v.zoom * this.getResMult();
                        break;
                    }
                    case 3: {
                        this.resMult = Double.parseDouble(this.stringEdit.toString());
                    }
                }
            }
            catch (NumberFormatException e1) {
                // empty catch block
            }
            this.stopEditing();
            return true;
        }
        if (key == 8 || key == 127) {
            int n = this.stringEdit.length();
            if (n == 0) {
                return false;
            }
            this.stringEdit.deleteCharAt(n - 1);
            return true;
        }
        if (k >= '\u001f' && k <= '\u00ff') {
            this.stringEdit.append(k);
            return true;
        }
        return false;
    }

    public double getWidth(ViewSimple v) {
        if (v.pref instanceof PlanBG) {
            return Math.round(this.r.width * v.zoom * this.getResMult());
        }
        return this.r.width;
    }

    public double getHeight(ViewSimple v) {
        if (v.pref instanceof PlanBG) {
            return Math.round(this.r.height * v.zoom * this.getResMult());
        }
        return this.r.height;
    }

    public RectangleD getRectangle() {
        return new RectangleD(this.r.x, this.r.y, this.r.width, this.r.height);
    }

    public double getResMult() {
        return !this.withFullRes ? 1.0 : this.resMult;
    }

    public void reset() {
        this.setVisible(true);
    }

    public void setVisible(boolean flag) {
        this.visible = flag;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public PointD getFocusPos() {
        if (this.isEditing()) {
            return new PointD(this.rectButton[this.edit].x + this.rectButton[this.edit].width, this.rectButton[this.edit].y);
        }
        return new PointD(this.r.x + this.r.width / 2.0, this.r.y + this.r.height / 2.0);
    }

    public boolean isDragging() {
        return this.visible && this.dragPoignee != -1;
    }

    public boolean isEditing() {
        return this.visible && this.edit != -1;
    }

    public void stopEditing() {
        this.edit = -1;
    }

    public void mouseMove(double xview, double yview, ViewSimple v) {
        if (!this.visible) {
            return;
        }
        this.moveLabel = this.getLabel(xview, yview);
        if (this.moveLabel != -1) {
            return;
        }
        PointD p = v.getPosition(xview, yview);
        this.movePoignee = this.getPoignee(p.x, p.y, v);
    }

    public boolean startDrag(ViewSimple v, double xview, double yview) {
        if (!this.visible) {
            return false;
        }
        PointD p = v.getPosition(xview, yview);
        this.dragPoignee = this.getPoignee(p.x, p.y, v);
        if (this.dragPoignee == -1) {
            this.dragY = -1.0;
            this.dragX = -1.0;
            return false;
        }
        this.dragX = p.x;
        this.dragY = p.y;
        return true;
    }

    public void mouseDrag(ViewSimple vs, int xview, int yview, boolean shift) {
        if (!this.visible) {
            return;
        }
        PointD p = vs.getPosition((double)xview, (double)yview);
        double x = p.x;
        double y = p.y;
        double dx = x - this.dragX;
        double dy = y - this.dragY;
        if (shift && (this.dragPoignee == 1 || this.dragPoignee == 2 || this.dragPoignee == 4 || this.dragPoignee == 3)) {
            if (this.r.width < this.r.height) {
                this.r.width = this.r.height;
            } else {
                this.r.height = this.r.width;
            }
            if (Math.abs(dx) < Math.abs(dy)) {
                dx = dy;
            } else {
                dy = dx;
            }
        }
        switch (this.dragPoignee) {
            case 0: {
                this.r.x += dx;
                this.r.y += dy;
                break;
            }
            case 1: {
                this.r.x += dx;
                this.r.y += dy;
                this.r.width -= dx;
                this.r.height -= dy;
                break;
            }
            case 2: {
                this.r.y += dy;
                this.r.width += dx;
                this.r.height -= dy;
                break;
            }
            case 3: 
            case 9: {
                this.r.width += dx;
                this.r.height += dy;
                break;
            }
            case 4: {
                this.r.x += dx;
                this.r.width -= dx;
                this.r.height += dy;
                break;
            }
            case 5: {
                this.r.y += dy;
                this.r.height -= dy;
                break;
            }
            case 6: {
                this.r.width += dx;
                break;
            }
            case 7: {
                this.r.height += dy;
                break;
            }
            case 8: {
                this.r.x += dx;
                this.r.width -= dx;
            }
        }
        if (this.r.width * vs.zoom < 1.0) {
            this.r.width = 1.0 / vs.zoom;
        }
        if (this.r.height * vs.zoom < 1.0) {
            this.r.height = 1.0 / vs.zoom;
        }
        this.dragX = x;
        this.dragY = y;
    }

    public void endDrag(ViewSimple vs) {
        this.dragPoignee = -1;
        this.dragY = -1.0;
        this.dragX = -1.0;
        if (vs.pref instanceof PlanBG) {
            double f = vs.zoom * this.getResMult();
            this.r.x = (double)Math.round(this.r.x * f) / f;
            this.r.y = (double)Math.round(this.r.y * f) / f;
            this.r.height = (double)Math.round(this.r.height * f) / f;
            this.r.width = (double)Math.round(this.r.width * f) / f;
        } else {
            this.r.x = Math.round(this.r.x);
            this.r.y = Math.round(this.r.y);
            this.r.width = Math.round(this.r.width);
            this.r.height = Math.round(this.r.height);
        }
    }

    private int getLabel(double xview, double yview) {
        try {
            for (int i = 2; i <= 5; ++i) {
                if (!this.fullRes && i == 3 || !this.rectButton[i].contains(xview, yview)) continue;
                return i;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return -1;
    }

    private int getPoignee(double x, double y, ViewSimple v) {
        if (!this.visible) {
            return -1;
        }
        if (this.r.width == 1.0 || this.r.height == 1.0) {
            return 3;
        }
        for (int i = 1; i <= 8; ++i) {
            RectangleD rc = this.getRectPoignee(i, v);
            if (!rc.contains(x, y)) continue;
            return i;
        }
        return this.r.contains(x, y) ? 0 : -1;
    }

    private RectangleD getRectPoignee(int poignee, ViewSimple v) {
        if (!this.visible) {
            return null;
        }
        double w = 20.0 / v.zoom;
        double w2 = w / 2.0;
        switch (poignee) {
            case 1: {
                return new RectangleD(this.r.x - w2, this.r.y - w2, w, w);
            }
            case 2: {
                return new RectangleD(this.r.x + this.r.width - w2, this.r.y - w2, w, w);
            }
            case 3: {
                return new RectangleD(this.r.x + this.r.width - w2, this.r.y + this.r.height - w2, w, w);
            }
            case 4: {
                return new RectangleD(this.r.x - w2, this.r.y + this.r.height - w2, w, w);
            }
            case 5: {
                return new RectangleD(this.r.x + w, this.r.y - w2, this.r.width - 2.0 * w, w);
            }
            case 6: {
                return new RectangleD(this.r.x + this.r.width - w2, this.r.y + w, w, this.r.height - 2.0 * w);
            }
            case 8: {
                return new RectangleD(this.r.x - w2, this.r.y + w, w, this.r.height - 2.0 * w);
            }
            case 7: {
                return new RectangleD(this.r.x + w, this.r.y + this.r.height - w2, this.r.width - 2.0 * w, w);
            }
        }
        return null;
    }

    private void drawCheckbox(Graphics g, int x, int y) {
        if (!this.withFullRes) {
            return;
        }
        String s = "original resolution";
        FontMetrics f = g.getFontMetrics();
        int w = f.stringWidth(s) + 17;
        int h = f.getHeight();
        Util.drawCartouche(g, x, y, w, h, 0.6f, null, Color.white);
        Util.drawCheckbox(g, x, y + 3, null, null, Color.red, this.fullRes);
        g.setColor(Color.black);
        Font ft = g.getFont();
        g.setFont(ft.deriveFont(1));
        g.drawString(s, x + 15, y + h / 2 + 5);
        g.setFont(ft);
        this.rectButton[6] = new RectangleD(x, y, w, h);
    }

    private void drawButton(Graphics g, int code, int x, int y, int w, int h) {
        g.setColor(Aladin.BKGD);
        g.fillRect(x, y, w, h);
        this.rectButton[code] = new RectangleD(x, y, w, h);
        g.setColor(Color.white);
        g.drawLine(x, y, x + w, y);
        g.drawLine(x, y, x, y + h);
        g.setColor(Color.black);
        g.drawLine(x, y + h, x + w, y + h);
        g.drawLine(x + w, y, x + w, y + h);
        String s = Aladin.chaine.getString(code == 0 ? "OK" : "CLOSE");
        FontMetrics f = g.getFontMetrics();
        g.drawString(s, x + w / 2 - f.stringWidth(s) / 2, y + h - 3);
    }

    private void drawLabel(Graphics g, int code, ViewSimple v) {
        PointD hg = v.getPositionInView(this.r.x, this.r.y);
        PointD bd = v.getPositionInView(this.r.x + this.r.width, this.r.y + this.r.height);
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 15;
        boolean ed = this.edit == code;
        String s = ed ? this.stringEdit.toString() : null;
        switch (code) {
            case 3: {
                if (this.fullRes || !this.withFullRes) {
                    return;
                }
                if (s == null) {
                    double r = this.getResMult();
                    s = "res. x " + Util.myRound(r + "", 2);
                }
                w = g.getFontMetrics().stringWidth(s);
                x = (int)(hg.x + (double)(h / 2) + 2.0);
                y = (int)(bd.y - (double)h - 3.0);
                break;
            }
            case 2: {
                if (v.pref instanceof PlanBG) {
                    return;
                }
                if (s == null) {
                    s = Util.myRound(this.r.x + "", 0) + "," + Util.myRound("" + ((double)((PlanImage)v.pref).naxis2 - (this.r.y + this.r.height)), 0);
                }
                w = g.getFontMetrics().stringWidth(s);
                x = (int)(hg.x + (double)(h / 2) + 2.0);
                y = (int)(bd.y - (double)h - 3.0);
                break;
            }
            case 4: {
                if (s == null) {
                    s = Util.myRound("" + this.getWidth(v), 0);
                }
                w = g.getFontMetrics().stringWidth(s);
                x = (int)(bd.x + hg.x) / 2 - w / 2;
                y = (int)(hg.y + 3.0);
                break;
            }
            case 5: {
                if (s == null) {
                    s = Util.myRound("" + this.getHeight(v), 0);
                }
                w = g.getFontMetrics().stringWidth(s);
                x = (int)(bd.x - (double)w - (double)(h / 2) - 1.0);
                y = (int)(bd.y + hg.y) / 2 - h / 2;
            }
        }
        Util.drawCartouche(g, x, y, w, h, ed ? 1.0f : 0.6f, ed ? Color.black : null, Color.white);
        g.setColor(Color.black);
        Font ft = g.getFont();
        g.setFont(ft.deriveFont(1));
        g.drawString(s, x, y + h / 2 + 5);
        g.setFont(ft);
        this.rectButton[code] = new RectangleD(x, y, w, h);
        if (ed) {
            boolean blink;
            x = x + w - 1;
            boolean bl = blink = System.currentTimeMillis() / 500L % 2L == 0L;
            if (blink) {
                g.setColor(Color.black);
                g.drawLine(x, y + 2, x, y + h - 2);
                g.drawLine(x + 1, y + 2, x + 1, y + h - 2);
            }
        }
    }

    public void draw(Graphics g, ViewSimple v) {
        if (!this.visible) {
            return;
        }
        this.withFullRes = v.pref instanceof PlanBG && v.pref.hasAvailablePixels();
        g.setColor(this.color);
        PointD hg = v.getPositionInView(this.r.x, this.r.y);
        PointD bd = v.getPositionInView(this.r.x + this.r.width, this.r.y + this.r.height);
        RectangleD rc = new RectangleD(hg.x, hg.y, bd.x - hg.x + 1.0, bd.y - hg.y + 1.0);
        int w = v.getWidth();
        int h = v.getHeight();
        Util.drawArea(this.aladin, g, 0, 0, w, (int)rc.y, this.color, 0.15f, false);
        Util.drawArea(this.aladin, g, 0, (int)rc.y, (int)rc.x, (int)rc.height, this.color, 0.15f, false);
        Util.drawArea(this.aladin, g, (int)(rc.x + rc.width), (int)rc.y, (int)((double)w - (rc.x + rc.width)), (int)rc.height, this.color, 0.15f, false);
        Util.drawArea(this.aladin, g, 0, (int)rc.y + (int)rc.height, w, (int)((double)h - (rc.y + rc.height)), this.color, 0.15f, false);
        g.drawRect((int)hg.x, (int)hg.y, (int)(bd.x - hg.x + 1.0), (int)(bd.y - hg.y + 1.0));
        this.hasButton = false;
        boolean flagMoc = this.plan instanceof PlanMoc;
        if (!flagMoc && bd.x - hg.x > 80.0 && bd.y - hg.y > 50.0) {
            this.drawLabel(g, 3, v);
            this.drawLabel(g, 2, v);
            this.drawLabel(g, 4, v);
            this.drawLabel(g, 5, v);
        }
        int x = (int)((bd.x + hg.x) / 2.0 - 45.0);
        int y = (int)(bd.y + (double)(bd.y - hg.y > 2.0 * (double)v.getHeight() / 3.0 ? -25 : 15));
        if (this.dragX == -1.0) {
            this.drawButton(g, 0, x, y, 45, 15);
            this.drawButton(g, 1, x + 45 + 5, y, 50, 15);
            this.hasButton = true;
        }
        if (!flagMoc) {
            x = (int)(hg.x + 10.0);
            y = (int)(hg.y + (double)(bd.y - hg.y > 2.0 * (double)v.getHeight() / 3.0 ? 4 : -20));
            this.drawCheckbox(g, x, y);
        }
        int cursor = 0;
        if (this.moveLabel != -1) {
            cursor = 2;
        } else {
            int fleche;
            int n = fleche = this.dragPoignee != -1 ? this.dragPoignee : this.movePoignee;
            if (fleche != -1) {
                cursor = CURSOR[fleche];
            }
        }
        if (cursor != this.oCursor) {
            this.oCursor = cursor;
            v.setCursor(new Cursor(cursor));
        }
    }
}

