/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Calque;
import cds.aladin.Plan;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

public final class Couleur
extends JComponent
implements MouseListener {
    static final int W = 20;
    static final int GAP = 4;
    int w = 16;
    static int iDC = 0;
    int ww = 20;
    int gap = 4;
    private boolean noColor = false;
    static final int NBDEFAULTCOLORS = 22;
    static Color[] DC;
    static Color[] DC1;
    Color[] dc;
    Rectangle[] dcRect;
    int row;
    int current = -1;
    boolean first;
    private Dimension DIM;
    private ActionListener listener = null;

    protected Couleur() {
        this(null);
    }

    protected Couleur(Color c) {
        this(c, false);
    }

    protected Couleur(Color c, boolean flagNoColor) {
        this.dc = DC;
        this.noColor = flagNoColor;
        this.setCouleur(c);
        this.DIM = new Dimension(this.dc.length / 2 * 20, 40);
        this.first = true;
        this.row = this.dc.length / 2;
        this.addMouseListener(this);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.DIM;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.DIM;
    }

    private static int nextRand() {
        return (int)(Math.random() * 1000.0) % 256;
    }

    private static void initDefaultColors() {
        int n = 22;
        DC = new Color[n];
        for (int i = 0; i < n; ++i) {
            Couleur.DC[i] = i < DC1.length ? DC1[i] : new Color(Couleur.nextRand(), Couleur.nextRand(), Couleur.nextRand());
        }
    }

    protected Couleur(Color c, int width, int gap) {
        this.dc = DC;
        this.setCouleur(c);
        if (width > gap) {
            this.ww = width;
            this.gap = gap;
            this.w = this.ww - this.gap;
        }
        this.DIM = new Dimension(DC.length / 2 * this.ww, 2 * this.ww);
        this.first = true;
        this.row = this.dc.length / 2;
        this.addMouseListener(this);
    }

    protected Couleur(Color c, int width, int gap, Color[] tabcoul) {
        int i;
        this.dc = new Color[DC1.length + tabcoul.length];
        for (i = 0; i < DC1.length; ++i) {
            this.dc[i] = DC1[i];
        }
        for (i = 0; i < tabcoul.length; ++i) {
            this.dc[i + Couleur.DC1.length] = tabcoul[i];
        }
        this.row = this.dc.length / 2;
        this.setCouleur(c);
        if (width > gap) {
            this.ww = width;
            this.gap = gap;
            this.w = this.ww - this.gap;
        }
        this.DIM = new Dimension(this.dc.length / 2 * this.ww, 2 * this.ww);
        this.first = true;
        this.addMouseListener(this);
    }

    protected Couleur(Color[] tabcoul, Color c, int width, int gap) {
        this.dc = new Color[tabcoul.length];
        for (int i = 0; i < tabcoul.length; ++i) {
            this.dc[i] = tabcoul[i];
        }
        this.row = this.dc.length / 2;
        this.setCouleur(c);
        if (width > gap) {
            this.ww = width;
            this.gap = gap;
            this.w = this.ww - this.gap;
        }
        this.DIM = new Dimension(this.dc.length / 2 * this.ww, 2 * this.ww);
        this.first = true;
        this.addMouseListener(this);
    }

    protected void setNoColorFlag(boolean flag) {
        this.noColor = flag;
    }

    protected static Color getNextDefault(Calque calque) {
        int j;
        Plan[] allPlan = calque.getPlans();
        for (j = 0; j < DC.length; ++j) {
            int i;
            for (i = 0; i < allPlan.length && (allPlan[i].type == 0 || DC[j] != allPlan[i].c); ++i) {
            }
            if (i == allPlan.length) break;
        }
        if (j == DC.length) {
            if (++iDC == DC.length) {
                iDC = 0;
            }
            j = iDC;
        }
        return DC[j];
    }

    protected static boolean isFree(Calque calque, Color c) {
        Plan[] allPlan = calque.getPlans();
        for (int i = 0; i < allPlan.length; ++i) {
            if (allPlan[i].type == 0 || c != allPlan[i].c) continue;
            return false;
        }
        return true;
    }

    protected boolean setCouleur(Color c) {
        if (this.noColor && c == null) {
            this.current = this.dc.length - 1;
            return true;
        }
        for (int i = 0; i < this.dc.length; ++i) {
            if (!c.equals(this.dc[i])) continue;
            this.current = i;
            this.repaint();
            return true;
        }
        return false;
    }

    protected Color getCouleur() {
        if (this.current == -1 || this.noColor && this.current == this.dc.length - 1) {
            return null;
        }
        return this.dc[this.current];
    }

    protected static Color getCouleur(int i) {
        return DC[i % DC.length];
    }

    private int getIndice(int x, int y) {
        if (this.dcRect == null) {
            return -1;
        }
        Point p = new Point(x, y);
        for (int i = 0; i < this.dcRect.length; ++i) {
            if (!this.dcRect[i].contains(p)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int current = this.getIndice(e.getX(), e.getY());
        if (this.current != current) {
            this.current = current;
            if (this.listener != null) {
                this.listener.actionPerformed(new ActionEvent(this, 1001, ""));
            }
            this.repaint();
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.first) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.dc.length / 2 * this.ww, 2 * this.ww);
            this.first = false;
        }
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < this.row; ++i) {
                Color c2;
                Color c1;
                int k = j * this.row + i;
                if (this.dcRect == null) {
                    this.dcRect = new Rectangle[this.dc.length];
                }
                if (this.dcRect[k] == null) {
                    this.dcRect[k] = new Rectangle(i * this.ww, j * this.ww, this.w, this.w);
                }
                boolean onNoColor = this.noColor && k == this.dc.length - 1;
                g.setColor(onNoColor ? Color.white : this.dc[k]);
                g.fillRect(this.dcRect[k].x, this.dcRect[k].y, this.dcRect[k].width, this.dcRect[k].height);
                if (k != this.current) {
                    c1 = Color.white;
                    c2 = Color.black;
                } else {
                    c2 = Color.white;
                    c1 = Color.black;
                }
                g.setColor(c1);
                g.drawLine(this.dcRect[k].x, this.dcRect[k].y + this.dcRect[k].height, this.dcRect[k].x, this.dcRect[k].y);
                g.drawLine(this.dcRect[k].x, this.dcRect[k].y, this.dcRect[k].x + this.dcRect[k].width, this.dcRect[k].y);
                g.setColor(c2);
                g.drawLine(this.dcRect[k].x + this.w, this.dcRect[k].y, this.dcRect[k].x + this.dcRect[k].width, this.dcRect[k].y + this.dcRect[k].height);
                g.drawLine(this.dcRect[k].x + this.w, this.dcRect[k].y + this.dcRect[k].height, this.dcRect[k].x, this.dcRect[k].y + this.dcRect[k].height);
                if (!onNoColor) continue;
                g.setColor(Color.black);
                g.drawLine(this.dcRect[k].x, this.dcRect[k].y, this.dcRect[k].x + this.dcRect[k].width, this.dcRect[k].y + this.dcRect[k].height);
                g.drawLine(this.dcRect[k].x, this.dcRect[k].y + this.dcRect[k].height, this.dcRect[k].x + this.dcRect[k].width, this.dcRect[k].y);
            }
        }
    }

    protected static Color[] getBrighterColors(Color c, int nb) {
        Color[] colors = new Color[nb];
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        float step = (hsb[1] - 0.15f) / (float)Math.max(1, nb - 1);
        for (int i = 0; i < nb; ++i) {
            colors[i] = Color.getHSBColor(hsb[0], hsb[1] - (float)i * step, hsb[2]);
        }
        return colors;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void addActionListener(ActionListener l) {
        this.listener = l;
    }

    public void removeActionListener(ActionListener l) {
        this.listener = null;
    }

    static {
        DC1 = new Color[]{Color.red, Color.blue, new Color(153, 204, 0), new Color(255, 255, 0), new Color(0, 0, 102), new Color(0, 255, 255), new Color(153, 0, 204), new Color(0, 153, 204), new Color(204, 153, 0), new Color(204, 0, 153), new Color(0, 254, 153), new Color(102, 51, 51), new Color(255, 204, 154), new Color(255, 154, 204), new Color(154, 255, 51), new Color(102, 0, 0), new Color(255, 154, 51), new Color(255, 0, 255), new Color(0, 255, 0), new Color(0, 0, 0), new Color(255, 255, 255)};
        Couleur.initDefaultColors();
    }
}

