/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.ContourAlgorithm;
import cds.aladin.PointD;
import cds.tools.Util;

public final class ContourPlot
extends ContourAlgorithm {
    int xSteps;
    int ySteps;
    private short[][] z;
    private int compteur;
    private boolean newContour;
    private PointD p1;
    private PointD p2;
    private PointD pTemp;
    private PointD firstPoint;
    int[] l1 = new int[4];
    int[] l2 = new int[4];
    int[] ij = new int[2];
    int[] i1 = new int[2];
    int[] i2 = new int[2];
    int[] i3 = new int[6];
    int ibkey;
    int icur;
    int jcur;
    int ii;
    int jj;
    int elle;
    int ix;
    int iedge;
    int iflag;
    int ni;
    int ks;
    int idir;
    int nxidir;
    int k;
    int z1;
    int z2;
    double cval;
    double[] intersect = new double[4];
    double[] xy = new double[2];
    double[] prevXY = new double[2];
    float lev;
    boolean[] workSpace;
    boolean jump;
    private double prevU;
    private double prevV;
    private double u;
    private double v;
    private PointD[] Contours;
    int index;
    int nb = 0;

    public ContourPlot() {
        this.init();
    }

    private int sign(int a, int b) {
        a = Math.abs(a);
        if (b < 0) {
            return -a;
        }
        return a;
    }

    void DrawKernel() {
        if (this.iflag == 1 || this.iflag == 4 || this.iflag == 5) {
            this.prevU = this.prevXY[0] - 1.0;
            this.prevV = this.prevXY[1] - 1.0;
            this.u = this.xy[0] - 1.0;
            this.v = this.xy[1] - 1.0;
            this.p1 = new PointD(this.prevU, this.prevV);
            this.p2 = new PointD(this.u, this.v);
            if (this.newContour) {
                this.newContour = false;
                this.firstPoint = this.p1;
            }
            this.pTemp = new PointD(-1.0, -1.0);
            if (this.index > 0) {
                this.pTemp = this.Contours[this.index - 1];
            }
            if (this.index == 0 || this.pTemp == null || (int)this.p1.x != (int)this.pTemp.x || (int)this.p1.y != (int)this.pTemp.y) {
                this.check();
                this.Contours[this.index] = this.p1;
                ++this.index;
            }
            this.pTemp = this.Contours[this.index - 1];
            if ((int)this.p2.x != (int)this.pTemp.x || (int)this.p2.y != (int)this.pTemp.y) {
                this.check();
                this.Contours[this.index] = this.p2;
                ++this.index;
            }
            this.nb += 2;
            if (Aladin.isSlow && this.nb % 300 == 0) {
                Util.pause(10);
            }
        }
        this.prevXY[0] = this.xy[0];
        this.prevXY[1] = this.xy[1];
    }

    void DetectBoundary() {
        this.ix = 1;
        if (this.ij[1 - this.elle] != 1) {
            this.ii = this.ij[0] - this.i1[1 - this.elle];
            this.jj = this.ij[1] - this.i1[this.elle];
            this.ii = this.ij[0] + this.i2[this.elle];
            this.jj = this.ij[1] + this.i2[1 - this.elle];
            this.ix = 0;
            if (this.ij[1 - this.elle] >= this.l1[1 - this.elle]) {
                this.ix += 2;
                return;
            }
        }
        this.ii = this.ij[0] + this.i1[1 - this.elle];
        this.jj = this.ij[1] + this.i1[this.elle];
    }

    boolean Routine_label_020() {
        this.l2[0] = this.ij[0];
        this.l2[1] = this.ij[1];
        this.l2[2] = -this.ij[0];
        this.l2[3] = -this.ij[1];
        this.idir = 0;
        this.nxidir = 1;
        this.k = 1;
        this.ij[0] = Math.abs(this.ij[0]);
        this.ij[1] = Math.abs(this.ij[1]);
        this.elle = 0;
        return false;
    }

    boolean Routine_label_050() {
        while (this.ij[this.elle] >= this.l1[this.elle]) {
            if (++this.elle <= 1) continue;
            this.elle = this.idir % 2;
            this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
            if (!this.Routine_label_150()) continue;
            return true;
        }
        this.ii = this.ij[0] + this.i1[this.elle];
        this.jj = this.ij[1] + this.i1[1 - this.elle];
        this.jump = false;
        return false;
    }

    boolean Routine_label_150() {
        ++this.compteur;
        if (Aladin.isSlow && this.compteur % 2000 == 0) {
            Util.pause(10);
        }
        while (true) {
            if (this.ij[this.elle] < this.l1[this.k - 1]) {
                int n = this.elle;
                this.ij[n] = this.ij[n] + 1;
                if (this.ij[this.elle] > this.l2[this.k - 1]) {
                    this.l2[this.k - 1] = this.ij[this.elle];
                    this.idir = this.nxidir;
                    this.k = this.nxidir = this.idir + 1;
                    if (this.nxidir > 3) {
                        this.nxidir = 0;
                    }
                }
                this.ij[0] = Math.abs(this.ij[0]);
                this.ij[1] = Math.abs(this.ij[1]);
                this.elle = 0;
                return false;
            }
            if (this.idir != this.nxidir) {
                this.ij[this.elle] = this.l1[this.k - 1];
                this.k = ++this.nxidir;
                this.elle = 1 - this.elle;
                this.ij[this.elle] = this.l2[this.k - 1];
                if (this.nxidir <= 3) continue;
                this.nxidir = 0;
                continue;
            }
            if (this.ibkey != 0) {
                return true;
            }
            this.ibkey = 1;
            this.ij[0] = this.icur;
            this.ij[1] = this.jcur;
            if (!this.Routine_label_020()) break;
        }
        return false;
    }

    short Routine_label_200() {
        while (true) {
            this.xy[this.elle] = (double)this.ij[this.elle] + this.intersect[this.iedge - 1];
            this.xy[1 - this.elle] = this.ij[1 - this.elle];
            this.workSpace[2 * (this.xSteps * (this.ij[1] - 1) + this.ij[0] - 1) + this.elle] = true;
            this.DrawKernel();
            if (this.iflag >= 4) {
                this.icur = this.ij[0];
                this.jcur = this.ij[1];
                return 1;
            }
            this.ContinueContour();
            if (!this.workSpace[2 * (this.xSteps * (this.ij[1] - 1) + this.ij[0] - 1) + this.elle]) {
                return 2;
            }
            this.iflag = 5;
            this.iedge = this.ks + 2;
            if (this.iedge > 4) {
                this.iedge -= 4;
            }
            this.intersect[this.iedge - 1] = this.intersect[this.ks - 1];
        }
    }

    boolean CrossedByContour() {
        this.ii = this.ij[0] + this.i1[this.elle];
        this.jj = this.ij[1] + this.i1[1 - this.elle];
        this.z1 = this.z[this.ij[0] - 1][this.ij[1] - 1];
        this.z2 = this.z[this.ii - 1][this.jj - 1];
        int i = 2 * (this.xSteps * (this.ij[1] - 1) + this.ij[0] - 1) + this.elle;
        if (!this.workSpace[i] && this.lev > (float)Math.min(this.z1, this.z2) && this.lev <= (float)Math.max(this.z1, this.z2)) {
            this.workSpace[i] = true;
            return true;
        }
        return false;
    }

    void ContinueContour() {
        this.ni = 1;
        if (this.iedge >= 3) {
            this.ij[0] = this.ij[0] - this.i3[this.iedge - 1];
            this.ij[1] = this.ij[1] - this.i3[this.iedge + 1];
        }
        for (int local_k = 1; local_k < 5; local_k = (int)((short)(local_k + 1))) {
            if (local_k == this.iedge) continue;
            this.ii = this.ij[0] + this.i3[local_k - 1];
            this.jj = this.ij[1] + this.i3[local_k];
            this.z1 = this.z[this.ii - 1][this.jj - 1];
            this.ii = this.ij[0] + this.i3[local_k];
            this.jj = this.ij[1] + this.i3[local_k + 1];
            this.z2 = this.z[this.ii - 1][this.jj - 1];
            if (!(this.cval > (double)Math.min(this.z1, this.z2)) || !(this.cval <= (double)Math.max(this.z1, this.z2))) continue;
            if (local_k == 1 || local_k == 4) {
                int zz = this.z2;
                this.z2 = this.z1;
                this.z1 = zz;
            }
            this.intersect[local_k - 1] = (this.cval - (double)this.z1) / (double)(this.z2 - this.z1);
            ++this.ni;
            this.ks = local_k;
        }
        if (this.ni != 2) {
            this.ks = 5 - this.iedge;
            if (this.intersect[2] >= this.intersect[0]) {
                this.ks = 3 - this.iedge;
                if (this.ks <= 0) {
                    this.ks += 4;
                }
            }
        }
        this.elle = this.ks - 1;
        this.iflag = 1;
        this.jump = true;
        if (this.ks >= 3) {
            this.ij[0] = this.ij[0] + this.i3[this.ks - 1];
            this.ij[1] = this.ij[1] + this.i3[this.ks + 1];
            this.elle = this.ks - 3;
        }
    }

    void ContourPlotKernel() {
        this.l1[0] = this.xSteps;
        this.l1[1] = this.ySteps;
        this.l1[2] = -1;
        this.l1[3] = -1;
        this.i1[0] = 1;
        this.i1[1] = 0;
        this.i2[0] = 1;
        this.i2[1] = -1;
        this.i3[0] = 1;
        this.i3[1] = 0;
        this.i3[2] = 0;
        this.i3[3] = 1;
        this.i3[4] = 1;
        this.i3[5] = 0;
        this.prevXY[0] = 0.0;
        this.prevXY[1] = 0.0;
        this.xy[0] = 1.0;
        this.xy[1] = 1.0;
        this.iflag = 6;
        this.DrawKernel();
        this.icur = Math.max(1, Math.min((int)Math.floor(this.xy[0]), this.xSteps));
        this.jcur = Math.max(1, Math.min((int)Math.floor(this.xy[1]), this.ySteps));
        this.ibkey = 0;
        this.ij[0] = this.icur;
        this.ij[1] = this.jcur;
        if (this.Routine_label_020() && this.Routine_label_150()) {
            return;
        }
        if (this.Routine_label_050()) {
            return;
        }
        while (true) {
            short val_label_200;
            this.DetectBoundary();
            if (this.jump) {
                if (this.ix != 0) {
                    this.iflag = 4;
                }
                this.iedge = this.ks + 2;
                if (this.iedge > 4) {
                    this.iedge -= 4;
                }
                this.intersect[this.iedge - 1] = this.intersect[this.ks - 1];
                val_label_200 = this.Routine_label_200();
                if (val_label_200 == 1) {
                    if (this.Routine_label_020() && this.Routine_label_150()) {
                        return;
                    }
                    if (!this.Routine_label_050()) continue;
                    return;
                }
                if (val_label_200 == 2) continue;
                return;
            }
            if (this.ix != 3 && this.ix + this.ibkey != 0 && this.CrossedByContour()) {
                this.newContour = true;
                if (this.index > 0 && this.p2 != null && !this.p2.equals(this.Contours[this.index - 1]) && this.distance(this.p2, this.firstPoint) < 2.0) {
                    this.check();
                    this.Contours[this.index] = this.p2;
                    ++this.index;
                }
                this.check();
                this.Contours[this.index] = null;
                ++this.index;
                this.iedge = this.elle + 1;
                this.cval = this.lev;
                if (this.ix != 1) {
                    this.iedge += 2;
                }
                this.iflag = 2 + this.ibkey;
                this.intersect[this.iedge - 1] = (this.cval - (double)this.z1) / (double)(this.z2 - this.z1);
                val_label_200 = this.Routine_label_200();
                if (val_label_200 == 1) {
                    if (this.Routine_label_020() && this.Routine_label_150()) {
                        return;
                    }
                    if (!this.Routine_label_050()) continue;
                    return;
                }
                if (val_label_200 == 2) continue;
                return;
            }
            if (++this.elle > 1) {
                this.elle = this.idir % 2;
                this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
                if (this.Routine_label_150()) {
                    return;
                }
            }
            if (this.Routine_label_050()) break;
        }
    }

    @Override
    protected PointD[] getContours() {
        this.init();
        this.z = new short[this.width][this.height];
        for (int j = 0; j < this.height; ++j) {
            int a = j * this.width;
            for (int i = 0; i < this.width; ++i) {
                this.z[i][j] = this.data[a + i];
            }
        }
        this.xSteps = this.width - 1;
        this.ySteps = this.height - 1;
        int workLength = 2 * this.xSteps * this.ySteps;
        this.workSpace = new boolean[workLength];
        this.ContourPlotKernel();
        PointD[] tmp = new PointD[this.index];
        System.arraycopy(this.Contours, 0, tmp, 0, this.index);
        this.Contours = tmp;
        this.pc.updatePourcent(1.0);
        return this.Contours;
    }

    protected void init() {
        this.compteur = 0;
        this.index = 0;
        this.nb = 0;
        this.Contours = new PointD[5000];
    }

    private PointD[] realloc(PointD[] tab) {
        PointD[] tmp = new PointD[tab.length + 5000];
        System.arraycopy(tab, 0, tmp, 0, tab.length);
        return tmp;
    }

    private void check() {
        if (this.index == this.Contours.length) {
            this.Contours = this.realloc(this.Contours);
        }
    }

    @Override
    protected void setLevel(double level) {
        this.level = level;
        this.lev = (float)level;
    }

    private double distance(PointD a, PointD b) {
        return Math.sqrt(Math.pow(a.x - b.x, 2.0) + Math.pow(a.y - b.y, 2.0));
    }
}

