/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.FilterProperties;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.Source;
import cds.aladin.UCDFilter;
import cds.savot.model.SavotField;
import cds.tools.parser.Parser;
import cds.tools.parser.ParserException;
import cds.xml.Field;
import java.util.Iterator;
import java.util.Vector;

public class ColumnCalculator {
    private SavotField[] fields;
    private String[] expr;
    private Plan p;
    private Expression[] parsers;
    private String error = "";
    private Aladin a;
    private int nbDec;

    protected ColumnCalculator(SavotField[] fields, String[] expr, Plan p, int nbDec, Aladin a) {
        this(a);
        this.setFields(fields);
        this.setExpr(expr);
        this.setPlan(p);
        this.setNbDec(nbDec);
    }

    protected ColumnCalculator(Aladin a) {
        this.a = a;
    }

    protected void setNbDec(int nbDec) {
        this.nbDec = nbDec;
    }

    protected void setFields(SavotField[] fields) {
        this.fields = fields;
    }

    protected void setExpr(String[] expr) {
        this.expr = expr;
        this.parsers = null;
    }

    protected void setPlan(Plan p) {
        this.p = p;
    }

    protected boolean createParser() {
        this.error = "";
        if (this.expr == null || this.fields == null || this.p == null) {
            this.error = "One of the parameters was null";
            return false;
        }
        int i = 0;
        this.parsers = new Expression[this.expr.length];
        try {
            for (i = 0; i < this.expr.length; ++i) {
                this.parsers[i] = new Expression(this.expr[i]);
                if (this.parsers[i].createParser()) continue;
                throw new ParserException();
            }
        }
        catch (ParserException e) {
            this.error = this.parsers[i].error;
            return false;
        }
        return true;
    }

    protected String getError() {
        return this.error;
    }

    protected boolean compute() {
        int i;
        if (this.parsers == null && !this.createParser()) {
            return false;
        }
        Source[] sources = this.getSources();
        if (sources == null) {
            return true;
        }
        Field[] myFields = new Field[this.fields.length];
        for (int i2 = 0; i2 < myFields.length; ++i2) {
            myFields[i2] = new Field(this.fields[i2].getName());
            myFields[i2].arraysize = this.fields[i2].getArraySize();
            myFields[i2].datatype = "D";
            myFields[i2].description = this.fields[i2].getDescription();
            myFields[i2].ID = this.fields[i2].getId();
            myFields[i2].precision = this.fields[i2].getPrecision();
            myFields[i2].ucd = this.fields[i2].getUcd();
            myFields[i2].unit = this.fields[i2].getUnit();
            myFields[i2].width = "10";
            myFields[i2].computeColumnSize();
        }
        for (i = 0; i < sources.length; ++i) {
            Source s = sources[i];
            for (int j = 0; j < this.parsers.length; ++j) {
                Expression parser = this.parsers[j];
                String value = parser.eval(s, this.nbDec);
                this.addCol(myFields[j], value, s);
            }
        }
        this.a.view.setMesure();
        FilterProperties.majFilterProp(false, true);
        for (i = 0; i < this.parsers.length; ++i) {
            this.a.log("newcolumn", "name=" + this.fields[i].getName() + " expr=" + this.expr[i] + " catplane=" + this.p.label);
        }
        return true;
    }

    private void addCol(Field field, String value, Source s) {
        if (s.leg.field[s.leg.field.length - 1] != field) {
            Field[] newFields = new Field[s.leg.field.length + 1];
            boolean[] newComputed = new boolean[s.leg.computed.length + 1];
            System.arraycopy(s.leg.field, 0, newFields, 0, s.leg.field.length);
            System.arraycopy(s.leg.computed, 0, newComputed, 0, s.leg.computed.length);
            newFields[s.leg.field.length] = field;
            newComputed[s.leg.computed.length] = true;
            s.leg.field = newFields;
            s.leg.computed = newComputed;
        }
        s.info = new String(s.info + "\t" + value);
        s.fixInfo();
    }

    private Source[] getSources() {
        Vector<Source> vec = new Vector<Source>();
        Iterator<Obj> it = this.p.iterator();
        while (it.hasNext()) {
            Source s;
            Obj o = it.next();
            if (!(o instanceof Source) || (s = (Source)o) == null) continue;
            vec.addElement(s);
        }
        Object[] sources = new Source[vec.size()];
        vec.copyInto(sources);
        vec = null;
        return sources;
    }

    public static double round(double d, int nbDec) {
        if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
            return d;
        }
        double fact = Math.pow(10.0, nbDec);
        return (double)Math.round(d * fact) / fact;
    }

    public static String format(double d, int nbDec) {
        String s = Double.toString(d);
        int sepIndex = s.indexOf(".");
        if (sepIndex >= 0) {
            int end;
            int expIndex = s.indexOf("E");
            int n = end = s.length() > sepIndex + nbDec + 1 ? sepIndex + nbDec + 1 : s.length();
            if (expIndex >= 0) {
                end = expIndex > end ? end : expIndex;
            }
            String saveText = new String(s);
            s = s.substring(0, end);
            if (expIndex >= 0) {
                s = s + saveText.substring(expIndex);
            }
        }
        return s;
    }

    class Expression {
        String error = "";
        String s;
        UCDFilter condFilter;
        boolean conditional = false;
        Parser parser1;
        Parser parser2;

        Expression(String s) {
            this.s = s;
        }

        boolean createParser() {
            int qMarkIndex = this.s.indexOf(63);
            int dbPointIndex = this.s.lastIndexOf(58);
            if (qMarkIndex >= 0 && dbPointIndex >= 0) {
                this.conditional = true;
            }
            if (!this.conditional) {
                try {
                    this.parser1 = UCDFilter.createParser(this.s.replace('$', ' ').trim(), ColumnCalculator.this.a);
                }
                catch (ParserException e) {
                    this.error = "Incorrect syntax for expression " + this.s;
                    return false;
                }
            }
            String condStr = this.s.substring(0, qMarkIndex);
            String parser1Str = this.s.substring(qMarkIndex + 1, dbPointIndex);
            String parser2Str = this.s.substring(dbPointIndex + 1);
            this.condFilter = new UCDFilter("test", condStr + " {}", ColumnCalculator.this.a, null);
            if (this.condFilter.badSyntax) {
                this.error = "Incorrect syntax for condition " + condStr;
                return false;
            }
            try {
                this.parser1 = UCDFilter.createParser(parser1Str.replace('$', ' ').trim(), ColumnCalculator.this.a);
            }
            catch (ParserException e) {
                this.error = "Incorrect syntax for expression " + parser1Str;
                return false;
            }
            try {
                this.parser2 = UCDFilter.createParser(parser2Str.replace('$', ' ').trim(), ColumnCalculator.this.a);
            }
            catch (ParserException e) {
                this.error = "Incorrect syntax for expression " + parser2Str;
                return false;
            }
            return true;
        }

        String eval(Source s, int nbDec) {
            String value = "";
            if (this.conditional) {
                if (this.condFilter.verifyValueConstraints(s, 0)) {
                    if (Action.setAllVariables(this.parser1, s, false)) {
                        value = ColumnCalculator.format(this.parser1.eval(), nbDec);
                    }
                } else if (Action.setAllVariables(this.parser2, s, false)) {
                    value = ColumnCalculator.format(this.parser2.eval(), nbDec);
                }
            } else if (Action.setAllVariables(this.parser1, s, false)) {
                value = ColumnCalculator.format(this.parser1.eval(), nbDec);
            }
            return value;
        }
    }
}

