/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameHeaderFits;
import cds.aladin.FrameInfo;
import cds.aladin.MyInputStream;
import cds.aladin.Pcat;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.ServerSkybot;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class Chaine {
    private static String STRINGFILE = "Aladin.string";
    private static String STRINGFILE0 = "Aladin0.string";
    private boolean flagAll = false;
    protected static Hashtable map;
    private Aladin aladin;
    private String lastFileName = null;
    private ArrayList defList = null;
    private boolean loadDefList = false;
    private static SimpleAttributeSet atKey;
    private static SimpleAttributeSet atValue;
    private static SimpleAttributeSet atLang;
    private static SimpleAttributeSet atCom;
    private static SimpleAttributeSet atHist;
    private static SimpleAttributeSet atYellow;
    private static SimpleAttributeSet atWhite;
    private boolean first = true;
    private JButton clear;
    private JFrame frame;
    private DefaultStyledDocument df;
    JTextPane ta;
    JTextField ts;

    Chaine(Aladin aladin) {
        this.aladin = aladin;
        if (map == null) {
            map = new Hashtable(4000);
            this.loadDefList = true;
            this.defList = new ArrayList(1500);
            this.loadFile(STRINGFILE0);
            this.loadDefList = false;
            this.loadAddFiles();
        }
        this.createChaine();
    }

    protected void createChaine() {
        Pcat.createChaine(this);
        Plan.createChaine(this);
        FrameInfo.createChaine(this);
        PlanImage.createChaine(this);
        ServerSkybot.createChaine(this);
        FrameHeaderFits.createChaine(this);
    }

    private static String replaceNL(String s) {
        char[] a = s.toCharArray();
        boolean slash = false;
        int i = 0;
        int j = 0;
        while (i < a.length) {
            int c = a[i];
            if (slash && c == 110) {
                --j;
                c = 10;
            }
            boolean bl = slash = c == 92;
            if (i != j) {
                a[j] = c;
            }
            ++i;
            ++j;
        }
        return i == j ? s : new String(a, 0, j);
    }

    private static String reverseNL(String s) {
        int n = s.length();
        StringBuffer b = new StringBuffer(n + 10);
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                b.append('\\');
                b.append('n');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFile(String s) {
        long t = System.currentTimeMillis();
        MyInputStream is = null;
        try {
            InputStream in = this.getClass().getResourceAsStream("/" + s);
            if (in == null) {
                throw new Exception();
            }
            is = new MyInputStream(in);
            is = is.startRead();
        }
        catch (Exception e) {
            try {
                FileInputStream in = new FileInputStream(new File(s));
                if (in == null) {
                    throw new Exception();
                }
                is = new MyInputStream(in);
            }
            catch (Exception e1) {
                try {
                    String x = Aladin.aladin.getCodeBase() + s;
                    is = Util.openStream(x);
                }
                catch (Exception e2) {
                    e1.printStackTrace();
                    e2.printStackTrace();
                    return;
                }
            }
        }
        BufferedReader dis = null;
        try {
            dis = s.indexOf(".utf") >= 0 ? new BufferedReader(new InputStreamReader((InputStream)is, "UTF8")) : new BufferedReader(new InputStreamReader((InputStream)is, "iso-8859-1"));
            this.parseStringFile(dis);
            Aladin.trace(1, "String file " + s + " loaded (" + (System.currentTimeMillis() - t) + "ms)");
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.trace(1, "Could not load strings file " + s);
            return;
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (Exception e1) {}
            }
        }
    }

    private static int getStringIndex(String s) {
        int i;
        int n = s.length();
        for (i = 0; i < n && !Character.isSpace(s.charAt(i)); ++i) {
        }
        while (i < n && Character.isSpace(s.charAt(i))) {
            ++i;
        }
        return i > 0 && i < n ? i : -1;
    }

    private void parseStringFile(BufferedReader dis) throws IOException {
        String line;
        while ((line = dis.readLine()) != null) {
            int end;
            if (line.trim().length() > 0 && line.charAt(0) == '#' || (end = Chaine.getStringIndex(line)) < 0) continue;
            String key = line.substring(0, end - 1).trim();
            String valeur = Chaine.replaceNL(line.substring(end));
            if (key.equals("LANGUAGE")) {
                this.aladin.configuration.setLanguage(valeur);
                continue;
            }
            if (key.length() == 0) continue;
            map.put(key, valeur);
            if (!this.loadDefList || key.indexOf(".") >= 0) continue;
            this.defList.add(key);
        }
    }

    protected void testLanguage(String param) {
        String suf = "";
        String lang = null;
        if (param == null || param.trim().length() == 0) {
            suf = this.aladin.configuration.getLang();
            if (suf.length() > 0) {
                lang = this.aladin.configuration.getLanguage(suf.substring(1));
            }
        } else {
            try {
                int offset = param.indexOf(32);
                if (offset < 0) {
                    offset = param.length();
                }
                suf = (suf = param.substring(0, offset).trim()).length() == 2 ? "." + suf : "";
                if (offset != param.length()) {
                    lang = param.substring(offset).trim();
                }
            }
            catch (Exception e) {
                suf = "";
            }
        }
        if (suf.length() == 0) {
            Aladin.warning("Missing parameters !");
            return;
        }
        this.testLanguage(suf, lang);
    }

    private void search(String key) {
        int pos;
        if (atKey == null) {
            atKey = new SimpleAttributeSet();
            atKey.addAttribute(StyleConstants.CharacterConstants.Foreground, Color.blue);
            atKey.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atValue = new SimpleAttributeSet();
            atValue.addAttribute(StyleConstants.CharacterConstants.Foreground, Color.black);
            atValue.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atCom = new SimpleAttributeSet();
            atCom.addAttribute(StyleConstants.CharacterConstants.Foreground, Aladin.GREEN);
            atCom.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atLang = new SimpleAttributeSet();
            atLang.addAttribute(StyleConstants.CharacterConstants.Foreground, new Color(127, 0, 85));
            atLang.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atHist = new SimpleAttributeSet();
            atHist.addAttribute(StyleConstants.CharacterConstants.Foreground, Color.red);
            atHist.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atWhite = new SimpleAttributeSet();
            atWhite.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atYellow = new SimpleAttributeSet();
            atYellow.addAttribute(StyleConstants.CharacterConstants.Background, Color.yellow);
        }
        String s = this.ta.getText();
        if (this.first) {
            this.first = false;
            int opos = 0;
            while ((pos = s.indexOf("\n", opos)) >= 0) {
                if (s.charAt(opos) == '#') {
                    this.df.setCharacterAttributes(opos, pos - opos, atCom, true);
                } else {
                    int valOffset = s.indexOf(32, opos + 1);
                    if (s.substring(opos, valOffset).equals("LANGUAGE")) {
                        this.df.setCharacterAttributes(opos, pos - opos, atLang, true);
                    } else {
                        this.df.setCharacterAttributes(opos, valOffset - opos, atKey, true);
                        if (s.charAt(valOffset + 1) == '[' && s.charAt(pos - 1) == ']') {
                            this.df.setCharacterAttributes(valOffset, pos - valOffset, atHist, true);
                        } else {
                            this.df.setCharacterAttributes(valOffset, pos - valOffset, atValue, true);
                        }
                    }
                }
                opos = pos + 1;
            }
        } else {
            this.df.setCharacterAttributes(0, s.length() - 1, atWhite, false);
        }
        if (key.length() == 0) {
            this.clear.setEnabled(false);
            return;
        }
        this.clear.setEnabled(true);
        pos = -1;
        int firstPos = -1;
        while ((pos = s.indexOf(key, pos + 1)) >= 0) {
            this.df.setCharacterAttributes(pos, key.length(), atYellow, false);
            if (firstPos != -1) continue;
            firstPos = pos;
        }
        if (firstPos != -1) {
            this.ta.setCaretPosition(firstPos);
        }
    }

    private JPanel makePanelTranslation() {
        JButton b;
        this.df = new DefaultStyledDocument();
        this.ta = new JTextPane(this.df);
        this.ta.setFont(Aladin.COURIER);
        JScrollPane sc = new JScrollPane(this.ta);
        sc.setPreferredSize(new Dimension(700, 800));
        JPanel pa = new JPanel(new BorderLayout());
        pa.add((Component)sc, "Center");
        JPanel p = new JPanel();
        this.ts = new JTextField(10);
        this.ts.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String s = ((JTextField)e.getSource()).getText();
                Chaine.this.search(s);
            }
        });
        p.add(Aladin.createLabel("Search"));
        p.add(this.ts);
        this.clear = b = new JButton("Clear");
        b.setEnabled(false);
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Chaine.this.ts.setText("");
                Chaine.this.search("");
            }
        });
        p.add(new JLabel(""));
        b = new JButton("Install");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Chaine.this.installTranslation();
            }
        });
        p.add(b);
        b = new JButton("Send to Aladin team...");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Chaine.this.aladin;
                    Aladin.info(Chaine.this.frame, "If you agree for submitting your translation file for an official distribution, please after installing and testing your work, attach the following file to a mail address to:\n \nEmail: language@aladin.u-strasbg.fr\nFile : " + Chaine.this.getTranslationFullName() + "\n \n" + "Please, do not forget to specify in this mail " + "your name and quality\n" + "Thanks for your contribution !");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        p.add(b);
        b = new JButton("Close");
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Chaine.this.frame.dispose();
            }
        });
        pa.add((Component)p, "South");
        return pa;
    }

    private String getTranslationFullName() throws Exception {
        String s = this.ta.getText();
        int pos = s.indexOf("\nLANGUAGE");
        String langue = s.substring(pos + 10, s.indexOf(40, pos) - 1).trim();
        boolean flagUTF = this.testUTF(s);
        String filename = this.getTranslationFileName(langue, flagUTF);
        String dir = System.getProperty("user.home") + Util.FS + Aladin.CACHE;
        String fullName = dir + Util.FS + filename;
        return fullName;
    }

    private String getTranslationFileName(String langue, boolean flagUTF) {
        StringBuffer s = new StringBuffer(50);
        char[] a = langue.toCharArray();
        boolean first = true;
        for (int i = 0; i < a.length; ++i) {
            char c = a[i];
            if (Character.isSpaceChar(c)) {
                first = true;
                continue;
            }
            c = first ? Character.toUpperCase(c) : Character.toLowerCase(c);
            first = false;
            s.append(c);
        }
        return "Aladin-" + s.toString() + "-" + "v8.155".substring(1) + "-perso.string" + (flagUTF ? ".utf" : "");
    }

    protected void testLanguage(String suf, String lang) {
        if (this.defList == null) {
            return;
        }
        boolean first1 = true;
        boolean first2 = true;
        boolean first3 = true;
        if (suf.length() > 0) {
            String author;
            this.frame = new JFrame("Translation");
            Aladin.setIcon(this.frame);
            StringBuffer text = new StringBuffer(8000);
            this.frame.getContentPane().add(this.makePanelTranslation());
            if (lang == null || lang.length() == 0) {
                lang = "Unknown";
            }
            if ((author = this.aladin.configuration.getLanguageAuthor(suf.substring(1))) == null) {
                author = "YourName";
            }
            text.append("# TRANSLATION PROCEDURE:\n# 0) Complete LANGUAGE line if necessary [in purple] (language name + author name)\n# 1) Translate missing sentences [in red] (do not forget to remove the brackets);\n# 2) Remove translated sentences no longer required [in green]\n# 3) Check translated sentences already done [in black]\n# *) Do not modify keywords (first word of each line);\n#    Do not remove control characters (*,!,%) at the beginning of some words;\n# 4) Install your translation, restart Aladin and check the result\n\n");
            text.append("\nLANGUAGE " + lang + " (" + suf.substring(1) + ") " + "v8.155".substring(1) + " " + author + "\n");
            for (String key : this.defList) {
                if (map.get(key + suf) != null) continue;
                if (first1) {
                    first1 = false;
                    text.append("\n### MISSING TRANSLATION:\n");
                }
                text.append(key + suf + " [" + Chaine.reverseNL((String)map.get(key)) + "]\n");
            }
            Enumeration e = map.keys();
            while (e.hasMoreElements()) {
                String k;
                String key = (String)e.nextElement();
                if (!key.endsWith(suf) || map.get(k = key.substring(0, key.lastIndexOf(suf))) != null || key.startsWith("Tool.")) continue;
                if (first2) {
                    first2 = false;
                    text.append("\n### TRANSLATION NO LONGER REQUIRED:\n");
                }
                text.append("#" + key + " " + Chaine.reverseNL((String)map.get(key)) + "\n");
            }
            for (String key : this.defList) {
                if (map.get(key + suf) == null) continue;
                if (first3) {
                    first3 = false;
                    text.append("\n### TRANSLATION DONE:\n");
                }
                text.append(key + suf + " " + Chaine.reverseNL((String)map.get(key + suf)) + "\n");
            }
            if (first1 && first2) {
                Aladin.info(this.frame, "The translation (" + suf + ") seems complete!");
            }
            this.frame.pack();
            this.frame.setVisible(true);
            this.ta.setText(text.toString());
            this.ta.setCaretPosition(0);
            this.first = true;
            new Thread("Translation"){

                @Override
                public void run() {
                    Util.pause(100);
                    Chaine.this.search("");
                }
            }.start();
        }
    }

    private boolean testUTF(String s) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            if ((s.charAt(i) & 0xFF00) == 0) continue;
            return true;
        }
        return false;
    }

    private void installTranslation() {
        try {
            byte[] buf;
            boolean flagUTF = false;
            String langue = "";
            String s = this.ta.getText();
            StringBuffer text = new StringBuffer(8000);
            StringTokenizer st = new StringTokenizer(s, "\n");
            while (st.hasMoreTokens()) {
                int end;
                int pos;
                String line = st.nextToken().trim();
                if (line.length() == 0 || line.charAt(0) == '#' || (pos = line.indexOf(32)) < 0 || line.charAt(pos + 1) == '[' && line.charAt(line.length() - 1) == ']') continue;
                text.append(line + Util.CR);
                if (langue.length() != 0 || !line.startsWith("LANGUAGE") || (end = line.indexOf("(")) <= 8) continue;
                langue = line.substring(8, end - 1).trim();
                text.append(Util.CR);
            }
            flagUTF = this.testUTF(s);
            s = text.toString();
            if (!flagUTF) {
                buf = s.getBytes("ISO-8859-1");
            } else {
                buf = s.getBytes("UTF-8");
                byte[] buf1 = new byte[buf.length + 3];
                System.arraycopy(buf, 0, buf1, 3, buf.length);
                buf1[0] = -17;
                buf1[1] = -69;
                buf1[2] = -65;
                buf = buf1;
            }
            String fileName = this.getTranslationFileName(langue, flagUTF);
            this.aladin.configuration.installLanguage(langue, fileName, buf);
            Aladin.info(this.aladin, Aladin.chaine.getString("RESTART"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadAddFiles() {
        this.addAltFiles();
        if (Aladin.STRINGFILE == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(Aladin.STRINGFILE, ";");
        while (st.hasMoreTokens()) {
            String filename = st.nextToken();
            this.loadFile(filename);
        }
    }

    private void addAltFiles() {
        block4: {
            try {
                String name;
                int i;
                String dir = System.getProperty("user.home") + Util.FS + Aladin.CACHE;
                FilenameFilter filter = new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return Util.matchMaskIgnoreCase("Aladin*.string*", name);
                    }
                };
                File fdir = new File(dir);
                File[] list = fdir.listFiles(filter);
                for (i = 0; i < list.length; ++i) {
                    name = list[i].getName();
                    if (!name.endsWith("-perso.string.utf") && !name.endsWith("-perso.string")) continue;
                    Aladin.STRINGFILE = Aladin.STRINGFILE == null ? "" : ";" + Aladin.STRINGFILE;
                    Aladin.STRINGFILE = list[i].getAbsolutePath() + Aladin.STRINGFILE;
                }
                for (i = 0; i < list.length; ++i) {
                    name = list[i].getName();
                    if (!name.endsWith(".utf") && !name.endsWith(".string") || name.endsWith("-perso.string.utf") || name.endsWith("-perso.string")) continue;
                    Aladin.STRINGFILE = Aladin.STRINGFILE == null ? "" : ";" + Aladin.STRINGFILE;
                    Aladin.STRINGFILE = list[i].getAbsolutePath() + Aladin.STRINGFILE;
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block4;
                e.printStackTrace();
            }
        }
    }

    public String getString(String key) {
        String suf = this.aladin.configuration.getLang();
        Object o = map.get(key + suf);
        if (o == null && !this.flagAll) {
            try {
                this.loadFile(STRINGFILE);
            }
            catch (Exception e) {
                // empty catch block
            }
            o = map.get(key + suf);
            this.flagAll = true;
        }
        if (o == null && suf.length() > 0) {
            if (key.startsWith("TIP")) {
                return null;
            }
            o = map.get(key);
        }
        if (o == null) {
            if (key.startsWith("TIP")) {
                return null;
            }
            System.err.println("No default string for [" + key + "]");
            return "[" + key + "]";
        }
        return (String)o;
    }

    static {
        atKey = null;
    }
}

