/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Forme;
import cds.aladin.Plan;
import cds.aladin.Position;
import cds.aladin.RectangleD;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;

public class Cercle
extends Forme {
    protected Cercle(Plan plan, ViewSimple v, double xv, double yv, double rv) {
        super(plan, new Position[2]);
        this.o[0] = new Position(plan, v, xv, yv, 0.0, 0.0, 5, null);
        this.o[1] = new Position(plan, v, xv, yv + rv, 0.0, 0.0, 5, null);
        this.setObjet(this.o);
    }

    protected Cercle(Plan plan, Coord c, double radius) {
        super(plan, new Position[2]);
        this.o[0] = new Position(plan, null, 0.0, 0.0, c.al, c.del, 2, null);
        double del = c.del + radius;
        if (del > 90.0) {
            del = c.del - radius;
        }
        this.o[1] = new Position(plan, null, 0.0, 0.0, c.al, del, 2, null);
        this.setObjet(this.o);
    }

    protected Cercle(Plan plan, Position[] o) {
        super(plan, o);
    }

    @Override
    public String getObjType() {
        return "Circle";
    }

    protected double getRayon(ViewSimple v) {
        double dy = this.o[1].yv[v.n] - this.o[0].yv[v.n];
        double dx = this.o[1].xv[v.n] - this.o[0].xv[v.n];
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    protected boolean inside(ViewSimple v, double x, double y) {
        double yc;
        if (!this.isVisible()) {
            return false;
        }
        double xc = Math.abs(x - this.o[0].xv[v.n]);
        return Math.sqrt(xc * xc + (yc = Math.abs(y - this.o[0].yv[v.n])) * yc) < this.getRayon(v);
    }

    @Override
    protected boolean in(ViewSimple v, double x, double y) {
        if (!this.isVisible()) {
            return false;
        }
        return Cercle.inPerimetre(this.o[0].xv[v.n], this.o[0].yv[v.n], this.getRayon(v), x, y, 3.0 + 9.0 / v.getZoom());
    }

    protected static boolean inPerimetre(double xc, double yc, double r, double x, double y, double l) {
        return Math.abs((x -= xc) * x + (y -= yc) * y - r * r) < l * l;
    }

    @Override
    protected boolean inRectangle(ViewSimple v, RectangleD r) {
        return this.o[0].inRectangle(v, r);
    }

    @Override
    protected boolean inClip(ViewSimple v, Rectangle clip) {
        boolean rep = super.inClip(v, clip);
        return rep;
    }

    @Override
    protected Rectangle extendClip(ViewSimple v, Rectangle clip) {
        if (!this.isVisible()) {
            return clip;
        }
        int L = (int)Math.round(this.getRayon(v) * v.getZoom()) + 1;
        Point p = this.o[0].getViewCoord(v, L, L);
        if (p == null) {
            return clip;
        }
        if (this.isSelected()) {
            return Cercle.unionRect(clip, p.x - L - 2, p.y - L - 2, L * 2 + 4, L * 2 + 4);
        }
        return Cercle.unionRect(clip, p.x - L, p.y - L, L * 2, L * 2);
    }

    @Override
    protected void drawSelect(Graphics g, ViewSimple v) {
        Rectangle r = this.getClip(v);
        int xc = 0;
        int yc = 0;
        for (int i = 0; i < 4; ++i) {
            switch (i) {
                case 0: {
                    xc = r.x + r.width / 2 - 4;
                    yc = r.y;
                    break;
                }
                case 1: {
                    xc = r.x + r.width / 2 - 4;
                    yc = r.y + r.height - 4;
                    break;
                }
                case 2: {
                    xc = r.x + r.width - 4;
                    yc = r.y + r.height / 2 - 4;
                    break;
                }
                case 3: {
                    xc = r.x;
                    yc = r.y + r.height / 2 - 4;
                }
            }
            g.setColor(Color.green);
            g.fillRect(xc + 1, yc + 1, 4, 4);
            g.setColor(Color.black);
            g.drawRect(xc, yc, 4, 4);
        }
    }

    @Override
    protected boolean draw(Graphics g, ViewSimple v, int dx, int dy) {
        if (!this.isVisible()) {
            return false;
        }
        int L = (int)Math.round(this.getRayon(v) * v.getZoom());
        Point p = this.o[0].getViewCoord(v, L, L);
        if (p == null) {
            return false;
        }
        p.x += dx;
        p.y += dy;
        g.setColor(this.getColor());
        if (this.plan != null && (double)this.plan.getOpacityLevel() > 0.02 && Aladin.isFootprintPlane(this.plan) && Aladin.ENABLE_FOOTPRINT_OPACITY && g instanceof Graphics2D) {
            Composite saveComposite = null;
            Graphics2D g2d = (Graphics2D)g;
            saveComposite = g2d.getComposite();
            Composite myComposite = Util.getFootprintComposite(this.plan.getOpacityLevel());
            g2d.setComposite(myComposite);
            g2d.fill(new Ellipse2D.Double(p.x - L, p.y - L, L * 2, L * 2));
            g2d.setComposite(saveComposite);
        }
        g.drawOval(p.x - L, p.y - L, L * 2, L * 2);
        if (this.isSelected()) {
            if (this.plan != null && this.plan.type == 10) {
                return true;
            }
            g.setColor(Color.green);
            this.drawSelect(g, v);
        }
        return true;
    }
}

