/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.ColFilter;
import cds.aladin.FilterProperties;
import cds.aladin.Legende;
import cds.aladin.LocalXMatch;
import cds.aladin.Obj;
import cds.aladin.Pcat;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.Source;
import cds.aladin.Tok;
import cds.aladin.XMatchResult;
import cds.astro.Astrocoo;
import cds.astro.Unit;
import cds.tools.Util;
import cds.xml.Field;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public final class CDSXMatch {
    static final int BESTMATCH = 1;
    static final int ALLMATCH = 2;
    static final int NOMATCH = 4;
    static final int POSXMATCH = 1;
    static final int JOIN = 2;
    static final int POSXMATCH_ELLIPSES = 3;
    private ColFilter colFilter;
    private Aladin aladin;
    static int xMatchNb = 0;
    private static Astrocoo frame = new Astrocoo();
    private static final String UCD_DIST = "POS_ANG_DIST_GENERAL";
    private static final String UCD_SIGMA = "stat.stdev";
    private static final String DEFAULT_PREFIX_T1 = "";
    private static final String DEFAULT_PREFIX_T2 = "";
    private static final String DEFAULT_SUFFIX_T1 = "_tab1";
    private static final String DEFAULT_SUFFIX_T2 = "_tab2";
    int[] idxColToKeep1;
    int[] idxColToKeep2;
    static final String UCD_RA = "POS_EQ_RA";
    static final String UCD_DEC = "POS_EQ_DEC";
    static final String UCD1PLUS_RA = "pos.eq.ra";
    static final String UCD1PLUS_DEC = "pos.eq.dec";

    protected CDSXMatch(Aladin aladin) {
        this.aladin = aladin;
    }

    public void xID(Plan p1, Plan p2, String label, int index1, int index2, Aladin aladin) {
        double begin = System.currentTimeMillis();
        PlanCatalog pc = this.initPlaneCreation(p1, label);
        String[] array1 = new String[p1.getCounts()];
        this.fillXIDArray(p1.pcat, array1, index1);
        String[] array2 = new String[p2.getCounts()];
        this.fillXIDArray(p2.pcat, array2, index2);
        double beginXmatch = System.currentTimeMillis();
        Aladin.trace(3, "Total time for extracting fields : " + (beginXmatch - begin));
        XMatchResult[] result = LocalXMatch.xID(array1, array2);
        double end = System.currentTimeMillis();
        Aladin.trace(3, "Total time for xid : " + (end - beginXmatch));
        this.fillResultPlane(pc, result, p1, p2, null, null, 2);
        aladin.log("xmatch", "xid");
    }

    private void fillXIDArray(Pcat pcat, String[] array, int index) {
        Iterator<Obj> it = pcat.iterator();
        int i = 0;
        while (it.hasNext()) {
            Source o = (Source)it.next();
            array[i] = o.getValue(index);
            ++i;
        }
    }

    public void posXMatch(Plan p1, Plan p2, String label, int[] coordTab1, int[] coordTab2, double[] seuils, int method, Aladin aladin) {
        this.posXMatch(p1, p2, label, coordTab1, coordTab2, seuils, method, aladin, false);
    }

    public void posXMatch(Plan p1, Plan p2, String label, int[] coordTab1, int[] coordTab2, double[] seuils, int method, Aladin aladin, boolean fromScript) {
        double begin = System.currentTimeMillis();
        if (coordTab1 == null && (coordTab1 = CDSXMatch.findCoord(p1)) == null) {
            Aladin.warning(Aladin.chaine.getString("NOCOOR") + " " + p1.label);
            return;
        }
        if (coordTab2 == null && (coordTab2 = CDSXMatch.findCoord(p2)) == null) {
            Aladin.warning(Aladin.chaine.getString("NOCOOR") + " " + p2.label);
            return;
        }
        PlanCatalog pc = this.initPlaneCreation(p1, label);
        double[][] array1 = new double[p1.getCounts()][2];
        boolean[] ignoreFlag1 = new boolean[p1.getCounts()];
        CDSXMatch.fillXMatchArray(p1.pcat, array1, coordTab1, ignoreFlag1);
        double[][] array2 = new double[p2.getCounts()][2];
        boolean[] ignoreFlag2 = new boolean[p2.getCounts()];
        CDSXMatch.fillXMatchArray(p2.pcat, array2, coordTab2, ignoreFlag2);
        if (!fromScript) {
            aladin.console.printCommand("xmatch " + Tok.quote(p1.label) + " " + Tok.quote(p2.label) + " " + seuils[1]);
        }
        double beginXmatch = System.currentTimeMillis();
        Aladin.trace(3, "Total time for extracting coordinates : " + (beginXmatch - begin));
        XMatchResult[] result = LocalXMatch.xMatch(array1, array2, ignoreFlag1, ignoreFlag2, seuils, method);
        double end = System.currentTimeMillis();
        Aladin.trace(3, "Total time for xmatch : " + (end - beginXmatch));
        this.fillResultPlane(pc, result, p1, p2, coordTab1, array1, 1);
        Aladin.trace(3, "Total time for creation of the plane : " + ((double)System.currentTimeMillis() - end));
        aladin.log("xmatch", "positional");
    }

    public void posXMatchEllipses(Plan p1, Plan p2, String label, int[] coordTab1, int[] coordTab2, int[] paramEllipses1, int[] paramEllipses2, double nbSigmaMin, double nbSigmaMax, int method, Aladin aladin) {
        double begin = System.currentTimeMillis();
        if (coordTab1 == null && (coordTab1 = CDSXMatch.findCoord(p1)) == null) {
            Aladin.warning("Coordinates columns not found for plane " + p1.label);
            return;
        }
        if (coordTab2 == null && (coordTab2 = CDSXMatch.findCoord(p2)) == null) {
            Aladin.warning("Coordinates columns not found for plane " + p2.label);
            return;
        }
        PlanCatalog pc = this.initPlaneCreation(p1, label);
        double[][] array1 = new double[p1.getCounts()][2];
        boolean[] ignoreFlag1 = new boolean[p1.getCounts()];
        CDSXMatch.fillXMatchArray(p1.pcat, array1, coordTab1, ignoreFlag1);
        double[][] array2 = new double[p2.getCounts()][2];
        boolean[] ignoreFlag2 = new boolean[p2.getCounts()];
        CDSXMatch.fillXMatchArray(p2.pcat, array2, coordTab2, ignoreFlag2);
        double[] maj1 = new double[p1.getCounts()];
        double[] min1 = new double[p1.getCounts()];
        double[] pa1 = new double[p1.getCounts()];
        CDSXMatch.fillEllipsesParamArray(p1.pcat, maj1, min1, pa1, paramEllipses1, ignoreFlag1);
        double[] maj2 = new double[p2.getCounts()];
        double[] min2 = new double[p2.getCounts()];
        double[] pa2 = new double[p2.getCounts()];
        CDSXMatch.fillEllipsesParamArray(p2.pcat, maj2, min2, pa2, paramEllipses2, ignoreFlag2);
        double beginXmatch = System.currentTimeMillis();
        Aladin.trace(3, "Total time for extracting coordinates : " + (beginXmatch - begin));
        XMatchResult[] result = LocalXMatch.xMatchEllipse(array1, array2, maj1, min1, pa1, maj2, min2, pa2, ignoreFlag1, ignoreFlag2, new double[]{nbSigmaMin, nbSigmaMax}, method);
        double end = System.currentTimeMillis();
        Aladin.trace(3, "Total time for ellipses xmatch : " + (end - beginXmatch));
        this.fillResultPlane(pc, result, p1, p2, coordTab1, array1, 3);
        aladin.log("xmatch", "ellipses");
    }

    private static void fillXMatchArray(Pcat pcat, double[][] array, int[] coordTab, boolean[] flagIgnore) {
        Iterator<Obj> it = pcat.iterator();
        int i = 0;
        while (it.hasNext()) {
            Source o = (Source)it.next();
            try {
                String content = o.getValue(coordTab[0]);
                if (CDSXMatch.isSexa(content)) {
                    content = CDSXMatch.sexa2Deg(content, true);
                }
                array[i][0] = Double.valueOf(content);
                content = o.getValue(coordTab[1]);
                if (CDSXMatch.isSexa(content)) {
                    content = CDSXMatch.sexa2Deg(content, false);
                }
                array[i][1] = Double.valueOf(content);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                flagIgnore[i] = true;
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
                flagIgnore[i] = true;
            }
            ++i;
        }
    }

    private static void fillEllipsesParamArray(Pcat pcat, double[] maj, double[] min, double[] pa, int[] ellipsesParamIdx, boolean[] flagIgnore) {
        double multFactPa;
        double multFactMin;
        double multFactMaj;
        Unit uArcSec;
        Source s = (Source)pcat.iterator().next();
        Unit uDegTemplate = null;
        Unit uArcSecTemplate = null;
        Unit uDeg = null;
        Unit uMaj = null;
        try {
            uDegTemplate = new Unit("1 deg");
            uArcSecTemplate = new Unit("1 arcsec");
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            uArcSec = new Unit(uArcSecTemplate);
            uMaj = new Unit("1 " + s.getUnit(ellipsesParamIdx[0]));
            uArcSec.convertFrom(uMaj);
            multFactMaj = uArcSec.getValue();
        }
        catch (ParseException e) {
            multFactMaj = 1.0;
        }
        catch (ArithmeticException e2) {
            multFactMaj = 1.0;
        }
        System.out.println("facteur pour MAJ : " + multFactMaj);
        try {
            uArcSec = new Unit(uArcSecTemplate);
            Unit uMin = new Unit("1 " + s.getUnit(ellipsesParamIdx[1]));
            uArcSec.convertFrom(uMin);
            multFactMin = uArcSec.getValue();
        }
        catch (ParseException e) {
            multFactMin = 1.0;
        }
        catch (ArithmeticException e2) {
            multFactMin = 1.0;
        }
        System.out.println("facteur pour MIN : " + multFactMin);
        try {
            uDeg = new Unit(uDegTemplate);
            Unit uPa = new Unit("1 " + s.getUnit(ellipsesParamIdx[2]));
            uDeg.convertFrom(uPa);
            multFactPa = uDeg.getValue();
        }
        catch (ParseException e) {
            multFactPa = 1.0;
        }
        catch (ArithmeticException e2) {
            multFactPa = 1.0;
        }
        System.out.println("facteur pour PA : " + multFactPa);
        Iterator<Obj> it = pcat.iterator();
        int i = 0;
        while (it.hasNext()) {
            Source o = (Source)it.next();
            try {
                String content = o.getValue(ellipsesParamIdx[0]);
                maj[i] = multFactMaj * Double.valueOf(content);
                try {
                    content = o.getValue(ellipsesParamIdx[1]);
                    min[i] = multFactMin * Double.valueOf(content);
                }
                catch (NumberFormatException e) {
                    min[i] = maj[i];
                }
                try {
                    content = o.getValue(ellipsesParamIdx[2]);
                    pa[i] = multFactPa * Double.valueOf(content);
                }
                catch (NumberFormatException e) {
                    pa[i] = 0.0;
                }
            }
            catch (NumberFormatException e) {
                flagIgnore[i] = true;
                pa[i] = 0.0;
                min[i] = 0.0;
                maj[i] = 0.0;
            }
            ++i;
        }
    }

    private static String sexa2Deg(String sexa, boolean isRA) {
        String str = isRA ? sexa + " +0 0 0.0" : "0 0 0.0 " + sexa;
        try {
            frame.set(str);
        }
        catch (Exception e) {
            return "0";
        }
        return isRA ? frame.getLon() + "" : frame.getLat() + "";
    }

    private static boolean isSexa(String s) {
        char[] a = s.toCharArray();
        int nbb = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == ':' || a[i] == ' ' || a[i] == '\t') {
                ++nbb;
            }
            if (nbb < 1) continue;
            return true;
        }
        return false;
    }

    private void ucdRewriting(Legende leg) {
        Field[] f = leg.field;
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < f.length; ++i) {
            String ucd;
            int k;
            String ucdOrg = f[i].ucd;
            if (ucdOrg == null || (k = (ucd = ucdOrg.toLowerCase()).indexOf("_main")) < 0 && (k = ucd.indexOf(";meta.main")) < 0) continue;
            if (!v.contains(ucd)) {
                v.addElement(ucd);
                continue;
            }
            f[i].ucd = ucdOrg.substring(0, k);
        }
    }

    private PlanCatalog initPlaneCreation(Plan p1, String label) {
        ++xMatchNb;
        int n = this.aladin.calque.newPlanCatalog();
        PlanCatalog pc = (PlanCatalog)this.aladin.calque.plan[n];
        pc.param = "xmatch";
        pc.setLabel(label != null ? label : "XMatch");
        pc.objet = p1.objet != null ? p1.objet : "";
        pc.flagOk = false;
        this.aladin.calque.select.repaint();
        return pc;
    }

    private void fillResultPlane(PlanCatalog pc, XMatchResult[] result, Plan p1, Plan p2, int[] coordTab1, double[][] array, int xmatchType) {
        ArrayList<Source> tmp;
        boolean ellXMatch = xmatchType == 3;
        Obj[] o1 = p1.pcat.getObj();
        Obj[] o2 = p2.pcat.getObj();
        Legende leg = null;
        Hashtable<String, Legende> legMemory = new Hashtable<String, Legende>();
        Legende saveLeg2 = null;
        Legende saveLeg1 = null;
        Hashtable<Legende, ArrayList<Source>> legToSources = new Hashtable<Legende, ArrayList<Source>>();
        Source srcResult = null;
        for (int i = 0; i < result.length; ++i) {
            Source s2;
            int idx1 = result[i].idx1;
            int idx2 = result[i].idx2;
            double dist = result[i].dist;
            Source s1 = (Source)o1[idx1];
            Source source = s2 = dist == -1.0 ? null : (Source)o2[idx2];
            if (saveLeg1 == null || saveLeg2 == null || s1.leg != saveLeg1 || s2 != null && s2.leg != saveLeg2) {
                saveLeg1 = s1.leg;
                saveLeg2 = s2 == null ? null : s2.leg;
                String id = s1.leg.toString() + (s2 == null ? "null" : s2.leg.toString());
                leg = (Legende)legMemory.get(id);
                if (leg == null) {
                    leg = this.createLeg(xmatchType, ellXMatch, s1, s2, coordTab1);
                    legMemory.put(id, leg);
                }
            }
            String newInfo = xmatchType == 2 ? "<&_getReadMe " + pc.label + " >" + "\t" + this.getOnlyInfo((Source)o1[idx1], true) + "\t" + this.getOnlyInfo((Source)o2[idx2], false) : (dist == -1.0 ? "<&_getReadMe " + pc.label + " >" + "\t" + Util.round(dist, 4) + "\t" + this.getOnlyInfo((Source)o1[idx1], true) : "<&_getReadMe " + pc.label + " >" + "\t" + Util.round(dist, 4) + "\t" + this.getOnlyInfo((Source)o1[idx1], true) + "\t" + this.getOnlyInfo((Source)o2[idx2], false));
            if (array == null) {
                Source s = (Source)o1[idx1];
                srcResult = new Source(pc, s.raj, s.dej, "", newInfo, leg);
            } else {
                srcResult = new Source(pc, array[idx1][0], array[idx1][1], "", newInfo, leg);
            }
            tmp = (ArrayList)legToSources.get(leg);
            if (tmp == null) {
                tmp = new ArrayList<Source>();
                legToSources.put(leg, tmp);
            }
            tmp.add(srcResult);
        }
        Enumeration enumTables = legToSources.elements();
        while (enumTables.hasMoreElements()) {
            tmp = (ArrayList<Source>)enumTables.nextElement();
            Iterator it = tmp.iterator();
            while (it.hasNext()) {
                pc.pcat.setObjetFast((Obj)it.next());
            }
        }
        pc.setSourceType(Source.getDefaultType(result.length));
        pc.setActivated(true);
        pc.flagOk = true;
        this.aladin.calque.select.repaint();
        this.aladin.view.repaintAll();
        FilterProperties.notifyNewPlan();
    }

    private Legende createLeg(int xmatchType, boolean ellXMatch, Source s1, Source s2, int[] coordTab1) {
        Vector<Field> v = new Vector<Field>();
        if (xmatchType != 2) {
            Field distField = ellXMatch ? new Field("NSigma") : new Field("dist");
            distField.ucd = ellXMatch ? UCD_SIGMA : UCD_DIST;
            distField.datatype = "D";
            distField.description = ellXMatch ? "Distance in sigmas" : "Distance between 2 cross-matched sources";
            distField.unit = ellXMatch ? "---" : "arcsec";
            distField.width = "7";
            distField.computeColumnSize();
            v.addElement(distField);
        }
        Source o = s1;
        String prefix = this.colFilter == null ? "" : this.colFilter.prefix1;
        String suffix = this.colFilter == null ? DEFAULT_SUFFIX_T1 : this.colFilter.suffix1;
        this.addField(true, o, v, prefix, suffix, coordTab1, true);
        o = s2;
        prefix = this.colFilter == null ? "" : this.colFilter.prefix2;
        String string = suffix = this.colFilter == null ? DEFAULT_SUFFIX_T2 : this.colFilter.suffix2;
        if (o != null) {
            this.addField(false, o, v, prefix, suffix, null, false);
        }
        Legende leg = new Legende(v);
        this.ucdRewriting(leg);
        return leg;
    }

    private String getOnlyInfo(Source s, boolean tab1) {
        int idx = s.info.indexOf(9);
        String ret = idx >= 0 ? s.info.substring(idx + 1) : s.info;
        if (this.colFilter != null) {
            int[] idxColToKeep = tab1 ? this.idxColToKeep1 : this.idxColToKeep2;
            String[] values = Util.split(ret, "\t", ':', ':');
            ret = "";
            for (int i = 0; i < idxColToKeep.length; ++i) {
                ret = ret + values[idxColToKeep[i]];
                if (i >= idxColToKeep.length - 1) continue;
                ret = ret + "\t";
            }
        }
        return ret;
    }

    private void addField(boolean tab1, Source s, Vector<Field> v, String prefix, String suffix, int[] coordTab, boolean coo) {
        if (tab1) {
            this.idxColToKeep1 = null;
        } else {
            this.idxColToKeep2 = null;
        }
        if (this.colFilter != null) {
            if (tab1) {
                this.idxColToKeep1 = new int[this.colFilter.fieldTab1.length];
            } else {
                this.idxColToKeep2 = new int[this.colFilter.fieldTab2.length];
            }
        }
        int k = 0;
        for (int i = 0; i < s.leg.field.length; ++i) {
            Field curF = s.leg.field[i];
            boolean keep = true;
            if (this.colFilter != null && (keep = tab1 ? this.colFilter.inTab1(curF.name) : this.colFilter.inTab2(curF.name))) {
                if (tab1) {
                    this.idxColToKeep1[k++] = i;
                } else {
                    this.idxColToKeep2[k++] = i;
                }
            }
            if (!keep) continue;
            Field f = new Field("");
            f.ID = curF.ID;
            f.name = prefix + curF.name + suffix;
            f.description = curF.description;
            f.title = prefix + curF.title + suffix;
            f.type = curF.type;
            f.unit = curF.unit;
            f.ucd = this.colFilter != null ? (tab1 ? this.colFilter.getUcdTab1(curF.name) : this.colFilter.getUcdTab2(curF.name)) : curF.ucd;
            f.datatype = curF.datatype;
            f.width = curF.width;
            f.nullValue = curF.nullValue;
            f.arraysize = curF.arraysize;
            f.columnSize = curF.columnSize;
            f.precision = curF.precision;
            f.href = curF.href;
            f.gref = curF.gref;
            f.refText = curF.refText;
            f.refValue = curF.refValue;
            if (coo && coordTab != null && i == coordTab[0]) {
                f.coo = 1;
            }
            if (coo && coordTab != null && i == coordTab[1]) {
                f.coo = 2;
            }
            v.addElement(f);
        }
    }

    protected static int[] findCoord(Plan p) {
        Field[] fields = p.getFirstLegende().field;
        boolean foundRA = false;
        boolean foundDEC = false;
        int indexRA = -1;
        int indexDEC = -1;
        int indexRAByName = -1;
        int indexDECByName = -1;
        for (int i = 0; !(i >= fields.length || foundRA && foundDEC); ++i) {
            String ucdLC;
            String ucd = fields[i].ucd;
            String string = ucdLC = ucd == null ? null : ucd.toLowerCase();
            if (!foundRA && ucd != null && (ucdLC.startsWith(UCD1PLUS_RA) || ucd.startsWith(UCD_RA))) {
                foundRA = true;
                indexRA = i;
            } else if (!foundDEC && ucd != null && (ucdLC.startsWith(UCD1PLUS_DEC) || ucd.startsWith(UCD_DEC))) {
                foundDEC = true;
                indexDEC = i;
            }
            String name = fields[i].name;
            if (name == null) continue;
            if ((name = name.toLowerCase()).startsWith("_")) {
                name = name.substring(1);
            }
            if (indexRAByName < 0 && (name.startsWith("ra") || name.startsWith("alpha"))) {
                indexRAByName = i;
                continue;
            }
            if (indexDECByName >= 0 || !name.startsWith("de") && !name.startsWith("delta")) continue;
            indexDECByName = i;
        }
        if (foundRA && foundDEC) {
            return new int[]{indexRA, indexDEC};
        }
        if (indexRAByName >= 0 && indexDECByName >= 0) {
            return new int[]{indexRAByName, indexDECByName};
        }
        return null;
    }

    protected static int findIdx(Plan p, String[] ucds) {
        int i;
        if (ucds == null || ucds.length == 0) {
            return -1;
        }
        Field[] fields = p.getFirstLegende().field;
        int[] indexes = new int[ucds.length];
        int nbMatch = 0;
        for (i = 0; i < ucds.length; ++i) {
            ucds[i] = ucds[i].toLowerCase();
            indexes[i] = -1;
        }
        block1: for (i = 0; i < fields.length && indexes[0] < 0 && nbMatch < ucds.length; ++i) {
            String ucdLC = fields[i].ucd;
            if (ucdLC == null) continue;
            ucdLC = ucdLC.toLowerCase();
            for (int j = 0; j < ucds.length; ++j) {
                if (indexes[j] >= 0 || !ucds[j].equals(ucdLC)) continue;
                indexes[j] = i;
                ++nbMatch;
                continue block1;
            }
        }
        for (i = 0; i < indexes.length; ++i) {
            if (indexes[i] < 0) continue;
            return indexes[i];
        }
        return -1;
    }

    protected void setColFilter(ColFilter colFilter) {
        this.colFilter = colFilter;
    }
}

