/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanFilter;
import cds.aladin.Projection;
import cds.aladin.Source;
import cds.aladin.UCDFilter;
import cds.aladin.ViewSimple;
import cds.astro.Unit;
import cds.image.EPSGraphics;
import cds.tools.Util;
import cds.tools.parser.Parser;
import cds.tools.parser.ParserException;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.text.ParseException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Action {
    boolean badSyntax = false;
    static final String[] COLORNAME = new String[]{"black", "blue", "cyan", "darkGray", "gray", "green", "lightGray", "magenta", "orange", "pink", "red", "white", "yellow"};
    static final Color[] MYCOLORS = new Color[]{Color.black, Color.blue, Color.cyan, Color.darkGray, Color.gray, Color.green, Color.lightGray, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow};
    protected static final String DRAWOBJECT = "drawobject";
    protected static final String DRAWSTRING = "drawstring";
    protected static final String HIDE = "hide";
    protected static final String SIZE = "circle";
    protected static final String FILLSIZE = "fillcircle";
    protected static final String FIXEDCIRCLE = "fixedcircle";
    protected static final String ELLIPSE = "ellipse";
    protected static final String FILLELLIPSE = "fillellipse";
    protected static final String RECTANGLE = "rectangle";
    protected static final String PM = "pm";
    protected static final String LINE = "line";
    protected static final String RGB = "rgb";
    protected static final String RAINBOW = "rainbow";
    protected static final String SATURATION = "saturation";
    protected static final String OVAL = "oval";
    protected static final String CARRE = "square";
    protected static final String CROIX = "cross";
    protected static final String PLUS = "plus";
    protected static final String LOSANGE = "rhomb";
    protected static final String TRIANGLE = "triangle";
    protected static final String POINT = "dot";
    protected static final String DOT = "microdot";
    protected static final String[] NOPARAMSHAPE = new String[]{"oval", "square", "cross", "plus", "rhomb", "triangle", "dot", "microdot"};
    protected static final String DRAW = "draw";
    protected static final String COLOR = "color=";
    protected static final String SHAPE = "shape=";
    Parser majAxisParser;
    Parser minAxisParser;
    Parser posAngleParser;
    Parser pmDecParser;
    Parser pmRAParser;
    Color color = null;
    Parser sizeParser;
    private int maxRadius = 30;
    private int minRadius = 3;
    Parser redParser;
    Parser greenParser;
    Parser blueParser;
    Parser rainbowParser;
    Parser saturationParser;
    Parser lineRa1Parser;
    Parser lineDec1Parser;
    Parser lineRa2Parser;
    Parser lineDec2Parser;
    boolean colorIsVariable = false;
    boolean userDefinedMinMax = false;
    boolean rainbowColorIsVariable = false;
    boolean saturationColorIsVariable = false;
    boolean mustComputeMinMax = true;
    boolean mustComputeRGBMinMax = true;
    boolean mustComputeRainbowMinMax = true;
    boolean userDefinedRainbowMinMax = false;
    boolean mustComputeSaturationMinMax = true;
    boolean userDefinedSaturationMinMax = false;
    double minValue;
    double maxValue;
    double redMinValue;
    double redMaxValue;
    double blueMinValue;
    double blueMaxValue;
    double greenMinValue;
    double greenMaxValue;
    double rainbowMinValue;
    double rainbowMaxValue;
    double saturationMinValue;
    double saturationMaxValue;
    private String shape = "draw";
    private String function = "drawobject";
    String textToDisp;
    Parser parserToDisp = null;
    int wTexte;
    int hTexte;
    private static Font FONT = Aladin.SBOLD;
    private static int FONT_SIZE = Aladin.SSIZE;
    Aladin a;
    PlanFilter pf;
    String ERR1;
    String ERR2;
    String ERR3;
    String ERR4;
    String ERR5;
    String ERR6;
    String ERR7;
    String ERR8;
    String ERR9;
    String ERR10;
    String ERR11;
    String ERR12;
    String ERR13;
    String ERR14;
    String ERR15;
    String ERR16;
    String ERR17;
    String ERR19;
    String ERR20;
    String ERR21;
    String ERR22;
    String ERR23;
    String ERR24;

    protected void createChaine() {
        this.ERR1 = Aladin.chaine.getString("ACERR1");
        this.ERR2 = Aladin.chaine.getString("ACERR2");
        this.ERR3 = Aladin.chaine.getString("ACERR3");
        this.ERR4 = Aladin.chaine.getString("ACERR4");
        this.ERR5 = Aladin.chaine.getString("ACERR5");
        this.ERR6 = Aladin.chaine.getString("ACERR6");
        this.ERR7 = Aladin.chaine.getString("ACERR7");
        this.ERR8 = Aladin.chaine.getString("ACERR8");
        this.ERR9 = Aladin.chaine.getString("ACERR9");
        this.ERR10 = Aladin.chaine.getString("ACERR10");
        this.ERR11 = Aladin.chaine.getString("ACERR11");
        this.ERR12 = Aladin.chaine.getString("ACERR12");
        this.ERR13 = Aladin.chaine.getString("ACERR13");
        this.ERR14 = Aladin.chaine.getString("ACERR14");
        this.ERR15 = Aladin.chaine.getString("ACERR15");
        this.ERR16 = Aladin.chaine.getString("ACERR16");
        this.ERR17 = Aladin.chaine.getString("ACERR17");
        this.ERR19 = Aladin.chaine.getString("ACERR19");
        this.ERR20 = Aladin.chaine.getString("ACERR20");
        this.ERR21 = Aladin.chaine.getString("ACERR21");
        this.ERR22 = Aladin.chaine.getString("ACERR22");
        this.ERR23 = Aladin.chaine.getString("ACERR23");
        this.ERR24 = Aladin.chaine.getString("ACERR24");
    }

    Action(String actionStr, Aladin a, PlanFilter pf) {
        this.a = a;
        this.createChaine();
        this.pf = pf;
        this.decodeAction(actionStr);
    }

    protected void action(Source s, Graphics g, ViewSimple v, Point p, int numero, int index, int dx, int dy) {
        this.action(s, g, v, p, numero, index, true, dx, dy);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void action(Source s, Graphics g, ViewSimple v, Point p, int numero, int index, boolean setColor, int dx, int dy) {
        String texte;
        Color theColor;
        block34: {
            int right;
            block35: {
                block33: {
                    int pos;
                    if (setColor) {
                        this.setColor(s);
                    }
                    if ((theColor = this.color) == null) {
                        theColor = s.plan.c;
                    }
                    if (this.function.equals(HIDE)) {
                        return;
                    }
                    if (this.function.equals(DRAWOBJECT)) {
                        int intValue;
                        if (this.shape.equals(DRAW)) {
                            s.doDraw(g, p, theColor);
                            return;
                        }
                        if (this.shape.equals(OVAL)) {
                            g.setColor(theColor);
                            s.drawOval(g, p);
                            return;
                        }
                        if (this.shape.equals(CARRE)) {
                            g.setColor(theColor);
                            s.drawCarre(g, p);
                            return;
                        }
                        if (this.shape.equals(CROIX)) {
                            g.setColor(theColor);
                            s.drawCroix(g, p);
                            return;
                        }
                        if (this.shape.equals(PLUS)) {
                            g.setColor(theColor);
                            s.drawPlus(g, p);
                            return;
                        }
                        if (this.shape.equals(LOSANGE)) {
                            g.setColor(theColor);
                            s.drawLosange(g, p);
                            return;
                        }
                        if (this.shape.equals(TRIANGLE)) {
                            g.setColor(theColor);
                            s.drawTriangle(g, p);
                            return;
                        }
                        if (this.shape.equals(POINT)) {
                            g.setColor(theColor);
                            s.drawPoint(g, p);
                            return;
                        }
                        if (this.shape.equals(DOT)) {
                            g.setColor(theColor);
                            s.drawPoint(g, p);
                            return;
                        }
                        if (this.shape.equals(ELLIPSE) || this.shape.equals(FILLELLIPSE)) {
                            this.drawEllipse(s, g, v, p, theColor, numero, index, dx, dy, this.shape.equals(FILLELLIPSE));
                            return;
                        }
                        if (this.shape.equals(RECTANGLE)) {
                            this.drawRectangle(s, g, v, p, theColor, numero, index, dx, dy);
                            return;
                        }
                        if (this.shape.equals(PM)) {
                            this.drawPM(s, g, v, p, theColor, numero, index, dx, dy);
                            return;
                        }
                        if (this.shape.equals(LINE)) {
                            this.drawLine(s, g, v, p, theColor, numero, index, dx, dy);
                            return;
                        }
                        if (!(this.shape.equals(SIZE) || this.shape.equals(FILLSIZE) || this.shape.equals(FIXEDCIRCLE))) {
                            s.doDraw(g, p, null);
                            return;
                        }
                        if (s.values[numero][index][0] == -1.0) {
                            return;
                        }
                        g.setColor(theColor);
                        if (this.shape.equals(FIXEDCIRCLE)) {
                            intValue = (int)s.values[numero][index][0];
                        } else {
                            double scaleFactor = v.getProj().r / (60.0 * v.getProj().rm) * v.getZoom();
                            intValue = (int)(s.values[numero][index][0] * scaleFactor * (double)s.plan.getScalingFactor());
                            if (intValue < 3) {
                                s.drawPoint(g, p);
                                return;
                            }
                        }
                        if (this.shape.equals(SIZE)) {
                            g.drawOval(p.x - intValue / 2, p.y - intValue / 2, intValue, intValue);
                            return;
                        }
                        if (this.shape.equals(FILLSIZE) && Aladin.ENABLE_FOOTPRINT_OPACITY && g instanceof Graphics2D) {
                            Graphics2D g2d = (Graphics2D)g;
                            Composite saveComposite = g2d.getComposite();
                            float opacityLevel = Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL * s.plan.getOpacityLevel();
                            Composite myComposite = Util.getImageComposite(opacityLevel);
                            g2d.setComposite(myComposite);
                            g2d.fillOval(p.x - intValue / 2, p.y - intValue / 2, intValue, intValue);
                            g2d.setComposite(saveComposite);
                            return;
                        }
                        g.fillOval(p.x - intValue / 2, p.y - intValue / 2, intValue, intValue);
                        return;
                    }
                    if (!this.function.equals(DRAWSTRING)) return;
                    if (this.textToDisp == null || !this.textToDisp.startsWith("[") && !this.textToDisp.startsWith("{")) break block33;
                    if (this.textToDisp.startsWith("[")) {
                        pos = s.findUCD(this.textToDisp.substring(1, this.textToDisp.length() - 1).toUpperCase());
                        if (pos < 0) {
                            return;
                        }
                        texte = s.getValue(pos);
                    } else {
                        pos = s.findColumn(this.textToDisp.substring(1, this.textToDisp.length() - 1));
                        if (pos < 0) {
                            return;
                        }
                        texte = s.getValue(pos);
                    }
                    if (texte == null) {
                        texte = "";
                    }
                    break block34;
                }
                if (this.parserToDisp == null) break block35;
                if (!Action.setAllVariables(this.parserToDisp, s, false)) {
                    return;
                }
                texte = new Double(this.parserToDisp.eval()).toString();
                int sepIndex = texte.indexOf(".");
                if (sepIndex >= 0) {
                    int end;
                    int expIndex = texte.indexOf("E");
                    int n = end = texte.length() > sepIndex + 5 ? sepIndex + 5 : texte.length();
                    if (expIndex >= 0) {
                        end = expIndex > end ? end : expIndex;
                    }
                    String saveText = new String(texte);
                    texte = texte.substring(0, end);
                    if (expIndex >= 0) {
                        texte = texte + saveText.substring(expIndex);
                    }
                }
                break block34;
            }
            int left = this.textToDisp.indexOf("\"");
            texte = left >= 0 && (right = this.textToDisp.lastIndexOf("\"")) >= 0 && left != right ? this.textToDisp.substring(left + 1, right) : this.textToDisp;
        }
        float scalingFactor = s.plan.getScalingFactor();
        Font font = scalingFactor == 1.0f ? FONT : FONT.deriveFont((float)FONT.getSize() * (2.0f * scalingFactor / 3.0f));
        FontMetrics m = Toolkit.getDefaultToolkit().getFontMetrics(font);
        this.wTexte = m.stringWidth(texte) / 2;
        this.hTexte = m.getHeight() / 2;
        g.setFont(font);
        g.setColor(theColor);
        g.drawString(texte, p.x - this.wTexte, p.y + this.hTexte - 8);
    }

    private void decodeAction(String s) {
        int suite;
        String os = new String(s);
        s = UCDFilter.skipSpaces(s);
        while (s.charAt(0) == '\n') {
            s = s.substring(1);
        }
        int beginParam = s.indexOf("(");
        String paramStr = "";
        if (beginParam < 0) {
            beginParam = s.length();
        } else {
            int endParam = this.getClosingParenthesis(s, beginParam + 1);
            if (endParam < 0) {
                this.badSyntax = true;
                Aladin.warning(this.ERR1, 1);
                return;
            }
            paramStr = s.substring(beginParam + 1, endParam);
        }
        String myFunction = s.substring(0, beginParam);
        if (myFunction.equals(DRAWOBJECT)) {
            this.function = DRAWOBJECT;
            this.decodeDrawObject(paramStr);
            return;
        }
        if (myFunction.equals(DRAWSTRING)) {
            this.function = DRAWSTRING;
            this.decodeDrawString(paramStr);
            return;
        }
        if (myFunction.equals(HIDE)) {
            this.function = HIDE;
            return;
        }
        int beginDraw = os.indexOf(DRAW);
        if (beginDraw >= 0) {
            os = os.substring(beginDraw + DRAW.length());
        }
        if ((suite = this.processFunction(os = os.trim())) >= 0 && suite < os.length()) {
            this.processFunction(os.substring(suite).trim());
        }
    }

    private void setColor(Source s) {
        if (this.colorIsVariable) {
            this.color = this.computeColor(s);
        } else if (this.rainbowColorIsVariable) {
            this.color = this.computeRainbowColor(s);
        } else if (this.saturationColorIsVariable) {
            this.color = this.computeSaturationColor(s);
        }
    }

    private int processFunction(String s) {
        String name;
        int pos;
        int before;
        if (s.length() == 0) {
            return -1;
        }
        if (s.startsWith("\"")) {
            int index = s.indexOf("\"", 1);
            if (index < 0) {
                this.badSyntax = true;
                Aladin.warning(this.ERR2, 1);
                return -1;
            }
            this.function = DRAWSTRING;
            this.textToDisp = s.substring(1, index);
            return index + 1;
        }
        if (s.startsWith("[") || s.startsWith("{")) {
            int end;
            int n = end = s.startsWith("[") ? s.indexOf("]") : s.indexOf("}");
            if (end < 0) {
                this.badSyntax = true;
                Aladin.warning(this.ERR3, 1);
                return -1;
            }
            this.function = DRAWSTRING;
            this.textToDisp = s.substring(0, end + 1);
            return end + 1;
        }
        int b1 = s.indexOf(" ");
        int b2 = s.indexOf("(");
        if (b1 >= 0 && b2 >= 0) {
            int n = Math.min(s.indexOf(" "), s.indexOf("("));
        }
        if ((before = b1 < 0 ? b2 : b1) < 0) {
            before = s.length();
        }
        if ((pos = Action.findColorName(name = s.substring(0, before))) >= 0) {
            this.color = MYCOLORS[pos];
            return name.length();
        }
        if (s.startsWith(RGB)) {
            before = s.indexOf("(");
            if (before < 0) {
                this.badSyntax = true;
                Aladin.warning(this.ERR4, 1);
                return -1;
            }
            int end = this.getClosingParenthesis(s, before + 1);
            if (end < 0) {
                this.badSyntax = true;
                Aladin.warning(this.ERR5, 1);
                return -1;
            }
            this.decodeRGB(s.substring(Math.max(0, before), end + 1));
            return end + 1;
        }
        if (s.startsWith(RAINBOW)) {
            before = s.indexOf("(");
            if (before < 0) {
                this.badSyntax = true;
                Aladin.warning(this.ERR6, 1);
                return -1;
            }
            int end = this.getClosingParenthesis(s, before + 1);
            if (end < 0) {
                this.badSyntax = true;
                Aladin.warning(this.ERR7, 1);
                return -1;
            }
            this.decodeRainbow(s.substring(Math.max(0, before), end + 1));
            return end + 1;
        }
        if (s.startsWith(SATURATION)) {
            before = s.indexOf("(");
            if (before < 0) {
                this.badSyntax = true;
                Aladin.warning(this.ERR6, 1);
                return -1;
            }
            int end = this.getClosingParenthesis(s, before + 1);
            if (end < 0) {
                this.badSyntax = true;
                Aladin.warning(this.ERR7, 1);
                return -1;
            }
            this.decodeSaturation(s.substring(Math.max(0, before), end + 1));
            return end + 1;
        }
        if (name.startsWith("#")) {
            this.color = Action.decodeColorString(s.substring(0, before));
            return name.length();
        }
        if (name.equals(OVAL) || name.equals(CARRE) || name.equals(CROIX) || name.equals(PLUS) || name.equals(LOSANGE) || name.equals(TRIANGLE) || name.equals(POINT) || name.equals(DOT)) {
            this.shape = name;
            this.function = DRAWOBJECT;
            return name.length();
        }
        if (s.startsWith(SIZE) || s.startsWith(FILLSIZE) || s.startsWith(FIXEDCIRCLE) || s.startsWith(ELLIPSE) || s.startsWith(FILLELLIPSE) || s.startsWith(PM) || s.startsWith(RECTANGLE) || s.startsWith(LINE)) {
            this.function = DRAWOBJECT;
            before = s.indexOf("(");
            if (before < 0) {
                this.badSyntax = true;
                Aladin.warning(this.ERR8, 1);
                return -1;
            }
            int end = this.getClosingParenthesis(s, before + 1);
            if (end < 0) {
                this.badSyntax = true;
                Aladin.warning(this.ERR9, 1);
                return -1;
            }
            this.decodeShape(SHAPE + s.substring(0, end + 1));
            return end + 1;
        }
        try {
            this.parserToDisp = UCDFilter.createParser(s, this.a);
            this.function = DRAWSTRING;
            return -1;
        }
        catch (ParserException e) {
            this.badSyntax = true;
            Aladin.warning(this.ERR10 + "[" + s + "]", 1);
            return -1;
        }
    }

    protected static Color getColor(String s) {
        int pos = Action.findColorName(s);
        if (pos >= 0) {
            return MYCOLORS[pos];
        }
        if (s.startsWith(RGB)) {
            return Action.decodeStaticRGB(s);
        }
        return Action.decodeColorString(s);
    }

    private void processColor(String s) {
        int pos = Action.findColorName(s);
        if (pos >= 0) {
            this.color = MYCOLORS[pos];
            return;
        }
        if (s.startsWith(RGB)) {
            this.decodeRGB(s);
            return;
        }
        if (s.startsWith(RAINBOW)) {
            this.decodeRainbow(s);
            return;
        }
        if (s.startsWith(SATURATION)) {
            this.decodeSaturation(s);
            return;
        }
        this.color = Action.decodeColorString(s);
    }

    private void decodeSaturation(String s) {
        String paramStr = s.substring(s.indexOf("(") + 1, Math.max(s.lastIndexOf(")"), 0));
        StringTokenizer st = new StringTokenizer(paramStr, ",");
        if (st.countTokens() != 1 && st.countTokens() != 3) {
            this.badSyntax = true;
            Aladin.warning(this.ERR11 + " " + SATURATION + " rainbow(exp[,minValue,maxValue])", 1);
            return;
        }
        try {
            this.saturationParser = UCDFilter.createParser(st.nextToken(), this.a);
        }
        catch (ParserException e) {
            Aladin.warning(this.ERR12, 1);
            this.badSyntax = true;
            return;
        }
        if (this.saturationParser.isConstant()) {
            this.color = Color.getHSBColor(this.getHue((float)this.saturationParser.eval()), 1.0f, 1.0f);
        } else {
            this.saturationColorIsVariable = true;
        }
        if (st.hasMoreTokens()) {
            try {
                this.saturationMinValue = Double.valueOf(st.nextToken());
                this.saturationMaxValue = Double.valueOf(st.nextToken());
            }
            catch (NumberFormatException e) {
                Aladin.warning(this.ERR13, 1);
                this.badSyntax = true;
                return;
            }
            this.mustComputeSaturationMinMax = false;
            this.userDefinedSaturationMinMax = true;
        }
    }

    private void decodeRainbow(String s) {
        String paramStr = s.substring(s.indexOf("(") + 1, Math.max(s.lastIndexOf(")"), 0));
        StringTokenizer st = new StringTokenizer(paramStr, ",");
        if (st.countTokens() != 1 && st.countTokens() != 3) {
            this.badSyntax = true;
            Aladin.warning(this.ERR11 + " " + RAINBOW + " rainbow(exp[,minValue,maxValue])", 1);
            return;
        }
        try {
            this.rainbowParser = UCDFilter.createParser(st.nextToken(), this.a);
        }
        catch (ParserException e) {
            Aladin.warning(this.ERR12, 1);
            this.badSyntax = true;
            return;
        }
        if (this.rainbowParser.isConstant()) {
            this.color = Color.getHSBColor(this.getHue((float)this.rainbowParser.eval()), 1.0f, 1.0f);
        } else {
            this.rainbowColorIsVariable = true;
        }
        if (st.hasMoreTokens()) {
            try {
                this.rainbowMinValue = Double.valueOf(st.nextToken());
                this.rainbowMaxValue = Double.valueOf(st.nextToken());
            }
            catch (NumberFormatException e) {
                Aladin.warning(this.ERR13, 1);
                this.badSyntax = true;
                return;
            }
            this.mustComputeRainbowMinMax = false;
            this.userDefinedRainbowMinMax = true;
        }
    }

    protected static Color decodeStaticRGB(String s) {
        try {
            int pos = s.indexOf(40) + 1;
            int next = s.indexOf(44, pos);
            int r = Integer.parseInt(s.substring(pos, next));
            pos = next + 1;
            next = s.indexOf(44, pos);
            int g = Integer.parseInt(s.substring(pos, next));
            pos = next + 1;
            next = s.indexOf(41, pos);
            int b = Integer.parseInt(s.substring(pos, next));
            return new Color(r, g, b);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void decodeRGB(String s) {
        String paramStr = s.substring(s.indexOf("(") + 1, Math.max(s.lastIndexOf(")"), 0));
        StringTokenizer st = new StringTokenizer(paramStr, ",");
        if (st.countTokens() != 3) {
            this.badSyntax = true;
            Aladin.warning(this.ERR14, 1);
            return;
        }
        try {
            this.redParser = UCDFilter.createParser(st.nextToken(), this.a);
            this.greenParser = UCDFilter.createParser(st.nextToken(), this.a);
            this.blueParser = UCDFilter.createParser(st.nextToken(), this.a);
        }
        catch (ParserException e) {
            Aladin.warning(this.ERR15, 1);
            this.badSyntax = true;
            return;
        }
        if (this.redParser.isConstant() && this.greenParser.isConstant() && this.blueParser.isConstant()) {
            this.color = new Color(Math.max(Math.min((float)this.redParser.eval() / 255.0f, 1.0f), 0.0f), Math.max(Math.min((float)this.greenParser.eval() / 255.0f, 1.0f), 0.0f), Math.max(Math.min((float)this.blueParser.eval() / 255.0f, 1.0f), 0.0f));
        } else {
            this.colorIsVariable = true;
        }
    }

    private static Color decodeColorString(String s) {
        Color retCol;
        try {
            retCol = Color.decode(s);
        }
        catch (NumberFormatException e) {
            retCol = null;
        }
        return retCol;
    }

    protected static int findColorName(String s) {
        for (int i = 0; i < COLORNAME.length; ++i) {
            if (!s.equalsIgnoreCase(COLORNAME[i])) continue;
            return i;
        }
        return -1;
    }

    protected static String findColorName(Color c) {
        for (int i = 0; i < MYCOLORS.length; ++i) {
            if (!c.equals(MYCOLORS[i])) continue;
            return COLORNAME[i];
        }
        return "rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")";
    }

    private Color computeSaturationColor(Source s) {
        if (this.mustComputeSaturationMinMax) {
            this.computeSaturationMinMax();
            this.mustComputeSaturationMinMax = false;
        }
        if (!Action.setAllVariables(this.saturationParser, s, false)) {
            return null;
        }
        double val = this.saturationParser.eval();
        if (val == 99.9) {
            return null;
        }
        Color orgColor = s.plan.c;
        float[] hsbVals = new float[3];
        Color.RGBtoHSB(orgColor.getRed(), orgColor.getGreen(), orgColor.getBlue(), hsbVals);
        float hue = hsbVals[0];
        float value = hsbVals[2];
        float saturation = (float)((val - this.saturationMinValue) / (this.saturationMaxValue - this.saturationMinValue));
        return Color.getHSBColor(hue, saturation, value);
    }

    private Color computeRainbowColor(Source s) {
        if (this.mustComputeRainbowMinMax) {
            this.computeRainbowMinMax();
            this.mustComputeRainbowMinMax = false;
        }
        if (!Action.setAllVariables(this.rainbowParser, s, false)) {
            return null;
        }
        double val = this.rainbowParser.eval();
        if (val == 99.9) {
            return null;
        }
        float hue = (float)((val - this.rainbowMinValue) / (this.rainbowMaxValue - this.rainbowMinValue));
        hue = this.getHue(hue);
        return Color.getHSBColor(hue, 1.0f, 1.0f);
    }

    private float getHue(float hue) {
        float upLimit = 0.78f;
        float ret = 1.0f - hue;
        if ((ret *= 0.78f) > 0.78f) {
            ret = 0.78f;
        }
        if (ret < 0.0f) {
            ret = 0.0f;
        }
        return ret;
    }

    private Color computeColor(Source s) {
        if (this.mustComputeRGBMinMax) {
            this.computeRGBMinMax();
            this.mustComputeRGBMinMax = false;
        }
        if (!Action.setAllVariables(this.redParser, s, false)) {
            return null;
        }
        if (!Action.setAllVariables(this.blueParser, s, false)) {
            return null;
        }
        if (!Action.setAllVariables(this.greenParser, s, false)) {
            return null;
        }
        double redVal = this.redParser.eval();
        double greenVal = this.greenParser.eval();
        double blueVal = this.blueParser.eval();
        if (redVal == 99.9 || greenVal == 99.9 || blueVal == 99.9) {
            return null;
        }
        float redComp = this.redParser.isConstant() ? Math.max(Math.min((float)redVal / 255.0f, 1.0f), 0.0f) : (float)((redVal - this.redMinValue) / (this.redMaxValue - this.redMinValue));
        float greenComp = this.greenParser.isConstant() ? Math.max(Math.min((float)greenVal / 255.0f, 1.0f), 0.0f) : (float)((greenVal - this.greenMinValue) / (this.greenMaxValue - this.greenMinValue));
        float blueComp = this.blueParser.isConstant() ? Math.max(Math.min((float)blueVal / 255.0f, 1.0f), 0.0f) : (float)((blueVal - this.blueMinValue) / (this.blueMaxValue - this.blueMinValue));
        return new Color(redComp, greenComp, blueComp);
    }

    private void decodeDrawString(String param) {
        StringTokenizer st = new StringTokenizer(param, ",");
        String curStr = null;
        while (st.hasMoreTokens()) {
            curStr = st.nextToken();
            if (curStr.startsWith(COLOR)) {
                try {
                    while (Action.countNbOcc('(', curStr) != Action.countNbOcc(')', curStr)) {
                        curStr = curStr + "," + st.nextToken();
                    }
                }
                catch (NoSuchElementException e) {
                    Aladin.warning(this.ERR16, 1);
                    this.badSyntax = true;
                    return;
                }
                this.processColor(curStr.substring(COLOR.length()));
                continue;
            }
            this.textToDisp = curStr;
        }
    }

    private void decodeDrawObject(String param) {
        StringTokenizer st = new StringTokenizer(param, ",");
        String curStr = null;
        while (st.hasMoreTokens()) {
            curStr = st.nextToken();
            if (curStr.startsWith(COLOR)) {
                try {
                    while (Action.countNbOcc('(', curStr) != Action.countNbOcc(')', curStr)) {
                        curStr = curStr + "," + st.nextToken();
                    }
                }
                catch (NoSuchElementException e) {
                    Aladin.warning(this.ERR16, 1);
                    this.badSyntax = true;
                    return;
                }
                this.processColor(curStr.substring(COLOR.length()));
                continue;
            }
            if (!curStr.startsWith(SHAPE)) continue;
            if ((curStr.indexOf(SIZE) >= 0 || curStr.indexOf(FILLSIZE) >= 0 || curStr.indexOf(FIXEDCIRCLE) >= 0 || curStr.indexOf(LINE) >= 0 || curStr.indexOf(ELLIPSE) >= 0 || curStr.indexOf(FILLELLIPSE) >= 0 || curStr.indexOf(PM) >= 0 || curStr.indexOf(RECTANGLE) >= 0) && curStr.indexOf("(") >= 0) {
                try {
                    while (Action.countNbOcc('(', curStr) != Action.countNbOcc(')', curStr)) {
                        curStr = curStr + "," + st.nextToken();
                    }
                }
                catch (NoSuchElementException e) {
                    Aladin.warning(this.ERR17, 1);
                    this.badSyntax = true;
                    return;
                }
            }
            this.decodeShape(curStr);
        }
    }

    private void decodeShape(String s) {
        String param = s.substring(s.indexOf("(") + 1, Math.max(s.lastIndexOf(")"), 0));
        if (param.length() != 0) {
            this.shape = s.substring(SHAPE.length(), s.indexOf("(")).trim();
            if (this.shape.equals(SIZE) || this.shape.equals(FILLSIZE) || this.shape.equals(FIXEDCIRCLE)) {
                StringTokenizer st = new StringTokenizer(param, ",");
                if (st.countTokens() != 1 && st.countTokens() != 3 && st.countTokens() != 5) {
                    this.badSyntax = true;
                    Aladin.warning(this.ERR11 + " " + SIZE + " (exp[,minRadius,maxRadius])", 1);
                    return;
                }
                try {
                    this.sizeParser = UCDFilter.createParser(st.nextToken(), this.a);
                }
                catch (ParserException e) {
                    Aladin.warning(this.ERR19, 1);
                    this.badSyntax = true;
                }
                if (st.hasMoreTokens()) {
                    try {
                        this.minRadius = Integer.valueOf(st.nextToken().trim());
                        this.maxRadius = Integer.valueOf(st.nextToken().trim());
                    }
                    catch (NumberFormatException e) {
                        Aladin.warning(this.ERR20, 1);
                        this.badSyntax = true;
                        return;
                    }
                }
                if (st.hasMoreTokens()) {
                    try {
                        this.minValue = Integer.valueOf(st.nextToken().trim()).intValue();
                        this.maxValue = Integer.valueOf(st.nextToken().trim()).intValue();
                    }
                    catch (NumberFormatException e) {
                        Aladin.warning(this.ERR21, 1);
                        this.badSyntax = true;
                        return;
                    }
                    this.mustComputeMinMax = false;
                    this.userDefinedMinMax = true;
                }
            } else if (this.shape.equals(ELLIPSE) || this.shape.equals(FILLELLIPSE)) {
                this.decodeEllipseParameters(param);
            } else if (this.shape.equals(RECTANGLE)) {
                this.decodeRectangleParameters(param);
            } else if (this.shape.equals(PM)) {
                this.decodePMParameters(param);
            } else if (this.shape.equals(LINE)) {
                this.decodeLineParameters(param);
            }
        } else {
            this.shape = s.substring(SHAPE.length());
            if (this.shape.equals(LINE) || this.shape.equals(ELLIPSE) || this.shape.equals(FILLELLIPSE) || this.shape.equals(RECTANGLE) || this.shape.equals(SIZE) || this.shape.equals(FILLSIZE) || this.shape.equals(FIXEDCIRCLE) || this.shape.equals(PM)) {
                Aladin.warning(this.ERR22 + " " + this.shape, 1);
                this.badSyntax = true;
            }
        }
    }

    private void decodeLineParameters(String param) {
        StringTokenizer st = new StringTokenizer(param, ",");
        String dec2 = "";
        String ra2 = "";
        String dec1 = "";
        String ra1 = "";
        try {
            ra1 = st.nextToken();
            dec1 = st.nextToken();
            ra2 = st.nextToken();
            dec2 = st.nextToken();
        }
        catch (NoSuchElementException e) {
            Aladin.warning("Missing parameter for the line function !", 1);
            this.badSyntax = true;
        }
        this.lineRa1Parser = UCDFilter.createParser(ra1, this.a);
        this.lineDec1Parser = UCDFilter.createParser(dec1, this.a);
        this.lineRa2Parser = UCDFilter.createParser(ra2, this.a);
        this.lineDec2Parser = UCDFilter.createParser(dec2, this.a);
    }

    private void decodePMParameters(String param) {
        StringTokenizer st = new StringTokenizer(param, ",");
        String pmra = "";
        String pmdec = "";
        try {
            pmra = st.nextToken();
            pmdec = st.nextToken();
        }
        catch (NoSuchElementException e) {
            Aladin.warning(this.ERR23, 1);
            this.badSyntax = true;
        }
        this.pmRAParser = UCDFilter.createParser(pmra, this.a);
        this.pmDecParser = UCDFilter.createParser(pmdec, this.a);
    }

    private void decodeRectangleParameters(String param) {
        this.decodeEllipseParameters(param);
    }

    private void decodeEllipseParameters(String param) {
        StringTokenizer st = new StringTokenizer(param, ",");
        String posAngle = "";
        String minAxis = "";
        String majAxis = "";
        try {
            majAxis = st.nextToken();
            minAxis = st.nextToken();
            posAngle = st.nextToken();
        }
        catch (NoSuchElementException e) {
            Aladin.warning(this.ERR24, 1);
            this.badSyntax = true;
        }
        this.majAxisParser = UCDFilter.createParser(majAxis, this.a);
        this.minAxisParser = UCDFilter.createParser(minAxis, this.a);
        this.posAngleParser = UCDFilter.createParser(posAngle, this.a);
    }

    private void computeMinMax(Source[] sources) {
        if (this.sizeParser.isConstant()) {
            this.minValue = 0.0;
            this.maxValue = this.sizeParser.eval();
            return;
        }
        this.minValue = Double.POSITIVE_INFINITY;
        this.maxValue = Double.NEGATIVE_INFINITY;
        for (int i = sources.length - 1; i >= 0; --i) {
            double value;
            Source s = sources[i];
            if (Aladin.isSlow && i % 50 == 0) {
                Util.pause(10);
            }
            if (!Action.setAllVariables(this.sizeParser, s, false) || Math.abs(value = this.sizeParser.eval()) == 99.9) continue;
            if (value > this.maxValue) {
                this.maxValue = value;
            }
            if (!(value < this.minValue)) continue;
            this.minValue = value;
        }
    }

    private void computeSaturationMinMax() {
        this.saturationMinValue = Double.POSITIVE_INFINITY;
        this.saturationMaxValue = Double.NEGATIVE_INFINITY;
        Plan p = null;
        Plan[] plans = this.pf.getConcernedPlans();
        double value = Double.POSITIVE_INFINITY;
        for (int i = plans.length - 1; i >= 0; --i) {
            p = plans[i];
            if (!p.isCatalog()) continue;
            Iterator<Obj> it = ((PlanCatalog)plans[i]).iterator();
            int j = 0;
            while (it.hasNext()) {
                Obj o = it.next();
                if (o instanceof Source) {
                    Source s = (Source)o;
                    if (Aladin.isSlow && j % 50 == 0) {
                        Util.pause(10);
                    }
                    if (s != null && Action.setAllVariables(this.saturationParser, s, false) && Math.abs(value = this.saturationParser.eval()) != 99.9) {
                        if (value > this.saturationMaxValue) {
                            this.saturationMaxValue = value;
                        }
                        if (value < this.saturationMinValue) {
                            this.saturationMinValue = value;
                        }
                    }
                }
                ++j;
            }
        }
        if (value == this.saturationMaxValue) {
            this.saturationMinValue = 0.0;
        }
    }

    private void computeRainbowMinMax() {
        this.rainbowMinValue = Double.POSITIVE_INFINITY;
        this.rainbowMaxValue = Double.NEGATIVE_INFINITY;
        Plan p = null;
        Plan[] plans = this.pf.getConcernedPlans();
        double hue = Double.POSITIVE_INFINITY;
        for (int i = plans.length - 1; i >= 0; --i) {
            p = plans[i];
            if (!p.isCatalog()) continue;
            Iterator<Obj> it = p.iterator();
            int j = 0;
            while (it.hasNext()) {
                Obj o = it.next();
                if (o instanceof Source) {
                    Source s = (Source)o;
                    if (Aladin.isSlow && j % 50 == 0) {
                        Util.pause(10);
                    }
                    if (s != null && Action.setAllVariables(this.rainbowParser, s, false) && Math.abs(hue = this.rainbowParser.eval()) != 99.9) {
                        if (hue > this.rainbowMaxValue) {
                            this.rainbowMaxValue = hue;
                        }
                        if (hue < this.rainbowMinValue) {
                            this.rainbowMinValue = hue;
                        }
                    }
                }
                ++j;
            }
        }
        if (hue == this.rainbowMaxValue) {
            this.rainbowMinValue = 0.0;
        }
    }

    private void computeRGBMinMax() {
        this.blueMinValue = Double.POSITIVE_INFINITY;
        this.greenMinValue = Double.POSITIVE_INFINITY;
        this.redMinValue = Double.POSITIVE_INFINITY;
        this.blueMaxValue = Double.NEGATIVE_INFINITY;
        this.greenMaxValue = Double.NEGATIVE_INFINITY;
        this.redMaxValue = Double.NEGATIVE_INFINITY;
        Plan p = null;
        Plan[] plans = this.pf.getConcernedPlans();
        for (int i = plans.length - 1; i >= 0; --i) {
            p = plans[i];
            if (!p.isCatalog()) continue;
            Iterator<Obj> it = ((PlanCatalog)p).iterator();
            int j = 0;
            while (it.hasNext()) {
                Obj o = it.next();
                if (o instanceof Source) {
                    Source s = (Source)o;
                    if (Aladin.isSlow && j % 50 == 0) {
                        Util.pause(10);
                    }
                    if (s != null && Action.setAllVariables(this.redParser, s, false) && Action.setAllVariables(this.greenParser, s, false) && Action.setAllVariables(this.blueParser, s, false)) {
                        double redValue = this.redParser.eval();
                        double greenValue = this.greenParser.eval();
                        double blueValue = this.blueParser.eval();
                        if (Math.abs(redValue) != 99.9) {
                            if (redValue > this.redMaxValue) {
                                this.redMaxValue = redValue;
                            }
                            if (redValue < this.redMinValue) {
                                this.redMinValue = redValue;
                            }
                        }
                        if (Math.abs(greenValue) != 99.9) {
                            if (greenValue > this.greenMaxValue) {
                                this.greenMaxValue = greenValue;
                            }
                            if (greenValue < this.greenMinValue) {
                                this.greenMinValue = greenValue;
                            }
                        }
                        if (Math.abs(blueValue) != 99.9) {
                            if (blueValue > this.blueMaxValue) {
                                this.blueMaxValue = blueValue;
                            }
                            if (blueValue < this.blueMinValue) {
                                this.blueMinValue = blueValue;
                            }
                        }
                    }
                }
                ++j;
            }
        }
        if (this.redMinValue == this.redMaxValue) {
            this.redMinValue = 0.0;
        }
        if (this.greenMinValue == this.greenMaxValue) {
            this.greenMinValue = 0.0;
        }
        if (this.blueMinValue == this.blueMaxValue) {
            this.blueMinValue = 0.0;
        }
    }

    private void computePM(Source s, int numero, int index) {
        double newValDe;
        double newValRA;
        if (!Action.setAllVariables(this.pmRAParser, s, false, true)) {
            return;
        }
        if (!Action.setAllVariables(this.pmDecParser, s, false, true)) {
            return;
        }
        s.values[numero][index][0] = this.pmRAParser.eval();
        s.values[numero][index][1] = this.pmDecParser.eval();
        Unit uRA = null;
        Unit uDec = null;
        try {
            uRA = this.pmRAParser.evalUnit();
            uDec = this.pmDecParser.evalUnit();
        }
        catch (ParseException e) {
            return;
        }
        Unit RAunitless = null;
        Unit RAmas = null;
        Unit DEmas = null;
        boolean succeed = true;
        try {
            RAunitless = new Unit("1ms/yr");
            RAunitless.convertFrom(uRA);
        }
        catch (ParseException e) {
            succeed = false;
        }
        catch (ArithmeticException e2) {
            succeed = false;
        }
        if (succeed) {
            newValRA = 15.0 * RAunitless.value * Math.cos(s.dej * Math.PI / 180.0);
        } else {
            succeed = true;
            try {
                RAmas = new Unit("1mas/yr");
                RAmas.convertFrom(uRA);
            }
            catch (ParseException e) {
                succeed = false;
            }
            catch (ArithmeticException e2) {
                succeed = false;
            }
            if (succeed) {
                newValRA = RAmas.value;
            } else {
                return;
            }
        }
        succeed = true;
        try {
            DEmas = new Unit("1mas/yr");
            DEmas.convertFrom(uDec);
        }
        catch (ParseException e) {
            succeed = false;
        }
        catch (ArithmeticException e2) {
            succeed = false;
        }
        if (succeed) {
            newValDe = DEmas.value;
            if (Double.isNaN(newValRA) || Double.isNaN(newValDe)) {
                return;
            }
        } else {
            return;
        }
        s.values[numero][index][0] = newValRA;
        s.values[numero][index][1] = newValDe;
    }

    private void computeLine(Source s, int numero, int index) {
        if (!Action.setAllVariables(this.lineRa1Parser, s, false, true)) {
            return;
        }
        if (!Action.setAllVariables(this.lineDec1Parser, s, false, true)) {
            return;
        }
        if (!Action.setAllVariables(this.lineRa2Parser, s, false, true)) {
            return;
        }
        if (!Action.setAllVariables(this.lineDec2Parser, s, false, true)) {
            return;
        }
        s.values[numero][index][0] = this.lineRa1Parser.eval();
        s.values[numero][index][1] = this.lineDec1Parser.eval();
        s.values[numero][index][2] = this.lineRa2Parser.eval();
        s.values[numero][index][3] = this.lineDec2Parser.eval();
    }

    private void drawPM(Source s, Graphics g, ViewSimple v, Point p, Color c, int numero, int index, int dx, int dy) {
        double factor = 1000.0;
        factor *= (double)s.plan.getScalingFactor();
        double pmRA = s.values[numero][index][0];
        double pmDec = s.values[numero][index][1];
        double lFleche = (pmRA * pmRA + pmDec * pmDec) / 100.0;
        if (lFleche > 6.0) {
            lFleche = 6.0;
        }
        if (pmRA == -1.0 && pmDec == -1.0) {
            return;
        }
        Plan base = v.pref;
        if (base == null) {
            base = s.plan;
        }
        Projection proj = v.getProj();
        Coord coord = new Coord();
        coord.al = s.raj;
        coord.del = s.dej;
        coord = proj.getXY(coord);
        if (Double.isNaN(coord.x)) {
            return;
        }
        double orgX = coord.x;
        double orgY = coord.y;
        coord.al += (pmRA *= factor) / 3600000.0 / Math.cos(Math.PI * coord.del / 180.0);
        coord.del += (pmDec *= factor) / 3600000.0;
        coord = new Coord(coord.al, coord.del);
        coord = proj.getXY(coord);
        if (Double.isNaN(coord.x)) {
            return;
        }
        Point p1 = v.getViewCoord(orgX, orgY);
        Point p2 = v.getViewCoord(coord.x, coord.y);
        if (p1 == null || p2 == null) {
            return;
        }
        double dist = Math.sqrt(Math.pow(p1.x - p2.x, 2.0) + Math.pow(p1.y - p2.y, 2.0));
        if (proj.t == 4 || proj.t == 11) {
            Coord coordBis = new Coord(s.raj, s.dej);
            coordBis.al -= pmRA / 3600000.0 / Math.cos(Math.PI * coord.del / 180.0);
            coordBis.del -= pmDec / 3600000.0;
            proj.getXY(coordBis);
            Point p2Bis = v.getViewCoord(coordBis.x, coordBis.y);
            double distBis = Math.sqrt(Math.pow(p1.x - p2Bis.x, 2.0) + Math.pow(p1.y - p2Bis.y, 2.0));
            if (Math.abs(distBis - dist) > 50.0) {
                return;
            }
        }
        if ((lFleche *= v.getZoom()) > dist / 5.0) {
            lFleche = dist / 5.0;
        }
        if (lFleche > 17.0) {
            lFleche = 17.0;
        } else if (lFleche < 3.0) {
            lFleche = 4.0;
        }
        double angle = Math.atan((orgY - coord.y) / (orgX - coord.x));
        if (orgX - coord.x < 0.0) {
            angle += Math.PI;
        }
        double alpha = angle + 0.7853981633974483;
        Point f1 = new Point((int)(lFleche * Math.cos(alpha)) + p2.x, (int)(lFleche * Math.sin(alpha)) + p2.y);
        alpha = angle - 0.7853981633974483;
        Point f2 = new Point((int)(lFleche * Math.cos(alpha)) + p2.x, (int)(lFleche * Math.sin(alpha)) + p2.y);
        p1.x += dx;
        p2.x += dx;
        f1.x += dx;
        f2.x += dx;
        p1.y += dy;
        p2.y += dy;
        f1.y += dy;
        f2.y += dy;
        g.setColor(c);
        g.drawLine(p1.x, p1.y, p2.x, p2.y);
        g.drawLine(p2.x, p2.y, f1.x, f1.y);
        g.drawLine(p2.x, p2.y, f2.x, f2.y);
    }

    private void drawLine(Source s, Graphics g, ViewSimple v, Point p, Color c, int numero, int index, int dx, int dy) {
        double ra1 = s.values[numero][index][0];
        double de1 = s.values[numero][index][1];
        double ra2 = s.values[numero][index][2];
        double de2 = s.values[numero][index][3];
        if (ra1 == -1.0 && de1 == -1.0) {
            return;
        }
        Plan base = v.pref;
        if (base == null) {
            base = s.plan;
        }
        Coord coord1 = new Coord();
        coord1.al = ra1;
        coord1.del = de1;
        coord1 = v.getProj().getXY(coord1);
        if (Double.isNaN(coord1.x)) {
            return;
        }
        Coord coord2 = new Coord();
        coord2.al = ra2;
        coord2.del = de2;
        coord2 = v.getProj().getXY(coord2);
        if (Double.isNaN(coord2.x)) {
            return;
        }
        Point p1 = v.getViewCoord(coord1.x, coord1.y);
        Point p2 = v.getViewCoord(coord2.x, coord2.y);
        if (p1 == null || p2 == null) {
            return;
        }
        g.setColor(c);
        p1.x += dx;
        p2.x += dx;
        p1.y += dy;
        p2.y += dy;
        g.drawLine(p1.x, p1.y, p2.x, p2.y);
    }

    private void computeRectangle(Source s, int numero, int index) {
        this.computeEllipse(s, numero, index);
    }

    private void computeEllipse(Source s, int numero, int index) {
        Unit arcsecMajUnit = null;
        Unit arcsecMinUnit = null;
        Unit degPosAngUnit = null;
        try {
            arcsecMajUnit = new Unit("1arcsec");
            arcsecMinUnit = new Unit("1arcsec");
            degPosAngUnit = new Unit("1deg");
        }
        catch (ParseException e) {
            // empty catch block
        }
        boolean setVarUnitSucceed = true;
        if (!Action.setAllVariables(this.majAxisParser, s, false, true)) {
            setVarUnitSucceed = false;
            if (!Action.setAllVariables(this.majAxisParser, s, false)) {
                return;
            }
        }
        if (!Action.setAllVariables(this.minAxisParser, s, false, true)) {
            setVarUnitSucceed = false;
            if (!Action.setAllVariables(this.minAxisParser, s, false)) {
                return;
            }
        }
        s.values[numero][index][0] = this.majAxisParser.eval();
        s.values[numero][index][1] = this.minAxisParser.eval();
        boolean convertSucceed = true;
        if (setVarUnitSucceed) {
            try {
                Unit majAxUnit = this.majAxisParser.evalUnit();
                Unit minAxUnit = this.minAxisParser.evalUnit();
                arcsecMajUnit.convertFrom(majAxUnit);
                arcsecMinUnit.convertFrom(minAxUnit);
                if (majAxUnit.toStringInSI().equals("mag") || minAxUnit.toStringInSI().equals("mag") || majAxUnit.symbol.equals("") || minAxUnit.symbol.equals("")) {
                    convertSucceed = false;
                }
            }
            catch (ParseException e) {
                convertSucceed = false;
                System.out.println("ERROR");
            }
            catch (ArithmeticException e2) {
                convertSucceed = false;
            }
            if (Double.isNaN(arcsecMajUnit.value) || Double.isNaN(arcsecMinUnit.value)) {
                convertSucceed = false;
            }
            if (convertSucceed) {
                s.values[numero][index][0] = arcsecMajUnit.value;
                s.values[numero][index][1] = arcsecMinUnit.value;
            }
        }
        setVarUnitSucceed = true;
        if (!Action.setAllVariables(this.posAngleParser, s, false, true)) {
            setVarUnitSucceed = false;
            if (!Action.setAllVariables(this.posAngleParser, s, false)) {
                return;
            }
        }
        s.values[numero][index][2] = this.posAngleParser.eval();
        convertSucceed = true;
        if (setVarUnitSucceed) {
            try {
                Unit posAngUnit = this.posAngleParser.evalUnit();
                degPosAngUnit.convertFrom(posAngUnit);
                if (posAngUnit.toStringInSI().equals("mag") || posAngUnit.symbol.equals("")) {
                    convertSucceed = false;
                }
            }
            catch (ParseException e) {
                convertSucceed = false;
            }
            catch (ArithmeticException e2) {
                convertSucceed = false;
            }
            if (Double.isNaN(degPosAngUnit.value)) {
                convertSucceed = false;
            }
            if (convertSucceed) {
                s.values[numero][index][2] = degPosAngUnit.value;
            }
        }
    }

    private void drawRectangle(Source s, Graphics g, ViewSimple v, Point p, Color c, int numero, int index, int dx, int dy) {
        double majAxis = s.values[numero][index][0];
        double minAxis = s.values[numero][index][1];
        double posAngle = s.values[numero][index][2];
        if (posAngle == -1.0) {
            posAngle = 0.0;
        }
        if (majAxis == -1.0) {
            return;
        }
        Plan base = v.pref;
        if (base == null) {
            base = s.plan;
        }
        Coord coord = new Coord();
        coord.al = s.raj;
        coord.del = s.dej;
        Coord coord2 = new Coord();
        coord2.al = s.raj;
        coord2.del = s.dej;
        coord2 = v.getProj().getXY(coord2);
        if (Double.isNaN(coord2.x)) {
            return;
        }
        double orgX = coord2.x;
        double orgY = coord2.y;
        coord.al += majAxis / 3600.0 * Math.sin(posAngle * 2.0 * Math.PI / 360.0) / Math.cos(coord.del * 2.0 * Math.PI / 360.0);
        coord.del += majAxis / 3600.0 * Math.cos(posAngle * 2.0 * Math.PI / 360.0);
        coord2.al += minAxis / 3600.0 * Math.cos(posAngle * 2.0 * Math.PI / 360.0) / Math.cos(coord2.del * 2.0 * Math.PI / 360.0);
        coord2.del += -(minAxis / 3600.0) * Math.sin(posAngle * 2.0 * Math.PI / 360.0);
        coord = new Coord(coord.al, coord.del);
        coord = v.getProj().getXY(coord);
        if (Double.isNaN(coord.x)) {
            return;
        }
        coord2 = new Coord(coord2.al, coord2.del);
        coord2 = v.getProj().getXY(coord2);
        if (Double.isNaN(coord2.x)) {
            return;
        }
        Point p1 = v.getViewCoord(coord.x, coord.y);
        double x1 = coord.x;
        double y1 = coord.y;
        Point p2 = v.getViewCoord(coord.x - 2.0 * (coord.x - orgX), coord.y - 2.0 * (coord.y - orgY));
        if (p1 == null || p2 == null) {
            return;
        }
        double gdAxe = Math.sqrt(Math.pow(p2.x - p1.x, 2.0) + Math.pow(p2.y - p1.y, 2.0));
        p1 = v.getViewCoord(coord2.x, coord2.y);
        p2 = v.getViewCoord(coord2.x - 2.0 * (coord2.x - orgX), coord2.y - 2.0 * (coord2.y - orgY));
        if (p1 == null || p2 == null) {
            return;
        }
        double petitAxe = Math.sqrt(Math.pow(p2.x - p1.x, 2.0) + Math.pow(p2.y - p1.y, 2.0));
        Point centre = new Point((p1.x + p2.x) / 2, (p1.y + p2.y) / 2);
        double angle = Math.atan((orgY - y1) / (orgX - x1)) * 180.0 / Math.PI;
        this.doDrawRectangle(g, c, centre, 0.25 * gdAxe, 0.25 * petitAxe, angle, dx, dy);
    }

    private void drawEllipse(Source s, Graphics g, ViewSimple v, Point p, Color c, int numero, int index, int dx, int dy, boolean transparency) {
        double majAxis = s.values[numero][index][0];
        double minAxis = s.values[numero][index][1];
        double posAngle = s.values[numero][index][2];
        if (posAngle == -1.0) {
            posAngle = 0.0;
        }
        if (majAxis == -1.0) {
            return;
        }
        Plan base = v.pref;
        if (base == null) {
            base = s.plan;
        }
        Coord coord = new Coord();
        coord.al = s.raj;
        coord.del = s.dej;
        Coord coord2 = new Coord();
        coord2.al = s.raj;
        coord2.del = s.dej;
        Projection proj = v.getProj();
        coord2 = proj.getXY(coord2);
        double orgX = coord2.x;
        double orgY = coord2.y;
        coord.al += majAxis / 3600.0 * Math.sin(posAngle * 2.0 * Math.PI / 360.0) / Math.cos(coord.del * 2.0 * Math.PI / 360.0);
        coord.del += majAxis / 3600.0 * Math.cos(posAngle * 2.0 * Math.PI / 360.0);
        coord2.al += minAxis / 3600.0 * Math.cos(posAngle * 2.0 * Math.PI / 360.0) / Math.cos(coord2.del * 2.0 * Math.PI / 360.0);
        coord2.del += -(minAxis / 3600.0) * Math.sin(posAngle * 2.0 * Math.PI / 360.0);
        coord = proj.getXY(coord);
        coord2 = proj.getXY(coord2);
        Point p1 = v.getViewCoord(coord.x, coord.y);
        double x1 = coord.x;
        double y1 = coord.y;
        Point p2 = v.getViewCoord(coord.x - 2.0 * (coord.x - orgX), coord.y - 2.0 * (coord.y - orgY));
        if (p1 == null || p2 == null) {
            return;
        }
        double gdAxe = Math.sqrt(Math.pow(p2.x - p1.x, 2.0) + Math.pow(p2.y - p1.y, 2.0));
        p1 = v.getViewCoord(coord2.x, coord2.y);
        p2 = v.getViewCoord(coord2.x - 2.0 * (coord2.x - orgX), coord2.y - 2.0 * (coord2.y - orgY));
        if (p1 == null || p2 == null) {
            return;
        }
        double petitAxe = Math.sqrt(Math.pow(p2.x - p1.x, 2.0) + Math.pow(p2.y - p1.y, 2.0));
        if (proj.t == 4 || proj.t == 11) {
            Coord coordBis = new Coord(s.raj, s.dej);
            coordBis.al -= majAxis / 3600.0 * Math.sin(posAngle * 2.0 * Math.PI / 360.0) / Math.cos(coordBis.del * 2.0 * Math.PI / 360.0);
            coordBis.del -= majAxis / 3600.0 * Math.cos(posAngle * 2.0 * Math.PI / 360.0);
            proj.getXY(coordBis);
            Point p1Bis = v.getViewCoord(coordBis.x, coordBis.y);
            Point p2Bis = v.getViewCoord(coordBis.x - 2.0 * (coordBis.x - orgX), coordBis.y - 2.0 * (coordBis.y - orgY));
            double gdAxeBis = Math.sqrt(Math.pow(p2Bis.x - p1Bis.x, 2.0) + Math.pow(p2Bis.y - p1Bis.y, 2.0));
            if (gdAxeBis < gdAxe) {
                gdAxe = gdAxeBis;
            }
            Coord coord2Bis = new Coord(s.raj, s.dej);
            coord2Bis.al -= minAxis / 3600.0 * Math.cos(posAngle * 2.0 * Math.PI / 360.0) / Math.cos(coord2Bis.del * 2.0 * Math.PI / 360.0);
            coord2Bis.del -= -(minAxis / 3600.0) * Math.sin(posAngle * 2.0 * Math.PI / 360.0);
            proj.getXY(coord2Bis);
            p1Bis = v.getViewCoord(coord2Bis.x, coord2Bis.y);
            p2Bis = v.getViewCoord(coord2Bis.x - 2.0 * (coord2Bis.x - orgX), coord2Bis.y - 2.0 * (coord2Bis.y - orgY));
            double petitAxeBis = Math.sqrt(Math.pow(p2Bis.x - p1Bis.x, 2.0) + Math.pow(p2Bis.y - p1Bis.y, 2.0));
            if (petitAxeBis < petitAxe) {
                petitAxe = petitAxeBis;
                p2 = p2Bis;
                p1 = p1Bis;
            }
        }
        Point centre = new Point((p1.x + p2.x) / 2, (p1.y + p2.y) / 2);
        double angle = Math.atan((orgY - y1) / (orgX - x1)) * 180.0 / Math.PI;
        this.doDrawEllipse(g, s, c, centre, 0.5 * gdAxe, 0.5 * petitAxe, angle, dx, dy, transparency);
    }

    private void doDrawRectangle(Graphics g, Color c, Point center, double width, double height, double angle, int dx, int dy) {
        int i;
        angle = angle * Math.PI / 180.0;
        Point[] p = new Point[4];
        for (i = 0; i < 4; ++i) {
            int signX = i == 0 || i == 3 ? -1 : 1;
            int signY = i > 1 ? -1 : 1;
            double tmpX = (double)signX * width;
            double tmpY = (double)signY * height;
            double x = tmpX * Math.cos(angle) - tmpY * Math.sin(angle) + (double)center.x;
            double y = tmpX * Math.sin(angle) + tmpY * Math.cos(angle) + (double)center.y;
            p[i] = new Point((int)(x += (double)dx), (int)(y += (double)dy));
        }
        g.setColor(c);
        for (i = 0; i < 3; ++i) {
            g.drawLine(p[i].x, p[i].y, p[i + 1].x, p[i + 1].y);
        }
        g.drawLine(p[3].x, p[3].y, p[0].x, p[0].y);
    }

    private void doDrawEllipse(Graphics g, Source s, Color c, Point center, double semiMA, double semiMI, double angle, int dx, int dy, boolean transparency) {
        g.setColor(c);
        if (g instanceof EPSGraphics || !(g instanceof Graphics2D)) {
            Util.drawEllipse(g, center.x + dx, center.y + dy, semiMA, semiMI, angle);
            return;
        }
        boolean drawInTransparency = transparency && Aladin.ENABLE_FOOTPRINT_OPACITY;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(c);
        AffineTransform saveTransform = g2d.getTransform();
        Composite saveComposite = null;
        if (drawInTransparency) {
            saveComposite = g2d.getComposite();
            float opacityLevel = Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL * s.plan.getOpacityLevel();
            Composite myComposite = Util.getImageComposite(opacityLevel);
            g2d.setComposite(myComposite);
        }
        angle = angle * Math.PI / 180.0;
        g2d.rotate(angle, center.x + dx, center.y + dy);
        if (drawInTransparency) {
            g2d.fill(new Ellipse2D.Double((double)(center.x + dx) - semiMA, (double)(center.y + dy) - semiMI, semiMA * 2.0, semiMI * 2.0));
        } else {
            g2d.draw(new Ellipse2D.Double((double)(center.x + dx) - semiMA, (double)(center.y + dy) - semiMI, semiMA * 2.0, semiMI * 2.0));
        }
        g2d.setTransform(saveTransform);
        if (drawInTransparency) {
            g2d.setComposite(saveComposite);
        }
    }

    protected static int countNbOcc(char c, String s) {
        int nb = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++nb;
        }
        return nb;
    }

    private void computeSize(Source s, int numero, int index) {
    }

    private void finalComputeSize(Source s, int numero, int index) {
        if (!Action.setAllVariables(this.sizeParser, s, false)) {
            return;
        }
        double value = this.sizeParser.eval();
        if (this.sizeParser.isConstant()) {
            s.values[numero][index][0] = value;
            return;
        }
        if (value > this.maxValue) {
            value = this.maxValue;
        } else if (value < this.minValue) {
            value = this.minValue;
        }
        s.values[numero][index][0] = (double)this.minRadius + (value - this.minValue) * (double)(this.maxRadius - this.minRadius) / (this.maxValue - this.minValue);
    }

    protected void computeExtremum(Source[] sources) {
        if (this.shape.equals(SIZE) || this.shape.equals(FILLSIZE) || this.shape.equals(FIXEDCIRCLE)) {
            this.computeMinMax(sources);
        }
    }

    protected void computeValues(Source s, int numero, int index) {
        s.values[numero][index][3] = -1.0;
        s.values[numero][index][2] = -1.0;
        s.values[numero][index][1] = -1.0;
        s.values[numero][index][0] = -1.0;
        if (this.shape.equals(SIZE) || this.shape.equals(FILLSIZE) || this.shape.equals(FIXEDCIRCLE)) {
            this.computeSize(s, numero, index);
        } else if (this.shape.equals(ELLIPSE) || this.shape.equals(FILLELLIPSE)) {
            this.computeEllipse(s, numero, index);
        } else if (this.shape.equals(RECTANGLE)) {
            this.computeRectangle(s, numero, index);
        } else if (this.shape.equals(PM)) {
            this.computePM(s, numero, index);
        } else if (this.shape.equals(LINE)) {
            this.computeLine(s, numero, index);
        }
    }

    protected void finalcomputeValues(Source s, int numero, int index) {
        if (this.shape.equals(SIZE) || this.shape.equals(FILLSIZE) || this.shape.equals(FIXEDCIRCLE)) {
            this.finalComputeSize(s, numero, index);
        }
    }

    protected void reset() {
        if (!this.userDefinedMinMax) {
            this.mustComputeMinMax = true;
        }
        this.mustComputeRGBMinMax = true;
        if (!this.userDefinedRainbowMinMax) {
            this.mustComputeRainbowMinMax = true;
        }
        if (!this.userDefinedSaturationMinMax) {
            this.mustComputeSaturationMinMax = true;
        }
    }

    private int getClosingParenthesis(String s, int begin) {
        int oBegin = begin;
        int result;
        while ((result = s.indexOf(")", begin)) != -1) {
            String subStr = s.substring(oBegin, result + 1);
            if (Action.countNbOcc('(', subStr) + 1 == Action.countNbOcc(')', subStr)) {
                return result;
            }
            begin = result + 1;
        }
        return -1;
    }

    protected static boolean setAllVariables(Parser parser, Source s, boolean cont, boolean setUnit) {
        Iterator iterVar = parser.getVariables();
        while (iterVar.hasNext()) {
            int pos;
            String curVar = (String)iterVar.next();
            if (curVar.startsWith("[")) {
                pos = s.findUCD(curVar.substring(1, curVar.length() - 1).toUpperCase());
                if (pos < 0) {
                    if (cont) continue;
                    return false;
                }
            } else {
                pos = s.findColumn(curVar.substring(1, curVar.length() - 1));
                if (pos < 0) {
                    if (cont) continue;
                    return false;
                }
            }
            try {
                parser.setVar(curVar, Double.valueOf(s.getValue(pos)));
            }
            catch (NumberFormatException exc) {
                if (cont) continue;
                return false;
            }
            catch (NullPointerException npExc) {
                if (cont) continue;
                return false;
            }
            if (!setUnit || parser.setVarUnit(curVar, s.getUnit(pos))) continue;
            return false;
        }
        return true;
    }

    protected static boolean setAllVariables(Parser parser, Source s, boolean cont) {
        return Action.setAllVariables(parser, s, cont, false);
    }
}

