		
extern "C" {
#define PIXCM 1 
#include "platform.h" //Contains the Declarations & Enumerators for the different platforms.(i.e. SUN,Mac,Win98,Win NT)
#include "pigendef.h" //Contains the Declarations & Enumerators for the simple dll
#include "pigenfcn.h" //Contains the Declarations for the simple dll
#include "piimgdef.h" //ROI definition
#include "piimgfcn.h" //ROI functions
#include "pishtdef.h" //PI controller DLLs external defintion and define file shutter operations
#include "pishtfcn.h" //PI controller DLLs external defintion shutter operations.
#include "pivardef.h" //Contains the Declarations for PI variables functions
#include "pivarfcn.h" //Contains the Declarations for variable functions
#include "pividdef.h" //PI controller Video routines (RS170)
#include "pimltfcn.h" //Multiple frame collection
#include "pitimdef.h" //Timing mode definition
#include "pitimfcn.h" //Timing mode function
#include "pifcsfcn.h" //Contains the Declarations for the simple dll skipping operations
#include "pifcsdef.h" //Contains the Declarations & Enumerators for the simple dll
}
/*******************************************/
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <ctype.h>
#include <stdlib.h>
#include <winsock.h>
#include "stdlib.h"
#include "time.h"
#include "fstream.h" 
#include "conio.h"
#include "direct.h"
#include "dos.h"
#include "math.h"
#include "io.h"
#include "share.h"
#include <Windows.h>
#include <Wininet.h>
#include <memory.h>

#define PORT                        10000           //PORT ADDRESS
#define FITS_HEADER_SIZE            16384           //FITS HEADER SIZE
#define ACKNOWLEDGE_SIZE            100

#define END_MSG_CHAR                '\n'
#define END_MSG_STRING              "\n"

#define ACQUISITION_CMD             "ACQ"     
#define END_ACQUISITION_CMD         "END_ACQ" 

#define ACKNOLEDGE_RECEPTION        "DATA RECEIVED" 
#define ACKNOLEDGE_EXECUTION_OK     "OK"      
#define ACKNOLEDGE_EXECUTION_ERR    "ERROR"   

#define FILENAME_KEYW               "FILENAME"
#define TIME_EXPO_KEYW              "EXPTIME"
#define OBS_MODE                    "OBS_MODE"
#define CAMERA_NUMBER               "NOCAM"

#define SUCCESS                     1
#define FAILURE                     0

#define TRUE                        1
#define FALSE                       0

#define MASTER_CAMERA_NUMBER        2
#define SLAVE_CAMERA_NUMBER         1

#define ACQUISITION_PATH            "c:\\Dpsm\\"

#define HOST                        "pc1"

#define MASTER                      TRUE
#define DEBUG_MODE                  TRUE

char    fitsFileName[256]   = "";
char    acquisitionMode[80] = "";
float   exposureTime        = 0;
int     cameraNumber        = MASTER_CAMERA_NUMBER;
int     fitsHeaderLoaded    = FALSE;
int     fitsFileReady       = FALSE;
FILE    *fitsFileDescriptor;
char    *mainFitsHeader     = NULL;
//*********************************************/


#define NPIX            262144			    //512X512
#define DIMX            512			        //Pixel image dimension
#define DIMY            512			        //Pixel image dimension

long shbuffer_size;		  //Imaage buffer dimension
int shcontroller_ok;	  //Status code for the PI initialization routine
int DONE_FLAG;            //Flag for data collection
int TEXP=0;               //exposure time (ms)
int TESTWR;				  //fflush flag
int S;					  //Delay counter 
unsigned short port = 3002; //Socket port number
unsigned int STATUS;      //Used for status of PICM_ChkData
unsigned int ERROR_CODE;  //If status is false, this holds error
short IMM0[NPIX];         //Image buffer
short huge *LPVBUFFER=0;  //Image pointer to the memory 
short MIN_IMA,MAX_IMA;    //Image minimum & maximum
double TEXPSEC=5;		  //exposure time (s)
double AVG,RMS;           //Image average & rms
char ERRORSTRING[60]={0}; //Error string
char RECORD[120]={0};     //"acq.log" record (path,data,texp,avg....) 
char PIERROR[6]={0};      //PI functions error code
char c;                   //For DEBUG and GETCH

static HANDLE shglb;	  //

void ccderror(void);
int saveimm(FILE *ofsout);



//*********************************************************************
//*********************************************************************
//          PentaMax CCD Initialization Procedure
//*********************************************************************
//*********************************************************************	

int initccd(void)  
{	
    int controller_ok;		//ritorno delle funzioni Princeton
    long buffer_size;		//dimensioni del buffer dell'immagine
    static HANDLE hglb;		//

    //Create and Initialize controller object
    controller_ok=PICM_CreateController(DC131,KDK_1035x1317,
                                        ROM_FULL,APP_NORMAL_IMAGING,
                                        &ERROR_CODE);
    if (controller_ok!=1)
    {
        strcpy(ERRORSTRING,"ERROR:\t\tCCD ERROR @@@ Create contoller error ");
        ccderror();
        return FAILURE;
    }

    //Set type of PC PI-interface card used. This will also set the ADC defaults     
    controller_ok=PICM_SetInterfaceCard(PCI_COMPLEX_PC_Interface,
                                        0x0d00,CHANNEL_10,&ERROR_CODE);
    if (controller_ok!=1)
    {
        strcpy(ERRORSTRING,"ERROR:\t\tCCD ERROR @@@ Set interface card error ");
        ccderror();
        return FAILURE;
    }

    //This function will set the fast ADC avaiable in controller.
    PICM_Set_Fast_ADC();

    //Set ROI for image, If this function is not called full image is default. 
    //this allows a sub-region and/or a grouped/binned image to be collected.  
    controller_ok=PICM_SetROI(146,5,1169,1028,2,2,&ERROR_CODE);
    if (controller_ok!=1)
    {
        strcpy(ERRORSTRING,"ERROR:\t\tCCD ERROR @@@ Set ROI error ");
        ccderror();
        return FAILURE;
    }

    //This function returns the amount of memory the user should allocate to 
    //hold all of his data.
    buffer_size=PICM_SizeNeedToAllocate();
    hglb=GlobalAlloc(GPTR, buffer_size);
    LPVBUFFER=(short huge*) GlobalLock(hglb);

    //Configura lo shutter in modalita' non "manuale"
    PICM_Set_shuttermode(SHUTTER_NORMAL); 
    //Configura la versione del controller
    PICM_Set_controller_version(5);            
    PICM_Set_RS170_enable(TRUE);           //Abilita la modalita' RS170
    //Abilita' la visualizzazione sul monitor
    PICM_CMSetLongParam(CMP_VIDEO_TYPE, 2);

    //This function downloads all information to controller It sets up the    
    //dma buffers, ring buffer, and the users buffer. It also hooks in the     
    //interrupt routine used by data collection.
    controller_ok=PICM_Initialize_System(LPVBUFFER,&ERROR_CODE);
    if (controller_ok!=1)
    {
        strcpy(ERRORSTRING,"ERROR:\tCCD ERROR @@@ Initialize System error ");
        ccderror();
        return FAILURE;
    }

    PICM_Set_shuttermode(SHUTTER_NORMAL);  
    return SUCCESS;
}

//*********************************************************************
//*********************************************************************
//          Fast PentaMax CCD initialization procedure
//*********************************************************************
//*********************************************************************	
int short_initccd(void)  //Inizializza la CCD
{	
    int controller_ok; //ritorno delle funzioni Princeton

    //This function downloads all information to controller It sets up the    
    //dma buffers, ring buffer, and the users buffer. It Also hooks in the     
    //interrupt routine used by data collection.
    controller_ok=PICM_Initialize_System(LPVBUFFER,&ERROR_CODE);

    if (controller_ok!=1)
    {
        strcpy(ERRORSTRING,"ERROR:\t\tCCD ERROR @@@ Initialize System error ");
        ccderror();
        return FAILURE;
    }
	return SUCCESS;
}

//*********************************************************************
//*********************************************************************
//       Image disk storing procedure
//*********************************************************************
//*********************************************************************

int saveimm() 
{    
    int     jndx;               //indice di riga                       
    int     jndy;               //indice di colonna
    short   huge *immbuffer;    //Puntatore dell'immagine
    char    huge *address;      //Punta al primo elemento dell'immagine

    immbuffer=LPVBUFFER;

    address=(char huge*)LPVBUFFER; 

    for(jndx=0;jndx<DIMX;jndx++)
    {
        if (fwrite(address,2,DIMX,fitsFileDescriptor) != DIMX)
        {
            printf("ERROR:\t\tA PROBLEM HAS OCCURED WRITING DATA\n");
            PICM_ResetUserBuffer();
            return FAILURE;
        }
        address = address + DIMY * 2;
        for(jndy=0;jndy<DIMY;jndy++)
        {
            IMM0[jndx*DIMY+jndy]=*immbuffer;
            immbuffer++;
        }
    }

    TESTWR=1;
    while (TESTWR!=0)
    {
        TESTWR=fflush(fitsFileDescriptor);  //Forza la scrittura dell'immagine sul disco  	   
    }

    PICM_ResetUserBuffer(); //This function resets software counters and address
    return SUCCESS;
}
//*********************************************************************
//*********************************************************************
//       FOTO Procedure - NORMAL image acquisition
//       maximum frame rate in this mode is ~ 2 frames/s
//*********************************************************************
//*********************************************************************
int foto(void)
{  
    PICM_SetExposure(TEXPSEC,&ERROR_CODE);//Set the camera exposure in seconds	
    PICM_Start_controller();//Startup Controller to acquire data
    DONE_FLAG=false;
    while(!DONE_FLAG)
        DONE_FLAG=PICM_ChkData(&STATUS);//Checks if data has been collected

    if (saveimm() == FAILURE)  // image storing
    {
        return FAILURE;
    }
    else
    {
        PICM_Stop_controller();  //Stops Controller from collecting data
        return SUCCESS;
    }
}
//*********************************************************************
//*********************************************************************
//       BUIO Procedure - DARK image acquIsition procedure
//*********************************************************************
//*********************************************************************

int buio(void) //Aquisisce immagini di buio
{
    PICM_Set_shuttermode(SHUTTER_CLOSE);//Physically open or close shutter:
    PICM_SetExposure(TEXPSEC,&ERROR_CODE); //Set the camera exposure in seconds
    if (short_initccd() == FAILURE) 
    {
        return FAILURE;
    }

    PICM_Start_controller();//Startup Controller to acquire data
    DONE_FLAG=false;
    while(!DONE_FLAG)
        DONE_FLAG=PICM_ChkData(&STATUS);//Checks if data has been collected

    if (saveimm() == FAILURE)  // image storing
    {
        return FAILURE;
    }
    else
    {
        PICM_Stop_controller();//Stops Controller from collecting data
        PICM_Set_shuttermode(SHUTTER_NORMAL);//Physically open or close shutter
        if (short_initccd() == FAILURE) 
        {
            return FAILURE;
        }
        else
        {
            return SUCCESS;
        }
    }
}


int cameraAcqCmd(void)  
{
    int answer;
    //alloca spazio in memoria per l'immagine//
    shbuffer_size=PICM_SizeNeedToAllocate();
    shglb=GlobalAlloc(GPTR, shbuffer_size);
    LPVBUFFER=(short huge*) GlobalLock(shglb);
    shcontroller_ok=PICM_Initialize_System(LPVBUFFER,&ERROR_CODE);
    if (shcontroller_ok!=1)
    {
        strcpy(ERRORSTRING,"@@@ CCD ERROR @@@ Initialize System    error ");
        ccderror();
        return FAILURE;
    }

    answer =  foto();

    // dealloca spazio in memoria per l'immagine
    GlobalUnlock(shglb);
    GlobalFree(shglb);
    return answer;
}	

int cameraDarkCmd(void)  
{
    int answer;
    //alloca spazio in memoria per l'immagine//
    shbuffer_size=PICM_SizeNeedToAllocate();
    shglb=GlobalAlloc(GPTR, shbuffer_size);
    LPVBUFFER=(short huge*) GlobalLock(shglb);
    shcontroller_ok=PICM_Initialize_System(LPVBUFFER,&ERROR_CODE);
    if (shcontroller_ok!=1)
    {
        strcpy(ERRORSTRING,"ERROR:\t\tCCD ERROR @@@ Initialize System error ");
        ccderror();
        return FAILURE;
    }

    answer =  buio();

    // dealloca spazio in memoria per l'immagine
    GlobalUnlock(shglb);
    GlobalFree(shglb);
    return answer;
}	

//*********************************************************************
//*********************************************************************
//          ERROR output procedure
//*********************************************************************
//*********************************************************************	

void ccderror(void)  
{
    sprintf(PIERROR,"%d",ERROR_CODE); 
    strcat(ERRORSTRING,PIERROR);
    strcat(ERRORSTRING,"\n");
    printf("ERROR:\t\t %s",ERRORSTRING);
    strcpy(ERRORSTRING,"");
    strcpy(PIERROR,"");
}

/*
int main(void)
{
   ofsout=fopen("c:\\toto.dat","wb");//Open file to save image

   if (ofsout==0)  //Se non riesce ad aprire il file va in errore
   {
      strcpy(ERRORSTRING,"@@@ ERROR @@@ Can't open file to save image @@@"); 
	  return (FAILURE);
   }

   printf("INIT CCD\n");

   if (initccd() == FAILURE)
   {
		return(FAILURE);
   }

   printf("FOTO\n");

   if (foto() == FAILURE)
   {
		return(FAILURE);
   }

   printf("END ACQ\n");

   if (end_acq() == FAILURE)
   {
		return(FAILURE);
   }

   return(SUCCESS);
}
*/


//This function look for <keyword> in <fitsHeader> and return its
//value in <value>
//WARNING: <value> must be big enough to store the result.
int fitsFindInHeader(char *fitsHeader, char *keyWord, char *value)
{
    char *position;
    int  i;
    int  j;
    
    //Look for the keyword
    //If is not present 
    if ((position = strstr(fitsHeader,keyWord)) == NULL)
    {
        //Retrun an error
        printf("ERROR:\t\tKEYWORD NOT FOUND IN THE HEADER\n");
        return FAILURE;
    }
    
    //Find the equal sign
    //If is not present
    if ((char)position[8] != '=')
    {
        //Retrun an error
        printf("ERROR:\t\tINVALID fITS STRUCTURE\n");
        return FAILURE;
    }

    //Skip all the spaces
    i = 1;
    while (((char)position[8+i] == ' ') && (i <= 70))
    {
        i++;
    }

    //If There is only spaces
    if ( i == 70)
    {
        //return an error
        printf("ERROR:\t\tKEYWORD NOT FILLED IN THE HEADER\n");
        return FAILURE;
    }
    
    //If the keyword value is a string
    if((char)position[8+i] == '\'')
    {
        if (DEBUG_MODE == TRUE)
        printf("INFORMATION:\tKeyword '%s' is a string: '", keyWord);
        //Retrieve string chars
        j = 1;
        while((8+i+j <= 79) && (position[8+i+j] != '\''))
        {
            *value = position[8+i+j];
            if (DEBUG_MODE == TRUE)
            printf("%c",position[8+i+j]);
            j++;
            value++;
            
        }
        if (DEBUG_MODE == TRUE)
        printf("'\n");
        //if the last char is a single quote
        if(position[8+i+j] == '\'')
        {
            //return SUCCESS
            return SUCCESS;
        }
        //else
        else
        {
            //Return an error
            printf("ERROR:\t\tINVALID KEYWORD VALUE\n");
            return FAILURE;
        }
    }
    //If the keyword is a number
    else
    {
        if (DEBUG_MODE == TRUE)
        printf("INFORMATION:\tKeyword '%s' is a number : '", keyWord);
        //Retrieve number digits
        j = 0;
        while((8+i+j <= 79) && (isdigit((int)position[8+i+j]) != 0))
        {
            *value = position[8+i+j];
            if (DEBUG_MODE == TRUE)
            printf("%c",position[8+i+j]);
            j++;
            value++;
        }

        //Verify if there is something behind the coma
        if (position[8+i+j] == '.')
        {
            *value = position[8+i+j];
            value++;
            if (DEBUG_MODE == TRUE)
            printf("%c",position[8+i+j]);
            j++;

            //Copy all the data behind the coma
            while((8+i+j <= 79) && (isdigit((int)position[8+i+j]) != 0))
            {
                *value = position[8+i+j];
                if (DEBUG_MODE == TRUE)
                printf("%c",position[8+i+j]);
                j++;
                value++;
            }
        } 
        if (DEBUG_MODE == TRUE)
        printf("'\n");
        return SUCCESS;
    }
}

//This function send a <buffer> to the DPSM PC client
int sendToSlave(char *buffer)
{
    char    ack[ACKNOWLEDGE_SIZE];    //FITS HEADER
    int     sd;                       //SOCKET DESCRIPTOR
    struct  sockaddr_in pin;          //BORDEL POUR SOCKET
    struct  hostent     *hp;
    int     received;
    int     i, k;
    int     position = 0;
    int     foundEndMsg = FALSE;

    if ((hp = gethostbyname(HOST)) == NULL)
    {
        perror("FATAL ERROR:\t\t");
        return(FAILURE);
    }

    //FILL the socket structure with host information
    memset(&pin, 0,sizeof(pin));
    pin.sin_family = AF_INET;
	memcpy(&pin.sin_addr, hp->h_addr, hp->h_length);
    pin.sin_port = htons(PORT);

    //Get an internet socket 
    if ((sd = socket(AF_INET, SOCK_STREAM, 0)) == INVALID_SOCKET)
    {
        perror("FATAL ERROR:\t\t");
        close(sd);
        exit(FAILURE);
    }

    //Connect to PORT on HOST
    if (connect(sd, (const struct sockaddr FAR *) &pin,sizeof(pin)) != 0)
    {
        perror("FATAL ERROR:\t\t");
        close(sd);
        exit(FAILURE);
    }
    if (DEBUG_MODE == TRUE)
    printf("INFORMATION:\tConnection with slave established\n");

    //Send a message
    if (send(sd, buffer, strlen(buffer), 0) == -1)
    {
        perror("FATAL ERROR:\t\t");
        close(sd);
        exit(FAILURE);
    }

    //Send message End
    if (send(sd, END_MSG_STRING, 1, 0) == -1)
    {
        perror("FATAL ERROR:\t\t");
        close(sd);
        exit(FAILURE);
    }

    if (DEBUG_MODE == TRUE)
    {
        printf("INFORMATION:\tMessage to slave sent(%d char)\n",
               strlen(buffer));
    }

    
    //Check if the transmission is ended
    while (foundEndMsg == FALSE)
    {
        //Initialize reception buffer
        memset(&ack[0],0,ACKNOWLEDGE_SIZE);

        //Get the data reception acknowledge from the client
        if((received = recv(sd, ack, ACKNOWLEDGE_SIZE, MSG_PEEK)) == -1)
        {
            perror("FATAL ERROR:\t\t");
            close(sd);
            exit(FAILURE);
        }
        i=0;
        while((i < received) && (foundEndMsg == FALSE))
        {   
            if (ack[i] == END_MSG_CHAR)
            {
                position = i;
                foundEndMsg = TRUE;
            }
            i++;
        }
    }
    
    //Initialize reception buffer
    memset(ack,0,ACKNOWLEDGE_SIZE);

    //Get the data reception acknowledge from the client
    if((recv(sd, ack, position+1, 0)) == -1)
    {
        perror("FATAL ERROR:\t\t");
        close(sd);
        exit(FAILURE);
    }
    ack[position] = '\0';
    

    if (DEBUG_MODE == TRUE)
    printf("INFORMATION:\tReception of the slave acknowledge : '%s' \n", ack);
    
    //Check the acknowledge message
    if(strcmp(ack, ACKNOLEDGE_RECEPTION) != 0)
    {
        printf("ERROR:\t\tTHE PC CLIENT REPLY A STRANGE MESSAGE: '%s' %d %d\n",
               ack, position, received);
        for (k = 0;k < position+1;k++) printf("%x ",ack[k]);
        printf("\n");
        close(sd);
        return FAILURE;
    }
    
    foundEndMsg = FALSE;
    //Check if the transmission is ended
    while (foundEndMsg == FALSE)
    {
        //Initialize reception buffer
        memset(ack,0,ACKNOWLEDGE_SIZE);

        //Get the data reception acknowledge from the client
        if((received = recv(sd, ack, ACKNOWLEDGE_SIZE, MSG_PEEK)) == -1)
        {
            perror("FATAL ERROR:\t\t");
            close(sd);
            exit(FAILURE);
        }

        i=0;
        while((i < received) && (foundEndMsg == FALSE))
        {   
            if (ack[i] == END_MSG_CHAR)
            {
                position = i;
                foundEndMsg = TRUE;
            }
            i++;
        }
    }
    //Initialize reception buffer
    memset(ack,0,ACKNOWLEDGE_SIZE);

    //Get the data completion acknowledge from the client
    if((recv(sd, ack, position+1, 0)) == -1)
    {
        perror("FATAL ERROR:\t\t");
        close(sd);
        exit(FAILURE);
    }
    ack[position] = '\0';

    if (DEBUG_MODE == TRUE)
    printf("INFORMATION:\tClient result acknowledge : '%s' \n", ack);

    //Check the acknowledge message
    if (strcmp(ack,ACKNOLEDGE_EXECUTION_ERR) == 0)
    {
        printf("ERROR:\t\tTHE DPSM PC CLIENT HAS RETURNED AN ERROR '%s'\n",
               ack);
        close(sd);
        return(FAILURE);
    }

    if (strcmp(ack, ACKNOLEDGE_EXECUTION_OK) == 0)
    {
        close(sd);
        return(SUCCESS);
    }
    else
    {
        printf("ERROR:\t\tTHE DPSM PC CLIENT REPLY A NOT UNDERSTANDABLE MESSAGE: '%s'\n", ack);
        close(sd);
        return(FAILURE);
    }
}

//This function open a file using the fits header parameters
int initAcquisition()
{
    char path[1024] = "";
    unsigned int nbOfItem = 0;

    //if we are on the right PC
    if (((MASTER == TRUE) && (cameraNumber == MASTER_CAMERA_NUMBER))
        || 
        ((MASTER == FALSE) && (cameraNumber == SLAVE_CAMERA_NUMBER)))
    {

        //Create full file name
        strcpy(path, ACQUISITION_PATH);
        strcat(path,fitsFileName);
        if (DEBUG_MODE == TRUE)
            printf("INFORMATION:\tCreating the fits file: '%s'\n", path);

        //Open the file
        fitsFileDescriptor = fopen(path, "w");
        if (fitsFileDescriptor == NULL)
        {
            printf("ERROR: IMPOSSIBLE TO OPEN THE FILE: %s\n", path);
            return FAILURE;
        }

        //Write the header
        if (DEBUG_MODE == TRUE)
            printf("INFORMATION:\tWriting the FITS header\n");
        nbOfItem = fwrite(mainFitsHeader, sizeof(char), strlen(mainFitsHeader),
                          fitsFileDescriptor);
        //Check if everything has benn writed
        if (nbOfItem != strlen(mainFitsHeader))
        {
            printf("ERROR: IMPOSSIBLE TO WRITE THE FILE");
            return FAILURE;
        } 

        //Set status variable
        fitsHeaderLoaded = TRUE;
        fitsFileReady    = TRUE;
        if (DEBUG_MODE == TRUE)
            printf("INFORMATION:\tFile successfully created\n");
        return SUCCESS;
    }
    //else (if we are in the wrong PC)
    else
    {
        //Send fits header to the other PC 
        if (sendToSlave(mainFitsHeader) == SUCCESS)
        {
            //Set status variable
            fitsHeaderLoaded = TRUE;
            fitsFileReady    = TRUE;
            return SUCCESS;
        }
        else
        {
            return FAILURE;
        }
    }
}

//This funtion perform an acquisition and put the result in the fits file
int doAcquisition()
{
    if (fitsFileReady == FALSE)
    {
        printf("ERROR:\t\tTHE fITS HEADER IS NOT LOADED\n");
        return FAILURE;
    }
    if (DEBUG_MODE == TRUE)
    printf("INFORMATION:\tDoing an acquisition.....\n");
    
    return cameraAcqCmd();
}

//This function close an acquisition
int doEndAcquisition()
{
	int test=1;
   
    if (fitsFileReady == FALSE)
    {
        printf("ERROR:\t\tTHE fITS HEADER IS NOT LOADED\n");
        return FAILURE;
    }
    if (DEBUG_MODE == TRUE)
    printf("INFORMATION:\tClose the fits file\n");
    
	//Flush disk buffers
    while (test !=0)
    {
        test=fflush(fitsFileDescriptor);    	   
    }

    //Close file
    if (fclose(fitsFileDescriptor) != 0)
    {
        //Update status variable
        printf("ERROR:\t\tIMPOSSIBLE TO CLOSE THE FITS FILE\n");
        fitsHeaderLoaded = FALSE;
        fitsFileReady    = FALSE;
        return FAILURE;
    }
    else
    {
        if (DEBUG_MODE == TRUE)
        printf("INFORMATION:\tThe fits file has been closed\n");
        fitsHeaderLoaded = FALSE;
        fitsFileReady    = FALSE;
        return SUCCESS;
    }
}

//This function call the acquisition function or send the acquisition command to
//the other PC
int startAcquisition()
{
    if (((MASTER == TRUE) && (cameraNumber == MASTER_CAMERA_NUMBER))
        || 
        ((MASTER == FALSE) && (cameraNumber == SLAVE_CAMERA_NUMBER)))
    {
        return doAcquisition();
    }
    else
    {
        return sendToSlave(ACQUISITION_CMD);
    }
}

//This function call the end acquisition function or send the acquisition 
//command to the other PC
int endAcquisition()
{
    if (((MASTER == TRUE) && (cameraNumber == MASTER_CAMERA_NUMBER))
        || 
        ((MASTER == FALSE) && (cameraNumber == SLAVE_CAMERA_NUMBER)))
    {
        return doEndAcquisition();
    }
    else
    {
        return sendToSlave(END_ACQUISITION_CMD);
    }
}

//This function parse a command message
int commandExecution(char *command)
{
    int error;
    
    if (strcmp(command, ACQUISITION_CMD) == 0)
    {
        if (DEBUG_MODE == TRUE)
        printf("INFORMATION:\tStart an acquisition\n");
        return startAcquisition();
    }
    else
    {
        if (strcmp(command, END_ACQUISITION_CMD) == 0)
        {
            if (DEBUG_MODE == TRUE)
            printf("INFORMATION:\tEnd an acquisition\n");
            error = endAcquisition();
            fitsHeaderLoaded = FALSE;
            fitsFileReady    = FALSE;
            return error;

        }
        else
        {
            printf("ERROR:\t\tDATA ARE NEITHER FITS HEADER NOR COMMAND\n");
            return FAILURE;
        }
    }
}

//This function process a received message in order to determine if it is a fits
//header or a command
int processData(char *fitsHeader)
{
    char    tmp[80] = "";
    char    cameraNumberString[80] = "";
    
    //Check The fits header size
    if (strlen(fitsHeader) < 2880)
    {
        return commandExecution(fitsHeader);
    }

    
    //************ ICI ajouter un TAILLE / 2880 == ENTIER **********


    if (fitsHeaderLoaded == TRUE)
    {
        if (DEBUG_MODE == TRUE)
        printf("WARNING:\tA SECOND FITS HEADER HAS BEEN RECEIVED \n");
        if (endAcquisition() == FAILURE)
        {
            fitsHeaderLoaded = FALSE;
            fitsFileReady    = FALSE;
            return FAILURE;
        }
        else
        {
            fitsHeaderLoaded = FALSE;
            fitsFileReady    = FALSE;
        }
    }

    if (DEBUG_MODE == TRUE) 
    {
        printf("********************************************************\n");
        printf("******************** NEW OBSERVATION *******************\n");
        printf("********************************************************\n");
    }
    //Check FILENAME_KEYW
    if (fitsFindInHeader(fitsHeader, FILENAME_KEYW,
                         &fitsFileName[0]) == FAILURE)
    {
        return FAILURE;
    }

    if (strcmp(fitsFileName,"") == 0)
    {
        printf("ERROR:\t\tKEYWORD '%s' NOT DEFINED IN THE FITS HEADER\n",
               FILENAME_KEYW);
        return FAILURE;
    }

    //Check TIME_EXPO_KEYW
    if (fitsFindInHeader(fitsHeader, TIME_EXPO_KEYW, &tmp[0]) == FAILURE)
    {
        return FAILURE;
    }

    if (strcmp(tmp,"") == 0)
    {
        printf("ERROR:\t\tKEYWORD '%s' NOT DEFINED IN THE FITS HEADER\n",
               TIME_EXPO_KEYW);
        return FAILURE;
    }
    else
    {
        //Check the exposure time value
        if (sscanf(tmp, "%f", &exposureTime) != 1)
        {
            printf("ERROR:\t\tEXPOSURE TIME VALUE IS INCORRECT\n");
            return FAILURE;
        }
        else
        {
            if ((exposureTime*1000>20000)||(exposureTime*1000<20))
            {
                printf("ERROR:\t\tEXPOSITION TIME OUT OF RANGE\n"); 
                return FAILURE;
            }
			else
			{
				TEXPSEC = exposureTime;
			}
        }
    }

    //check OBS_MODE 
    if (fitsFindInHeader(fitsHeader, OBS_MODE, &acquisitionMode[0]) == FAILURE)
    {
        return FAILURE;
    }

    if (strcmp(acquisitionMode,"") == 0)
    {
        printf("ERROR:\t\tKEYWORD '%s' NOT DEFINED IN THE FITS HEADER\n",
               OBS_MODE);
        return FAILURE;
    }

    //Check Camera Number
    if (fitsFindInHeader(fitsHeader, CAMERA_NUMBER,
                         &cameraNumberString[0]) == FAILURE)
    {
        return FAILURE;
    }

    if (strcmp(cameraNumberString,"") == 0)
    {
        printf("ERROR:\t\tKEYWORD '%s' NOT DEFINED IN THE FITS HEADER\n",
               CAMERA_NUMBER);
        return FAILURE;
    }
    else
    {
        if(sscanf(cameraNumberString,"%d",&cameraNumber) != 1)
        {
            printf("ERROR:\t\tKEYWORD '%s' UNKNOWN VALUE\n",CAMERA_NUMBER);
            return FAILURE;
        }
        else
        {
            if ((cameraNumber != MASTER_CAMERA_NUMBER) &&
                (cameraNumber != SLAVE_CAMERA_NUMBER))
            {
                printf("ERROR:\t\tKEYWORD '%s' UNKNOWN VALUE\n", CAMERA_NUMBER);
                return FAILURE;
            }
        }
    }
   
    free(mainFitsHeader);
    mainFitsHeader = (char *)calloc(strlen(fitsHeader),sizeof(char));
    if (mainFitsHeader == NULL)
    {
        printf("FATAL ERROR:\tCALLOC ERROR\n");
        exit(FAILURE);
    }

    strcpy(mainFitsHeader,fitsHeader);

    if (initAcquisition() == FAILURE)
    {
        return FAILURE;
    }
    else
    {
        return SUCCESS;
    }
}

int main()
{
    char    fitsHeader[FITS_HEADER_SIZE]; //FITS HEADER
    SOCKET  socketUCCI, sockWait;         //SOCKET DESCRIPTOR
    struct  sockaddr_in sin;              //BORDEL POUR SOCKET
    struct  sockaddr_in pin;
    int FAR addrLen;
    char    *ack;
    int     received = 0;
    int     i;
    int     foundEndMsg = FALSE;
    int     position = 0;

	WSADATA	data;
	WORD	version;

	//Init Camera
	if (initccd() == FAILURE)
	{
		printf("FATAL ERROR:\tIMPOSSIBLE TO INIT IPM CAMERA\n");
        exit(FAILURE);
    }

    //Allocate message memory
    ack = (char *)calloc(ACKNOWLEDGE_SIZE, sizeof(char));
    if (ack == NULL)
    {
        printf("FATAL ERROR:\tCALLOC ERROR\n");
        exit(FAILURE);
    }
         
	//Init Windaube socket
	version = MAKEWORD(2,2);
	if (WSAStartup(version, &data) != 0)
	{
		printf("FATAL ERROR:\tWINDOWS SOCKET INIT\n");
		exit(FAILURE);
	}

    //Get a internet socket
    if ((socketUCCI = socket(AF_INET, SOCK_STREAM, 0)) == INVALID_SOCKET)
    {
        perror("FATAL ERROR:\tSOCKET UCCI");
        exit(FAILURE);
    }

    //Complete the socket structure
    memset(&sin, 0, sizeof(sin));
    sin.sin_family = AF_INET;
    sin.sin_addr.s_addr = INADDR_ANY;
    sin.sin_port = htons(PORT);

    //bind the socket
    if (bind(socketUCCI,(const struct sockaddr *)&sin, sizeof(sin)) == SOCKET_ERROR)
    {
        perror("FATAL ERROR:\tBIND SOCKETUCCI: ");
        close(socketUCCI);
        exit(FAILURE);
    }
    
    //Listen the socket
    if (listen(socketUCCI, 1) == INVALID_SOCKET)
    {
        perror("FATAL ERROR:\tLISTEN SOCKETUCCI");
        close(socketUCCI);
        exit(FAILURE);
    }

    while(1)
    {
		memset(&pin, 0, sizeof(pin));
        //Wait for a client
		addrLen = sizeof(pin);
        if ((sockWait = accept(socketUCCI,(struct sockaddr FAR*) &pin,
							   &addrLen)) == INVALID_SOCKET)
        {
            perror("FATAL ERROR:\tACCEPTING CONNECTION: ");
			printf("%d\n", WSAGetLastError());
            close(socketUCCI);
            exit(FAILURE);
        }
        if (DEBUG_MODE == TRUE)
        printf("INFORMATION:\tConnection received\n");

       
        //Check if the transmission is ended
        if (DEBUG_MODE == TRUE)
        {
            printf("INFORMATION:\tWaiting for the end of the message\n");
        }

        foundEndMsg = FALSE;
        while (foundEndMsg == FALSE)
        {
            //Initialize reception buffer
            memset (fitsHeader,0,FITS_HEADER_SIZE); 

            //Get the data reception acknowledge from the client
            if((received = recv(sockWait, fitsHeader, FITS_HEADER_SIZE,
                                MSG_PEEK)) == -1)
            {
                perror("FATAL ERROR:\tRECEIVING DATA: ");
                close(socketUCCI);
                close(sockWait);
                exit(FAILURE);
            }
            i=0;
            while((i < received) && (foundEndMsg == FALSE))
            {   
                if (fitsHeader[i] == END_MSG_CHAR)
                {
                    position = i;
                    foundEndMsg = TRUE;
                }
                i++;
            }
        }
        if (DEBUG_MODE == TRUE)
            printf("INFORMATION:\tEnd of the message\n");

        //Read the message
        if((recv(sockWait, fitsHeader, position+1,0)) == -1)
        {
            perror("FATAL ERROR:\tRECEIVING DATA: ");
            close(socketUCCI);
            close(sockWait);
            exit(FAILURE);
        }
        fitsHeader[position] = '\0';
        
        if (DEBUG_MODE == TRUE)
        printf("INFORMATION:\tReception of %d char \n", received);

        //Initialize reception buffer
        memset (ack,0,ACKNOWLEDGE_SIZE); 
        
        //Return an aknowledge of reception
        strcpy(ack, ACKNOLEDGE_RECEPTION);
        if (send(sockWait, ack, strlen(ACKNOLEDGE_RECEPTION), 0) == -1)
        {
            perror("FATAL ERROR:\tSENDING DATA: ");
            close(socketUCCI);
            close(sockWait);
            exit(FAILURE);
        }
        if (send(sockWait, END_MSG_STRING, 1, 0) == -1)
        {
            perror("FATAL ERROR:\tSENDING DATA: ");
            close(socketUCCI);
            close(sockWait);
            exit(FAILURE);
        }

        if (DEBUG_MODE == TRUE)
        printf("INFORMATION:\tFirst ucci acknowledge sent: '%s' \n", ack);

        //Initialize reception buffer
        memset(ack,0,ACKNOWLEDGE_SIZE);
        
        //Process received data
        if (processData(fitsHeader) ==  FAILURE)
        {
            //Return an aknowledge of FAILURE
            strcpy(ack,ACKNOLEDGE_EXECUTION_ERR);
        }
        else
        {
            //Return an aknowledge of FAILURE
            strcpy(ack,ACKNOLEDGE_EXECUTION_OK);
        }

        //Send Acknowledge
        if (send(sockWait, ack, strlen(ack), 0) == -1)
        {
            perror("FATAL ERROR:\tSENDING DATA: ");
            close(socketUCCI);
            close(sockWait);
            exit(FAILURE);
        }
        if (send(sockWait, END_MSG_STRING, 1, 0) == -1)
        {
            perror("FATAL ERROR:\tSENDING DATA: ");
            close(socketUCCI);
            close(sockWait);
            exit(FAILURE);
        }

        if (DEBUG_MODE == TRUE)
            printf("INFORMATION:\tSecond ucci acknowledge sent: '%s' \n", ack);

        close(sockWait);
    }
    close(socketUCCI);
    return SUCCESS;
}
