/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Grassin-Minec-Debin
 * @version 1.0
 */

/**
 * La temprature n'est modifiable que sur le panneau technique 'cameras'
 * Jrme, 31-10-2000
 */

package iu;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;

public class WindowsConfigPanel extends JPanel {
  boolean redrawTable = false;
  int windowNumber = 0;
  public static final String[] COLUMN_NAMES = { "number", "camera", 
    "wavelength (\u00C5)", "temperature", "X1", "Y1", "X2", "Y2", 
    "visualisation", "record"/*, "num"*/}; // "num" pour debugage
  DrawPanel drawPanel;
  Border border1;
  Border border2;
  Border border3;
  BorderLayout borderLayout2 = new BorderLayout();
  JButton jButtonDel = new JButton();
  JButton jButtonIns = new JButton();
  JButton jButtonFirst = new JButton();
  JButton jButtonLast = new JButton();
  JButton jButtonNext = new JButton();
  JButton jButtonPrev = new JButton();
  JButton jButtonFull = new JButton();
  JButton jButtonGetImg = new JButton("get image");
  GridBagLayout gridBagLayout5 = new GridBagLayout();
  GridBagLayout gridBagLayout4 = new GridBagLayout();
  GridBagLayout gridBagLayout20 = new GridBagLayout();
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  JScrollPane jScrollPane1 = new JScrollPane();
  JTextField jTextFieldWinNb = new JTextField();
  JLabel jLabel10 = new JLabel();
  JPanel jPanel6 = new JPanel();
  JPanel jPanel4 = new JPanel();
  JPanel jPanel2 = new JPanel();
  JPanel jPanel1 = new JPanel();
  JPanel jPanel24 = new JPanel();
  JTextField jTextFieldX1 = new JTextField();
  JTextField jTextFieldY1 = new JTextField();
  JTextField jTextFieldX2 = new JTextField();
  JTextField jTextFieldY2 = new JTextField();
  JTextField jTextFieldTemp = new JTextField(3);
  JTextField jTextFieldTime = new JTextField("350");
  JLabel jLabelTime = new JLabel("Integration time (ms)");
  JLabel jLabel9 = new JLabel();
  JLabel jLabel8 = new JLabel();
  BorderLayout borderLayout1 = new BorderLayout();
  JLabel jLabel7 = new JLabel();
  JLabel jLabelWinNb = new JLabel("window number");

  JLabel jLabelCam = new JLabel("camera");
  JLabel jLabelTemp = new JLabel("CCD temperature (C)");
  JLabel jLabel2 = new JLabel();
  JLabel jLabel1 = new JLabel("window size / position selection");
  JLabel jLabelWL = new JLabel("wavelength (\u00C5)");
  JTextField jTextFieldWL = new JTextField();
  JComboBox jComboBoxWaveLength = null;
  Border border4;
  JLabel jLabel11 = new JLabel("(100,100)");
//  JTable jTable1 = new JTable();
  JCheckBox jCheckBoxVisu = new JCheckBox("visualisation");
  JCheckBox jCheckBoxRecord = new JCheckBox("record");

  public WindowsConfigPanel() {
    try { jbInit(); }
    catch(Exception e) { e.printStackTrace(); }
  }

  private void jbInit() throws Exception {
    drawPanel = new DrawPanel(this/*, jTextFieldX1, jTextFieldY1, jTextFieldX2, jTextFieldY2, jLabel11, jTextFieldTime*/);

    border1 = new EtchedBorder(EtchedBorder.RAISED,Color.white,new Color(178, 178, 178));
    border2 = BorderFactory.createEtchedBorder(/*Color.white,new Color(142, 142, 142)*/);
    border3 = BorderFactory.createEtchedBorder(/*Color.white,new Color(142, 142, 142)*/);
    border4 = BorderFactory.createEmptyBorder();
    this.setLayout(borderLayout2);
    jButtonDel.setMargin(new Insets(0, 5, 0, 5));
    jButtonDel.setText("del");
    jButtonDel.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonDel_actionPerformed(e); }
    });
    jButtonIns.setMargin(new Insets(0, 5, 0, 5));
    jButtonIns.setText("ins");
    jButtonIns.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonIns_actionPerformed(e); }
    });
    jButtonFirst.setMargin(new Insets(0, 0, 0, 0));
    jButtonFirst.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonFirst_actionPerformed(e); }
    });
    jButtonFirst.setIcon(new ImageIcon(WindowsConfigPanel.class.getResource("premier.gif")));
    jButtonFirst.setBorder(null);
    jButtonLast.setMargin(new Insets(0, 0, 0, 0));
    jButtonLast.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonLast_actionPerformed(e); }
    });
    jButtonLast.setIcon(new ImageIcon(WindowsConfigPanel.class.getResource("dernier.gif")));
    jButtonLast.setBorder(null);
    jButtonNext.setMargin(new Insets(0, 0, 0, 0));
    jButtonNext.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonNext_actionPerformed(e); }
    });
    jButtonNext.setIcon(new ImageIcon(WindowsConfigPanel.class.getResource("apres.gif")));
    jButtonNext.setBorder(null);
    jButtonPrev.setMargin(new Insets(0, 0, 0, 0));
    jButtonPrev.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonPrev_actionPerformed(e); }
    });
    jButtonPrev.setIcon(new ImageIcon(WindowsConfigPanel.class.getResource("avant.gif")));
    jButtonPrev.setBorder(null);
    jButtonFull.setBorder(BorderFactory.createRaisedBevelBorder());
    jButtonFull.setMargin(new Insets(10, 20, 10, 20));
    jButtonFull.setText("full");
    jButtonFull.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonFull_actionPerformed(e); }
    });
    jButtonGetImg.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonGetImg_actionPerformed(); }
    });

    jTextFieldWinNb.setFont(new java.awt.Font("Dialog", 1, 25));
    jTextFieldWinNb.setForeground(Color.red);
    jTextFieldWinNb.setBorder(null);
    jTextFieldWinNb.setMaximumSize(new Dimension(32, 37));
    jTextFieldWinNb.setMinimumSize(new Dimension(32, 37));
    jTextFieldWinNb.setPreferredSize(new Dimension(32, 37));
    jTextFieldWinNb.setEditable(false);
    jTextFieldWinNb.setText(Integer.toString(windowNumber));
    jTextFieldWinNb.setHorizontalAlignment(SwingConstants.CENTER);
    jLabel10.setText("x1 =");
    jPanel4.setLayout(gridBagLayout5);
    jPanel4.setBorder(BorderFactory.createEtchedBorder());
    jPanel2.setLayout(borderLayout1);
    jPanel1.setBorder(border4);
    jPanel1.setLayout(gridBagLayout1);
    jTextFieldX1.setBorder(null);
    jTextFieldX1.setMinimumSize(new Dimension(35, 25));
    jTextFieldX1.setPreferredSize(new Dimension(35, 25));
    jTextFieldX1.setText(String.valueOf(ParamWindowsConf.XMIN));
    jTextFieldX1.setEditable(false);
    jTextFieldY1.setBorder(null);
    jTextFieldY1.setMinimumSize(new Dimension(35, 25));
    jTextFieldY1.setPreferredSize(new Dimension(35, 25));
    jTextFieldY1.setMargin(new Insets(2, 5, 2, 5));
    jTextFieldY1.setText(String.valueOf(ParamWindowsConf.YMIN));
    jTextFieldY1.setEditable(false);
    jTextFieldX2.setBorder(null);
    jTextFieldX2.setMinimumSize(new Dimension(35, 25));
    jTextFieldX2.setPreferredSize(new Dimension(35, 25));
    jTextFieldX2.setMargin(new Insets(2, 5, 2, 5));
    jTextFieldX2.setText(String.valueOf(ParamWindowsConf.XMAX));
    jTextFieldX2.setEditable(false);
    jTextFieldY2.setText(String.valueOf(ParamWindowsConf.YMAX));
    jTextFieldY2.setBorder(null);
    jTextFieldY2.setMinimumSize(new Dimension(35, 25));
    jTextFieldY2.setPreferredSize(new Dimension(35, 25));
    jTextFieldY2.setMargin(new Insets(2, 5, 2, 5));
    jTextFieldY2.setEditable(false);
    jTextFieldTemp.setEditable(false);
    jTextFieldTemp.setAlignmentX((float) 5.0);
    jTextFieldTemp.setAlignmentY((float) 1.0);
    jTextFieldTemp.setHorizontalAlignment(SwingConstants.CENTER);

    jLabel9.setText("y1 =");
    jLabel8.setText("x2 =");
    drawPanel.setBackground(Color.black);
    jLabel7.setText("y2 =");
    jLabel11.setMinimumSize(new Dimension(70, 25));
    jLabel11.setPreferredSize(new Dimension(70, 25));
    jTextFieldTime.setMinimumSize(new Dimension(40, 25));
    jTextFieldTime.setPreferredSize(new Dimension(40, 25));

//    jLabelWinNb.setForeground(SystemColor.desktop);
    jLabelCam.setFont(new java.awt.Font("Dialog", 1, 16));
    jLabelCam.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabelTemp.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabel2.setHorizontalAlignment(SwingConstants.CENTER);
    jLabel2.setText("windows definition table");
    jLabel1.setHorizontalAlignment(SwingConstants.CENTER);
    jTextFieldTime.setInputVerifier(new Verif(Verif.TYPEINT, 50, 10000));
    jTextFieldWL.setInputVerifier(new Verif(Verif.TYPEFLOAT, 3000f, 9000f));
    jTextFieldWL.addFocusListener(new FocusAdapter() {
      public void focusLost(FocusEvent e) {
        if(jTextFieldWL.getInputVerifier().shouldYieldFocus(jTextFieldWL))
          jTextFieldWL_focusLost(); }
    });
    jCheckBoxVisu.addChangeListener(new javax.swing.event.ChangeListener() {
      public void stateChanged(ChangeEvent e) { jCheckBoxVisu_stateChanged(); }
    });
    jCheckBoxRecord.addChangeListener(new javax.swing.event.ChangeListener() {
      public void stateChanged(ChangeEvent e) { jCheckBoxRecord_stateChanged(); }
    });
    this.add(jPanel1, BorderLayout.CENTER);
    jPanel1.add(jLabel1, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel1.add(drawPanel, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0,0,0,0),
            /*ParamWindowsConf.XMAX+2, ParamWindowsConf.YMAX+2));//*/374, 278));
    jPanel1.add(jPanel2, new GridBagConstraints(4, 1, 1, 4, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel2.add(jScrollPane1, BorderLayout.CENTER);

//    jScrollPane1.getViewport().add(jTable1, null);
    jPanel1.add(jLabel2, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel1.add(jPanel4, new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanel4.add(jTextFieldX1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel4.add(jLabel10, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel4.add(jLabel9, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel4.add(jTextFieldY1, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel4.add(jLabel8, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel4.add(jTextFieldX2, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel4.add(jLabel7, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel4.add(jTextFieldY2, new GridBagConstraints(8, 0, 4, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel4.add(jButtonFull, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));

    jPanel1.add(jPanel6, new GridBagConstraints(0, 4, 4, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 5, 5), 0, 0));

    jPanel6.setBorder(border2);
    jPanel6.setLayout(gridBagLayout4);
    jPanel6.add(jLabelWinNb, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel6.add(jPanel24, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanel24.setLayout(gridBagLayout20);
    jPanel24.add(jButtonFirst, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));
    jPanel24.add(jButtonPrev, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));
    jPanel24.add(jTextFieldWinNb, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    jPanel24.add(jButtonNext, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));
    jPanel24.add(jButtonLast, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));
    jPanel6.add(jButtonIns, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));
    jPanel6.add(jButtonDel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));
    jPanel6.add(jLabelCam, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel6.add(jLabelWL, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanel6.add(jTextFieldWL, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel6.add(jLabelTemp, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel6.add(jTextFieldTemp, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 10, 0));
    jPanel6.add(jCheckBoxVisu, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanel6.add(jCheckBoxRecord, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));

/*    jLabel11.setPreferredSize(50);
    jLabel11.setMaximumSize(50);
    jLabel11.setMinimumSize(50);*/
    jPanel1.add(jLabel11, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 10, 5, 5), 0, 0));
    jPanel1.add(jLabelTime, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 10, 5, 5), 0, 0));
    jPanel1.add(jTextFieldTime, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 5, 5), 0, 0));
    jPanel1.add(jButtonGetImg, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 10, 5, 5), 0, 0));
  }

  private void initJComboBoxWaveLength() {
    if (jComboBoxWaveLength!=null) jPanel6.remove(jComboBoxWaveLength);
    jComboBoxWaveLength = new JComboBox(UserParameters.acquisition.listeCam.getWaveString());
//    jComboBoxWaveLength = new JComboBox(UserParameters.paramWindowsConf.waveStrings);
    //    jComboBoxWaveLength.setBackground(Color.white);
    //    jComboBoxWaveLength.setFont(new java.awt.Font("Dialog", 1, 16));
    jComboBoxWaveLength.setPreferredSize(new Dimension(100, 26));
    jComboBoxWaveLength.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(ItemEvent e) { jComboBoxWaveLength_itemStateChanged(); }
    });
    jPanel6.add(jComboBoxWaveLength, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
  }

  public void jButtonGetImg_actionPerformed() {
    try {
      drawPanel.getImage();
    }
    catch (Exception e) { // IOException, BadValeurException
      AppIU.setStatus(e.getMessage());
      e.printStackTrace();
    }
  }

  public void jButtonFull_actionPerformed(ActionEvent e) {
    jTextFieldX1.setText(String.valueOf(ParamWindowsConf.XMIN));
    jTextFieldY1.setText(String.valueOf(ParamWindowsConf.YMIN));
    jTextFieldX2.setText(String.valueOf(ParamWindowsConf.XMAX));
    jTextFieldY2.setText(String.valueOf(ParamWindowsConf.YMAX));
    drawPanel.x1 = ParamWindowsConf.XMIN;
    drawPanel.y1 = ParamWindowsConf.YMIN;
    drawPanel.x2 = ParamWindowsConf.XMAX;
    drawPanel.y2 = ParamWindowsConf.YMAX;
    drawPanel.repaint();
    saveWindow();
    affTable();
  }

  // sauvegarde les donnees de la fenetre dans le tableau
  public void saveWindow() {
    UserParameters.paramWindowsConf.tableWindows[windowNumber].x1 = Integer.parseInt(jTextFieldX1.getText());
    UserParameters.paramWindowsConf.tableWindows[windowNumber].y1 = Integer.parseInt(jTextFieldY1.getText());
    UserParameters.paramWindowsConf.tableWindows[windowNumber].x2 = Integer.parseInt(jTextFieldX2.getText());
    UserParameters.paramWindowsConf.tableWindows[windowNumber].y2 = Integer.parseInt(jTextFieldY2.getText());
  }

  // maj l'affichage quand on passe a une autre fenetre
  private void affWindow() {
    redrawTable=false;
/*    System.out.println("[WindowsConfigPanel:affWindow] windowNumber=" + windowNumber +
      ", wavelength=" + UserParameters.paramWindowsConf.tableWindows[windowNumber].wavelength);*/
    jTextFieldWinNb.setText(Integer.toString(windowNumber));
    jComboBoxWaveLength.setSelectedIndex(UserParameters.paramWindowsConf.tableWindows[windowNumber].camera);
    jTextFieldTemp.setText(Float.toString(UserParameters.paramWindowsConf.tableWindows[windowNumber].temperature*.12f+6));
    jCheckBoxVisu.setSelected(UserParameters.paramWindowsConf.tableWindows[windowNumber].toVisu);
    jCheckBoxRecord.setSelected(UserParameters.paramWindowsConf.tableWindows[windowNumber].toFile);
    jTextFieldWL.setText(Float.toString(UserParameters.paramWindowsConf.tableWindows[windowNumber].wavelength));
    drawPanel.x1 = UserParameters.paramWindowsConf.tableWindows[windowNumber].x1;
    drawPanel.x2 = UserParameters.paramWindowsConf.tableWindows[windowNumber].x2;
    drawPanel.y1 = UserParameters.paramWindowsConf.tableWindows[windowNumber].y1;
    drawPanel.y2 = UserParameters.paramWindowsConf.tableWindows[windowNumber].y2;
    drawPanel.repaint();
    jTextFieldX1.setText(Integer.toString(drawPanel.x1));
    jTextFieldY1.setText(Integer.toString(drawPanel.y1));
    jTextFieldX2.setText(Integer.toString(drawPanel.x2));
    jTextFieldY2.setText(Integer.toString(drawPanel.y2));

    redrawTable=true;
    affTable();
  }

  public void jButtonNext_actionPerformed(ActionEvent e) {
    saveWindow();
    windowNumber++;
    if ( windowNumber > ParamWindowsConf.NB_LIGNE_MAX ) windowNumber = ParamWindowsConf.NB_LIGNE_MAX;
    if ( windowNumber >= UserParameters.paramWindowsConf.nbLigne ) UserParameters.paramWindowsConf.nbLigne = windowNumber + 1;
    affWindow();
  }

  public void jButtonPrev_actionPerformed(ActionEvent e) {
    saveWindow();
    windowNumber--;
    if ( windowNumber < 0 ) windowNumber = 0;
    affWindow();
  }

  public void jButtonFirst_actionPerformed(ActionEvent e) {
    saveWindow();
    windowNumber = 0;
    affWindow();
  }

  public void jButtonLast_actionPerformed(ActionEvent e) {
    saveWindow();
    windowNumber = UserParameters.paramWindowsConf.nbLigne - 1;
    if ( windowNumber < 0 ) windowNumber = 0;
    affWindow();
  }

  public void jButtonDel_actionPerformed(ActionEvent e) {
    saveWindow();
    UserParameters.paramWindowsConf.delete( windowNumber );
    if (( windowNumber >= UserParameters.paramWindowsConf.nbLigne )
        && (windowNumber > 0))
      windowNumber = UserParameters.paramWindowsConf.nbLigne - 1;
    affWindow();
  }

  public void jButtonIns_actionPerformed(ActionEvent e) {
    saveWindow();
    UserParameters.paramWindowsConf.insert( windowNumber );
    jComboBoxWaveLength_itemStateChanged();
    affWindow();
  }

  public void affTable() {
    //pour eviter qu'on ait 25000 afftable()
    if (redrawTable==false) return;
//    System.out.println("[WindowsConfigPanel:affTable] ");
    Object[][] tab = new Object[ UserParameters.paramWindowsConf.nbLigne ][ 11 ];
    for ( int i = 0 ; i < UserParameters.paramWindowsConf.nbLigne ; i++ ) {
      tab[ i ][ 0 ] = new Integer( i );
 /*     tab[ i ][ 1 ] = new String (jComboBoxWaveLength.getItemAt(
        UserParameters.paramWindowsConf.tableWindows[ i ].camera ).toString());*/
//      tab[ i ][ 1 ] = new Integer ( UserParameters.paramWindowsConf.tableWindows[ i ].camera );
      tab[ i ][ 1 ] = UserParameters.acquisition.listeCam.listeCamera
	[UserParameters.paramWindowsConf.tableWindows[ i ].camera].numRep;
      tab[ i ][ 2 ] = new Float ( UserParameters.paramWindowsConf.tableWindows[ i ].wavelength );
      tab[ i ][ 3 ] = new Float( UserParameters.paramWindowsConf.tableWindows[ i ].temperature*.12f+6 );
      tab[ i ][ 4 ] = new Integer( UserParameters.paramWindowsConf.tableWindows[ i ].x1 );
      tab[ i ][ 5 ] = new Integer( UserParameters.paramWindowsConf.tableWindows[ i ].y1 );
      tab[ i ][ 6 ] = new Integer( UserParameters.paramWindowsConf.tableWindows[ i ].x2 );
      tab[ i ][ 7 ] = new Integer( UserParameters.paramWindowsConf.tableWindows[ i ].y2 );
      tab[ i ][ 8 ] = new Boolean( UserParameters.paramWindowsConf.tableWindows[ i ].toVisu );
      tab[ i ][ 9 ] = new Boolean( UserParameters.paramWindowsConf.tableWindows[ i ].toFile );
      tab[ i ][ 10 ] = new Integer( UserParameters.paramWindowsConf.tableWindows[ i ].num );
    }
    JTable table = new JTable(tab, COLUMN_NAMES);
    table.setRowSelectionAllowed(false);
    table.setEnabled(false);
    jScrollPane1.getViewport().add(table, null);

    table.getColumnModel().getColumn(0).setPreferredWidth(80);
    table.getColumnModel().getColumn(1).setPreferredWidth(80);
    table.getColumnModel().getColumn(2).setPreferredWidth(160);
    table.getColumnModel().getColumn(3).setPreferredWidth(120);
    table.getColumnModel().getColumn(4).setPreferredWidth(50);
    table.getColumnModel().getColumn(5).setPreferredWidth(50);
    table.getColumnModel().getColumn(6).setPreferredWidth(50);
    table.getColumnModel().getColumn(7).setPreferredWidth(50);
    table.getColumnModel().getColumn(8).setPreferredWidth(110);
    table.getColumnModel().getColumn(9).setPreferredWidth(70);
  }

  public void jComboBoxWaveLength_itemStateChanged() {
    if (redrawTable==false) return;
    Camera cam = UserParameters.acquisition.listeCam.listeCamera[jComboBoxWaveLength.getSelectedIndex()];
    Integer newTemp = cam.temperature;
    UserParameters.paramWindowsConf.tableWindows[windowNumber].camera = jComboBoxWaveLength.getSelectedIndex();
    UserParameters.paramWindowsConf.tableWindows[windowNumber].temperature = newTemp.intValue();
    jTextFieldTemp.setText(Float.toString(newTemp.intValue()*.12f+6));
    jTextFieldWL.setText(cam.wavelength.toString());
    UserParameters.paramWindowsConf.tableWindows[windowNumber].wavelength = cam.wavelength.floatValue();
    affTable();
  }
/*
  public void jTextFieldTemp_focusLost() {
    UserParameters.paramWindowsConf.tableWindows[windowNumber].temperature = Integer.parseInt(jTextFieldTemp.getText());
    affTable();
  }
*/
  public void gainedFocus() {
    UserParameters.paramWindowsConf.cameratoIntf();
    initJComboBoxWaveLength();

    jPanel1.validate();
    affWindow();
  }

  public void lostFocus() throws BadValeurException {
//    jTextFieldTemp_focusLost();
    jTextFieldWL_focusLost();
    saveWindow();

    // Ci-dessous : verification pour ne pas avoir 2 windows avec le meme couple WL+Stokes
/*    ParamWindowsConf.Ligne[] ligne = UserParameters.paramWindowsConf.tableWindows;
    for ( int i = 0 ; i < UserParameters.paramWindowsConf.nbLigne-1 ; i++ )
      for ( int j = i+1 ; j < UserParameters.paramWindowsConf.nbLigne ; j++ ){
//System.out.println("[WindowsConfigPanel.lostFocus] wl["+i+"]="+ligne[i].wavelength+"wl[="+j+"]="+ligne[j].wavelength);
        if ( ligne[i].wavelength == ligne[j].wavelength )
          throw new BadValeurException("There are multiple windows with the same wavelength+Stokes : "
            + i + " and " + j);
 }
*/
    UserParameters.paramWindowsConf.intftocamera();
  }

  void jTextFieldWL_focusLost() {
    String waveText = jTextFieldWL.getText();
    if(waveText.length() != 0)
      UserParameters.paramWindowsConf.tableWindows[windowNumber].wavelength = Float.parseFloat(waveText);
    affTable();
  }

  void jCheckBoxVisu_stateChanged() {
    UserParameters.paramWindowsConf.tableWindows[windowNumber].toVisu = jCheckBoxVisu.isSelected();
    affTable();
  }

  void jCheckBoxRecord_stateChanged() {
    UserParameters.paramWindowsConf.tableWindows[windowNumber].toFile = jCheckBoxRecord.isSelected();
    affTable();
  }
}

class DrawPanel extends JPanel implements MouseListener, MouseMotionListener {
    public int x1, y1;
    public int x2, y2;
    WindowsConfigPanel W;
    JTextField X1, X2, Y1, Y2, time;
    JLabel XY;
    Image im;

    public DrawPanel(WindowsConfigPanel W/*, JTextField X1, JTextField Y1, JTextField X2, JTextField Y2, JLabel XY, JTextField time*/) {
      this.W = W;
      this.X1 = W.jTextFieldX1;
      this.Y1 = W.jTextFieldY1;
      this.Y2 = W.jTextFieldY2;
      this.X2 = W.jTextFieldX2;
      this.XY = W.jLabel11;
      this.time = W.jTextFieldTime;
      addMouseMotionListener(this);
      addMouseListener(this);

      int[] pix = new int[ParamWindowsConf.XMAX*ParamWindowsConf.YMAX];
      //for (int i=0; i<pix.length; i++) pix[i]=Math.round((data[2*i]*255+data[2*i+1])/2);
      im = Toolkit.getDefaultToolkit().createImage(new java.awt.image.MemoryImageSource(
        ParamWindowsConf.XMAX, ParamWindowsConf.YMAX, (int[])pix, 0, ParamWindowsConf.XMAX));
    }

    public void getImage() {
      try {
        W.lostFocus();

        Window win = UserParameters.acquisition.listeWin.getListe()[W.windowNumber];
        win.setColdb(1);
        win.setLigdb(1);
        win.setNbcol(ParamWindowsConf.XMAX);
        win.setNblig(ParamWindowsConf.YMAX);
        ProgObservation.acquisition(W.windowNumber, Integer.parseInt(time.getText()));

        im = Utils.getImage();
/*
        File file = new File("/tmp/visu.don");

        FileInputStream in = new FileInputStream(file);
        int w=ParamWindowsConf.XMAX, l=ParamWindowsConf.YMAX;
        byte[] data = new byte[w*l*2];
        in.read(data);

        int[] pix = new int[w*l];
        int min, max;
        if (data[0]<0) min=(data[0]+256)<<8;
        else min=(data[0])<<8;
        if (data[1]<0) min+=data[1]+256;
        else min+=data[1];
        max = min;
        int i, j;

        // data (2 bytes) -> pix (1 int) + inversion verticale + reperage des min & max
        for (int v=0; v<l; v++) for (int u=0; u<w; u++) {
          i = 2*(v*w+u);
          j = (l-v-1)*w+u;
          if (data[i]<0) pix[j]=(data[i]+256)<<8;
          else pix[j]=(data[i])<<8;
          if (data[i+1]<0) pix[j]+=data[i+1]+256;
          else pix[j]+=data[i+1];
          if (pix[j]<min) {
            min=pix[j];
//System.out.println("[WindowsConfigPanel.DrawPanel.getImage] data["+i+"]="+data[i]+", data["+(i+1)+"]="+data[i+1]+", min="+min);
          }
          if (pix[j]>max) max=pix[j];
        }
        float fact = 255f/(float)(max-min);
        int gris = 0x010101;
System.out.println("[WindowsConfigPanel.DrawPanel.drawImage] min="+min+", max="+max+", fact="+fact);
        // 1 int (0,65535) -> ARVB (0,255)^4 + ajustement du contraste
        for (i=0; i<pix.length; i++)
          pix[i] = Math.round((pix[i]-min)*fact)*gris | (255<<24); // (255<<24)=alpha

        im = Toolkit.getDefaultToolkit().createImage(
          new java.awt.image.MemoryImageSource(w, l, pix, 0, w));
System.out.println("[WindowsConfigPanel.DrawPanel.drawImage] im : height="+im.getHeight(this)
  +", width="+im.getWidth(this));*/
        this.repaint();
      }
      catch (Exception e) { System.err.println(e); }
      // FileNotFoundException, IOException, BadValeurException
    }

    public void mouseDragged(MouseEvent e) {
        e.consume();
        x2 = e.getX();
        y2 = e.getY();
        if ( x2 > ParamWindowsConf.XMAX ) x2 = ParamWindowsConf.XMAX;
        if ( x2 < ParamWindowsConf.XMIN ) x2 = ParamWindowsConf.XMIN;
        if ( y2 > ParamWindowsConf.YMAX ) y2 = ParamWindowsConf.YMAX;
        if ( y2 < ParamWindowsConf.YMIN ) y2 = ParamWindowsConf.YMIN;
        mouseMoved( e );
        repaint();
    }

    public void mouseMoved(MouseEvent e) {
        int x, y;
        e.consume();
        x = e.getX();
        y = e.getY();
        if ( x > ParamWindowsConf.XMAX ) x = ParamWindowsConf.XMAX;
        if ( x < ParamWindowsConf.XMIN ) x = ParamWindowsConf.XMIN;
        if ( y > ParamWindowsConf.YMAX ) y = ParamWindowsConf.YMAX;
        if ( y < ParamWindowsConf.YMIN ) y = ParamWindowsConf.YMIN;
        XY.setText( "(" + Integer.toString(x) + "," + Integer.toString(y) + ")" );
    }

    public void mousePressed(MouseEvent e) {
        e.consume();
        x2 = e.getX();
        y2 = e.getY();
        if ( x2 > ParamWindowsConf.XMAX ) x2 = ParamWindowsConf.XMAX;
        if ( x2 < ParamWindowsConf.XMIN ) x2 = ParamWindowsConf.XMIN;
        if ( y2 > ParamWindowsConf.YMAX ) y2 = ParamWindowsConf.YMAX;
        if ( y2 < ParamWindowsConf.YMIN ) y2 = ParamWindowsConf.YMIN;
        x1 = x2;
        y1 = y2;
        repaint();
    }
/**
 * Correction : quand on clique 1 point, les coordonnees ne changent pas.
 * Il faut faire un drag pour modifier les coordonnees.
 * Jerome, 09-03-2001.
 **/
    public void mouseReleased(MouseEvent e) {
      if ((x1!=x2) && (y1!=y2)) {
        X1.setText(Integer.toString(Math.min(x1, x2)));
        X2.setText(Integer.toString(Math.max(x1, x2)));
        Y1.setText(Integer.toString(Math.min(y1, y2)));
        Y2.setText(Integer.toString(Math.max(y1, y2)));
        W.saveWindow();
        W.affTable();
      } else {
        x1 = Integer.parseInt(X1.getText());
        x2 = Integer.parseInt(X2.getText());
        y1 = Integer.parseInt(Y1.getText());
        y2 = Integer.parseInt(Y2.getText());
        repaint();
      }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void paint(Graphics g) {
//System.out.println("[WindowsConfigPanel$DrawPanel:paint]");
      super.paint(g);
      g.setColor(getForeground());
      g.setPaintMode();
      g.drawImage(im, 0, 0, this);
      g.setXORMode(java.awt.Color.red);//getBackground());
      g.drawRect( Math.min(x1, x2), Math.min(y1, y2), Math.abs(x2 - x1), Math.abs(y2 - y1));
    }
}

