
// modif le 24/5/2000 par CM : ajout methode getVisu, getFile

package iu;

import java.lang.*;
import java.util.*;
import java.io.*;
import java.text.*;

public class Window implements Sauvegardable/*, Formatable*/
{

  private static final int MAXLIG = 288;
  private static final int MAXCOL = 384;
  private static final int MAXFEN = 40;
  private Integer nblig=new Integer(MAXLIG-2), ligdb=new Integer(1), 
    nbcol=new Integer(MAXCOL-2), coldb=new Integer(1), numero, 
    indCam=new Integer(0);
  public Integer num = new Integer(0);
  private Boolean toVisu = new Boolean(true);
  private Boolean toFile = new Boolean(false);

  public Float wavelength = new Float(4000.0);

  private static String sauvFormat = "'{'{0,number}'}' '{'{1,number}'}' '{'{2,number}'}' '{'{3,number}'}' '{'{4,number}'}' '{'{5,number}'}' '{'{6,number}'}' '{'{7}'}' '{'{8}'}' \n";

  /** Constructeur utile pour re-creer les objets avec le fichier sauvegarde */
  public Window() {
    }

  public Window(int numero,int indCam,float wavelength,int nblig,int ligdb,
    int nbcol,int coldb,boolean tovisu,boolean tofile, int num) throws BadValeurException {
      if(num >= MAXFEN) throw new BadValeurException("BadValeurWindow");
      if((ligdb+nblig)>MAXLIG) throw new BadValeurException("Window.BadValeurLigne");
      if((coldb+nbcol)>MAXCOL) throw new BadValeurException("Window.BadValeurColonne");

      this.numero= new Integer(numero);
      this.ligdb = new Integer(ligdb);
      this.coldb = new Integer(coldb);
      this.nblig = new Integer(nblig);
      this.nbcol = new Integer(nbcol);
      this.toVisu = new Boolean(tovisu);
      this.toFile = new Boolean(tofile);
      this.indCam = new Integer(indCam);
      this.wavelength = new Float(wavelength);
      this.num = new Integer(num);
    }

  /** Ecrit sous form {info} {info}.... */

  public void setObject_to_file(BufferedWriter out) throws IOException {
      Object[] info = {numero,indCam,wavelength,nblig,ligdb,nbcol,coldb,toVisu,toFile};
      MessageFormat form = new MessageFormat(sauvFormat);
      String resultat = new String(form.format(info));

//      System.out.println("[Window:setObject_to_file] " + resultat.length());
      try{ out.write(resultat,0,resultat.length()); }
      catch(IOException e) { throw e; }
    }

  /** Demande la ligne de texte et un parse position juste apres WIN */
  public void getObject_from_File(BufferedReader in) throws IOException
    {
      Object constr[];
      String tostudy = new String(in.readLine());
      ParsePosition status = new ParsePosition(0);

      MessageFormat form1 = new MessageFormat("'{'{0,number}'}' ");

      constr=  form1.parse(tostudy,status);
      this.numero=new Integer((constr[0]).toString());
      constr=  form1.parse(tostudy,status);
      this.indCam=new Integer((constr[0]).toString());
      constr=  form1.parse(tostudy,status);
      this.wavelength=new Float((constr[0]).toString());
      constr=  form1.parse(tostudy,status);
      this.nblig=new Integer((constr[0]).toString());
      constr=  form1.parse(tostudy,status);
      this.ligdb=new Integer((constr[0]).toString());
      constr=  form1.parse(tostudy,status);
      this.nbcol=new Integer((constr[0]).toString());
      constr=  form1.parse(tostudy,status);
      this.coldb=new Integer((constr[0]).toString());


      form1 = new MessageFormat("'{'{0}'}' ");
      constr=  form1.parse(tostudy,status);
      this.toVisu=new Boolean((constr[0]).toString());
      constr=  form1.parse(tostudy,status);
      this.toFile=new Boolean((constr[0]).toString());

    }

  public KeywordText getmotcle(boolean wacq) throws BadValeurException
    {
      KeywordText resul = new KeywordText(0, "");
      String keyword;
      Integer intVal;

      keyword = new String(UserRessource.cle_nblig);
      resul = resul.add(Formatage.motcle(keyword,numero,true,nblig));
      keyword = UserRessource.cle_ligdb;
      resul = resul.add(Formatage.motcle(keyword,numero,true,ligdb));
      keyword = UserRessource.cle_nbcol;
      resul = resul.add(Formatage.motcle(keyword,numero,true,nbcol));
      keyword = UserRessource.cle_coldb;
      resul = resul.add(Formatage.motcle(keyword,numero,true,coldb));
      keyword = UserRessource.cle_wavlt;
      resul = resul.add(Formatage.motcle(keyword,numero,true,wavelength));
      if(toVisu.booleanValue()||wacq)
	{
	  keyword = UserRessource.cle_visuf;
	  intVal = new Integer(1);
	  resul = resul.add(Formatage.motcle(keyword,numero,true,intVal));
	}
      if(toFile.booleanValue()&&!wacq)
	{
	  keyword = UserRessource.cle_enreg;
	  intVal = new Integer(1);
	  resul = resul.add(Formatage.motcle(keyword,numero,true,intVal));
	}
      return resul;
    }

  public void setLigdb(int ligdb) throws BadValeurException
    {
      if((ligdb+nblig.intValue())<MAXLIG)
	{
	  this.ligdb= new Integer(ligdb);
	}
      else { throw new BadValeurException("setLigdb.BadValeurLigne : "+ligdb);}
    }

  public void setColdb(int coldb) throws BadValeurException
    {
      if((coldb+nbcol.intValue())<MAXCOL)
	{
	  this.coldb= new Integer(coldb) ;
	}
      else {throw new BadValeurException("setColdb.BadValeurColonne : coldb="+coldb+", nbcol="+nbcol);}
    }

  public void setNblig(int nblig) throws BadValeurException
    {
      if((ligdb.intValue()+nblig)<MAXLIG)
	{
	  this.nblig = new Integer(nblig);
	}
      else {throw new BadValeurException("setNblig.BadValeurLigne : "+nblig);}
    }

  public void setNbcol(int nbcol) throws BadValeurException
    {
      if((coldb.intValue()+nbcol)<MAXCOL)
	{
	  this.nbcol = new Integer(nbcol);
	}
      else {throw new BadValeurException("setNbcol.BadValeurColonne : nbcol="+nbcol+", coldb="+coldb);}
    }
  public void setVisu(boolean what)
    {
      this.toVisu = new Boolean(what);
    }
  public void setFile(boolean what)
    {
      this.toFile = new Boolean(what);
    }


  public int getLigdb()
    {
      return this.ligdb.intValue();
    }
  public int getColdb()
    {
     return  this.coldb.intValue();
    }
  public int getNblig()
    {
      return this.nblig.intValue();
    }
  public int getNbcol()
    {
      return this.nbcol.intValue() ;
    }
  public void setNumero(int num) { this.numero = new Integer(num); }
/*
  public getNumero()
    {
      return this.numero.intValue();
    }*/
  public int getCam()
    {
      return(indCam.intValue());
    }
  public void setCam(int cam)
    {
      indCam = new Integer(cam);
    }
  public boolean getVisu()
    {
      return(toVisu.booleanValue());
    }
  public boolean getFile()
    {
      return(toFile.booleanValue());
    }

  //* Retourne les chaines de caracteres du formatage */


}

