/**
 * Title:        Interface-observateur<p>
 * Description:  Programmation d'une interface-observateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Minec-Debin
 * @version 1.0
 */

package iu;

import javax.swing.*;

public class Verif extends InputVerifier {
  int type;
  public final static int TYPEINT = Keyword.TYPEINT; 
  public final static int TYPEFLOAT = Keyword.TYPEFLOAT;
 
  float x1;
  float x2;

/**
 * Verification du type seulement.
 */

  public Verif(int type) {
    this.type = type;
    switch (type) {
    case TYPEINT :
      this.x1 = Integer.MIN_VALUE;
      this.x2 = Integer.MAX_VALUE;
      break;
    case TYPEFLOAT :
      this.x1 = -Float.MAX_VALUE;
      this.x2 = Float.MAX_VALUE;
      break;
    }
  }

/**
 * Verification du type et de la limite inferieure.
 */

  public Verif(int type, float x1) {
    this.type = type;
    this.x1 = x1;
    switch (type) {
    case TYPEINT :
      this.x2 = Integer.MAX_VALUE;
      break;
    case TYPEFLOAT :
      this.x2 = Float.MAX_VALUE;
      break;
    }
  }

/**
 * Verification du type et des limites.
 */

  public Verif(int type, float x1, float x2) {
    this.type = type;
    this.x1 = x1;
    this.x2 = x2;
  }

  public boolean verify(JComponent input) {
    JTextField tf = (JTextField) input;
    try {
      float val=x1;
      switch (type) {
      case TYPEINT : val = Integer.valueOf(tf.getText()).intValue(); break;
      case TYPEFLOAT : val = Float.valueOf(tf.getText()).floatValue(); break;
      }      
      if ( (val<x1) || (val>x2) ) 
	throw new NumberFormatException(val+" must be in ["+x1+","+x2+"]");
    }
    catch(NumberFormatException e) { 
      AppIU.setStatus("Number format error : "+e.getMessage());
 JOptionPane.showMessageDialog(null, "Not a number, see status bar.","Error", JOptionPane.ERROR_MESSAGE);
      tf.setText("");//selectAll(); 
      return false; 
    }
    return true;
  }
}
