/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Grassin-Minec-Debin
 * @version 1.0
 */

package iu;

import java.awt.*;
import java.io.*;
//import javax.swing.*;

public class Utils {
    private static final String VISUDON = "/tmp/visu.don";
    private static int w=ParamWindowsConf.XMAX, l=ParamWindowsConf.YMAX;
    private static int[] pix = new int[w*l];

/**
 * @return le tableau de pixels de l'image
 * @see #getImage()
 **/
    public static int[] getPix() { return pix; }

/**
 * Recupere les donnees du fichier <code>/tmp/visu.don</code> et les transforme 
 * en image.
 **/
    public static Image getImage() {
      try {
        File file = new File(VISUDON);

        FileInputStream in = new FileInputStream(file);
        byte[] data = new byte[w*l*2];
        in.read(data);

        int min, max;
        if (data[0]<0) min=(data[0]+256)<<8;
        else min=(data[0])<<8;
        if (data[1]<0) min+=data[1]+256;
        else min+=data[1];
        max = min;
        int i, j;

        // data (2 bytes) -> pix (1 int) + inversion verticale + reperage des min & max
        for (int v=0; v<l; v++) for (int u=0; u<w; u++) {
          i = 2*(v*w+u);
          j = (l-v-1)*w+u;
          if (data[i]<0) pix[j]=(data[i]+256)<<8;
          else pix[j]=(data[i])<<8;
          if (data[i+1]<0) pix[j]+=data[i+1]+256;
          else pix[j]+=data[i+1];
          if (pix[j]<min) {
            min=pix[j];
          }
          if (pix[j]>max) max=pix[j];
        }
        float fact = 255f/(float)(max-min);
        int gris = 0x010101;
System.out.println("[Utils.getImage] min="+min+", max="+max+", fact="+fact);
        // 1 int (0,65535) -> ARVB (0,255)^4 + ajustement du contraste
        for (i=0; i<pix.length; i++)
          pix[i] = Math.round((pix[i]-min)*fact)*gris | (255<<24); // (255<<24)=alpha

        return Toolkit.getDefaultToolkit().createImage(
          new java.awt.image.MemoryImageSource(w, l, pix, 0, w));
      }
      catch (Exception e) { System.err.println(e); }
      // FileNotFoundException, IOException, BadValeurException

      return null;
    }
    
  public static void recupDA3() {
    /*System.out.println*/AppIU.setStatus("Getting semi-static parameters from tracking...");
    try {
      Communication comm = new Communication(Communication.UCCI);
      String rep = comm.envoiMessage("DA3()", 5000);
      Coordonnees.setParameters(rep);
    }
    catch(Exception e) { //IOException ou RuntimeException
      /*System.err.println*/AppIU.setStatus(e.getMessage() + " => Semi-static parameters could not be retrieved.\n"
        + "The coordinates conversions will be incorrect.");
    }
  }
}
