/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Grassin-Minec-Debin
 * @version 1.0
 */

package iu;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;

public class TuningPanel extends JPanel {
  float coulisseZ = 0.1f, coulisseY = 0.1f;

  JPanel jPanelF1 = new JPanel();
  JPanel jPanelFilter = new JPanel();
  JPanel jPanelMirror = new JPanel();
  JPanel jPanel8 = new JPanel();
  JPanel jPanelPreslit = new JPanel();
  JPanel jPanelAB = new JPanel();
  JPanel jPanelCD = new JPanel();
  JPanel jPanelBeam = new JPanel();
  JPanel jPanelDerotator = new JPanel();
  JPanel jPanelFinder = new JPanel();
  JPanel jPanelF2 = new JPanel();
  JPanel jPanelTracking = new JPanel();

  GridBagLayout gridBagLayout14 = new GridBagLayout();
  GridBagLayout gridBagLayout10 = new GridBagLayout();
  GridBagLayout gridBagLayout19 = new GridBagLayout();
  GridBagLayout gridBagLayout3 = new GridBagLayout();
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  GridBagLayout gridBagLayout4 = new GridBagLayout();
  GridBagLayout gridBagLayout11 = new GridBagLayout();
  GridBagLayout gridBagLayout12 = new GridBagLayout();
  GridBagLayout gridBagLayout8 = new GridBagLayout();
  GridBagLayout gridBagLayout2 = new GridBagLayout();
  GridBagLayout gridBagLayout6 = new GridBagLayout();

  JToggleButton jButtonFermeture = new JToggleButton("Close");
  JToggleButton jButtonOuverture = new JToggleButton("Open");
  ButtonGroup groupMirror = new ButtonGroup();

  JButton jButtonMoinsY = new JButton("-");
  JButton jButtonPlusY = new JButton("+");
  JTextField jTextFieldY = new JTextField("0.1");

  JButton jButtonMoinsZ = new JButton("-");
  JTextField jTextFieldZ = new JTextField("0.1");
  JButton jButtonPlusZ = new JButton("+");

  JToggleButton jButton1F1 = new JToggleButton("1");
  JToggleButton jButton2F1 = new JToggleButton("2");
  JToggleButton jButton3F1 = new JToggleButton("3");
  JToggleButton jButton4F1 = new JToggleButton("4");
  JToggleButton jButton5F1 = new JToggleButton("5");
  ButtonGroup groupF1 = new ButtonGroup();

  ButtonGroup groupFilter = new ButtonGroup();
  JToggleButton jButton4307 = new JToggleButton("4307 \u00C5");
  JToggleButton jButtonStellaire = new JToggleButton("Stellar");
  JToggleButton jButtonHalpha = new JToggleButton("H \u03B1");//alpha");

  JToggleButton jButton1AB = new JToggleButton("1");
  JToggleButton jButton2AB = new JToggleButton("2");
  JToggleButton jButton3AB = new JToggleButton("3");
  JToggleButton jButton4AB = new JToggleButton("4");
  ButtonGroup groupAB = new ButtonGroup();

  JToggleButton jButton1CD = new JToggleButton("1");
  JToggleButton jButton2CD = new JToggleButton("2");
  JToggleButton jButton3CD = new JToggleButton("3");
  JToggleButton jButton4CD = new JToggleButton("4");
  ButtonGroup groupCD = new ButtonGroup();

  ButtonGroup groupDistribution = new ButtonGroup();
  JToggleButton jButtonSpectro100 = new JToggleButton("spectrograph 100%");
  JToggleButton jButtonVisee = new JToggleButton("field of view 100%");
  JToggleButton jButtonVisee8020 = new JToggleButton("spectro 80% / field of view 20%");

  JButton jButtonDerotator = new JButton("Send");

  JToggleButton jButtonOff = new JToggleButton("Off");
  JToggleButton jButtonOn = new JToggleButton("On");
  ButtonGroup groupFinder = new ButtonGroup();

  JToggleButton jButtonIpm = new JToggleButton("IPM");
  JToggleButton jButtonSpectro = new JToggleButton("Spectro");
  ButtonGroup groupF2 = new ButtonGroup();

  JButton jButtonCentre = new JButton("Sun Center");

  TitledBorder titledBorder8;
  Border border3;
  TitledBorder titledBorder5;
  Border border2;
  TitledBorder titledBorder3;
  TitledBorder titledBorder7;
  JTextField jTextFieldDerotator = new JTextField("0.");
  TitledBorder titledBorder9;
  Border border7;
  TitledBorder titledBorder10;
  Border border8;
  TitledBorder titledBorder11;
  Border border9;
  TitledBorder titledBorder12;
  Border border10;
  TitledBorder titledBorder13;
  Border border11;
  Border border12;
  TitledBorder titledBorder15;
  Border border13;
  TitledBorder titledBorder16;
  JLabel jLabelY = new JLabel("Y");
  JLabel jLabelZ = new JLabel("Z");

  public TuningPanel() {
    try { jbInit(); }
    catch(Exception e) { e.printStackTrace(); }
  }

  private void jbInit() throws Exception {
    border9 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
    titledBorder12 = new TitledBorder(border9,"Derotator ()");
    border10 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
    titledBorder13 = new TitledBorder(border10,"Finder");
    border11 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
    border12 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
    titledBorder15 = new TitledBorder(border12,"Preslit displacement (mm)"); //Dplacement Coulisse Y (mm)
    border13 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
    titledBorder16 = new TitledBorder(border13,"Mirrors caps"); //Capots des miroirs
    jButtonOn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonChercheur_actionPerformed(1); }
    });
    jButtonOff.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonChercheur_actionPerformed(0); }
    });
    jButtonMoinsY.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonY_actionPerformed(0); }
    });
    jButtonPlusY.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonY_actionPerformed(1); }
    });
    jButtonMoinsZ.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonZ_actionPerformed(0); }
    });
    jButtonPlusZ.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonZ_actionPerformed(1); }
    });
    jButtonOuverture.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonCapots_actionPerformed(1); }
    });
    jButtonFermeture.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonCapots_actionPerformed(0); }
    });
    jButton1F1.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonPrefente_actionPerformed(1); }
    });
    jButton2F1.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonPrefente_actionPerformed(2); }
    });
    jButton3F1.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonPrefente_actionPerformed(3); }
    });
    jButton4F1.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonPrefente_actionPerformed(4); }
    });
    jButton5F1.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonPrefente_actionPerformed(5); }
    });
    jButton1AB.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonAB_actionPerformed(1); }
    });
    jButton2AB.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonAB_actionPerformed(2); }
    });
    jButton3AB.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonAB_actionPerformed(3); }
    });
    jButton4AB.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonAB_actionPerformed(4); }
    });
    jButton1CD.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonCD_actionPerformed(1); }
    });
    jButton2CD.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonCD_actionPerformed(2); }
    });
    jButton3CD.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonCD_actionPerformed(3); }
    });
    jButton4CD.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonCD_actionPerformed(4); }
    });
    jButtonSpectro.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonF2_actionPerformed(1); }
    });
    jButtonIpm.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonF2_actionPerformed(0); }
    });
    jButton4307.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonTranslation_actionPerformed(new Float(-58)); }
    });
    jButtonStellaire.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonTranslation_actionPerformed(new Float(-175)); }
    });
    jButtonHalpha.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonTranslation_actionPerformed(new Float(182)); }
    });
    jButtonSpectro100.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonFaisceau_actionPerformed(new Float(0)); }
    });
    jButtonVisee.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonFaisceau_actionPerformed(new Float(-81)); }
    });
    jButtonVisee8020.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonFaisceau_actionPerformed(new Float(82)); }
    });
    jButtonCentre.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonCentre_actionPerformed(); }
    });
    jButtonDerotator.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonDerotator_actionPerformed(); }
    });

    jTextFieldDerotator.setPreferredSize(new Dimension(40, 21));
    jTextFieldY.setPreferredSize(new Dimension(40, 21));
    jTextFieldY.setHorizontalAlignment(SwingConstants.CENTER);
    jTextFieldZ.setPreferredSize(new Dimension(40, 21));
    jTextFieldZ.setHorizontalAlignment(SwingConstants.CENTER);

    groupDistribution.add(jButtonSpectro100);
    groupDistribution.add(jButtonVisee);
    groupDistribution.add(jButtonVisee8020);
    groupFilter.add(jButton4307);
    groupFilter.add(jButtonStellaire);
    groupFilter.add(jButtonHalpha);
    groupAB.add(jButton1AB);
    groupAB.add(jButton2AB);
    groupAB.add(jButton3AB);
    groupAB.add(jButton4AB);
    groupCD.add(jButton1CD);
    groupCD.add(jButton2CD);
    groupCD.add(jButton3CD);
    groupCD.add(jButton4CD);
    groupF1.add(jButton1F1);
    groupF1.add(jButton2F1);
    groupF1.add(jButton3F1);
    groupF1.add(jButton4F1);
    groupF1.add(jButton5F1);
    groupMirror.add(jButtonOuverture);
    groupMirror.add(jButtonFermeture);
    groupFinder.add(jButtonOn);
    groupFinder.add(jButtonOff);
    groupF2.add(jButtonIpm);
    groupF2.add(jButtonSpectro);

    border2 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
    titledBorder3 = new TitledBorder(border2,"Filter translation");
    border3 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
    titledBorder5 = new TitledBorder(border3,"Beam distribution");
    titledBorder7 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142)),"Tracking");
    titledBorder8 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142)),"F2 translation");
    titledBorder9 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142)),"F1 slit translation (position)");
    border7 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
    titledBorder10 = new TitledBorder(border7,"AB filter wheel");
    border8 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
    titledBorder11 = new TitledBorder(border8,"CD filter wheel");
    initComponents();

    setLayout(gridBagLayout19);
    jPanelMirror.setBorder(titledBorder16);
    jPanelMirror.setLayout(gridBagLayout3);
    jPanel8.setLayout(gridBagLayout1);
    jPanelPreslit.setBorder(titledBorder15);
    jPanelPreslit.setLayout(gridBagLayout4);

    jPanelF1.setBorder(titledBorder9);
    jPanelF1.setLayout(gridBagLayout10);
    jPanelFilter.setLayout(gridBagLayout14);
    jPanelFilter.setBorder(titledBorder3);
    jPanelAB.setLayout(gridBagLayout11);
    jPanelAB.setBorder(titledBorder10);
    jPanelCD.setBorder(titledBorder11);
    jPanelCD.setLayout(gridBagLayout12);
    jPanelBeam.setBorder(titledBorder5);
    jPanelBeam.setLayout(gridBagLayout2);
    jPanelDerotator.setBorder(titledBorder12);
    jPanelFinder.setBorder(titledBorder13);
    jPanelFinder.setLayout(gridBagLayout6);
    jPanelF2.setLayout(gridBagLayout8);
    jPanelF2.setBorder(titledBorder8);
    jPanelTracking.setBorder(titledBorder7);

    this.add(jPanel8, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

    jPanel8.add(jPanelPreslit, new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelPreslit.add(jLabelY, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelPreslit.add(jButtonMoinsY, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelPreslit.add(jTextFieldY, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.VERTICAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelPreslit.add(jButtonPlusY, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelPreslit.add(jLabelZ, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelPreslit.add(jButtonMoinsZ, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelPreslit.add(jTextFieldZ, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.VERTICAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelPreslit.add(jButtonPlusZ, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));

    jPanel8.add(jPanelMirror, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0
            ,GridBagConstraints.SOUTHEAST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelMirror.add(jButtonOuverture, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelMirror.add(jButtonFermeture, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.SOUTHEAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jPanelF1, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelF1.add(jButton1F1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelF1.add(jButton2F1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelF1.add(jButton3F1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelF1.add(jButton4F1, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelF1.add(jButton5F1, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jPanelFilter, new GridBagConstraints(2, 1, 2, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelFilter.add(jButton4307, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelFilter.add(jButtonStellaire, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelFilter.add(jButtonHalpha, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jPanelAB, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelAB.add(jButton1AB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelAB.add(jButton2AB, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelAB.add(jButton3AB, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelAB.add(jButton4AB, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jPanelCD, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelCD.add(jButton1CD, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelCD.add(jButton2CD, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelCD.add(jButton3CD, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelCD.add(jButton4CD, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jPanelBeam, new GridBagConstraints(2, 2, 2, 2, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelBeam.add(jButtonSpectro100, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelBeam.add(jButtonVisee8020, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelBeam.add(jButtonVisee, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));

    jPanel8.add(jPanelDerotator, new GridBagConstraints(3, 4, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelDerotator.add(jTextFieldDerotator);
    jPanelDerotator.add(jButtonDerotator);
    jPanel8.add(jPanelFinder, new GridBagConstraints(2, 4, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelFinder.add(jButtonOff, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelFinder.add(jButtonOn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jPanelF2, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelF2.add(jButtonSpectro, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelF2.add(jButtonIpm, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jPanelTracking, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelTracking.add(jButtonCentre, null);
  }

  void gainedFocus() {
  }

  void lostFocus() {
  }

  private void initComponents() {
    jTextFieldY.setInputVerifier(new Verif(Verif.TYPEFLOAT,-28,28));
    jTextFieldZ.setInputVerifier(new Verif(Verif.TYPEFLOAT,-28,28));
    jTextFieldDerotator.setInputVerifier(new Verif(Verif.TYPEFLOAT,-180,180));
  }

  void jButtonChercheur_actionPerformed(int on_off) {
    Communication comm;
    String resultat = "", message = "";
    Float pos = new Float((on_off==1)?63:-63);/*1=ON,0=OFF*/

    try { comm = new Communication(30000,Communication.UCCI); }
    catch (IOException e) {
      System.out.println(e.toString());
//      jTextAreaMessages.append("Communication with UCCI is impossible : " + e + "\n");
      return;
    }

    MoteurBase moteur = (MoteurBase)UserParameters.listeMoteur.getMoteur("EM19");
    message += moteur.pmvt(pos).getScript();

    try { resultat = comm.envoi(message); }
    catch (java.io.IOException e) {
        System.out.println(e.toString());
//      jTextAreaMessages.append("A problem occured while sending instructions to UCCI : " + e + "\n");
      return;
    }
  }

  void jButtonY_actionPerformed(int plus_moins) {
    /*1=plus,0=moins*/
    Communication comm;
    String resultat = "", message = "";

    try {
      coulisseY = Float.valueOf(jTextFieldY.getText()).floatValue();

      comm = new Communication(20000,Communication.UCCI);

      MoteurBase moteur = (MoteurBase)UserParameters.listeMoteur.getMoteur("EM17");
      message += moteur.dmvt(new Float(plus_moins==1?coulisseY:-coulisseY)).getScript();

      resultat = comm.envoi(message);
    }
    catch (Exception e) {
      System.err.println(e.toString());
      return;
    }
  }

  void jButtonZ_actionPerformed(int plus_moins) {
    /*1=plus,0=moins*/
    Communication comm;
    String resultat = "", message = "";

    try {
      coulisseZ = Float.valueOf(jTextFieldZ.getText()).floatValue();

      comm = new Communication(20000,Communication.UCCI);

      MoteurBase moteur = (MoteurBase)UserParameters.listeMoteur.getMoteur("EM18");
      message += moteur.dmvt(new Float(plus_moins==1?coulisseZ:-coulisseZ)).getScript();

      resultat = comm.envoi(message);
    }
    catch (Exception e) {
      System.err.println(e.toString());
      return;
    }
  }

  void jButtonCapots_actionPerformed(int open_close) {
    Communication comm;
    String resultat = "", message = "";
    String commande= new String((open_close==1)?"OPEN":"CLOSE");

    try { comm = new Communication(20000,Communication.UCCI); }
    catch (java.io.IOException e) {
      System.out.println(e.toString());
//      jTextAreaMessages.append("Communication with UCCI is impossible : " + e + "\n");
      return;
    }
    message += commande+"(AE01)";

    try { resultat = comm.envoi(message); }
    catch (java.io.IOException e) {
        System.out.println(e.toString());
//      jTextAreaMessages.append("A problem occured while sending instructions to UCCI : " + e + "\n");
      return;
    }
  }

  void jButtonPrefente_actionPerformed(int pos) {
    Communication comm;
    String resultat = "", message = "";


    try { comm = new Communication(20000,Communication.UCCI); }
    catch (java.io.IOException e) {
      System.out.println(e.toString());
//      jTextAreaMessages.append("Communication with UCCI is impossible : " + e + "\n");
      return;
    }

    Roue moteur = (Roue)UserParameters.listeMoteur.getMoteur("EM24");
    message += moteur.pmvt(pos).getScript();

    try { resultat = comm.envoi(message); }
    catch (java.io.IOException e) {
        System.out.println(e.toString());
//      jTextAreaMessages.append("A problem occured while sending instructions to UCCI : " + e + "\n");
      return;
    }
  }

  void jButtonAB_actionPerformed(int pos) {
    Communication comm;
    String resultat = "", message = "";

    try { comm = new Communication(20000,Communication.UCCI); }
    catch (java.io.IOException e) {
      System.out.println(e.toString());
//      jTextAreaMessages.append("Communication with UCCI is impossible : " + e + "\n");
      return;
    }

    Roue moteur = (Roue)UserParameters.listeMoteur.getMoteur("EM58");
    message += moteur.pmvt(pos).getScript();

    try { resultat = comm.envoi(message); }
    catch (java.io.IOException e) {
        System.out.println(e.toString());
//      jTextAreaMessages.append("A problem occured while sending instructions to UCCI : " + e + "\n");
      return;
    }
  }

void jButtonCD_actionPerformed(int pos) {
    Communication comm;
    String resultat = "", message = "";

    try { comm = new Communication(20000,Communication.UCCI); }
    catch (java.io.IOException e) {
      System.out.println(e.toString());
//      jTextAreaMessages.append("Communication with UCCI is impossible : " + e + "\n");
      return;
    }

    Roue moteur = (Roue)UserParameters.listeMoteur.getMoteur("EM59");
    message += moteur.pmvt(pos).getScript();

    try { resultat = comm.envoi(message); }
    catch (java.io.IOException e) {
        System.out.println(e.toString());
//      jTextAreaMessages.append("A problem occured while sending instructions to UCCI : " + e + "\n");
      return;
    }
  }

  void jButtonF2_actionPerformed(int spectro_ipm) {
    /*1=spectro,0=ipm*/
    Communication comm;
    String resultat = "", message = "";
    Float position  = new Float((spectro_ipm==1?0:103.3));

    try { comm = new Communication(20000,Communication.UCCI); }
    catch (java.io.IOException e) {
      System.out.println(e.toString());
//      jTextAreaMessages.append("Communication with UCCI is impossible : " + e + "\n");
      return;
    }

    MoteurBase moteur = (MoteurBase)UserParameters.listeMoteur.getMoteur("EM70");
    message += moteur.pmvt(position).getScript();

    try { resultat = comm.envoi(message); }
    catch (java.io.IOException e) {
        System.out.println(e.toString());
//      jTextAreaMessages.append("A problem occured while sending instructions to UCCI : " + e + "\n");
      return;
    }
  }

  void jButtonTranslation_actionPerformed(Float position) {

    Communication comm;
    String resultat = "", message = "";


    try { comm = new Communication(180000,Communication.UCCI); }
    catch (java.io.IOException e) {
      System.out.println(e.toString());
//      jTextAreaMessages.append("Communication with UCCI is impossible : " + e + "\n");
      return;
    }

    MoteurBase moteur = (MoteurBase)UserParameters.listeMoteur.getMoteur("EM31");
    message += moteur.pmvt(position).getScript();

    try { resultat = comm.envoi(message); }
    catch (java.io.IOException e) {
        System.out.println(e.toString());
//      jTextAreaMessages.append("A problem occured while sending instructions to UCCI : " + e + "\n");
      return;
    }
  }

   void jButtonFaisceau_actionPerformed(Float position) {

    Communication comm;
    String resultat = "", message = "";


    try { comm = new Communication(60000,Communication.UCCI); }
    catch (java.io.IOException e) {
      System.out.println(e.toString());
//      jTextAreaMessages.append("Communication with UCCI is impossible : " + e + "\n");
      return;
    }

    MoteurBase moteur = (MoteurBase)UserParameters.listeMoteur.getMoteur("EM30");
    message += moteur.pmvt(position).getScript();

    try { resultat = comm.envoi(message); }
    catch (java.io.IOException e) {
        System.out.println(e.toString());
//      jTextAreaMessages.append("A problem occured while sending instructions to UCCI : " + e + "\n");
      return;
    }
  }

  void jButtonCentre_actionPerformed() {
    Communication comm;
    String resultat = "", message = "";

    try { comm = new Communication(20000,Communication.UCCI); }
    catch (java.io.IOException e) {
      System.out.println(e.toString());
      return;
    }
    message += "EQU(00000.0,00000.0)";
    try { resultat = comm.envoi(message); }
    catch (java.io.IOException e) {
        System.out.println(e.toString());
      return;
    }
  }

  void jButtonDerotator_actionPerformed() {
    Communication comm;
    String resultat = "", message = "";

    try { comm = new Communication(20000,Communication.UCCI); }
    catch (java.io.IOException e) {
      System.out.println(e.toString());
      return;
    }
    message += "OFD("+jTextFieldDerotator.getText()+")";
    try { resultat = comm.envoi(message); }
    catch (java.io.IOException e) {
        System.out.println(e.toString());
      return;
    }
  }
}
