/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Grassin-Minec-Debin
 * @version 1.0
 */

package iu;

import java.text.*;
import java.io.*;

public class Tiroir {
  String nom;
  int nbMoteur;
  Moteur[] moteurs;

  public Tiroir() {
  }

  public String toString() { return nom; }

  public void setObject_to_file(BufferedWriter out) throws IOException {
    for (int m = 0; m < nbMoteur; m++)
      moteurs[m].setObject_to_file(out);
  }

  public Moteur getLine(BufferedReader in) throws IOException {
    String nomMoteur = "", type = "", fonction = "", unite = "";
    float limiteMoins = 0, limitePlus = 0;
    Object constr[];
    ParsePosition status = new ParsePosition(0);
    String tostudy = new String(in.readLine());

//System.out.println("[Tiroir:getLine] " + tostudy);
    constr = ListeMoteur.formatLigne.parse(tostudy, status);

    try {
      nomMoteur = new String((constr[0]).toString());
      type = new String((constr[1]).toString());
      fonction = new String((constr[2]).toString());
      unite = new String((constr[3]).toString());
      limiteMoins = Float.parseFloat(constr[4].toString());
      limitePlus = Float.parseFloat(constr[5].toString());
    }
    catch (NumberFormatException e) {
     System.out.println("Error with motor " + nomMoteur + " : " + e);
    }

//System.out.println("[Tiroir:getLine] " + nomMoteur + ", " + type + ", " + fonction + ", " + unite + ", " + limiteMoins + ", " + limitePlus);
    if (type.equals(Moteur.TYPEBASE)) {
     return new MoteurBase(nomMoteur, type, fonction, unite, limiteMoins, limitePlus);
    }
    else if (type.equals(Moteur.TYPEVITESSE)) {
      return new MoteurVitesse(nomMoteur, type, fonction, unite, limiteMoins, limitePlus);
    }
    else if (type.equals(Moteur.TYPECAPOT)) {
      return new CapotVolet(nomMoteur, type, fonction, unite, limiteMoins, limitePlus);
    }
    else if (type.equals(Moteur.TYPEROUE)) {
      return new Roue(nomMoteur, type, fonction, unite, limiteMoins, limitePlus);
    }
    else if (type.equals(Moteur.TYPESONDE)) {
      return new Sonde(nomMoteur, type, fonction, unite, limiteMoins, limitePlus);
    }
    else throw new IOException(type + ":type de moteur inconnu");
  }

  public void getTiroir(BufferedReader in) throws IOException {
    Object constr[];
    ParsePosition status = new ParsePosition(0);
    String tostudy = new String(in.readLine());
    int i;

    constr = ListeMoteur.formatEntete.parse(tostudy, status);
//System.out.println("[ListeMoteur$Tiroir:getTiroir] " + tostudy);

    if (!constr[0].equals("tiroir"))
      throw new IOException("erreur dans le fichier " + UserParameters.moteurFile);
    nom = new String((constr[1]).toString());
    nbMoteur = Integer.parseInt(constr[2].toString());

    moteurs = new Moteur[nbMoteur];
    for (i = 0; i < nbMoteur; i++) {
//      moteurs[ i ] = new Moteur();
      moteurs[ i ] = getLine( in );
    }
  }
}