/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Minec-Debin
 * @version 1.0
 */

package iu;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;

public class TargetsPanel extends JPanel {
  private static int TAILLEIMG = 218504; // = ParamWindowsConf.XMAX*ParamWindowsConf.YMAX*2
  private static int TAILLEBLOC = 2880;

  boolean cadEnCours = false;
  int targetNumber = 0;
  int nbWave = 0;
  WaveLine[] waveLines;
  int sysPos = 0, sysInc = 0;

  Dimension dimension1;
  JLabel jLabelPosition = new JLabel("System");
  JLabel jLabelIncrement = new JLabel("System");
  JLabel jLabelOrient = new JLabel("Slit orientation");
  JLabel jLabelDirection = new JLabel("Scan direction (deg)");
  JLabel jLabel8 = new JLabel("Object Name");
  JLabel jLabel7 = new JLabel("Identify number");
  JLabel jLabelLongitude = new JLabel("X");
  JLabel jLabelLatitude = new JLabel("Y");
  JPanel jPanelIncr = new JPanel();
  JLabel jLabelArcSec = new JLabel("Total size");
  JLabel jLabelInc = new JLabel("Increment");
  JLabel jLabelNb = new JLabel("Number");
  JLabel jLabelStepX = new JLabel("X");
  JLabel jLabelStepY = new JLabel("Y");
  JLabel jLabelToTel = new JLabel("To telescope");
//  JLabel jLabel23 = new JLabel("Other");
  JLabel jLabel30 = new JLabel("Integration time (ms)");
  JLabel jLabelCustomName = new JLabel("Custom name");
  JLabel jLabelMode = new JLabel("Mode");
  JLabel jLabelFitsMode = new JLabel("FITS mode");
  JLabel jLabelObsMode = new JLabel("Type");
  JLabel jLabelUnite = new JLabel("(arcsec)");

  JLabel jLabelSize = new JLabel("Scan file size (Mb)");

  JTextField jTextFieldSize = new JTextField("0");
  JTextField jTextFieldScanningDirection = new JTextField();
  JComboBox jComboBoxIdNumber;
  JTextField jTextFieldCustomName = new JTextField();
  JTextField jTextFieldRegionLatitude = new JTextField("0.0", 5);
  JTextField jTextFieldScanLongitude = new JTextField("0.0", 5);
  JTextField jTextFieldRegionLongitude = new JTextField("0.0", 5);
  JTextField jTextFieldScanLatitude = new JTextField("0.0", 5);
  JTextField jTextFieldXNb = new JTextField();
  JTextField jTextFieldXInc = new JTextField();
  JTextField jTextFieldYNb = new JTextField();
  JTextField jTextFieldYInc = new JTextField();
  JTextField jTextField20 = new JTextField();
  JTextField jTextFieldShots = new JTextField("50");
  JTextField jTextFieldOrient = new JTextField();
  JTextField jTextFieldXSend = new JTextField("0.0");
  JTextField jTextFieldYSend = new JTextField("0.0");
  JRadioButton jRadioButtonXaxis = new JRadioButton("X axis first");
  JRadioButton jRadioButtonYaxis = new JRadioButton("Y axis first");
  JCheckBox jCheckBoxCut = new JCheckBox("1 file / band", true);

  JPanel jPanel13 = new JPanel();
  JPanel jPanelFlatField = new JPanel();
  JPanel jPanel6 = new JPanel();
  JPanel jPanelCut = new JPanel();
  JLabel jLabel29 = new JLabel("Used wavelength");
  JLabel jLabelSolarN = new JLabel("/ solar N (deg)");
  JLabel jLabelShots = new JLabel("Shots number");
  JPanel jPanelDef = new JPanel();
  JPanel jPanel17 = new JPanel();
  JPanel jPanel24 = new JPanel();
  JPanel jPanel25 = new JPanel();
  JPanel jPanel8 = new JPanel();
  JPanel jPanelActionProgram = new JPanel();
  JPanel jPanelPos = new JPanel();
  JPanel jPanelDark = new JPanel();
//  JPanel jPanelMove = new JPanel();
  JScrollPane jScrollPane2 = new JScrollPane();
  JScrollPane jScrollPaneComment = new JScrollPane();
  GridBagLayout gridBagLayout7 = new GridBagLayout();
  GridBagLayout gridBagLayout14 = new GridBagLayout();
  GridBagLayout gridBagLayout12 = new GridBagLayout();
  GridBagLayout gridBagLayout10 = new GridBagLayout();
  GridBagLayout gridBagLayout18 = new GridBagLayout();
  GridBagLayout gridBagLayout19 = new GridBagLayout();
  GridBagLayout gridBagLayout15 = new GridBagLayout();
  GridBagLayout gridBagLayout20 = new GridBagLayout();
  GridBagLayout gridBagLayout110 = new GridBagLayout();
  GridBagLayout gridBagLayout3 = new GridBagLayout();
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  GridBagLayout gridBagLayout5 = new GridBagLayout();
  GridBagLayout gridBagLayout6 = new GridBagLayout();
  GridBagLayout gridBagLayoutDark = new GridBagLayout();
  GridBagLayout gridBagLayoutCut = new GridBagLayout();
//  GridBagLayout gridBagLayoutMove = new GridBagLayout();
//  TitledBorder titledBorderMove = new TitledBorder("Telescope movement");
  TitledBorder titledBorderDef;
  TitledBorder titledBorderParam;
  TitledBorder titledBorderDark = new TitledBorder("Dark current");
  TitledBorder titledBorderActionProgram;
  TitledBorder titledBorderFlatField;
  TitledBorder titledBorderBeforeLoop;
  TitledBorder titledBorderLoop;
  TitledBorder titledBorder6;
  TitledBorder titledBorderScan = new TitledBorder("Scan parameters");
  TitledBorder titledBorderCut = new TitledBorder("Data file size");
  JCheckBox jCheckBoxLockSlit = new JCheckBox("perpendicular to slit", true);
  JButton jButtonPremier = new JButton();
  JButton jButtonDernier = new JButton();
  JButton jButtonApres = new JButton();
  JButton jButtonAvant = new JButton();
  JButton jButtonDel = new JButton("del");
  JButton jButtonGetIt = new JButton("get from tracking");
  JButton jButtonAcq = new JButton("get 1 image");
  JButton jButtonStAcq = new JButton("start acq");
  JButton jButtonPoint = new JButton("send telescope");
  JButton jButtonIncr = new JButton("send");
  ButtonGroup groupaxis = new ButtonGroup();
  ButtonGroup groupClose = new ButtonGroup();

  JLabel jLabelCenter = new JLabel("Region center");
  JLabel jLabelStart = new JLabel("Scan starting");
  JRadioButton jRadioButtonSpectro = new JRadioButton("close spectrograph input", true);
  JRadioButton jRadioButtonAll = new JRadioButton("close shutters only", false);
  JComboBox jComboBoxMode;
  JComboBox jComboBoxFitsMode;
  JComboBox jComboBoxSystemPosition;
  JComboBox jComboBoxSystemIncrement;
  JComboBox jComboBoxSlitOrientation;
  JComboBox jComboBoxObjectName;
  JComboBox jComboBoxObsMode;
  JTextField jTextFieldNb = new JTextField("1");
  JTextField jTextFieldNbAcq = new JTextField("0");
  JTextField jTextFieldXArcSec = new JTextField("0");
  JTextField jTextFieldYArcSec = new JTextField("0");
  JLabel jLabelNbAcq = new JLabel("Nb.acq./step");

  public static String[] mode;
  public static Integer[] fitsMode ;
  public static final String[] SLIT_ORIENTATION = { "celestial north", "solar north",
    "zenith", "celestial equator", "solar equator", "tangential", "radial", "other" };
  public static String[] objectName;
  public static String fitsComment;
  Border border1;
  JPanel jPanel20 = new JPanel();
  JLabel jLabel2 = new JLabel("Comment");
  JTextArea jTextAreaComment = new JTextArea(3, 26);
  java.util.ArrayList polar = new java.util.ArrayList();
  JComboBox jComboBoxPolar;
  JButton jButtonAdd = new JButton("add");
  JTextField jTextFieldSequence = new JTextField("");
  JButton jButtonResetAll = new JButton("Reset");
  JLabel jLabelSeq = new JLabel("Sequence :");
  JTextField jTextFieldAngle = new JTextField();
  JLabel jLabelAngle = new JLabel("Angle");
  JTextField jTextFieldHaxis = new JTextField();
  JLabel jLabelHaxis = new JLabel("h axis (arcsec)");
  JTextField jTextFieldLaxis = new JTextField();
  JLabel jLabelLaxis = new JLabel("l axis (arcsec)");
  JTextField jTextFieldNumberOfCycles = new JTextField();
  JButton jButtonGetItFromTracking = new JButton("get from tracking");
  JLabel jLabelLongitude1 = new JLabel("X");
  JLabel jLabelNumberOfCycles = new JLabel("Number of images");
  JLabel jLabelLatitude1 = new JLabel("Y");
  JTextField jTextFieldLatitude = new JTextField();
  JTextField jTextFieldLongitude = new JTextField();
  JPanel jPanel1 = new JPanel();

  public TargetsPanel() {
    try { jbInit(); }
    catch(Exception e) { e.printStackTrace(); }
  }

  private void jbInit() throws Exception {
    initComponents();

    jTextFieldXArcSec.setEditable(false);
    jTextFieldYArcSec.setEditable(false);
    jTextFieldNbAcq.setEditable(false);
    jTextFieldXNb.addFocusListener(new FocusAdapter() {
      public void focusLost(FocusEvent e) { maj_NbAcq(); maj_XArcSec(); }
    });
    jTextFieldXInc.addFocusListener(new FocusAdapter() {
      public void focusLost(FocusEvent e) { maj_XArcSec(); }
    });
    jTextFieldYNb.addFocusListener(new FocusAdapter() {
      public void focusLost(FocusEvent e) { maj_NbAcq(); maj_YArcSec(); }
    });
    jTextFieldNb.addFocusListener(new FocusAdapter() {
      public void focusLost(FocusEvent e) { maj_NbAcq(); }
    });
    jTextFieldYInc.addFocusListener(new FocusAdapter() {
      public void focusLost(FocusEvent e) { maj_YArcSec(); }
    });
    jTextFieldRegionLatitude.addFocusListener(new FocusAdapter() {
      public void focusLost(FocusEvent e) { maj_Start(); }
    });
    jTextFieldRegionLongitude.addFocusListener(new FocusAdapter() {
      public void focusLost(FocusEvent e) { maj_Start(); }
    });
    jTextFieldOrient.addFocusListener(new FocusAdapter() {
      public void focusLost(FocusEvent e) { maj_Start(); }
    });
    jTextFieldScanningDirection.addFocusListener(new FocusAdapter() {
      public void focusLost(FocusEvent e) { maj_Start(); }
    });

    border1 = BorderFactory.createEtchedBorder(/*Color.white,new Color(142, 142, 142)*/);

    titledBorderDef = new TitledBorder("");
    dimension1 = jPanelActionProgram.getPreferredSize();
    titledBorderParam = new TitledBorder("");
    titledBorderActionProgram = new TitledBorder("");
    titledBorderFlatField = new TitledBorder("");
    titledBorderLoop = new TitledBorder(BorderFactory.createEtchedBorder(), "Loop");
    titledBorderBeforeLoop = new TitledBorder(BorderFactory.createEtchedBorder(), "Before loop");
    titledBorder6 = new TitledBorder("");
    setLayout(gridBagLayout19);
    titledBorderScan.setBorder(BorderFactory.createEtchedBorder());
    jPanelIncr.setBorder(titledBorderScan);
    titledBorderDef.setBorder(BorderFactory.createEtchedBorder());
    titledBorderDef.setTitle("Definitions");
    jPanelDef.setBorder(titledBorderDef);
    jPanelDef.setLayout(gridBagLayout3);
    jPanel8.setLayout(gridBagLayout1);
    jPanelPos.setBorder(titledBorderParam);
    jPanelDark.setBorder(titledBorderDark);
    jPanelDark.setLayout(gridBagLayoutDark);
    titledBorderParam.setBorder(BorderFactory.createEtchedBorder());
    titledBorderParam.setTitle("Target position");
    jPanelActionProgram.setBorder(titledBorderActionProgram);
    jPanelActionProgram.setLayout(gridBagLayout7);
    titledBorderActionProgram.setBorder(BorderFactory.createEtchedBorder());
    titledBorderActionProgram.setTitle("Polarization settings");
    titledBorderFlatField.setBorder(BorderFactory.createEtchedBorder());
    titledBorderFlatField.setTitle("Flat field");

    jPanelPos.setLayout(gridBagLayout5);
//    jButtonGetIt.setBorder(BorderFactory.createRaisedBevelBorder());
    jButtonGetIt.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonGetIt_actionPerformed(); maj_Start();}
    });
    jButtonAcq.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { acquisition(); }
    });
    jButtonStAcq.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { startAcq(); }
    });
    jLabelLongitude.setMaximumSize(new Dimension(40, 17));
    jLabelLongitude.setMinimumSize(new Dimension(40, 17));
    jLabelLongitude.setPreferredSize(new Dimension(40, 17));
    jLabelLongitude.setHorizontalAlignment(SwingConstants.CENTER);
    jLabelLatitude.setMaximumSize(new Dimension(40, 17));
    jLabelLatitude.setMinimumSize(new Dimension(40, 17));
    jLabelLatitude.setPreferredSize(new Dimension(40, 17));
    jLabelLatitude.setHorizontalAlignment(SwingConstants.CENTER);
    jPanelIncr.setLayout(gridBagLayout6);

    jButtonDel.setMargin(new Insets(0, 5, 0, 5));
    jButtonDel.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonDel_actionPerformed(e); }
    });
    jButtonPremier.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonPremier_actionPerformed(e); }
    });
    jButtonDernier.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonDernier_actionPerformed(e); }
    });
    jButtonAvant.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonAvant_actionPerformed(e); }
    });
    jButtonApres.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonApres_actionPerformed(e); }
    });
    jTextField20.setMaximumSize(new Dimension(100, 37));
    jTextField20.setMinimumSize(new Dimension(100, 37));
    jTextField20.setPreferredSize(new Dimension(100, 37));

    jComboBoxFitsMode.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(ItemEvent e) { if (e.getStateChange()==ItemEvent.SELECTED)
        maj_Size(); }
    });
    jComboBoxSlitOrientation.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(ItemEvent e) { if (e.getStateChange()==ItemEvent.SELECTED)
        jComboBoxSlitOrientation_itemStateChanged(); }
    });
    jComboBoxSystemIncrement.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(ItemEvent e) { if (e.getStateChange()==ItemEvent.SELECTED)
        jComboBoxSystemIncrement_itemStateChanged(); }
    });
    jComboBoxSystemPosition.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(ItemEvent e) { if (e.getStateChange()==ItemEvent.SELECTED)
        jComboBoxSystemPosition_itemStateChanged(); }
    });
    jCheckBoxLockSlit.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(ItemEvent e) { jCheckBoxLockSlit_itemStateChanged(e); }
    });
    jCheckBoxCut.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(ItemEvent e) { maj_Size(); }
    });
    jRadioButtonXaxis.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(ItemEvent e) { maj_Size(); }
    });
    jRadioButtonYaxis.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(ItemEvent e) { maj_Size(); }
    });
    jTextFieldScanLatitude.setEditable(false);
    jTextFieldScanLongitude.setEditable(false);

    jTextAreaComment.setLineWrap(true);

    jScrollPaneComment.getViewport().add(jTextAreaComment);
    jScrollPaneComment.setMinimumSize(new Dimension(300, 60));
    jScrollPaneComment.setPreferredSize(new Dimension(300, 60));

    jRadioButtonYaxis.setHorizontalAlignment(SwingConstants.RIGHT);
    jRadioButtonXaxis.setHorizontalAlignment(SwingConstants.RIGHT);

/*
    jButtonU2.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonAnalyser_actionPerformed("-U"); }
    });
    jButtonU2.setPreferredSize(new Dimension(52, 27));
    jButtonV2.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonAnalyser_actionPerformed("-V"); }
    });
    jButtonV2.setPreferredSize(new Dimension(52, 27));
    jButtonV.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonAnalyser_actionPerformed("V"); }
    });
    jButtonV.setPreferredSize(new Dimension(52, 27));
    jButtonQ2.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonAnalyser_actionPerformed("-Q"); }
    });
    jButtonQ2.setPreferredSize(new Dimension(52, 27));
    jButtonU.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonAnalyser_actionPerformed("U"); }
    });
    jButtonU.setPreferredSize(new Dimension(52, 27));
    jButtonQ.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonAnalyser_actionPerformed("Q"); }
    });
    jButtonQ.setPreferredSize(new Dimension(52, 27));
*/
    jTextFieldSequence.setEditable(false);
    jTextFieldSize.setEditable(false);

    jButtonAdd.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonAdd_actionPerformed(); }
    });
    jButtonResetAll.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
              polar.clear();
        jTextFieldSequence.setText(""); maj_NbAcq(); }
    });
    jButtonPoint.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { pointage(); }
      });
    jButtonIncr.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { increment(); }
      });
    jLabelOrient.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabel8.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabel7.setHorizontalAlignment(SwingConstants.RIGHT);

    jLabelAngle.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabelHaxis.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabelLaxis.setHorizontalAlignment(SwingConstants.RIGHT);
    jButtonGetItFromTracking.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonGetItFlatField_actionPerformed(); }
    });
    jButtonGetItFromTracking.setBorder(BorderFactory.createRaisedBevelBorder());
    jLabelLongitude1.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabelNumberOfCycles.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabelLatitude1.setHorizontalTextPosition(SwingConstants.LEFT);
    jLabelLatitude1.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabelCenter.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabelStart.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabelDirection.setText("Scan direc. (deg)");
    groupaxis.add(jRadioButtonXaxis);
    groupaxis.add(jRadioButtonYaxis);
    groupClose.add(jRadioButtonSpectro);
    groupClose.add(jRadioButtonAll);
    jPanelFlatField.setBorder(titledBorderFlatField);
    jPanelFlatField.setLayout(gridBagLayout10);
    jPanel6.setLayout(gridBagLayout14);
    jPanel17.setLayout(gridBagLayout18);

    jPanel13.setLayout(gridBagLayout15);
    jLabel30.setHorizontalAlignment(SwingConstants.RIGHT);
    jButtonPremier.setMargin(new Insets(0, 0, 0, 0));
    jButtonPremier.setIcon(new ImageIcon(TargetsPanel.class.getResource("premier.gif")));
    jButtonPremier.setBorder(null);
    jButtonDernier.setMargin(new Insets(0, 0, 0, 0));
    jButtonDernier.setIcon(new ImageIcon(TargetsPanel.class.getResource("dernier.gif")));
    jButtonDernier.setBorder(null);
    jButtonApres.setMargin(new Insets(0, 0, 0, 0));
    jButtonApres.setIcon(new ImageIcon(TargetsPanel.class.getResource("apres.gif")));
    jButtonApres.setBorder(null);
    jButtonAvant.setMargin(new Insets(0, 0, 0, 0));
    jButtonAvant.setIcon(new ImageIcon(TargetsPanel.class.getResource("avant.gif")));
    jButtonAvant.setBorder(null);
    jTextField20.setBackground(new Color(204, 204, 204));
    jTextField20.setFont(new java.awt.Font("Dialog", 1, 25));
    jTextField20.setForeground(Color.red);
    jTextField20.setBorder(null);
    jTextField20.setEditable(false);
    jTextField20.setText("1 of 1");
    jTextField20.setHorizontalAlignment(SwingConstants.CENTER);
    jLabelMode.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabelFitsMode.setHorizontalAlignment(SwingConstants.RIGHT);
    jPanel24.setLayout(gridBagLayout20);
    jPanel25.setLayout(gridBagLayout110);
    jPanelCut.setLayout(gridBagLayoutCut);
    jPanelCut.setBorder(titledBorderCut);
    this.add(jPanel8, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanel8.add(jPanelActionProgram, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

    jPanelDark.add(jRadioButtonSpectro, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDark.add(jRadioButtonAll, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDark.add(jLabelShots, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDark.add(jTextFieldShots, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));

    jPanel8.add(jPanelDark, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));

/*
    jPanelActionProgram.add(jButtonU2, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    jPanelActionProgram.add(jButtonV2, new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    jPanelActionProgram.add(jButtonV, new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    jPanelActionProgram.add(jButtonQ2, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    jPanelActionProgram.add(jButtonU, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    jPanelActionProgram.add(jButtonQ, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
*/
    jPanelActionProgram.add(jLabelSeq, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    jPanelActionProgram.add(jTextFieldSequence, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelActionProgram.add(jButtonAdd, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    jPanelActionProgram.add(jButtonResetAll, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

    jPanel8.add(jPanelPos, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

    jPanelPos.add(jLabelPosition, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelPos.add(jComboBoxSystemPosition, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelPos.add(jLabelLongitude, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelPos.add(jLabelLatitude, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelPos.add(jLabelStart, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelPos.add(jTextFieldScanLongitude, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelPos.add(jTextFieldScanLatitude, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelPos.add(jLabelCenter, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelPos.add(jTextFieldRegionLongitude, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelPos.add(jTextFieldRegionLatitude, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelPos.add(jButtonGetIt, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelPos.add(jButtonPoint, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));

    jPanel8.add(jPanelIncr, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

    jPanelIncr.add(jLabelIncrement, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jComboBoxSystemIncrement, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jLabelUnite, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jLabelStepX, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jLabelStepY, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jLabelNbAcq, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jLabelNb, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jTextFieldXNb, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jTextFieldYNb, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jLabelInc, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jTextFieldXInc, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jTextFieldYInc, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jTextFieldNb, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jLabelArcSec, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jTextFieldXArcSec, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jTextFieldYArcSec, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jTextFieldNbAcq, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jLabelToTel, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jTextFieldXSend, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jTextFieldYSend, new GridBagConstraints(2, 5, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jButtonIncr, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jRadioButtonXaxis, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jRadioButtonYaxis, new GridBagConstraints(2, 6, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jLabelOrient, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jComboBoxSlitOrientation, new GridBagConstraints(1, 7, 3, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jTextFieldOrient, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jLabelSolarN, new GridBagConstraints(2, 8, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jCheckBoxLockSlit, new GridBagConstraints(2, 9, 2, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(4, 0, 6, 10), 0, 0));
    jPanelIncr.add(jLabelDirection, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelIncr.add(jTextFieldScanningDirection, new GridBagConstraints(1, 9, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));

    jPanel8.add(jPanelDef, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelDef.add(jLabelFitsMode, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDef.add(jComboBoxFitsMode, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDef.add(jLabelObsMode, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDef.add(jComboBoxObsMode, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDef.add(jLabelMode, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDef.add(jComboBoxMode, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDef.add(jLabel7, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDef.add(jComboBoxIdNumber, new GridBagConstraints(1, 3, 3, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDef.add(jLabel8, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDef.add(jComboBoxObjectName, new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDef.add(jLabelCustomName, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDef.add(jTextFieldCustomName, new GridBagConstraints(1, 5, 3, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDef.add(jLabel2, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDef.add(jScrollPaneComment, new GridBagConstraints(1, 6, 3, 1, 1.0, 1.0
            ,GridBagConstraints.NORTH, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));

    jPanel8.add(jPanelCut, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelCut.add(jLabelSize, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    jPanelCut.add(jTextFieldSize, new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
    jPanelCut.add(jCheckBoxCut, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

    jPanel8.add(jPanel13, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanel13.add(jPanelFlatField, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelFlatField.add(jLabelAngle, new GridBagConstraints(3, 8, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelFlatField.add(jTextFieldAngle, new GridBagConstraints(4, 8, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelFlatField.add(jLabelHaxis, new GridBagConstraints(3, 9, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelFlatField.add(jTextFieldHaxis, new GridBagConstraints(4, 9, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelFlatField.add(jLabelLaxis, new GridBagConstraints(3, 10, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelFlatField.add(jTextFieldLaxis, new GridBagConstraints(4, 10, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelFlatField.add(jLabelNumberOfCycles, new GridBagConstraints(3, 11, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelFlatField.add(jTextFieldNumberOfCycles, new GridBagConstraints(4, 11, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelFlatField.add(jLabelLongitude1, new GridBagConstraints(3, 12, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelFlatField.add(jTextFieldLongitude, new GridBagConstraints(4, 12, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelFlatField.add(jLabelLatitude1, new GridBagConstraints(3, 13, 1, 1, 0.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelFlatField.add(jTextFieldLatitude, new GridBagConstraints(4, 13, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelFlatField.add(jButtonGetItFromTracking, new GridBagConstraints(4, 14, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
/*    jPanelFlatField.add(jPanel1, new GridBagConstraints(3, 15, 2, 1, 0.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
*/
    jPanel8.add(jPanel6, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanel6.add(jLabel29, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 0, 5), 0, 0));
    jPanel6.add(jLabel30, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 0, 5), 0, 0));
    jPanel6.add(jScrollPane2, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel6.add(jButtonAcq, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 0, 5), 0, 0));
    jPanel6.add(jButtonStAcq, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 0, 5), 0, 0));

    this.add(jPanel25, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
    jPanel25.add(jPanel24, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    jPanel24.add(jButtonPremier, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));
    jPanel24.add(jButtonDernier, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));
    jPanel24.add(jButtonApres, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));
    jPanel24.add(jButtonAvant, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));
    jPanel24.add(jTextField20, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanel24.add(jButtonDel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jScrollPane2.getViewport().add(jPanel17, null);

  }

  private void initJComboBoxPolar() {
    if (jComboBoxPolar != null) jPanelActionProgram.remove(jComboBoxPolar);
    jComboBoxPolar = new JComboBox(UserParameters.listePolar.getStringListe());
    jPanelActionProgram.add(jComboBoxPolar, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
  }

  private void initComponents() {
    mode = (String[])UserParameters.paramFits.getChoice("INSTRUME");
    jComboBoxMode = new JComboBox(mode);

    fitsMode = (Integer[])UserParameters.paramFits.getChoice("THEMISFF");
    jComboBoxFitsMode = new JComboBox(fitsMode);

    jComboBoxSystemPosition = new JComboBox(Cible.SYSTEM_POS);

    jComboBoxSystemIncrement = new JComboBox((String[])UserParameters.paramFits.getChoice("SYSCOORD"));

    jComboBoxIdNumber = new JComboBox((String[])UserParameters.paramFits.getChoice("OBJ_ID"));
    jComboBoxIdNumber.setEditable(true);

    jComboBoxSlitOrientation = new JComboBox(SLIT_ORIENTATION);

    jComboBoxObsMode = new JComboBox(new String[] {"SCAN","CALIB"});

    objectName = (String[])UserParameters.paramFits.getChoice("OBJECT");
    fitsComment = "";
    jComboBoxObjectName = new JComboBox(objectName);

    initJComboBoxPolar();

    waveLines = new WaveLine[ ListeWindow.NB_MAX_WIN ];
    litWave();

    jTextFieldRegionLongitude.setInputVerifier(new Verif(Verif.TYPEFLOAT,-1500,1500));
    jTextFieldRegionLatitude.setInputVerifier(new Verif(Verif.TYPEFLOAT,-1500,1500));
    
    jTextFieldNb.setInputVerifier(new Verif(Verif.TYPEINT,1));
    jTextFieldXNb.setInputVerifier(new Verif(Verif.TYPEINT,1));
    jTextFieldYNb.setInputVerifier(new Verif(Verif.TYPEINT,1));
    jTextFieldXInc.setInputVerifier(new Verif(Verif.TYPEFLOAT));
    jTextFieldYInc.setInputVerifier(new Verif(Verif.TYPEFLOAT));
    jTextFieldXSend.setInputVerifier(new Verif(Verif.TYPEFLOAT));
    jTextFieldYSend.setInputVerifier(new Verif(Verif.TYPEFLOAT));
    jTextFieldOrient.setInputVerifier(new Verif(Verif.TYPEFLOAT,-180,360));
    jTextFieldScanningDirection.setInputVerifier(new Verif(Verif.TYPEFLOAT,-180,360));

    jTextFieldAngle.setInputVerifier(new Verif(Verif.TYPEINT,-180,360));
    jTextFieldHaxis.setInputVerifier(new Verif(Verif.TYPEINT,0));
    jTextFieldLaxis.setInputVerifier(new Verif(Verif.TYPEINT,0));
    jTextFieldNumberOfCycles.setInputVerifier(new Verif(Verif.TYPEINT,0));
    jTextFieldLongitude.setInputVerifier(new Verif(Verif.TYPEFLOAT));
    jTextFieldLatitude.setInputVerifier(new Verif(Verif.TYPEFLOAT));

    jTextFieldShots.setInputVerifier(new Verif(Verif.TYPEINT,0));

    setValues( targetNumber );
  }
/*
  public double getScanningDirection() {
    double f;
    if (jCheckBoxLockSlit.isSelected()) {
      if (jComboBoxSlitOrientation.getSelectedItem().equals("celestial north"))
        f= -Coordonnees.getP0() + 90.; //celestial north
      else if (jComboBoxSlitOrientation.getSelectedItem().equals("solar north"))
        f= 90.; //solar north
      else if (jComboBoxSlitOrientation.getSelectedItem().equals("celestial equator"))
        f= -Coordonnees.getP0(); //celestial equator
      else if (jComboBoxSlitOrientation.getSelectedItem().equals("solar equator"))
        f= 0.; //solar equator
      else if (jComboBoxSlitOrientation.getSelectedItem().equals("other"))
        f= Float.parseFloat(jTextFieldOrient.getText()) + 90.; //other
      else
        f= 999.99; //
    }
    else f= Float.parseFloat(jTextFieldScanningDirection.getText());
    if (f > 180.) f=f-180.;
    return f;
  }
*/

  private void maj_Start() {
    Coordonnees c = new Coordonnees(Double.parseDouble(jTextFieldScanLongitude.getText()),
      Double.parseDouble(jTextFieldScanLatitude.getText()));
    try {
      c = new Coordonnees(Double.parseDouble(jTextFieldRegionLongitude.getText()),
        Double.parseDouble(jTextFieldRegionLatitude.getText()));

      switch (jComboBoxSystemIncrement.getSelectedIndex()) {
        case 0 : switch (jComboBoxSystemPosition.getSelectedIndex()) { // EQUATORIAL
            case 0 : c = calcul(c); break; // equatorial
            case 1 : c = calcul(c.heliogToEquat()).equatToHeliog(); break; // heliographic
            case 2 : c = calcul(c.polToEquat()).equatToPol(); break; // polar
          }
          break;
/*        case 1 : switch (jComboBoxSystemPosition.getSelectedIndex()) { // AZIMUTHAL
            case 0 : c = calcul(c.equatToPol()).polToEquat(); break; // equatorial
            case 1 : c = calcul(c.heliogToPol()).polToHeliog(); break; // heliographic
            case 2 : c = calcul(c); break; // polar
          }
          break;*/
        case 1 : switch (jComboBoxSystemPosition.getSelectedIndex()) { // HELIOGRAPHIC
            case 0 : c = calcul(c.equatToHeliog()).heliogToEquat(); break; // equatorial
            case 1 : c = calcul(c); break; // heliographic
            case 2 : c = calcul(c.polToHeliog()).heliogToPol(); break; // polar
          }
          break;
        case 2 : switch (jComboBoxSystemPosition.getSelectedIndex()) { // HELIOCENTRIC
            case 0 : c = calcul(c.equatToHelioc()).heliocToEquat(); break; // equatorial
            case 1 : c = calcul(c.heliogToHelioc()).heliocToHeliog(); break; // heliographic
            case 2 : c = calcul(c.polToHelioc()).heliocToPol(); break; // polar
          }
          break;
      }
    }
    catch (NumberFormatException e) { 
      AppIU.setStatus("Coordinate conversion error : "+e.getMessage());
 JOptionPane.showMessageDialog(null, "Cordinate conversion error, see status bar.","Error", JOptionPane.ERROR_MESSAGE);
      System.err.println(e.getMessage());
    }
    jTextFieldScanLongitude.setText( Coordonnees.doubleFormat(c.X) );
    jTextFieldScanLatitude.setText( Coordonnees.doubleFormat(c.Y) );

  }

  private void pointage() {
    try {
      Coordonnees c = new Coordonnees(Double.parseDouble(jTextFieldRegionLongitude.getText()),
	Double.parseDouble(jTextFieldRegionLatitude.getText()));
      String message = "";
      
      switch (jComboBoxSystemPosition.getSelectedIndex()) {
        case 0 : message = Cible.equ(c); break; // equatorial
        case 1 : message = Cible.hlg(c);  break; // heliographic
        case 2 : message = Cible.pos(c); break; // polar
      }

      Communication comm = new Communication(20000,Communication.UCCI);
      String resultat = comm.envoi(message);
    }
    catch (NumberFormatException e) { 
      AppIU.setStatus("Region center coordinate error : "+e.getMessage()); 
 JOptionPane.showMessageDialog(null, "Coordinate error, see status bar.","Error", JOptionPane.ERROR_MESSAGE);
    }
    catch (java.io.IOException e) { 
      AppIU.setStatus("Error while pointing telescope : "+e.getMessage()); 
 JOptionPane.showMessageDialog(null, "pointing error, see status bar.","Error", JOptionPane.ERROR_MESSAGE);
    }
  }

  private void increment() {
    try {
      Coordonnees c = new Coordonnees(Double.parseDouble(jTextFieldXSend.getText()),
        Double.parseDouble(jTextFieldYSend.getText()));
      String message = "";

      switch (jComboBoxSystemIncrement.getSelectedIndex()) {
        case 0 : message = Cible.eqc(c); break; // equatorial
        case 1 : message = Cible.hlc(c);  break; // heliographic
        case 2 : message = Cible.helioc_inc(c); break; // heliocentric
      }

      Communication comm = new Communication(20000,Communication.UCCI);
      String resultat = comm.envoi(message);
    }
    catch (NumberFormatException e) { 
      AppIU.setStatus("Region center coordinate error : "+e.getMessage()); 
 JOptionPane.showMessageDialog(null, "Coordinate error, see status bar.","Error", JOptionPane.ERROR_MESSAGE);
    }
    catch (java.io.IOException e) { 
      AppIU.setStatus("Error while moving telescope : "+e.getMessage()); 
 JOptionPane.showMessageDialog(null, "telescope moving error, see status bar.","Error", JOptionPane.ERROR_MESSAGE);
    }
  }

  private Coordonnees calcul(Coordonnees c) {
    double XInc = Double.parseDouble(jTextFieldXInc.getText());
    double YInc = Double.parseDouble(jTextFieldYInc.getText());
    double largeur = (Integer.parseInt(jTextFieldXNb.getText())-1) * XInc;
    double hauteur = (Integer.parseInt(jTextFieldYNb.getText())-1) * YInc;
    double posY, posX, posY2, posX2;
    double scanningDirection= Cible.getScanningDirection(
      jComboBoxSlitOrientation.getSelectedItem().toString(),
      Float.parseFloat(jTextFieldOrient.getText()),
      jCheckBoxLockSlit.isSelected(),
      Float.parseFloat(jTextFieldScanningDirection.getText()) );

    /*balayage bandes horizontales*/
//    if (jRadioButtonXaxis.isSelected()) { posY = -hauteur/2; posX = -largeur/2; }
    /*balayage bandes verticales*/
//    else { posY = -hauteur/2; posX = -largeur/2; }
    posX = -largeur/2;
    posY = -hauteur/2;

    /* on fait la rotation du repere */
    posX2 = c.X + posX*Math.cos(scanningDirection) - posY*Math.sin(scanningDirection);
    posY2 = c.Y + posX*Math.sin(scanningDirection) + posY*Math.cos(scanningDirection);

    return new Coordonnees (posX2, posY2);
  }

  private void maj_XArcSec() {
    jTextFieldXArcSec.setText( String.valueOf( Integer.parseInt(jTextFieldXNb.getText())
      * Float.parseFloat(jTextFieldXInc.getText()) ) );
    maj_Start();
  }

  private void maj_YArcSec() {
    jTextFieldYArcSec.setText( String.valueOf( Integer.parseInt(jTextFieldYNb.getText())
      * Float.parseFloat(jTextFieldYInc.getText()) ) );
    maj_Start();
  }

  private void maj_NbAcq() {
    int nbA=0;

    nbA = polar.size();
    if (nbA == 0) nbA = 1;

    jTextFieldNbAcq.setText( String.valueOf( 
      Integer.parseInt(jTextFieldXNb.getText())
      * Integer.parseInt(jTextFieldYNb.getText()) 
      * Integer.parseInt(jTextFieldNb.getText()) * nbA) );

    maj_Size();
  }

  private void maj_Size() {
    float size = 0;
    Window win;
    int nb1, nb2;

    switch (((Integer)jComboBoxFitsMode.getSelectedItem()).intValue()) {
      case 1 :
        size = TAILLEIMG;
        break;
      case 2 : /* for (int i=0 ; i<nbWave ; i++)
        if (waveLines[i].jCheckBoxWave.isSelected()){
          win = UserParameters.acquisition.listeWin.getListe()[i];
          size += TAILLEBLOC + win.getNbcol()*win.getNblig();
        }*/
	size = 2*TAILLEBLOC + TAILLEIMG;
        if (polar.size() > 0) size *= polar.size();
        if (jRadioButtonXaxis.isSelected()) {
          nb1 = Integer.parseInt(jTextFieldXNb.getText());
          nb2 = Integer.parseInt(jTextFieldYNb.getText());
        } else {
          nb2 = Integer.parseInt(jTextFieldXNb.getText());
          nb1 = Integer.parseInt(jTextFieldYNb.getText());
        }
        size *= nb1;
	size *= Integer.parseInt(jTextFieldNb.getText());
        if (!jCheckBoxCut.isSelected()) size *= nb2;
        break;
      case 3 : /* for (int i=0 ; i<nbWave ; i++)
        if (waveLines[i].jCheckBoxWave.isSelected()){
          win = UserParameters.acquisition.listeWin.getListe()[i];
          size += win.getNbcol()*win.getNblig(); // difference avec fits2
        }*/
	size = TAILLEBLOC + TAILLEIMG;

        if (polar.size() > 0) size *= polar.size();
        if (jRadioButtonXaxis.isSelected()) {
          nb1 = Integer.parseInt(jTextFieldXNb.getText());
          nb2 = Integer.parseInt(jTextFieldYNb.getText());
        } else {
          nb2 = Integer.parseInt(jTextFieldXNb.getText());
          nb1 = Integer.parseInt(jTextFieldYNb.getText());
        }
        size *= nb1;
	size *= Integer.parseInt(jTextFieldNb.getText());
        if (!jCheckBoxCut.isSelected()) size *= nb2;
        break;
    }
/*
    if (((Integer)jComboBoxFitsMode.getSelectedItem()).intValue()>1) {
      size *= Integer.parseInt(jTextFieldNbAcq.getText());
      if (jCheckBoxCut.isSelected()) size /= Integer.parseInt(jTextFieldYNb.getText());
    }
*/
    size += TAILLEBLOC*4; // entete FITS : environ 4 paquets de 2880o.

    jTextFieldSize.setText(Float.toString(size/1024/1024));
  }

/**
 * Verifie si au moins une fenetre a ete selectionnee.
 **/
  private boolean checkWinSelected() {
    int i;
    for (i=0; (i<nbWave) && (!waveLines[i].jCheckBoxWave.isSelected()); i++);
    if (i == nbWave) {
      AppIU.setStatus("You must select a window.");
 JOptionPane.showMessageDialog(null, "No window selected.","Error", JOptionPane.ERROR_MESSAGE);
      return false;
    }
    else return true;
  }

  private void acquisition() {
    if (!checkWinSelected()) return;
    lostFocus();
    AppIU.setStatus("Launching one acquisition...");
    try {
      ProgObservation.acquisition(UserParameters.observation.tabCibles[targetNumber]);
    }
    catch (Exception e) {
      AppIU.setStatus("Error : "+e.getMessage());
 JOptionPane.showMessageDialog(null, "Acquisition information error"+"\n Call system administrator","Error", JOptionPane.ERROR_MESSAGE);
      System.err.println(e);
    }
  }

  private void startAcq() {
    if (!checkWinSelected()) return;
    lostFocus();
    try {
      if (!cadEnCours) {
        AppIU.setStatus("Launching the acquisition...");
        cadEnCours = true;
	jButtonAcq.setEnabled(false);
        jButtonStAcq.setText("stop acq");
        ProgObservation.startAcq(UserParameters.observation.tabCibles[targetNumber]);
      }
      else {
        cadEnCours = false;
	jButtonAcq.setEnabled(true);
        jButtonStAcq.setText("start acq");
        ProgObservation.stopAcq();
        AppIU.setStatus("Acquisition stopped.");
      }
    }
    catch (Exception e) {
      AppIU.setStatus("Error : "+e.getMessage());
 JOptionPane.showMessageDialog(null, "Acquisition error"+"\n see status bar","Error", JOptionPane.ERROR_MESSAGE);
      System.err.println(e);
    }
  }

  private void jButtonDel_actionPerformed(ActionEvent e) {
    UserParameters.observation.delete(Cible.TARGET, targetNumber );
    if ( targetNumber >= UserParameters.observation.nbCibles )
      targetNumber = UserParameters.observation.nbCibles-1;
    setValues(targetNumber);
  }

  private void jButtonApres_actionPerformed(ActionEvent e) {
    try { getValues(targetNumber); }
    catch(NumberFormatException ee) {
      JOptionPane.showMessageDialog(null, ee.toString(), "Error!", JOptionPane.ERROR_MESSAGE);
      return;
    }
    targetNumber++;
    if ( targetNumber >= UserParameters.observation.NB_TARGET_MAX ) targetNumber = UserParameters.observation.NB_TARGET_MAX-1;
    if ( UserParameters.observation.nbCibles <= targetNumber )
     UserParameters.observation.append(Cible.TARGET);
/*{
      UserParameters.observation.nbCibles = targetNumber+1;
      Cible ancienne = UserParameters.observation.tabCibles[targetNumber-1];
      Cible nouvelle = UserParameters.observation.tabCibles[targetNumber];
      UserParameters.observation.tabCibles[targetNumber] = new Cible(Cible.TARGET);
      UserParameters.observation.tabDarks[targetNumber] = new Cible(Cible.DARK);
      UserParameters.observation.tabFlats[targetNumber] = new Cible(Cible.FLATFIELD);
      nouvelle.fitsMode = ancienne.fitsMode;
      int num;
      for (int i=0 ; i<ListeWindow.NB_MAX_WIN; i++) {
        num = UserParameters.acquisition.listeWin.getWin(i);
        nouvelle.winUsed[num] = true;
        nouvelle.integrationTime[num] = ancienne.integrationTime[num];
      }
    }
*/
    setValues(targetNumber);
  }

  private void jButtonAvant_actionPerformed(ActionEvent e) {
    try { getValues(targetNumber); }
    catch(NumberFormatException ee) {
      JOptionPane.showMessageDialog(null, ee.toString(), "Error!", JOptionPane.ERROR_MESSAGE);
      return;
    }
    targetNumber--;
    if ( targetNumber < 0 ) targetNumber = 0;
    setValues(targetNumber);
  }

  private void jButtonPremier_actionPerformed(ActionEvent e) {
    try { getValues(targetNumber); }
    catch(NumberFormatException ee) {
      JOptionPane.showMessageDialog(null, ee.toString(), "Error!", JOptionPane.ERROR_MESSAGE);
      return;
    }
    targetNumber = 0;
    setValues(targetNumber);
  }

  private void jButtonGetIt_actionPerformed() {
    String resultat = "";
    String longitude = "0";
    String latitude = "0";

    try {
      Communication comm = new Communication(Communication.UCCI);
      resultat = comm.envoiMessage("DA2()", 20000);
    }
    catch (java.io.IOException e) {
      System.err.println("Communication with UCCI is impossible : " + e + "\n");
      return;
    }
//    jTextAreaActionProgram.append(resultat + "\n");
// Pour le format de la chaine renvoyee, voir document "Commandes UCCI", annexeII

    if(resultat.indexOf("Erreur") == -1) {

      try {      

	switch ( sysPos ) {
        case 0 : // equat
          longitude = resultat.substring(67, 74);
          latitude = resultat.substring(75, 82);
          break;
        case 1 : // heliog
          longitude = resultat.substring(49, 57);
          latitude = resultat.substring(58, 66);
          break;
        case 2 : // polar
          longitude = resultat.substring(31, 39);
          latitude = resultat.substring(40, 48);
          break;
	}
	
      }

      catch (java.lang.StringIndexOutOfBoundsException e) {
	  //      jTextAreaActionProgram.append("Format error in the UCCI string : " + e.getMessage() + "\n");
	  return;
	}
      jTextFieldRegionLongitude.setText(longitude);
      jTextFieldRegionLatitude.setText(latitude);
	
      }
      else {
	AppIU.setStatus("Format Error"+resultat);
	JOptionPane.showMessageDialog(null, "Format Error, see Status bar","Error", JOptionPane.ERROR_MESSAGE);
      }
  }

  public void jButtonGetItFlatField_actionPerformed() {
    String resultat = "";
    String longitude;
    String latitude;

    try {
      Communication comm = new Communication(Communication.UCCI);
      resultat = comm.envoiMessage("DA2()", 20000);
    }
    catch (java.io.IOException e) {
      System.err.println("Communication with UCCI is impossible : " + e + "\n");
//      jTextAreaActionProgram.append("Communication with UCCI is impossible : " + e + "\n");
      return;
    }
//    jTextAreaActionProgram.append(resultat + "\n");
// Pour le format de la chaine renvoyee, voir document "Commandes UCCI", annexeII
    if(resultat.indexOf("Erreur") == -1) {
      try {
	longitude = resultat.substring(67, 74);
	latitude = resultat.substring(75, 82);
      }
      catch (java.lang.StringIndexOutOfBoundsException e) {
	//      jTextAreaActionProgram.append("Format error in the UCCI string : " + e.getMessage() + "\n");
	return;
      }

      jTextFieldLongitude.setText(longitude);
      jTextFieldLatitude.setText(latitude);
    }
    else {
      AppIU.setStatus("Format Error"+resultat);
      JOptionPane.showMessageDialog(null, "Format Error, see Status bar","Error", JOptionPane.ERROR_MESSAGE);
    }
  }

  private void jButtonDernier_actionPerformed(ActionEvent e) {
    try { getValues(targetNumber); }
    catch(NumberFormatException ee) {
      JOptionPane.showMessageDialog(null, ee.toString(), "Error!", JOptionPane.ERROR_MESSAGE);
      return;
    }
    targetNumber = UserParameters.observation.nbCibles - 1;
    if ( targetNumber < 0 ) targetNumber = 0;
    setValues(targetNumber);
  }

  private void setValues(int number) {
    Cible cible = UserParameters.observation.tabCibles[number];
    Cible dark = UserParameters.observation.tabDarks[number];
    Cible flatField = UserParameters.observation.tabFlats[number];
    if (cible==null) cible = new Cible(Cible.TARGET);
    if (dark==null) dark = new Cible(Cible.TARGET);
    if (flatField==null) flatField = new Cible(Cible.TARGET);

    if (UserParameters.observation.nbCibles==0)
      jTextField20.setText("0 of 0");
    else
      jTextField20.setText(Integer.toString(number+1)+" of "+Integer.toString(UserParameters.observation.nbCibles));

  // definitions
    jComboBoxMode.setSelectedItem((String)cible.instrume.getValeur());
    jComboBoxFitsMode.setSelectedItem(new Integer(cible.fitsMode));
    jComboBoxIdNumber.setSelectedItem(cible.obj_id.getValeur().toString());
    jTextFieldCustomName.setText(cible.customName);
    jComboBoxObjectName.setSelectedItem(cible.object.getValeur().toString());
    jTextAreaComment.setText((String)cible.comment.getValeur());
    jComboBoxObsMode.setSelectedItem((String)cible.obs_mode.getValeur());

  // target position
    sysPos = 0;
    jComboBoxSystemPosition.setSelectedItem(cible.systemPosition);
    jTextFieldRegionLatitude.setText(cible.latirc.getValeur().toString());
    jTextFieldRegionLongitude.setText(cible.longtrc.getValeur().toString());

  // data file size
    jCheckBoxCut.setSelected(cible.cut);

  // polarization settings
    boolean noanalyzer = UserParameters.paramFits.getKeyword("ANALYS").getValeur().toString().equals("NOANALYZER");
    if (noanalyzer) {
	System.out.println("[TargetsPanel:setValues] Cible "+number+" No analyser !!!");
	jTextFieldSequence.setText("");}
    else {jTextFieldSequence.setText(cible.sequence.getValeur().toString());
System.out.println("[TargetsPanel:setValues] Cible "+number+" sequence "+cible.sequence.getValeur().toString());	
	}
    if (jComboBoxPolar != null) jComboBoxPolar.setEnabled(!noanalyzer);
    jButtonAdd.setEnabled(!noanalyzer);
    jButtonResetAll.setEnabled(!noanalyzer);
    polar = cible.polar;

  // scan parameters
    jTextFieldScanLatitude.setText(cible.latstart.getValeur().toString());
    jTextFieldScanLongitude.setText(cible.lngstart.getValeur().toString());
    jTextFieldXNb.setText(cible.nbstep_x.getValeur().toString());
    jTextFieldXInc.setText(cible.step_x.getValeur().toString());
    jTextFieldYNb.setText(cible.nbstep_y.getValeur().toString());
    jTextFieldYInc.setText(cible.step_y.getValeur().toString());
    jTextFieldScanningDirection.setText(Float.toString(cible.scanningDirection));
    jComboBoxSystemIncrement.setSelectedItem(cible.syscoord.getValeur().toString());
    jComboBoxSlitOrientation.setSelectedItem(cible.slitOrientation);
    jTextFieldOrient.setText(cible.angle.getValeur().toString());
    jCheckBoxLockSlit.setSelected(cible.lockSlit);
    jRadioButtonXaxis.setSelected(cible.Xaxis);
//    jRadioButtonYaxis.setSelected(!cible.Xaxis);
    jTextFieldNb.setText(Integer.toString(cible.nbAcq));

  // used wavelength
    int num;
    String tps;
    for (int i = 0 ; i < nbWave ; i++) {
      num = UserParameters.acquisition.listeWin.getWin(i);
      if (cible.integrationTime[num]==-1) tps = "300";
      else tps = Integer.toString(cible.integrationTime[num]);
      waveLines[ i ].jTextFieldTime.setText(tps);
      waveLines[ i ].jCheckBoxWave.setSelected(cible.winUsed[num]);
      checkIntgTime(waveLines[i].jTextFieldTime);
    }
  // dark current

    jRadioButtonAll.setSelected(!dark.closeSpectro);
    jRadioButtonSpectro.setSelected(dark.closeSpectro);
    jTextFieldShots.setText(Integer.toString(dark.nbacquisition));

  // flat field

    jTextFieldAngle.setText(Integer.toString(flatField.ang));
    jTextFieldHaxis.setText(Integer.toString(flatField.h));
    jTextFieldLaxis.setText(Integer.toString(flatField.l));
    jTextFieldLatitude.setText(flatField.latirc.getValeur().toString());
    jTextFieldLongitude.setText(flatField.longtrc.getValeur().toString());
    jTextFieldNumberOfCycles.setText(Integer.toString(flatField.nbacquisition));

  // maj des valeurs calculees automatiquement
    maj_XArcSec();
    maj_YArcSec();
    maj_NbAcq();
  }

  private void getValues(int number) {
    if (number>UserParameters.observation.nbCibles) {
      UserParameters.observation.tabCibles[number] = new Cible(Cible.TARGET);
      UserParameters.observation.tabDarks[number] = new Cible(Cible.DARK);
      UserParameters.observation.tabFlats[number] = new Cible(Cible.FLATFIELD);
    }
    Cible cible = UserParameters.observation.tabCibles[number];

  // definitions
    cible.instrume.setValeur((String)jComboBoxMode.getSelectedItem());
    cible.fitsMode = ((Integer)jComboBoxFitsMode.getSelectedItem()).intValue();
    cible.obj_id.setValeur(jComboBoxIdNumber.getSelectedItem().toString());
    cible.customName = jTextFieldCustomName.getText();
    cible.object.setValeur(jComboBoxObjectName.getSelectedItem().toString());
    cible.comment.setValeur(jTextAreaComment.getText());
    cible.obs_mode.setValeur(jComboBoxObsMode.getSelectedItem().toString());

  // target position
    cible.systemPosition = jComboBoxSystemPosition.getSelectedItem().toString();
    cible.longtrc.setValeur(jTextFieldRegionLongitude.getText());
    cible.latirc.setValeur(jTextFieldRegionLatitude.getText());

  // data file size
    cible.cut = jCheckBoxCut.isSelected();

  // polarization settings
    cible.sequence.setValeur(jTextFieldSequence.getText());
    cible.polar = polar;
System.out.println("[TargetsPanel.setValue] polar="+polar);

  // scan parameters
    
    cible.nbstep_x.setValeur(jTextFieldXNb.getText().toString());
    cible.step_x.setValeur(jTextFieldXInc.getText().toString());
    cible.nbstep_y.setValeur(jTextFieldYNb.getText().toString());
    cible.step_y.setValeur(jTextFieldYInc.getText().toString());
    cible.scanningDirection = Float.parseFloat(jTextFieldScanningDirection.getText());
    cible.syscoord.setValeur(jComboBoxSystemIncrement.getSelectedItem().toString());
    cible.slitOrientation = jComboBoxSlitOrientation.getSelectedItem().toString();
    cible.angle.setValeur(jTextFieldOrient.getText().toString());
    cible.lockSlit = jCheckBoxLockSlit.isSelected();
    cible.Xaxis = jRadioButtonXaxis.isSelected();
    //Au cas ou pas de focusLost sur un composant, il faut quand meme valider
    maj_NbAcq();
    maj_XArcSec();
    maj_YArcSec();
    cible.nbacquisition = Integer.parseInt(jTextFieldNbAcq.getText());
System.out.println("**TargetsPanel:getValue recupere nbacq"+jTextFieldNbAcq.getText());
    cible.nbAcq = Integer.parseInt(jTextFieldNb.getText());

    cible.lngstart.setValeur(jTextFieldScanLongitude.getText().toString());
    cible.latstart.setValeur(jTextFieldScanLatitude.getText().toString());

  // used wavelength
    int num;
    for (int i = 0 ; i < nbWave ; i++) {
      num = UserParameters.acquisition.listeWin.getWin(i);
      cible.winUsed[num] = waveLines[ i ].jCheckBoxWave.isSelected();
      cible.integrationTime[num] = Integer.parseInt(waveLines[ i ].jTextFieldTime.getText());
    }

  // dark current
    Cible dark = UserParameters.observation.tabDarks[number];
//    dark.closeAll = jRadioButtonAll.isSelected();
    dark.closeSpectro = jRadioButtonSpectro.isSelected();
    dark.nbacquisition = Integer.parseInt(jTextFieldShots.getText());
    dark.fitsMode = ((Integer)jComboBoxFitsMode.getSelectedItem()).intValue();
    dark.customName = jTextFieldCustomName.getText();
    for (int i = 0 ; i < nbWave ; i++) {
      num = UserParameters.acquisition.listeWin.getWin(i);
      dark.winUsed[num] = waveLines[ i ].jCheckBoxWave.isSelected();
      dark.integrationTime[num] = Integer.parseInt(waveLines[ i ].jTextFieldTime.getText());
    }

  // flat field
    Cible flatField = UserParameters.observation.tabFlats[number];
    flatField.ang = Integer.parseInt(jTextFieldAngle.getText());
    flatField.h = Integer.parseInt(jTextFieldHaxis.getText());
    flatField.l = Integer.parseInt(jTextFieldLaxis.getText());
    flatField.latirc.setValeur(jTextFieldLatitude.getText());
    flatField.longtrc.setValeur(jTextFieldLongitude.getText());
    flatField.nbacquisition = Integer.parseInt(jTextFieldNumberOfCycles.getText());
    flatField.customName = jTextFieldCustomName.getText();
    flatField.sequence.setValeur(jTextFieldSequence.getText());
    flatField.loopAnalyser = jTextFieldSequence.getText();
    flatField.polar = polar;
    flatField.slitOrientation = jComboBoxSlitOrientation.getSelectedItem().toString();
    flatField.fitsMode = ((Integer)jComboBoxFitsMode.getSelectedItem()).intValue();
    for (int i = 0 ; i < nbWave ; i++) {
      num = UserParameters.acquisition.listeWin.getWin(i);
      flatField.winUsed[num ] = waveLines[ i ].jCheckBoxWave.isSelected();
      flatField.integrationTime[num] = Integer.parseInt(waveLines[ i ].jTextFieldTime.getText());
    }
  }

  public void gainedFocus() {
//    UserParameters.paramTargets.GetTargetsFromCibles();
//    UserParameters.paramDark.getDarksFromCibles();
//    UserParameters.paramFlatField.getFlatsFromCibles();
    initJComboBoxPolar();
    jPanel17.removeAll();
    litWave();
    jPanel8.validate();
    setValues(targetNumber);
  }

  public void lostFocus() throws NumberFormatException {
    getValues(targetNumber);
  }

  private void litWave() {
    int i;
    String[] waveString = UserParameters.acquisition.listeWin.getWaveString();
    Cible cible = UserParameters.observation.tabCibles[ targetNumber ];

    int num;
    for (i = 0 ; i < UserParameters.acquisition.listeWin.getNbWin() ; i++) {
      num = UserParameters.acquisition.listeWin.getWin(i);
      waveLines[i] = new WaveLine(cible.winUsed[num], waveString[i],
                                  cible.integrationTime[num]);
      jPanel17.add((JPanel)waveLines[i], new GridBagConstraints(0, i, 1, 1, 0.0, 0.0
              ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
      JTextField jtf = waveLines[i].jTextFieldTime;
      jtf.addFocusListener(new java.awt.event.FocusAdapter() {
        public void focusLost(FocusEvent e) { checkIntgTime(e.getComponent()); }
      });
      jtf.setInputVerifier(new Verif(Verif.TYPEINT,0));
      waveLines[i].jCheckBoxWave.addItemListener(new java.awt.event.ItemListener() {
        public void itemStateChanged(ItemEvent e) { maj_Size(); }
      });
   }

    jPanel17.add(jPanel20, new GridBagConstraints(0, i, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    nbWave = i;
  }

/**
 * Cette fonction s'assure :
 * - qu'il n'y a pas des temps d'int\uFFE9gration diff\uFFE9rents pour un m\uFFEAme
 * obturateur. Remarque : des cam\uFFE9ras diff\uFFE9rentes peuvent avoir le
 * m\uFFEAme obturateur.
 * - tintg > 300 pour l'obtu 7 et > 10 pour les autres.
 * Cette fonction est appel\uFFE9 d\uFFE8s qu'un jTextFieldTime perd le focus.
 */
  private void checkIntgTime(Component c) {
    int i;
    int obtu1 = 0, obtu2 = 0;
    int time1 = Integer.parseInt( ((JTextField)c).getText() ), time2 = 0;

  // on r\uFFE9cup\uFFE8re le num\uFFE9ro de waveline = le num\uFFE9ro de cam\uFFE9ra
    for (i = 0 ; i < nbWave ; i++)
      if (waveLines[i].jTextFieldTime == c) break;
    obtu1 = UserParameters.acquisition.listeCam.getListe()
      [UserParameters.acquisition.listeWin.getListe()[i].getCam()]
      .numShutter.intValue();

    if (time1 < 10) time1 = 10;
    if ((obtu1 == 7) && (time1 < 300)) time1=300;

  // boucle : si on trouve une autre cam\uFFE9ra avec le m\uFFEAme obturateur, on v\uFFE9rifie le temps
    for (int j = 0; j < nbWave ; j++) {
      obtu2 = UserParameters.acquisition.listeCam.getListe()[
        UserParameters.acquisition.listeWin.getListe()[j].getCam()]
        .numShutter.intValue();
      if (obtu1 == obtu2) {
        time2 = Integer.parseInt(waveLines[j].jTextFieldTime.getText());
        if (time2 != time1)
          waveLines[j].jTextFieldTime.setText(Integer.toString(time1));
      }
    }
  }

/*
  void jCheckBoxCadenced_stateChanged() {
    boolean v = jCheckBoxCadenced.isSelected();
    boolean f = ( (Integer)jComboBoxFitsMode.getSelectedItem() ).intValue() == 3 ;

    jTextFieldAcquisition.setEnabled(v || f);
    jTextFieldCadenceTime.setEnabled(v);
  }
*//*
  void jComboBoxFitsMode_stateChanged() {
    jCheckBoxCadenced_stateChanged();
  }
*/
/*
  void jComboBoxLoopAnalyser_itemStateChanged() {
    maj_NbAcq();

    String cara = " ";
    String seq = jTextFieldSequence.getText();
//System.out.println("[TargetsPanel.jComboBoxLoopAnalyser_itemStateChanged]");

    for (int i=0; i<seq.length(); i++) {
      //  si le caractere est '-' suivi d'un caractere : on passe au caractere suivant
      if (String.valueOf(seq.charAt(i)).equals("-") && (i+1<seq.length())) i++;
      cara = String.valueOf(seq.charAt(i));
      // si le caractere n'est ni Q, ni U, ni V
      if (!(cara.equals("Q") || cara.equals("U") || cara.equals("V"))) {
        // alors : erreur de format
//        jComboBoxLoopAnalyser.requestFocus();
        JOptionPane.showMessageDialog(null, "The character "+cara+" is not allowed. "
          +"The string can only contain the following : 'Q, 'U', 'V, '-Q', '-U', '-V'.",
          "Format error", JOptionPane.ERROR_MESSAGE);
        return;
      }
    }
//    jComboBoxLoopAnalyser.setSelectedItem(seq);
  }
*/
  void jComboBoxSlitOrientation_itemStateChanged() {
    jTextFieldOrient.setEnabled(false);
    jCheckBoxLockSlit.setEnabled(true);
    switch ( jComboBoxSlitOrientation.getSelectedIndex() ) {
      case 0 : // celestial N
        jComboBoxSystemIncrement.setSelectedIndex( 0 ); // EQUATORIAL
        break;
      case 1 : // solar N
        if (jComboBoxSystemIncrement.getSelectedIndex() != 2) // HELIO*IC
          jComboBoxSystemIncrement.setSelectedIndex(1);
        break;
      case 2 : // zenith
        jComboBoxSystemIncrement.setSelectedIndex( 0 ); // EQUATORIAL
/*        jComboBoxSystemIncrement.setSelectedIndex( 0 ); // AZIMUTHAL
        jCheckBoxLockSlit.setSelected(true);
        jCheckBoxLockSlit.setEnabled(false);*/
        break;
      case 3 : // celestial equator
        jComboBoxSystemIncrement.setSelectedIndex( 0 ); // EQUATORIAL
        break;
      case 4 : // solar equator
        if (jComboBoxSystemIncrement.getSelectedIndex() != 2) // HELIO*IC
          jComboBoxSystemIncrement.setSelectedIndex(1);
        break;
      case 5 : // tangential
        jComboBoxSystemIncrement.setSelectedIndex( 0 ); // EQUATORIAL
        jCheckBoxLockSlit.setEnabled(false);
        jCheckBoxLockSlit.setSelected(true);
        break;
      case 6 : // radial
        jComboBoxSystemIncrement.setSelectedIndex( 0 ); // EQUATORIAL
        jCheckBoxLockSlit.setEnabled(false);
        jCheckBoxLockSlit.setSelected(true);
        break;
      case 7 : // other
        jComboBoxSystemIncrement.setSelectedIndex( 0 ); // EQUATORIAL
        jTextFieldOrient.setEnabled(true);
        break;
    }
    maj_Start();
  }

  void jCheckBoxLockSlit_itemStateChanged(ItemEvent e) {
    if (e.getStateChange()==ItemEvent.SELECTED)
      jTextFieldScanningDirection.setEnabled(false);
    else jTextFieldScanningDirection.setEnabled(true);
    maj_Start();
  }

  void jComboBoxSystemIncrement_itemStateChanged() {
    int newSysInc = jComboBoxSystemIncrement.getSelectedIndex();

    switch ( newSysInc ) {
      case 0 : // EQUATORIAL
        jLabelStepX.setText("X");
        jLabelStepY.setText("Y");
	jLabelUnite.setText("(arcsec)");
        int i=jComboBoxSlitOrientation.getSelectedIndex();
        if ((i!=3)&&(i!=5)&&(i!=6)&&(i!=7))
          jComboBoxSlitOrientation.setSelectedIndex( 0 );
        break;
/*      case 1 : // AZIMUTHAL
        jLabelStepX.setText("azimuth");
        jLabelStepY.setText("elevation");
	jLabelUnite.setText("(arcsec)");
        jComboBoxSlitOrientation.setSelectedIndex( 2 ); // zenith
        break;*/
      case 1 : // HELIOGRAPHIC
        jLabelStepX.setText("longitude");
        jLabelStepY.setText("latitude");
	jLabelUnite.setText("(deg)");
        if (jComboBoxSlitOrientation.getSelectedIndex() != 4)
          jComboBoxSlitOrientation.setSelectedIndex( 1 ); // solar *
        break;
      case 2 : // HELIOCENTRIC
        jLabelStepX.setText("Xh");
        jLabelStepY.setText("Yh");
	jLabelUnite.setText("(arcsec)");
        if (jComboBoxSlitOrientation.getSelectedIndex() != 4)
          jComboBoxSlitOrientation.setSelectedIndex( 1 ); // solar *
        break;
    }

/*    jTextFieldXInc.setText("0.0");
    jTextFieldYInc.setText("0.0");
    jTextFieldXArcSec.setText("0.0");
    jTextFieldYArcSec.setText("0.0");
    jTextFieldNbAcq.setText("0");*/
    sysInc = newSysInc;
    maj_Start();
  }

  void jComboBoxSystemPosition_itemStateChanged() {
    int newSysPos = jComboBoxSystemPosition.getSelectedIndex();
    Coordonnees C = new Coordonnees(0, 0);
    try { C = new Coordonnees(Double.parseDouble(jTextFieldRegionLongitude.getText()),
      Double.parseDouble(jTextFieldRegionLatitude.getText())); }
    catch(NumberFormatException e) {
      JOptionPane.showMessageDialog(null, "Format error : numeric value expected.\n"
        + e.getMessage(), "Error !", JOptionPane.ERROR_MESSAGE);
    }
    Coordonnees N = C;

    try {
      switch ( newSysPos ) {
        case 0 : //equat
          jLabelLongitude.setText("X");
          jLabelLatitude.setText("Y");
          if (sysPos == 1) N = C.heliogToEquat();
          else if (sysPos == 2) N = C.polToEquat();
	  jTextFieldRegionLongitude.setInputVerifier(new Verif(Verif.TYPEFLOAT,-1500,1500));
	  jTextFieldRegionLatitude.setInputVerifier(new Verif(Verif.TYPEFLOAT,-1500,1500));
          break;
        case 1 : //heliog
/*          if ((C.X<-90) || (C.X>90))
            throw new ArithmeticException("Latitude must be in [-90,+90]");
          if ((C.Y<0) || (C.Y>360))
            throw new ArithmeticException("Longitude must be in [0,+360]");*/
          if (sysPos == 0) N = C.equatToHeliog();
          else if (sysPos == 2) N = C.polToHeliog();
          jLabelLatitude.setText("latitude");
          jLabelLongitude.setText("longitude");
	  jTextFieldRegionLongitude.setInputVerifier(new Verif(Verif.TYPEFLOAT,0,360));
	  jTextFieldRegionLatitude.setInputVerifier(new Verif(Verif.TYPEFLOAT,-90,90));
          break;
        case 2 : //polar
          jLabelLongitude.setText("angle");
          jLabelLatitude.setText("radius");
          if (sysPos == 0) N = C.equatToPol();
          else if (sysPos == 1) N = C.heliogToPol();
	  jTextFieldRegionLongitude.setInputVerifier(new Verif(Verif.TYPEFLOAT,0,360));
	  jTextFieldRegionLatitude.setInputVerifier(new Verif(Verif.TYPEFLOAT,-1000,200));
          break;
      }
//System.out.println("[TargetsPanel.jComboBoxSystemPosition_itemStateChanged] X="+N.X+", Y="+N.Y);
      jTextFieldRegionLongitude.setText(Coordonnees.doubleFormat(N.X));
      jTextFieldRegionLatitude.setText(Coordonnees.doubleFormat(N.Y));

//      maj_Start();
      sysPos = newSysPos;
    }
    catch(ArithmeticException e) {
      System.err.println(e.getMessage());
      AppIU.setStatus("Coordinate error : "+e.getMessage());
 JOptionPane.showMessageDialog(null, "Coordinate error, see status bar.","Error", JOptionPane.ERROR_MESSAGE);
      jComboBoxSystemPosition.setSelectedIndex(sysPos);
    }
  }
/*
  void jButtonResetAll_actionPerformed(ActionEvent e) {
    jTextFieldSequence.setText("");
  }*/

  void jButtonAdd_actionPerformed() {
    polar.add(jComboBoxPolar.getSelectedItem());
    jTextFieldSequence.setText(jTextFieldSequence.getText()
      +jComboBoxPolar.getSelectedItem()+" | ");
    maj_NbAcq();
  }
/*  void jButtonAnalyser_actionPerformed(String polari) {
    jTextFieldSequence.setText(jTextFieldSequence.getText()+polari);
    maj_NbAcq();
  }*/

/*  void jButtonQ_actionPerformed(ActionEvent e) {
    jTextFieldSequence.setText(jTextFieldSequence.getText()+"Q");
  }
  void jButtonQ2_actionPerformed(ActionEvent e) {
    jTextFieldSequence.setText(jTextFieldSequence.getText()+"-Q");
  }
  void jButtonU_actionPerformed(ActionEvent e) {
    jTextFieldSequence.setText(jTextFieldSequence.getText()+"U");
  }
  void jButtonU2_actionPerformed(ActionEvent e) {
    jTextFieldSequence.setText(jTextFieldSequence.getText()+"-U");
  }
  void jButtonV2_actionPerformed(ActionEvent e) {
    jTextFieldSequence.setText(jTextFieldSequence.getText()+"-V");
  }
  void jButtonV_actionPerformed(ActionEvent e) {
    jTextFieldSequence.setText(jTextFieldSequence.getText()+"V");
  }*/
  void jButtonGetItFromTracking_actionPerformed(ActionEvent e) {

  }
}
