/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Minec-Debin
 * @version 1.0
 */
package iu;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.text.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.AbstractTableModel;
import javax.swing.filechooser.*;



public class SequencePanel extends JPanel {


  static public String DATAPATH = "/data/themis/";
  //  static public String DATAPATH = "/scratch/miguel/projets/io103/test/";
  static public String FILESAVE = "listsave.txt";
  static public String RUNSAVE  = "/home/backup/link_copy_new ";
  static int FILESIZE = 38;
  static long TAILLE_MAX_SELECTED = 8000000;
  long tailleSelected;

  JButton jButtonSave = new JButton("Save sequence");
  JButton jButtonDestroy = new JButton("Destroy sequence");

  JLabel jLabelSelection = new JLabel("Total selection size (kb): ");
  JLabel jLabelTotalSize = new JLabel("0");

  JPanel utilityPanel = new JPanel();
  JPanel jPanelSequences = new JPanel();
  BorderLayout borderLayoutThis = new BorderLayout();
  JScrollPane jScrollPaneSequences = new JScrollPane();

  JTable jTableSequences;  

  
  GridBagLayout gridBagLayoutSequences = new GridBagLayout();
  GridBagLayout gridBagLayoutUtil = new GridBagLayout();
  SequenceTableModel sequenceTableModel;

  int selectedRows[];
  private File listFiles[];
  private ArrayList listSequence ;
  

  public SequencePanel() {
    try { jbInit(); }
    catch(Exception e) { e.printStackTrace(); }
  }

  private void jbInit() throws Exception {
    initComponents();


    jPanelSequences.setLayout(gridBagLayoutSequences);
    this.setLayout(borderLayoutThis);



    jPanelSequences.add(jScrollPaneSequences, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0,
 GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    this.add(jPanelSequences, BorderLayout.CENTER);


    utilityPanel.setLayout(gridBagLayoutUtil);

    utilityPanel.add(jLabelSelection, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0,
 GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5,5,5,5), 0, 0));
    utilityPanel.add(jLabelTotalSize, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0,
 GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5,5,5,5), 0, 0));
    utilityPanel.add(jButtonDestroy, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0,
 GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5,5,5,5), 0, 0));
    utilityPanel.add(jButtonSave, new GridBagConstraints(3, 2, 1, 2, 1.0, 1.0,
 GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5,5,5,5), 0, 0));

    this.add(utilityPanel, BorderLayout.SOUTH);
  }

  private void initComponents() {
    int ligne,i;
    listFiles = FileSystemView.getFileSystemView().getFiles(new File(SequencePanel.DATAPATH),true);
    

    setSequence();
    sequenceTableModel = new SequenceTableModel();

    setTable();



    jTableSequences = new JTable(sequenceTableModel) {
      public void valueChanged(ListSelectionEvent e) {
	int i;

	Long longTmp;
        repaint();
        if(!e.getValueIsAdjusting()) {
	  // System.out.println("First Line is "+e.getFirstIndex()+"->"+e.toString());
	
	  try {
	    selectedRows =  jTableSequences.getSelectedRows(); 
 	    tailleSelected = 0;
	    for (i=0;i<selectedRows.length;i++) {
	      longTmp = (Long) sequenceTableModel.data[selectedRows[i]][3];
	      tailleSelected +=  longTmp.longValue();
	    }
	    jLabelTotalSize.setText(" "+tailleSelected);
	
	  }
	  catch(Exception exc) { /*exc.printStackTrace();*/ }
	}}};

    jTableSequences.getColumnModel().getColumn(0).setPreferredWidth(50);
    jTableSequences.getColumnModel().getColumn(1).setPreferredWidth(50);
    jTableSequences.getColumnModel().getColumn(2).setPreferredWidth(180);


    jButtonSave.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { 
        if (jTableSequences.getSelectedRow() != -1)
          save();
        else JOptionPane.showMessageDialog(null, "No line selected.",
					   "Error", JOptionPane.ERROR_MESSAGE);
      }
    });
    

    jButtonDestroy.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { 
        if (jTableSequences.getSelectedRow() != -1)
          destroy();
        else JOptionPane.showMessageDialog(null, "No line selected.",
					   "Error", JOptionPane.ERROR_MESSAGE);
      }
    });

    jScrollPaneSequences.getViewport().add(jTableSequences, null);
  }

  private void setTable() {

    SequenceObs sequenceTmp; 

    for ( int i = 0 ; i < listSequence.size(); i++ ) {

      sequenceTmp = (SequenceObs) listSequence.get(i);
      sequenceTableModel.data[ i ][ 0 ] = new String(sequenceTmp.getDate());
      sequenceTableModel.data[ i ][ 1 ] = new Integer(sequenceTmp.getNum());
      sequenceTableModel.data[ i ][ 2 ] = new Integer(sequenceTmp.getNbfiles());
      sequenceTableModel.data[ i ][ 3 ] = new Long(sequenceTmp.getSize());
      if (sequenceTmp.getMode().equals("sp"))
	sequenceTableModel.data[ i ][ 4 ] = new String("SPECTRA");
      if (sequenceTmp.getMode().equals("ip"))
	sequenceTableModel.data[ i ][ 4 ] = new String("IPM");
    }
  
    //sequenceTableModel.init(sequenceTableModel.nbRow-1);
    sequenceTableModel.fireTableDataChanged();
  }
 
  // Tri la liste des sequences par date et par sequence (ordre croissant)

  private void triSequence() {

    SequenceObs sequenceTmp,sequence1,sequence2;
    int i,j;
    //Classe les dates;

    for (i=0; i<listSequence.size(); i++) {
      for (j=i+1; j<listSequence.size(); j++) {

	sequence1 = (SequenceObs) listSequence.get(j);
	sequence2 = (SequenceObs) listSequence.get(i);

	if(sequence1.getDate().compareTo(sequence2.getDate()) > 0) {
	  sequenceTmp = (SequenceObs) listSequence.remove(j);
	  listSequence.add(i,sequenceTmp);
	}
      }
    }

    for(i =0; i<listSequence.size(); i++) {
      for(j=i+1; j<listSequence.size(); j++) {

	sequence1 = (SequenceObs) listSequence.get(j);
	sequence2 = (SequenceObs) listSequence.get(i);

	if((sequence1.getDate().equals(sequence2.getDate()))&&
	   (sequence1.getNum() > sequence2.getNum())) {
	  sequenceTmp = (SequenceObs) listSequence.remove(j);
	  listSequence.add(i,sequenceTmp);
	}
      }
    }
    
  }

  /*Rempli la liste list Sequence avec les objets sequence documentes */

  private void setSequence() {
	
    int i,j,numseq;
    boolean sequencePresente;
    File fileNow;
    String nameFile;
    SequenceObs sequenceobs;
    listSequence = new ArrayList();



    for(i=0;i<listFiles.length;i++) {
	
      fileNow = listFiles[i];
      nameFile = new String(fileNow.getName());


      if((fileNow.isFile())&&
	 (nameFile.length() == FILESIZE)&&
	 (nameFile.charAt(0) == 't')) {

	numseq = Integer.parseInt(nameFile.substring(1,4));

	if(!listSequence.isEmpty()) {

	  j=0;
	  sequencePresente =false;

	  while(j<listSequence.size()) {
			
	    sequenceobs = (SequenceObs) listSequence.get(j);
	    if((sequenceobs.getNum() == numseq)&&
	       (sequenceobs.getDate().equals(nameFile.substring(14,22)))){
	      sequenceobs.setAddTaille(fileNow.length());
	      j=listSequence.size();
	      sequencePresente =true;
	    }
	    j++;
	  } 	
	  if(!sequencePresente) {
	    /* nouvelle sequence */

      //
      //File newListFiles [ ];
      //newListFiles = new File [ newNbfiles ];
	    listSequence.add(new SequenceObs(numseq,1,fileNow.length(),nameFile.substring(11,13),nameFile.substring(14,22)));
		       	 
	  }
	}
	else {
	  listSequence.add(new SequenceObs(numseq,1,fileNow.length(),nameFile.substring(11,13),nameFile.substring(14,22)));


	}
      }
    }
  }

  private void save() {
    int i;
    SequenceObs sequenceobs;
    File fileSave;
    FileWriter fileWrite;

    fileSave = new File(DATAPATH+FILESAVE);

    
    try{
                     
      if( Long.parseLong(jLabelTotalSize.getText().trim()) > TAILLE_MAX_SELECTED ) {
	JOptionPane.showMessageDialog(null, "Total size must be < 8 000 000 kb",
				      "Error", JOptionPane.ERROR_MESSAGE);
      }
      else {

	if (JOptionPane.showConfirmDialog(null, "The sequence(s) selected will be "
					  +"saved on Exabyte tape. make sure the tapes are in the drives.", 
					  "Warning !",  JOptionPane.YES_NO_OPTION,
					  JOptionPane.WARNING_MESSAGE) == JOptionPane.YES_OPTION)
	    
	  {

	    try{
	      fileWrite = new FileWriter(fileSave);       
	      for(i=0;i<selectedRows.length;i++) {
		sequenceobs = (SequenceObs) listSequence.get(selectedRows[i]);
		// Ecrit les noms de fichiers dans un fichier liste
		sequenceobs.save(fileWrite);  
		fileWrite.flush();		   
	      }
	      Runtime.getRuntime().exec(RUNSAVE+DATAPATH+FILESAVE);
	    }
	    catch(Exception exc) {
	      exc.printStackTrace();
	    }
	  } 
      }
	
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }


  private void destroy() {
    int i;
    SequenceObs sequenceobs;

    if (JOptionPane.showConfirmDialog(null, "The sequence(s) selected will be "
				      +"permenently deleted. Please confirm.", 
				      "Warning !",  JOptionPane.YES_NO_OPTION,
				      JOptionPane.WARNING_MESSAGE) == JOptionPane.YES_OPTION) 
      {
      
      for(i=0;i<selectedRows.length;i++) {
	sequenceobs = (SequenceObs) listSequence.get(selectedRows[i]);
	sequenceobs.delete();      
      }  



      i=selectedRows.length-1;

      while(i>=0) {

	listSequence.remove(selectedRows[i]);	  	

	i--;
      }

      sequenceTableModel = new SequenceTableModel();
      setTable();        
      jTableSequences.setModel(sequenceTableModel);
      repaint();
    }
  }


  public void gainedFocus() {
    File fileSave;
    fileSave = new File(DATAPATH+FILESAVE);

    listFiles = FileSystemView.getFileSystemView().getFiles(new File(SequencePanel.DATAPATH),true);
    setSequence();
    triSequence();
    sequenceTableModel = new SequenceTableModel();
    setTable();
    jTableSequences.setModel(sequenceTableModel);
    repaint();
    try {
      if(fileSave.exists()) 
	jButtonSave.setEnabled(false);	      
      else
	jButtonSave.setEnabled(true);

    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  public void lostFocus()  {}


  /*********************************************************************/
  /* Classe SequenceObs pour regrouper les informations d'une sequence */



  private class SequenceObs {

    private int num,nbfiles;
    long tailleTotale;
    private String mode,date;
    
    SequenceObs() {
      num=0;
      nbfiles=0;
      tailleTotale=0;
      mode = new String();
      date = new String();
    }

    SequenceObs(int num, int nbfiles,long tailleTotale, String mode, String date) {
      this.tailleTotale = tailleTotale;
      this.nbfiles = nbfiles;
      this.num=num;
      this.mode = new String(mode);
      this.date = new String(date);
    }

    /* delete all the files of the sequence*/
    void delete() {
      int i,j=0;
      String nameFile;

      int newNbfiles = listFiles.length - nbfiles;
      
      File newListFiles [ ];
      newListFiles = new File [ newNbfiles ];


      for (i=0;i<listFiles.length;i++) {
	nameFile = listFiles[i].getName();

	if((nameFile.length() == FILESIZE)&&
	   (nameFile.charAt(0) == 't')&&
	   (num == Integer.parseInt(nameFile.substring(1,4)))&&
	   (date.equals(nameFile.substring(14,22))) )
	  { listFiles[i].delete(); }
	else
	  /** acutalise la liste des fichiers */
	{ newListFiles[j]=listFiles[i];
	 j++;}
      }
      listFiles= newListFiles;
    }
    void save(FileWriter fileW) {
      int i;
      long sizeFile;
      String ls = "-rwxr-xr-x   2 obs obs ";
      String ls2 = " Apr 10 13:01 ";
      String nameFile;

      try {
	for(i=0;i<listFiles.length;i++) {
	  nameFile = listFiles[i].getName();

	  if((nameFile.length() == FILESIZE)&&
	     (nameFile.charAt(0) == 't')&&
	     (num == Integer.parseInt(nameFile.substring(1,4)))&&
	     (date.equals(nameFile.substring(14,22))))
	    { 	  fileW.write(ls+listFiles[i].length()+ls2+nameFile+"\n"); }

	}
      }
      catch(Exception e) {
	e.printStackTrace();
      }
    }

    void setAddTaille(long taille) {
      this.tailleTotale += taille;
      this.nbfiles++;
    }

    int getNbfiles() { return nbfiles; }
    int getNum() { return num; }
    // Taille en kb
    long getSize() { return tailleTotale/1024; }
    String getMode() { return mode; }
    String getDate() { return date; }	
  }





  /*********************************************************************/
  /* Classe sequenceTablePanel pour utiliser l'interface ListSelection */
  
  

  private class SequenceTableModel extends AbstractTableModel {

    final String[] columnNames = { "Date", "Sequence nb", "Number of files", "size (kb)", "Mode"};

    private int nbRow;
    public Object[][] data;

    SequenceTableModel() {
      super();

      nbRow = listSequence.size();

      data = new Object[ nbRow ][ 5 ];

      for (int i = 0; i < nbRow; i++) init(i);

    }

    public int getColumnCount() { return columnNames.length; }

    public int getRowCount() { return nbRow; }

    public String getColumnName(int col) { return columnNames[col]; }

    public Object getValueAt(int row, int col) { return data[row][col]; }

    public Class getColumnClass(int c) {
      switch (c) {
      case 0 : return new String().getClass();
      case 1 : return new Integer(0).getClass();
      case 2 : return new Integer(0).getClass();
      case 3 : return new Long(0).getClass();
      case 4 : return new String().getClass();

      default : return new String().getClass();
      }
    }

    public boolean isCellEditable(int row, int col) { return false; }



    private void init(int nb) {
      data[ nb ][ 0 ] = new String("");
      data[ nb ][ 1 ] = new Integer(0);
      data[ nb ][ 2 ] = new Integer(0);
      data[ nb ][ 3 ] = new Long(0);
      data[ nb ][ 4 ] = new String("");
    }


    public void setValueAt(Object value, int row, int col) {
     
     
      data[row][col] = value;
      fireTableCellUpdated(row, col);
     
    }
  }



}
