/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Grassin-Minec-Debin
 * @version 1.0
 */

package iu;

import java.util.ArrayList;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;

public class ScriptEditorPanel extends JPanel {
  JScrollPane jScrollPaneListe = new JScrollPane();
  JList liste = new JList();
  JButton jButtonSave = new JButton("save script");
//  JButton jButtonRestoreModif = new JButton("restore modified");
  JButton jButtonRestoreDef = new JButton("restore default");
  JButton jButtonAddScript = new JButton("add script");
  JPanel jPanelEdit = new JPanel();
  JScrollPane jScrollPaneEdit = new JScrollPane();
  JLabel jLabelComment = new JLabel("comments on changes :");
  JScrollPane jScrollPaneComment = new JScrollPane();
  JTextArea jTextAreaComment = new JTextArea();
  JLabel jLabelExplain = new JLabel("To delete a script, simply delete all text in it");

  Font fontScript = new Font("DialogInput", Font.PLAIN, 12);
  String[] machines = new String[] {"uccis","vme","zeus"};
  private int nb = 0;  // nb de ligne de script de la cible ind
  private int ind = 0; // index de cible dans la liste

  JComboBox[] jcb;
  JTextArea[] jta;
  JScrollPane[] jsp;

  GridBagLayout gridBagLayoutEdit = new GridBagLayout();
  GridBagLayout gridBagLayoutThis = new GridBagLayout();

  ParamObservationStructure struct = UserParameters.paramObservationStructure;

  public ScriptEditorPanel() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() {
    this.setLayout(gridBagLayoutThis);
    jPanelEdit.setLayout(gridBagLayoutEdit);

    jButtonSave.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        sauvegarde(ind);
      }
    });
    jButtonRestoreDef.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        restoreDef(ind);
      }
    });
/*    jButtonRestoreModif.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        drawPanelEdit(ind, false);
        AppIU.setStatus("Modified script restored.");
      }
    });*/
    jButtonAddScript.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { 
        addScript(nb++, new Instruction("", ""));
        jPanelEdit.validate();
      }
    });

    jScrollPaneComment.getViewport().setView(jTextAreaComment);
    jScrollPaneComment.setMinimumSize(new Dimension(200, 400));
    jScrollPaneComment.setPreferredSize(new Dimension(200, 400));

    jScrollPaneEdit.setMinimumSize(new Dimension(600, 800));
    jScrollPaneEdit.setPreferredSize(new Dimension(600, 800));
    jScrollPaneEdit.getViewport().setView(jPanelEdit);

    jScrollPaneListe.setMinimumSize(new Dimension(200, 300));
    jScrollPaneListe.setPreferredSize(new Dimension(200, 300));

    liste.addListSelectionListener(new ListSelectionListener() {
      public void valueChanged(ListSelectionEvent e) {
//System.out.println("[ScriptEditorPanel.jbInit.ListSelectionListener] e="+e);
        if (!e.getValueIsAdjusting()) {
          if (liste.getSelectedIndex() >= 0) ind = liste.getSelectedIndex();
          drawPanelEdit(ind, false);
        }
      }
    });
    jScrollPaneListe.getViewport().setView(liste);
    majListe();
    
    this.add(jScrollPaneListe, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0,
      GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5,5,5,5), 0, 0));
    this.add(jScrollPaneEdit, new GridBagConstraints(2, 0, 1, 5, 1.0, 1.0,
      GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5,5,5,5), 0, 0));
    this.add(jButtonRestoreDef, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0,
      GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5,5,5,5), 0, 0));
/*    this.add(jButtonRestoreModif, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0,
      GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5,5,5,5), 0, 0));*/
    this.add(jButtonSave, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0,
      GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5,5,5,5), 0, 0));
    this.add(jButtonAddScript, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0,
      GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5,5,5,5), 0, 0));
    this.add(jLabelComment, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0,
      GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5,5,5,5), 0, 0));
    this.add(jScrollPaneComment, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0,
      GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5,5,5,5), 0, 0));
    this.add(jLabelExplain, new GridBagConstraints(0, 5, 3, 1, 1.0, 1.0,
      GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5,5,5,5), 0, 0));
  }

  private void restoreDef(int ind) {
    Cible cible = struct.getCible(ind);

    cible.scriptModif = null;  
    drawPanelEdit(ind, true);
	
    AppIU.setStatus("Default script restored.");
  }

  private void sauvegarde(int ind) {
    ArrayList listeScript = new ArrayList(nb);
    Cible cible = struct.getCible(ind);
    String script;

    for (int i=0; i<nb; i++) {
      script = jta[i].getText();
      if  (script.length() > 0)
	listeScript.add(new Instruction(script, 
          jcb[i].getSelectedItem().toString()));
    }
    cible.scriptModif = listeScript;
    cible.scriptComment = jTextAreaComment.getText();
    cible.scriptDate = new java.util.Date();
    AppIU.setStatus("Script saved.");
    drawPanelEdit(ind, false);
  }

  private void majListe() {
    String[] data = new String[struct.nbSequence];

//    this.remove(jScrollPaneListe);

    for (int i = 0; i<struct.nbSequence; i++)
      data[i] = (struct.sequences[i].extra?"extra ":"")
        +struct.sequences[i].getDesc();

    liste.setListData(data);
/*
    liste.addListSelectionListener(new ListSelectionListener() {
      public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
          ind = liste.getSelectedIndex();
          drawPanelEdit(ind, false);
        }
      }
    });
    jScrollPaneListe.getViewport().setView(liste);*/
/*    jScrollPaneListe.setMinimumSize(new Dimension(200, 300));
    jScrollPaneListe.setPreferredSize(new Dimension(200, 300));
    this.add(jScrollPaneListe, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0,
      GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5,5,5,5)
      , 0, 0));*/
  }

/**
 * @param ind : indice dans la liste
 * @param def : script par defaut ? (sinon script modifie)
 **/
  
  private void drawPanelEdit(int ind, boolean def) {
    jPanelEdit.removeAll();

System.out.println("[ScriptEditorPanel.drawPanelEdit] ind="+ind+", def="+def);
    Cible cible = struct.getCible(ind);
    if (cible == null) {
//      AppIU.setStatus("Error : this target is null.");
      return;
    }

    ArrayList listeScript;

    if (cible.scriptModif == null) def = true;
      else if (cible.scriptModif.size()==0) def = true;

    if (def) {
      try { cible.genereScript(); }
      catch (BadValeurException e) { 
        JOptionPane.showMessageDialog(null, "Error while making script, see Status bar.","Error", JOptionPane.ERROR_MESSAGE);
        AppIU.setStatus("Error while generating script for "+cible.getDesc(ind)
          +" : "+e.toString()); 
      }
      listeScript = cible.scriptIO;
    }
    else listeScript = cible.scriptModif;

    nb = listeScript.size();
System.out.println("[ScriptEditorPanel.drawPanelEdit] nb="+nb);

    jcb = new JComboBox[nb*2];
    jta = new JTextArea[nb*2];
    jsp = new JScrollPane[nb*2];
    for (int i=0; i<nb; i++)
      addScript(i, (Instruction)listeScript.get(i));
    jPanelEdit.validate();
    jPanelEdit.repaint();
    jScrollPaneEdit.repaint();

    if (def) jTextAreaComment.setText("");
      else jTextAreaComment.setText(cible.scriptComment);
  }

  private void addScript(int i, Instruction instr) {
    jcb[i] = new JComboBox(machines);
    jcb[i].setSelectedItem(instr.getMachine());
    jPanelEdit.add(jcb[i], new GridBagConstraints(0, i, 1, 1, 1.0, 1.0,
      GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5,5,5,5), 0, 0));
    jta[i] = new JTextArea(instr.getScript());
    jta[i].setFont(fontScript);
    jsp[i] = new JScrollPane(jta[i]);
//    jsp[i].setPreferredSize(); // ci-dessous : n'a pas l'air de fonctionner
    jta[i].setMinimumSize(new Dimension(300, 40));
    jta[i].setMaximumSize(new Dimension(300, 200));
    jPanelEdit.add(jsp[i], new GridBagConstraints(1, i, 1, 1, 1.0, 1.0,
      GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5,5,5,5), 0, 0));    
  }

  public void gainedFocus() {
    majListe();
// genereScript() est appele par panelStart.gainedFocus()
/*
    try {
      Cible.setFilterCh();
      for (int i = 0; i<struct.nbSequence; i++)
        struct.getCible(i).genereScript();
    }
    catch (BadValeurException e) { System.err.println(e); }
*/
    liste.setSelectedIndex(ind);
  }

  public void lostFocus() {

  }
}
