
/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Minec-Debin
 * @version 1.0
 */

package iu;

import java.io.*;
import java.util.*;
import javax.swing.*;

public class ProgObservation extends Thread {
  private boolean threadSuspended = false;
  /**
   * indique si le thread est lance
   */
  public boolean threadRunning = false;

  private ObservationPanel panel;

  private ParamObservationStructure structure;
  private Observation observation;

  public ProgObservation(ObservationPanel panel) {
    this.panel = panel;
    structure = UserParameters.paramObservationStructure;
    observation = UserParameters.observation;
  }

//  public boolean isRunning() { return threadRunning; }

  public void arreter() {
    threadRunning = false;
    try {
      Communication comm = new Communication(Communication.UCCI,
        Communication.ASYNCHRONE);
      String resultat = comm.envoiMessage("SEXIT()", 2000);
      if (resultat.length() > 0) throw new java.io.IOException(resultat);
      panel.jTextAreaMessages.append("Observation program stopped.\n");
      panel.jTextAreaMessages.revalidate();
      //notify();
    } catch (Exception e) { 
      JOptionPane.showMessageDialog(null, "Error while stopping, see status bar message.","Error", JOptionPane.ERROR_MESSAGE);
      AppIU.setStatus("Error while trying to stop : "+e.getMessage());
      e.printStackTrace();
    }
  }

  public void suspendre() {
    threadSuspended = !threadSuspended;
    try {
      Communication comm = new Communication(Communication.UCCI,
        Communication.ASYNCHRONE);
      if (threadSuspended) {
        String resultat = comm.envoiMessage("PAUSE(1)", 2000);
        if (resultat.length() > 0) throw new java.io.IOException(resultat);
        panel.jButtonStart.setText("resume");
        panel.jTextAreaMessages.append("Observation program paused.\n");
      }
      else {
        String resultat = comm.envoiMessage("PAUSE(0)", 2000);
        if (resultat.length() > 0) throw new java.io.IOException(resultat);
        panel.jButtonStart.setText("pause");
        panel.jTextAreaMessages.append("Observation program resumed.\n");
        //notify();
      }
      panel.jTextAreaMessages.revalidate();
    } catch (Exception e) { 
      AppIU.setStatus("Error while trying to stop : "+e.getMessage());
      JOptionPane.showMessageDialog(null, "Error while stopping, see status bar message.","Error", JOptionPane.ERROR_MESSAGE);
      e.printStackTrace();
    }

  }

  /**
   * Attention, j'ai mis qq timeouts pour les comms...
   */

  public void run() {
//    String message, resultat = "";
    String type = "";
    int target, phase, noReg = 0;
//    Communication communication;
    Cible cible;
    ParamObservationStructure.Sequence sequence;

    threadRunning = true;
    panel.jButtonStart.setText("pause");
    panel.jProgressBar1.setMaximum(structure.nbRepetitions * structure.nbSequence);

    for (int nRep = 0; nRep < structure.nbRepetitions; nRep++) {
      panel.jTextFieldNoSeq.setText(Integer.toString(nRep+1));
      UserParameters.paramFits.getKeyword("COUNT").setValeur(Integer.toString(nRep+1));

      for (int nSeq = 0; (nSeq < structure.nbSequence)&&threadRunning; nSeq++) {
        panel.jTextFieldNoPhase.setText(Integer.toString(nSeq + 1));
        sequence = structure.sequences[nSeq];
        target = sequence.target;
        phase = sequence.phase;

/*        panel.jProgressBar1.setValue(nRep + nSeq*structure.nbRepetitions);
        panel.jProgressBar1.repaint();
*/
        panel.jTextFieldPhaseName.setText("");
        cible = structure.getCible(nSeq);
        switch (phase) {
          case Cible.TARGET :
            type = new String("scan");
            panel.jTextFieldPhaseName.setText(cible.object.getValeur().toString()+" - "
              +cible.obj_id.getValeur().toString()+" - ");
            noReg++;
            break;
          case Cible.DARK : type = new String("dark current"); break;
          case Cible.FLATFIELD : type = new String("flat field"); break;
        }
        panel.jTextFieldPhaseName.setText(panel.jTextFieldPhaseName.getText()+cible.customName);
        panel.jTextFieldType.setText(type);
        panel.jTextFieldFits.setText(Integer.toString(cible.fitsMode));
        panel.jTextFieldTotalLoop.setText(Integer.toString(sequence.loops));
System.out.println("[ProgObservation:run] "+type+" - "+panel.jTextFieldPhaseName.getText());

        try {
          raoe();

          for (int loop = 0; loop < sequence.loops; loop++) {
	    Communication.envoiInstruction(cible.index());
            if (cible.scriptModif == null)
              Communication.envoiScript(cible.scriptIO);
	    else if (cible.scriptModif.size() == 0)
              Communication.envoiScript(cible.scriptIO);
            else Communication.envoiScript(cible.scriptModif);
            panel.jTextFieldNoLoop.setText(Integer.toString(loop + 1));
System.out.println("[ProgObservation:run] loop=" + loop);
/*
            index(cible, phase, noReg);

            da3();
            cible.dax1();
            envoiScript(cible.getScriptAvant());

            attendSiPause();
            int nbBandes = ((Integer)cible.nbstep_y.getValeur()).intValue();
            if (!cible.Xaxis) nbBandes = ((Integer)cible.nbstep_x.getValeur()).intValue();

            switch (phase) {
              case Cible.DARK :
                motcles(cible, false);
                closeObt(!cible.closeSpectro, false);
                communication = new Communication(Communication.UCCI);
                resultat = communication.envoiMessage(cible.getSequenceDark());
                closeObt(!cible.closeSpectro, true);
                break;
              case Cible.TARGET :
                if (!cible.cut) {
                  envoiScript(cible.getSequenceDebutBande(1));
                  motcles(cible, false);
                  message = cible.getSequenceTarget();
                  // on decoupe et envoie en plusieurs parties, pour XRLC
                  int deb = 0, fin = 0;
                  while ( (fin=message.indexOf(Communication.SEP_UCCI, deb))>-1 ) {
                    communication = new Communication(Communication.UCCI);
                    resultat += communication.envoiMessage(message.substring(deb, fin+2));
                    deb = fin+2;
                  }
                } else
                for (int i=1; i<=nbBandes; i++) {
                  envoiScript(cible.getSequenceDebutBande(i));
                  motcles(cible, false);
                  message = cible.getSequenceBande();
                  // on decoupe et envoie en plusieurs parties, pour XRLC
                  int deb = 0, fin = 0;
                  while ( (fin=message.indexOf(Communication.SEP_UCCI, deb))>-1 ) {
                    communication = new Communication(Communication.UCCI);
                    resultat += communication.envoiMessage(message.substring(deb, fin+2));
                    deb = fin+2;
                  }
                }
                break;
              case Cible.FLATFIELD :
                String seq = (String)cible.sequence.getValeur();
                if (seq.length()==0) {
                  motcles(cible, false);
                  communication = new Communication(Communication.UCCI);
                  resultat = communication.envoiMessage(cible.getSequenceFlat(""));
                } else {
                  String s;
                  for (int j = 0; j < seq.length(); j++) {
                    s = "";
                    if (seq.charAt(j)=='-') s += seq.charAt(j++);
                    s += seq.charAt(j);
//                    cible.sequence.setValeur(s);
                    envoiScript(s.toUpperCase()+"()/PLAM()");
                    motcles(cible, false);
                    communication = new Communication(Communication.UCCI);
                    resultat = communication.envoiMessage(cible.getSequenceFlat(s));
                  }
                }
                break;
            } // switch
            if (resultat.length() != 0)
              throw new java.io.IOException("erreur lors de la sequence UCCI : " + resultat);
*/
          } // for loop

          attendSiPause();
          if (!threadRunning) { fin(); return; }
        } //try
        catch(java.io.IOException e) { if (gestionErreur(e)) { nSeq--; noReg--;} }
//        catch(BadValeurException e) { if (gestionErreur(e)) {nSeq--; noReg--;} }

        try { raos(); }
        catch(Exception e) {
          e.printStackTrace();
          panel.jTextAreaMessages.append("A problem has occured with the acquisition program : "
            + e.getMessage() + "\n");
        }
      } // for nSeq
    } // for nRep
    panel.jProgressBar1.setValue(structure.nbSequence * structure.nbRepetitions);
    panel.jProgressBar1.repaint();

    fin();
  }
/*
  private static void closeObt(boolean closeAll, boolean ouvert) throws IOException {
    String message = "";

    Communication comm = new Communication(Communication.VME);
    if (!closeAll)
      message += "$COBT(0,"+(ouvert?"1":"0")+")";
    else {
      ListeCamera listeC = UserParameters.acquisition.listeCam;
      int obt;
      for(int i=0; i<listeC.getNbCam(); i++) {
        obt = (listeC.getListe())[i].numShutter.intValue();
        message += "$COBT("+obt+","+(ouvert?"1":"0")+")"+Communication.SEP_DEF;
      }
    }
    comm.envoiMessage(message, 20000);
  }
*/
  private void attendSiPause() throws IOException {
/* @todo attention si dessous : cmd a envoyer que si 'resume' */
    Communication comm;// = new Communication(Communication.UCCI, Communication.ASYNCHRONE);
    String resultat;// = comm.envoiMessage("PAUSE(1)", 2000);
//    if (resultat.length() > 0) throw new IOException(resultat);

    try {
      synchronized(this) {
        while (threadSuspended && threadRunning) wait();
/*
        if (!threadSuspended) {
          comm = new Communication(Communication.UCCI, Communication.ASYNCHRONE);
          resultat = comm.envoiMessage("PAUSE(0)", 2000);
          if (resultat.length() > 0) throw new IOException(resultat);
        }
        if (!threadRunning) {
          comm = new Communication(Communication.UCCI, Communication.ASYNCHRONE);
          resultat = comm.envoiMessage("ARRET()", 2000);
          if (resultat.length() > 0) throw new IOException(resultat);
        }*/
      }
    }
    catch (InterruptedException e) { }
  }

  /**
   * @return <code>true</code> if retry, <code>false</code> else.
   */
  private boolean gestionErreur(Exception e) {
    System.err.println(e.getMessage());
    panel.jTextAreaMessages.append("Error:" + e.getMessage()+"\n");
    panel.jScrollPane1.revalidate();

    switch (panel.getOnError()) {
      case ObservationPanel.ABORT :
        panel.jTextAreaMessages.append("Aborting.\n");
        fin();
        return false;
      case ObservationPanel.RETRY :
        panel.jTextAreaMessages.append("Retrying same phase.\n");
        return true;
      /*case ObservationPanel.PAUSE :
        suspendre();
        int choix = JOptionPane.showOptionDialog(null,
          e.getMessage() + "\nDo you want to continue ?",
          "An error has occured", JOptionPane.YES_NO_OPTION,
          JOptionPane.ERROR_MESSAGE, null, null, null);
        if (choix == JOptionPane.NO_OPTION) { fin(); break; } //else, continue :*/
      case ObservationPanel.CONTINUE :
        panel.jTextAreaMessages.append("Continuing same phase.\n");
        return false;
      default : return false;
    }
  }

  public static void raoe() throws IOException {
    Communication communication = new Communication(Communication.ZEUS);
    String resultat = communication.envoiMessage("$RAOE", 20000);
    if (resultat.length() > 0) throw new IOException(resultat);
  }

  public static void wacq(int nb) throws IOException { // pour WindowsConfigPanel.getImg
    Communication communication = new Communication(Communication.VME);
    String resultat;

    for (int i=1; i<nb; i++) {
      resultat = communication.envoi("$WACQ", 2000);
      // il faut 2 wacq() pour avoir l'image (bug de la visu ?)
      if (resultat.length() > 0) throw new IOException(resultat);
    }

    resultat = communication.envoiMessage("$WACQ", 2000);
    if (resultat.length() > 0) throw new IOException(resultat);
  }

  public static void tacq() throws IOException { // pour TargetsPanel
    Communication communication = new Communication(Communication.VME);
    String resultat = communication.envoiMessage("$TACQ(0)", 2000);
    if (resultat.length() != 0) throw new IOException(resultat);
  }

  public static void pacq() throws IOException { // pour TargetsPanel
    Communication communication = new Communication(Communication.VME);
    String resultat = communication.envoiMessage("$PACQ", 2000);
    if (resultat.length() != 0) throw new IOException(resultat);
  }

  public static void raos() throws IOException {
    Communication comm = new Communication(Communication.ZEUS);
    comm.envoiMessage("$RAOS", 5000);
   /* 
      comm = new Communication(Communication.VME);
      comm.envoiMessage("$EACQ", 5000);
*/
  }
/*
  private void plam() throws IOException {
    Communication communication = new Communication(Communication.UCCI);
    String resultat = communication.envoiMessage("PLAM()", 25000);
    if (resultat.length() > 0)
      throw new java.io.IOException("reponse du PLAM par l'UCCI non conforme : " + resultat);
  }
*/
/*
  private void da3() throws IOException {
    Communication communication = new Communication(Communication.UCCI);
    String resultat = communication.envoiMessage("DA3()", 25000);
    if (resultat.length() > 3) {
      if (!resultat.substring(0,3).equals("DA3"))
        throw new java.io.IOException("reponse du DA3 par l'UCCI non conforme : " + resultat);
    } else throw new java.io.IOException("reponse du DA3 par l'UCCI non conforme : " + resultat);

    try { Coordonnees.setParameters(resultat); }
    catch (IndexOutOfBoundsException e) { e.printStackTrace(); }
    catch (NumberFormatException e) { e.printStackTrace(); }

    communication = new Communication(Communication.VME);
    resultat = communication.envoiMessage("$" + resultat, 5000);
    if (resultat.length() != 0)
      throw new java.io.IOException("erreur renvoyee par le VME : " + resultat);
  }
*/

 public static void motcles(Cible cible, boolean wacq) throws BadValeurException, IOException {
  // mots-cles
    KeywordText keywordText = cible.getmotcle(wacq);
    String message = new String("");
    Communication communication = new Communication(Communication.ZEUS);

    if (wacq) communication.envoiMessage("$RAOE", 10000);

    message += "$MCLE(" + keywordText.nbLignes + ")" + "\n";//Communication.SEP_DEF;
    message += keywordText.texte+"\r";
    communication = new Communication(Communication.ZEUS);
    String resultat = communication.envoiMessage(message, 10000);
    if (resultat.length() != 0)
      throw new java.io.IOException("erreur dans la liste de mots-cles : " + resultat);

  // decodage
    message = "$DEC2";
    communication = new Communication(Communication.ZEUS);
    resultat = communication.envoiMessage(message, 10000);
    if (resultat.length() != 0)
      throw new IOException("erreur dans le decodage : " + resultat);
  }

/*  private void envoiScript(ArrayList liste) throws IOException {
    Instruction instr;
    String resultat;

    for (int i=0; i<liste.size(); i++) {
      instr = (Instruction)liste.get(i);
      Communication communication = new Communication(instr.getMachine());
      resultat = communication.envoiMessage(message, 60000);
    if (resultat.length() > 0)
      throw new IOException("erreur avec l'UCCI:" + resultat);
  /*    Communication communication = new Communication(Communication.UCCI);
    String resultat = communication.envoiMessage(message, 60000);
    if (resultat.length() > 0)
      throw new IOException("erreur avec l'UCCI:" + resultat);*/
/*  }*/
/*
  private void ppou() throws IOException, BadValeurException {
    // il faut se placer avant de demander PPOU
    Communication communication = new Communication(Communication.UCCI);
    String resultat = communication.envoiMessage(cible.getSequencePointage(), 20000);
    if (resultat.length() > 0)
      throw new java.io.IOException("erreur avec l'UCCI:" + resultat);

    communication = new Communication(Communication.UCCI);
    resultat = communication.envoiMessage("PPOU()"+Communication.SEP_UCCI, 2000);
    if (resultat.length() > 0)
      throw new IOException("erreur avec l'UCCI:" + resultat);
  }
*/
/*
  private void index(Cible cible, int phase, int noReg)
    throws IOException, BadValeurException {
    Communication communication = new Communication(Communication.UCCI);
    String message = "";

    // INDEX(SEQ_IND[no_sequence], IND_REG[no_region])
System.out.println("[ProgObservation.paramDyn] seq_ind="+UserParameters.paramFits.getKeyword("SEQ_IND").getValeur());
    message += "INDEX(" + ((Integer)UserParameters.paramFits.getKeyword("SEQ_IND")
      .getValeur()).toString() + ",";
    if (phase == Cible.TARGET) message += Integer.toString(noReg);
    else message += "1";
    message += ")" + Communication.SEP_UCCI;

    String resultat = communication.envoiMessage(message, 2000);
    if (resultat.length() > 0)
      throw new IOException("erreur avec l'UCCI:" + resultat);
  }
*/
/**
 * Fait 1 acquisition pour 1 fenetre : pour WindowsConfigPanel et CameraPanel.
 */
  public static void acquisition(int winNb, int time) throws IOException, BadValeurException {
/*    closeObt(1, false);
    closeObt(2, false);*/
    ListeWindow listeWin = UserParameters.acquisition.listeWin;
    int num = listeWin.getWin(winNb);
//    Cible cible = UserParameters.cible0;

    for(int i=0; i<ListeWindow.NB_MAX_WIN; i++)
      UserParameters.cible0.winUsed[i]=false;
    UserParameters.cible0.winUsed[num]=true;
    UserParameters.cible0.integrationTime[num]=time;

    System.out.println("[ProgObservation.acquisition] listeWin.getListe()["
      +winNb+"].getCam()="+listeWin.getListe()[winNb].getCam()
      +", numRep="+UserParameters.acquisition.listeCam.getListe()[
        listeWin.getListe()[winNb].getCam()].numRep); 
    try {
      System.out.println("[ProgObservation.acquisition] win="+winNb+", cam="
        +UserParameters.acquisition.listeCam.getListe()[listeWin.getListe()
          [winNb].getCam()].numRep); 
    }
    catch (NullPointerException e) { 
      AppIU.setStatus("Error : "+e.getMessage());
      JOptionPane.showMessageDialog(null, "Exception error, see status bar message.","Error", JOptionPane.ERROR_MESSAGE);
      e.printStackTrace(); 
    }

    UserParameters.cible0.cadac.setValeur("0");
    UserParameters.cible0.ctrac.setValeur("0");
    motcles(UserParameters.cible0, true);
    wacq(2);
    raos();
  }

/**
 * Fait 1 acquisition pour 1 cible, avec eventuellement plusieurs fenetres :
 * pour TargetsPanel ("get image").
 */
  public static void acquisition(Cible cible) throws IOException, BadValeurException {
/*    closeObt(1, false);
    closeObt(2, false);*/
    cible.cadac.setValeur("0");
    cible.ctrac.setValeur("0");
    motcles(cible, true);
    wacq(2);
    raos();
  }

/**
 * Fait des acquisitions en boucle pour 1 cible, avec eventuellement plusieurs
 * fenetres : pour TargetsPanel ("start acq").
 */
  public static void startAcq(Cible cible) throws IOException, BadValeurException {
/*    closeObt(1, false);
    closeObt(2, false);*/
// @todo : calculer cadac
    int cadac;
    cadac = 350*cible.getNbWinSelected()+cible.getMaxIntgTime();
    cible.cadac.setValeur(new Integer(cadac).toString());
    cible.ctrac.setValeur("2");
    motcles(cible, true);
    // pour bien remettre la configuration pour les scans
    cible.cadac.setValeur("0");
    cible.ctrac.setValeur("0");
    tacq();
  }

/**
 * Arrete les acquisitions en boucle pour 1 cible : pour TargetsPanel ("stop acq").
 */
  public static void stopAcq() throws IOException {
    pacq();
    raos();
   
  }

  private void fin() {
    threadRunning = false;
    panel.jButtonStart.setText("start");
    panel.jButtonStop.setEnabled(false);
    Integer seq_ind = new Integer(((Integer)UserParameters.paramFits.getKeyword("SEQ_IND").getValeur())
      .intValue()+1);
    panel.jTextFieldSeq.setText(seq_ind.toString());
  }
}
