package iu;

import java.lang.*;
import java.util.*;
import java.math.*;

/** Prefente du telescope*/

public class Poursuite
{
  private static String RS0;
  private static String RS0_C;
  private static String RS1;
  private static String RS1_C;
  private static String AZC;
  private static String AZC_C;
  private static String CEN;
  private static String CEN_C;
  private static String COA;
  private static String COA_C;
  private static String DA0;
  private static String DA0_C;
  private static String DA1;
  private static String DA1_C;
  private static String DA2;
  private static String DA2_C;
  private static String DA3;
  private static String DA3_C;
  private static String DAX1;
  private static String DAX1_C;
  private static String DEM;
  private static String DEM_C;
  private static String DOS;
  private static String DOS_C;
  private static String END;
  private static String END_C;
  private static String EPH;
  private static String EPH_C;
  private static String EQC;
  private static String EQC_C;
  private static String EQU;
  private static String EQU_C;
  private static String ETO;
  private static String ETO_C;
  private static String FK5;
  private static String FK5_C;
  private static String FLA;
  private static String FLA_C;
  private static String GAR;
  private static String GAR_C;
  private static String HAL;
  private static String HAL_C;
  private static String HEL;
  private static String HEL_C;
  private static String HLC;
  private static String HLC_C;
  private static String HLG;
  private static String HLG_C;
  private static String MAN;
  private static String MAN_C;
  private static String OBJ;
  private static String OBJ_C;
  private static String OMB;
  private static String OMB_C;
  private static String POI;
  private static String POI_C;
  private static String PRB;
  private static String PRB_C;
  private static String REC;
  private static String REC_C;
  private static String TIMSUM;
  private static String TIMSUM_C;
  private static String UP0;
  private static String UP0_C;

  public Poursuite(UserRessource messages)
    {
      this.i18n(messages);
    }

  public void i18n(UserRessource messages)
    {

      this.RS0 = messages.poursuite_rs0;
      this.RS0_C = messages.poursuite_rs0_c;
      this.RS1 = messages.poursuite_rs1;
      this.RS1_C = messages.poursuite_rs1_c;
      this.AZC = messages.poursuite_azc;
      this.AZC_C = messages.poursuite_azc_c;
      this.CEN = messages.poursuite_cen;
      this.CEN_C = messages.poursuite_cen_c;
      this.COA = messages.poursuite_coa;
      this.COA_C = messages.poursuite_coa_c;
      this.DA0 = messages.poursuite_da0;

      this.DA0_C = messages.poursuite_da0_c;
      this.DA1 = messages.poursuite_da1;
      this.DA1_C = messages.poursuite_da1_c;
      this.DA2 = messages.poursuite_da2;
      this.DA2_C = messages.poursuite_da2_c;
      this.DA3 = messages.poursuite_da3;
      this.DA3_C = messages.poursuite_da3_c;
      this.DAX1 = messages.poursuite_dax1;
      this.DAX1_C = messages.poursuite_dax1_c;
      this.DEM = messages.poursuite_dem;
      this.DEM_C = messages.poursuite_dem_c;
      this.DOS = messages.poursuite_dos;
      this.DOS_C = messages.poursuite_dos_c;
      this.END = messages.poursuite_end;
      this.END_C = messages.poursuite_end_c;
      this.EPH = messages.poursuite_eph;
      this.EPH_C = messages.poursuite_eph_c;
      this.EQC = messages.poursuite_eqc;

      this.EQC_C = messages.poursuite_eqc_c;
      this.EQU = messages.poursuite_equ;
      this.EQU_C = messages.poursuite_equ_c;
      this.ETO = messages.poursuite_eto;
      this.ETO_C = messages.poursuite_eto_c;
      this.FK5 = messages.poursuite_fk5;
      this.FK5_C = messages.poursuite_fk5_c;
      this.FLA = messages.poursuite_fla;
      this.FLA_C = messages.poursuite_fla_c;
      this.GAR = messages.poursuite_gar;
      this.GAR_C = messages.poursuite_gar_c;
      this.HAL = messages.poursuite_hal;
      this.HAL_C = messages.poursuite_hal_c;
      this.HEL = messages.poursuite_hel;
      this.HEL_C = messages.poursuite_hel_c;
      this.HLC = messages.poursuite_hlc;
      this.HLC_C = messages.poursuite_hlc_c;
      this.HLG = messages.poursuite_hlg;
      this.HLG_C = messages.poursuite_hlg_c;
      this.MAN = messages.poursuite_man;
      this.MAN_C = messages.poursuite_man_c;
      this.OBJ = messages.poursuite_obj;
      this.OBJ_C = messages.poursuite_obj_c;
      this.OMB = messages.poursuite_omb;
      this.OMB_C = messages.poursuite_omb_c;
      this.POI = messages.poursuite_poi;
      this.POI_C = messages.poursuite_poi_c;
      this.PRB = messages.poursuite_prb;
      this.PRB_C = messages.poursuite_prb_c;
      this.REC = messages.poursuite_rec;
      this.REC_C = messages.poursuite_rec_c;
      this.TIMSUM = messages.poursuite_timsum;
      this.TIMSUM_C = messages.poursuite_timsum_c;
      this.UP0 = messages.poursuite_up0;
      this.UP0_C = messages.poursuite_up0_c;

    }

  public Instruction rs0()
    {
      return(new Instruction(RS0,RS0+"()",RS0_C, Communication.UCCI));
    }
  public Instruction rs1()
    {
      return(new Instruction(RS1,RS1+"()",RS1_C, Communication.UCCI));
    }
  /** Format des parametres BigDecimal "*****.*", "*****.* */
  public Instruction azc(BigDecimal arcsec1,BigDecimal arcsec2)
    throws BadValeurException
    {
      try { return new Instruction
	      (AZC,
	       AZC+"("+Formatage.setModel(arcsec1,"*****.*")+","+
	       Formatage.setModel(arcsec2,"*****.*")+")",
	       AZC_C+arcsec1+","+arcsec2, Communication.UCCI); }
      catch(BadValeurException e)
	{ throw e;}
    }

  public Instruction cen()
    {
      return(new Instruction(CEN,CEN+"()",CEN_C, Communication.UCCI));
    }

  public Instruction coa()
    {
      return(new Instruction(COA,COA+"()",COA_C, Communication.UCCI));
    }
  public Instruction da0()
    {
      return(new Instruction(DA0,DA0+"()",DA0_C, Communication.UCCI));
    }
  public Instruction da1()
    {
      return(new Instruction(DA1,DA1+"()",DA1_C, Communication.UCCI));
    }
  public Instruction da2()
    {
      return(new Instruction(DA2,DA2+"()",DA2_C, Communication.UCCI));
    }
  public Instruction da3()
    {
      return(new Instruction(DA3,DA3+"()",DA3_C, Communication.UCCI));
    }


  public Instruction dax1()
    {
      return(new Instruction(DAX1,DAX1+"()",DAX1_C, Communication.UCCI));
    }
  public Instruction dem(BigDecimal noband,BigDecimal hh,
			   BigDecimal mm,BigDecimal ss) throws BadValeurException
    {
      try{return new Instruction
		 (DEM,
		  DEM+"("+
		  Formatage.setModel(noband,"**")+","+
		  Formatage.setModel(hh,"**")+","+
		  Formatage.setModel(mm,"**")+","+
		  Formatage.setModel(ss,"**")+")",
		  DEM_C, Communication.UCCI);}

      catch(BadValeurException e)
	{ throw e;}
    }

  public Instruction dos()
    {
      return(new Instruction(DOS,DOS+"()",DOS_C, Communication.UCCI));
    }

  public Instruction end()
    {
      return(new Instruction(END,END+"()",END_C, Communication.UCCI));
    }

  public Instruction eph()
    {
      return(new Instruction(EPH,EPH+"()",EPH_C, Communication.UCCI));
    }
  public Instruction eqc(BigDecimal x,BigDecimal y) throws BadValeurException
    {
      try{ return new Instruction(
				    EQC,
				    EQC+"("+
				    Formatage.setModel(x,"*****.*")+","+
				    Formatage.setModel(y,"*****.*")+")",
				    EQC_C+x.toString()+" "+y.toString(), Communication.UCCI);}
      catch(BadValeurException e)
	{ throw e; }
    }
  public Instruction equ(BigDecimal x,BigDecimal y) throws BadValeurException
    {
      try{ return new Instruction(
				    EQU,
				    EQU+"("+
				    Formatage.setModel(x,"*****.*")+","+
				    Formatage.setModel(y,"*****.*")+")",
				    EQU_C+x.toString()+" "+y.toString(), Communication.UCCI);}
      catch(BadValeurException e)
	{ throw e; }
    }
  public Instruction eto(BigDecimal no) throws BadValeurException
    {
      try{ return new Instruction(
				    ETO,
				    ETO+"("+
				    Formatage.setModel(no,"**")+")",
				    ETO_C, Communication.UCCI);}
      catch(BadValeurException e)
	{ throw e; }
    }
  public Instruction fk5()
    {
      return(new Instruction(FK5,FK5+"()",FK5_C, Communication.UCCI));
    }
  public Instruction FLA(BigDecimal x,BigDecimal y,BigDecimal z)
    throws BadValeurException
   {
      try{ return new Instruction(
				    FLA,
				    FLA+"("+
				    Formatage.setModel(x,"*****.*")+","+
				    Formatage.setModel(y,"*****.*")+","+
				    Formatage.setModel(z,"*****.*")+")",
				    FLA_C, Communication.UCCI);}
      catch(BadValeurException e)
	{ throw e; }
    }
  public Instruction gar()
    {
      return(new Instruction(GAR,GAR+"()",GAR_C, Communication.UCCI));
    }
  public Instruction hal()
    {
      return(new Instruction(HAL,HAL+"()",HAL_C, Communication.UCCI));
    }
  public Instruction hel(BigDecimal lon,BigDecimal lat)
    throws BadValeurException
   {
      try{ return new Instruction(
				    HEL,
				    HEL+"("+
				    Formatage.setModel(lon,"****.**")+","+
				    Formatage.setModel(lat,"****.**")+")",
				    HEL_C+lon.toString()+" "+lat.toString(), Communication.UCCI);}
      catch(BadValeurException e)
	{ throw e; }
    }


  public Instruction hlc(BigDecimal lon,BigDecimal lat)
    throws BadValeurException
    {
      try{ return new Instruction(
				    HLC,
				    HLC+"("+
				    Formatage.setModel(lon,"****.**")+","+
				    Formatage.setModel(lat,"****.**")+")",
				    HLC_C+lon.toString()+" "+lat.toString(), Communication.UCCI);}
      catch(BadValeurException e)
	{ throw e; }
    }
  public Instruction hlg(BigDecimal lon,BigDecimal lat)
    throws BadValeurException
   {
      try{ return new Instruction(
				    HLG,
				    HLG+"("+
				    Formatage.setModel(lon,"****.**")+","+
				    Formatage.setModel(lat,"****.**")+")",
				    HLG_C+lon.toString()+" "+lat.toString(), Communication.UCCI);}
      catch(BadValeurException e)
	{ throw e; }
    }
  public Instruction man()
    {
      return(new Instruction(MAN,MAN+"()",MAN_C, Communication.UCCI));
    }

  public Instruction obj(BigDecimal hh, BigDecimal mm, BigDecimal sec,
			   BigDecimal deg, BigDecimal min,BigDecimal secdec)
    throws BadValeurException
    {
      try{ return new Instruction(
				    OBJ,
				    OBJ+"("+
				    Formatage.setModel(hh,"**")+","+
				    Formatage.setModel(mm,"**")+","+
				    Formatage.setModel(sec,"**.**")+","+
				    Formatage.setModel(deg,"***")+","+
				    Formatage.setModel(min,"***")+","+
				    Formatage.setModel(secdec,"***.*")
				    +")", OBJ_C, Communication.UCCI);}
      catch(BadValeurException e)
	{ throw e; }
    }

  public Instruction omb()
    {
      return(new Instruction(OMB,OMB+"()",OMB_C, Communication.UCCI));
    }

  public Instruction poi()
    {
      return(new Instruction(POI,POI+"()",POI_C, Communication.UCCI));
    }
  public Instruction prb()
    {
      return(new Instruction(PRB,PRB+"()",PRB_C, Communication.UCCI));
    }
  public Instruction rec(BigDecimal arcsec1,BigDecimal arcsec2)
    throws BadValeurException
    {
      try{ return new Instruction(
				    REC,
				    REC+"("+
				    Formatage.setModel(arcsec1,"*****.*")+","+
				    Formatage.setModel(arcsec2,"*****.*")+")",
				    REC_C, Communication.UCCI);}
      catch(BadValeurException e)
	{ throw e; }
    }

  public Instruction timesum()
    {
      return(new Instruction(TIMSUM,TIMSUM+"()",TIMSUM_C, Communication.UCCI));
    }
  public Instruction up0()
    {
      return(new Instruction(UP0,UP0+"()",UP0_C, Communication.UCCI));
    }
}
