/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Grassin-Minec-Debin
 * @version 1.0
 */
 
package iu;

import java.awt.*;
import java.awt.event.*;
import java.text.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.AbstractTableModel;

public class PolarPanel extends JPanel {
  JButton jButtonIns = new JButton("ins");
  JButton jButtonDel = new JButton("del");
  JButton jButtonAdd = new JButton("append");
  
  JPanel jPanel = new JPanel();
  JPanel jPanelTools = new JPanel();
  BorderLayout borderLayoutThis = new BorderLayout();
  JScrollPane jScrollPane = new JScrollPane();
  JTable jTable = new JTable();
  GridBagLayout gridBagLayout = new GridBagLayout();
  PolarTableModel polarTableModel;

  public PolarPanel() {
    try { jbInit(); }
    catch(Exception e) { e.printStackTrace(); }
  }

  private void jbInit() throws Exception {
    initComponents();

    jPanel.setLayout(gridBagLayout);
    this.setLayout(borderLayoutThis);
    this.add(jPanel, BorderLayout.CENTER);
    jPanel.add(jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    this.add(jPanelTools, BorderLayout.SOUTH);
    jPanelTools.add(jButtonIns);
    jPanelTools.add(jButtonDel);
    jPanelTools.add(jButtonAdd);
  }

  private void initComponents() {
    jButtonDel.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        polarTableModel.delete(jTable.getSelectedRow());
      }
    });
    jButtonIns.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        int i = jTable.getSelectedRow();
        polarTableModel.insert(i);
        jTable.setRowSelectionInterval(i,i);
      }
    });
    jButtonAdd.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        polarTableModel.append();
        jTable.setRowSelectionInterval(polarTableModel.getRowCount()-1,
          polarTableModel.getRowCount()-1);
      }
    });

    polarTableModel = new PolarTableModel();
    setTable();
    jTable = new JTable(polarTableModel);
    polarTableModel.addTableModelListener(new TableModelListener() {
      public void tableChanged(TableModelEvent e) { polarTableModel_tableChanged(e); }
    });
/*
    javax.swing.table.TableColumnModel cols = jTable.getColumnModel();
    jTable.setPreferredScrollableViewportSize(new Dimension(800, 600));
    jTable.sizeColumnsToFit(-1);

    cols.getColumn(0).setPreferredWidth(100);
    cols.getColumn(1).setPreferredWidth(120);
    cols.getColumn(2).setPreferredWidth(120);
    cols.getColumn(3).setPreferredWidth(180);
    cols.getColumn(4).setPreferredWidth(120);
    cols.getColumn(5).setPreferredWidth(180);
    cols.getColumn(6).setPreferredWidth(160);
    cols.getColumn(7).setPreferredWidth(160);
*/
    jScrollPane.getViewport().add(jTable, null);
  }

  private void setTable() {
    ListePolar paramPolar = UserParameters.listePolar;

    for ( int i = 0 ; i < paramPolar.getNbPol(); i++ ) {
      polarTableModel.data[i][0] = new String(paramPolar.listePolar[i].name);
      polarTableModel.data[i][1] = new Float(paramPolar.listePolar[i].pos1.floatValue());
      polarTableModel.data[i][2] = new Float(paramPolar.listePolar[i].pos2.floatValue());
    }
    polarTableModel.nbRow = paramPolar.getNbPol();
    polarTableModel.fireTableDataChanged();
  }

  private void getTable() throws NumberFormatException {
    int i=0;
    ListePolar paramPolar = UserParameters.listePolar;
    Object[] ligne;
    try {
      for ( i = 0 ; i < polarTableModel.getRowCount(); i++ ) {
        ligne = polarTableModel.data[i];
        paramPolar.listePolar[i] = new Polar(ligne[0].toString(),
          Float.parseFloat(ligne[1].toString()),
          Float.parseFloat(ligne[2].toString()));
       }
    } catch (NumberFormatException e) { 
      throw new NumberFormatException("polar line "+i+" : "+e.getMessage()); 
    }
    paramPolar.nbPolar = polarTableModel.getRowCount();
  }

  public void gainedFocus() {
    setTable();
  }

  public void lostFocus() throws NumberFormatException {
    JTextField component;
    int row,column;

    if(jTable.isEditing()) {
      row = jTable.getEditingRow();
      column = jTable.getEditingColumn();
      component = (JTextField) jTable.getEditorComponent();
      if(column == 0) { //Chaine de caractere
	polarTableModel.data[row][column] = component.getText();
	polarTableModel.fireTableCellUpdated(row, column);
      }
      else
	jTable.setValueAt(new Float(Float.parseFloat(component.getText())),row,column);
	  
      // System.out.println("[CameraPanel:lostFocus] editing at"+row+" "+column+" "+component.getText());
    }
    

    getTable();
  }

  public void polarTableModel_tableChanged(TableModelEvent e) {
/*    Object[][] data = polarTableModel.data;
    int i = e.getFirstRow();

    if(  e.getType() == e.UPDATE ) {
      switch (e.getColumn()) {
      }
      if ( data[ polarTableModel.getRowCount() - 1 ][ 0 ].equals(new Integer(0)) == false )
        polarTableModel.append();
      if ( (polarTableModel.getRowCount() > 1)
        && ( data[polarTableModel.getRowCount()-2][0].equals(new Integer(0)) ) )
        polarTableModel.delete(polarTableModel.getRowCount()-1);
    }*/
  }

  private class PolarTableModel extends AbstractTableModel {
    final String[] columnNames = { "name", "1st quarter waveplate ()", 
      "2nd quarter waveplate ()" };
    public final int NB_POLAR_MAX = UserParameters.listePolar.NB_MAX_POL;
    private int nbRow;
    public Object[][] data;

    PolarTableModel() {
      super();
      data = new Object[ NB_POLAR_MAX ][ 3 ];
/*      nbRow = UserParameters.listePol.getNbPol() +1;
      for (int i = 0; i < nbRow; i++) init(i);
      if (nbRow < 1) nbRow = 1;*/
      nbRow = 1;
    }

    public int getColumnCount() { return columnNames.length; }

    public int getRowCount() { return nbRow; }

    public String getColumnName(int col) { return columnNames[col]; }

    public Object getValueAt(int row, int col) { return data[row][col]; }

    public Class getColumnClass(int c) {
      switch (c) {
        case 0 : return new String().getClass();
        case 1 : return new Float(0.f).getClass();
        case 2 : return new Float(0.f).getClass();
        default : return new String().getClass();
      }
    }

    public boolean isCellEditable(int row, int col) { return true; }

    public void delete(int nb) {
      if ( nb >= 0 ) {
        for ( int i = nb ; i < nbRow - 1 ; i++ )
          move(i, i + 1);
	//        if ( --nbRow < 1 ) nbRow = 1;
        fireTableDataChanged();
      }
    }

    public void insert(int nb) {
      if ( nb >= 0 ) {
        nbRow++;
        init(nbRow - 1);
        for ( int i = nbRow - 1 ; i > nb ; i-- )
          move(i, i - 1);
        init(nb);
        fireTableDataChanged();
      }
    }

    private void move(int nb1, int nb2) {
      data[ nb1 ][ 0 ] = data[ nb2 ][ 0 ];
      data[ nb1 ][ 1 ] = data[ nb2 ][ 1 ];
      data[ nb1 ][ 2 ] = data[ nb2 ][ 2 ];
    }

    private void init(int nb) {
      data[ nb ][ 0 ] = new String("");
      data[ nb ][ 1 ] = new Float(0.f);
      data[ nb ][ 2 ] = new Float(0.f);
    }

    public void append() {
      nbRow++;
      init(nbRow-1);
      fireTableDataChanged();
    }

    public void setValueAt(Object value, int row, int col) {
      try {
        switch (col) {
          case 1 : if ((((Float)value).floatValue()<-90.f)||(((Float)value).floatValue()>90f))
            throw new BadValeurException("-90,+90"); break;
          case 2 : if ((((Float)value).floatValue()<-90f)||(((Float)value).floatValue()>90f))
            throw new BadValeurException("-90,+90"); break;
        }
        data[row][col] = value;
        fireTableCellUpdated(row, col);
      }
      catch (BadValeurException e) {
        AppIU.setStatus("'"+columnNames[col]+"' must be in ["+e.getMessage()+"]");
 JOptionPane.showMessageDialog(null, "Bad value, see status bar message.","Error", JOptionPane.ERROR_MESSAGE);
      }

    }
  }
}
