
// maintenu par Damien Debin
// cree le 4/4/2000

// Modification le 24.5.2000 par CM ajout de tovisu, toenreg et correction
// dans pour gestion de temperature.


package iu;

public class ParamWindowsConf {
  public static int XMIN = 1;
  public static int YMIN = 1;
  public static int XMAX = 382;
  public static int YMAX = 286;

  public class Ligne {
    public int camera; // numero de camera
    public float wavelength; // longueur d'onde en A
    public int temperature; // temperature CCD
    public int x1,y1,x2,y2; // coordonnees fenetre
    public boolean toVisu, toFile;
    public int num;
    public void init(int i) {
      camera = 0;
      temperature = 25;
      wavelength = 4000;
      x1 = XMIN;
      y1 = YMIN;
      x2 = XMAX;
      y2 = YMAX;
      toVisu = true;
      toFile = true;
      num = i;
    }
    public void init( Ligne l ) {
      camera = l.camera;
      temperature = l.temperature;
      wavelength = l.wavelength;
      x1 = l.x1;
      y1 = l.y1;
      x2 = l.x2;
      y2 = l.y2;
      toVisu = l.toVisu;
      toFile = l.toFile;
      num = l.num;
    }
    public Ligne(int i) { init(i); }
    public Ligne() { init(0); }
  }

  String[] waveStrings = {"none"};
  public static final int NB_LIGNE_MAX = 40;
  public int nbLigne;
  public Ligne[] tableWindows = new Ligne[ NB_LIGNE_MAX ];

  public ParamWindowsConf() {
    nbLigne = 1;
    for( int i = 0 ; i < NB_LIGNE_MAX ; i++ ) 
      tableWindows[ i ] = new Ligne(i);
  }

  /** Permet d'entrer les donnees des structures cameras dans
    la structure de donnees de l'interface */
  public void cameratoIntf() {
    ListeWindow listeWin = UserParameters.acquisition.listeWin;
    ListeCamera listeCam = UserParameters.acquisition.listeCam;
    Ligne nouvelle;
    int intTmp;
    nbLigne =0;

    waveStrings = listeCam.getWaveString();

    for( int i = 0 ; i < listeWin.getNbWin() ; i++ ) {
	nouvelle  = new Ligne();
	// donne l'indice de la camera, c'est l'interface qui met wavelt
	if (listeWin.getListe()[i].getCam() < listeCam.getNbCam())
          nouvelle.camera = listeWin.getListe()[i].getCam();
        else nouvelle.camera = 0;
        intTmp = (listeCam.getListe())[nouvelle.camera].temperature.intValue();
        nouvelle.temperature = intTmp;
	nouvelle.x1 = (listeWin.getListe())[i].getColdb();
	nouvelle.y1 = (listeWin.getListe())[i].getLigdb();
	nouvelle.x2 = (listeWin.getListe())[i].getNbcol()+nouvelle.x1 -1;
	nouvelle.y2 = (listeWin.getListe())[i].getNblig()+nouvelle.y1 -1;
	nouvelle.toVisu = (listeWin.getListe())[i].getVisu();
	nouvelle.toFile = (listeWin.getListe())[i].getFile();
        nouvelle.wavelength = (listeWin.getListe())[i].wavelength.floatValue();
        nouvelle.num = (listeWin.getListe())[i].num.intValue();
	tableWindows[nbLigne]= nouvelle;
      nbLigne++;
      }
  }

  public void intftocamera() {
      int indcam,nblig,ligdb,nbcol,coldb, num;
      float wavelength;
      boolean toVisu,toFile;
      Window newwin;
      ListeCamera listeCam = UserParameters.acquisition.listeCam;
      ListeWindow listeWin = new ListeWindow();

      for(int i=0; i <nbLigne; i++) {
	  indcam = tableWindows[i].camera;
	  //listeCam.getListe()[indcam].temperature = new Integer(tableWindows[i].temperature);
          wavelength = tableWindows[i].wavelength;
	  nblig = tableWindows[i].y2 - tableWindows[i].y1 +1;
	  ligdb = tableWindows[i].y1;
	  nbcol = tableWindows[i].x2 - tableWindows[i].x1 +1;
	  coldb = tableWindows[i].x1;
	  toVisu = tableWindows[i].toVisu;
	  toFile = tableWindows[i].toFile;
	  num =  tableWindows[i].num;
//          listeCam[indcam].temperature = new Integer(tableWindows[i].temperature);
	  try {
	    newwin = new Window(i,indcam,wavelength,nblig,ligdb,nbcol,coldb,toVisu,toFile,num);
	    listeWin.addWindow(newwin);
	  }
	  catch(BadValeurException e) {
            listeWin = new ListeWindow();
	    System.out.println(e.toString());
	  }
	}
      UserParameters.acquisition.listeWin = listeWin;

    }

  public void delete(int nb) {
    int i;
    for ( i = nb ; i < NB_LIGNE_MAX-1 ; i++ )
      tableWindows[ i ].init(tableWindows[ i + 1 ]);
    tableWindows[ NB_LIGNE_MAX-1 ].init(tableWindows[NB_LIGNE_MAX-2].num+1);
    nbLigne--;
    if ( nbLigne < 0 ) nbLigne = 0;
  }

  public void insert(int nb) {
    if ( nbLigne == NB_LIGNE_MAX ) return;
    for ( int i = nbLigne ; i > nb ; i-- )
      tableWindows[ i ].init(tableWindows[ i - 1 ]);
    tableWindows[ nb ].init(nb);
    nbLigne++;
  }
}
