// maintenu par Damien Debin
// cree le 4/4/2000

package iu;

import java.io.*;
import java.text.*;

public class ParamObservationStructure {
  public class Sequence {
    public int    loops = 0;
    public int    phase = Cible.NONE;
    public int    target = 0;
    public boolean extra = false;

    public Sequence() { init(); }

    public Sequence(Sequence t) { init(t); }

    public void init() {
      loops = 0;
      phase = Cible.NONE;
      target = 0;
      extra = false;
    }

    public void init(Sequence t) {
      loops = t.loops;
      phase = t.phase;
      target = t.target;
      extra = t.extra;
    }

  public String getDesc() {
    Observation obs = UserParameters.observation;
    switch (phase) {
      case Cible.TARGET : return new String(obs.tabCibles[target].obs_mode.getValeur()
          +" - "+Integer.toString(target+1)+" - "+obs.tabCibles[target].customName);
      case Cible.DARK : if (extra) return new String("extra DARK CURRENT - "
          +Integer.toString(target+1)+" - "+obs.extraDarks[target].customName);
        else return new String("DARK CURRENT - "
          +Integer.toString(target+1)+" - "+obs.tabDarks[target].customName);
      case Cible.FLATFIELD : if (extra) return new String("extra FLAT FIELD - "
          +Integer.toString(target+1)+" - "+obs.extraFlats[target].customName);
        else return new String("FLAT FIELD - "
          +Integer.toString(target+1)+" - "+obs.tabFlats[target].customName);
      default : return new String("");
    }
  }

  }

  public final static int NB_SEQUENCE_MAX = 16;
  public Sequence[] sequences = new Sequence[ NB_SEQUENCE_MAX ];
  public int nbSequence;
  public int nbRepetitions = 1;

  public ParamObservationStructure() {
    nbSequence = 0;
    for( int i = 0 ; i < NB_SEQUENCE_MAX ; i++ ) sequences[ i ] = new Sequence();
  }

  public Cible getCible(int i) {
System.out.println("[ParamObservationStructure.getCible] i="+i);
    Observation obs = UserParameters.observation;
    Sequence seq = sequences[i];
    int target = seq.target;
    boolean extra = seq.extra;
    
    switch (seq.phase) {
      case Cible.TARGET : return obs.tabCibles[target];
      case Cible.DARK : if (extra) return obs.extraDarks[target]; 
        else return obs.tabDarks[target];
      case Cible.FLATFIELD : if (extra) return obs.extraFlats[target]; 
        else return obs.tabFlats[target];
      default : return null;
    }
  }

  public void genereScripts() {
    AppIU.setStatus("Generating scripts...");

    try { Cible.setFilterCh(); }
    catch (BadValeurException e) { 
      AppIU.setStatus("Error while retrieving filterch from the UCCI : "
        +e.toString()); 
    }

    Cible cible;
    int indReg = 1;
    for(int i=0; i<nbSequence; i++) {
      cible = getCible(i);
      if (cible.type == Cible.TARGET) indReg++;
      cible.indreg = indReg;
      try { cible.genereScript(); }
      catch (BadValeurException e) { 
        AppIU.setStatus("Error while generating script for "+cible.getDesc(i)
          +" : "+e.toString()); 
      }
    }
  }
  
  private static final String sauvFormat1 = "'{'{0,number}'}'";
  private static final String sauvFormat2 = "'{'{0,number}'}' '{'{1,number}'}' '{'{2,number}'}' '{'{3,number}'}'";

  public void setObject_to_file(BufferedWriter out) throws IOException {
    String resultat;
    Object[] info1 = { new Integer(nbSequence) };
    Object[] info2 = new Object[4];

    resultat = new String("{SEQ}\n");
    out.write(resultat,0,resultat.length());

    MessageFormat form = new MessageFormat(sauvFormat1);
    resultat = new String(form.format(info1));
    out.write(resultat,0,resultat.length());
    out.newLine();

    form = new MessageFormat(sauvFormat2);
    for(int i=0;i<nbSequence;i++) {
      info2[0]=new Integer(sequences[i].loops);
      info2[1]=new Integer(sequences[i].phase);
      info2[2]=new Integer(sequences[i].target);
      info2[3]=new Integer(sequences[i].extra?1:0);
      resultat = new String(form.format(info2));
      out.write(resultat,0,resultat.length());
      out.newLine();
    }

    form = new MessageFormat(sauvFormat1);
    info1[0] = new Integer(nbRepetitions);
    resultat = new String(form.format(info1));
    out.write(resultat,0,resultat.length());
    out.newLine();

    resultat = new String("{/SEQ}\n");
    out.write(resultat,0,resultat.length());
  }

  public void getObject_from_File(BufferedReader in) throws IOException {
    getObject_from_File(in, new boolean[] { true, true });
  }

  public void getObject_from_File(BufferedReader in, boolean[] parties) throws IOException {
    Object constr[];
    String tostudy;
    ParsePosition status = new ParsePosition(0);
    MessageFormat form = new MessageFormat(sauvFormat1);

    in.readLine(); //{SEQ}

    tostudy = new String(in.readLine());
    status.setIndex(0);
    constr = form.parse(tostudy,status);
    if (parties[1]) nbSequence = Integer.parseInt(constr[0].toString());

    form = new MessageFormat(sauvFormat2);
    for (int i=0; i<nbSequence; i++) {
      tostudy = new String(in.readLine());
      status.setIndex(0);
      constr = form.parse(tostudy,status);
      if (parties[1]) {
        sequences[i].loops = Integer.parseInt(constr[0].toString());
        sequences[i].phase = Integer.parseInt(constr[1].toString());
        sequences[i].target = Integer.parseInt(constr[2].toString());
        sequences[i].extra = Integer.parseInt(constr[3].toString())==1;
      }
    }
    tostudy = new String(in.readLine());
    status.setIndex(0);
    form = new MessageFormat(sauvFormat1);
    constr = form.parse(tostudy,status);
    if (parties[1]) nbRepetitions = Integer.parseInt(constr[0].toString());

    in.readLine(); //{/SEQ}
  }

  public int getNbReg() {
    int n = 0;
    for (int i=0; i<nbSequence; i++)
      if (sequences[i].phase == Cible.TARGET) n++;
    return n;
  }

}
