/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Grassin-Minec-Debin
 * @version 1.0
 */

package iu;

import java.awt.*;
import javax.swing.*;
import javax.swing.text.JTextComponent;

public class ParamLine extends JPanel {
//  private JLabel jLabelParam = null;
  public JComponent jComponent  = null;
  private boolean isjComboBox;
  public String label;
  private GridBagLayout gridBagLayoutParam = new GridBagLayout();
  private JScrollPane jScrollPane;

  public String getText() {
    if (isjComboBox)
      return ( (JComboBox)jComponent ).getSelectedItem().toString();
    else
      return ( (JTextComponent)jComponent ).getText();
  }

  public void setText(Object valeur) {
    if (isjComboBox)
      ( (JComboBox)jComponent ).setSelectedItem(valeur);
    else
      ( (JTextComponent)jComponent ).setText(valeur.toString());
  }
/**
 * cree un JTextField
 */
  public ParamLine(String label, int modif, Object valeur) {
    int longueur;
    try {
      jComponent = new JTextField(valeur.toString());

      this.label = new String(label);

      if ( modif != 0 ) {
        ((JTextField)jComponent).setEditable(true);
        if (valeur instanceof String) longueur = 400;//180;
        else longueur = 100;
      }
      else {
        ((JTextField)jComponent).setEditable(false);
        longueur = 100;
      }
      ((JTextField)jComponent).setPreferredSize(new Dimension(jComponent.getWidth()+longueur, 20));
      ((JTextField)jComponent).setMinimumSize(new Dimension(longueur, 20));

      jbInit();
    }
    catch(Exception e) { e.printStackTrace(); }

    isjComboBox = false;
  }

/**
 * cree un JTextArea
 */
  public ParamLine(String label) {
    try {
      jComponent = new JTextArea(3, 34);

      this.label = new String(label);

      ((JTextArea)jComponent).setEditable(true);
      jScrollPane = new JScrollPane();

      jbInit();
    }
    catch(Exception e) { e.printStackTrace(); }

    isjComboBox = false;
  }

/**
 * cree un JComboBox
 */
  public ParamLine(String label, int modif, Object[] list) {
    try {
      jComponent = new JComboBox(list);
      ((JComboBox)jComponent).setSelectedItem(list[0]);
      this.label = new String(label);

      if ( modif != 0 ) ((JComboBox)jComponent).setEditable(true);
      else ((JComboBox)jComponent).setEditable(false);

      jbInit();
    }
    catch(Exception e) { e.printStackTrace(); }

    isjComboBox = true;
  }

  private void jbInit() throws Exception {

    if (jScrollPane == null)
      this.add(jComponent);
    else {
      jScrollPane.getViewport().add(jComponent);
      this.add(jScrollPane);
    }

    this.setToolTipText(label);
  }
}
