/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Grassin-Minec-Debin
 * @version 1.0
 */

package iu;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.filechooser.*;

public class PanelTech extends JPanel {
  FileIO fileIO;
  int currentTab = 0;

  JTabbedPane jTabbedPane = new JTabbedPane();
  CameraPanel cameraPanel;
//  MotorPanel motorPanel;
  FitsPanel fitsTechPanel;
//  SpecialPositionPanel specialPositionPanel = new SpecialPositionPanel();
  PolarPanel polarPanel;

  GridBagLayout gridBagLayout1 = new GridBagLayout();
//  JPanel jPanelHaut = new JPanel();
  JButton jButtonMenu = new JButton("menu");
  JLabel jLabelTitre = new JLabel("Technical parameters");
  JButton jButtonLoad = new JButton("load");
  JButton jButtonSave = new JButton("save");
//  JButton jButtonReset = new JButton("reset");
//  JButton jButtonHelp = new JButton("help");

  public PanelTech() {
    try {
      fileIO = new FileIO();
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    this.addFocusListener(new FocusListener() {
	    public void focusLost(FocusEvent e) { lostFocus(); }
	    public void focusGained(FocusEvent e) { gainedFocus(); }
    });
    
    cameraPanel = new CameraPanel();
//    motorPanel = new MotorPanel();
    fitsTechPanel = new FitsPanel(Keyword.SOURCETEC);
    polarPanel = new PolarPanel();

    jTabbedPane.addChangeListener(new javax.swing.event.ChangeListener() {
      public void stateChanged(ChangeEvent e) { jTabbedPane_stateChanged(); }
    });
    this.setLayout(gridBagLayout1);
    jLabelTitre.setFont(new java.awt.Font("Dialog", 1, 20));
    jLabelTitre.setHorizontalAlignment(SwingConstants.CENTER);
    jLabelTitre.setHorizontalTextPosition(SwingConstants.LEADING);
    jButtonLoad.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        fileIO.jButtonLoad_actionPerformed();
        gainedFocus();
      }
    });
    
    jButtonSave.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
//        jTabbedPane_stateChanged();
        lostFocus();
        fileIO.jButtonSave_actionPerformed();
      }
    });
/*    jButtonReset.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonReset_actionPerformed(e); }
    });
    jButtonHelp.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonHelp_actionPerformed(e); }
    });*/

    add(jTabbedPane, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jTabbedPane.addTab("Cameras", cameraPanel);
    jTabbedPane.addTab("Technical FITS", fitsTechPanel);
    jTabbedPane.addTab("Polarization", polarPanel);
//    jTabbedPane.addTab("Motors", motorPanel);
//    jTabbedPane.addTab("Special positions", specialPositionPanel);

    add(jButtonMenu, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    add(jLabelTitre, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
    add(jButtonLoad, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    add(jButtonSave, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
//    jPanelHaut.add(jButtonReset);
//    jPanelHaut.add(jButtonHelp);
/*    this.add(jPanelHaut, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
      ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));*/
  }

  void gainedFocus() {
    switch ( currentTab ) {
      case 0 : cameraPanel.gainedFocus(); break;
      case 1 : fitsTechPanel.gainedFocus(); break;
      case 2 : polarPanel.gainedFocus(); break;
//      case 2 : motorPanel.gainedFocus(); break;
//      case 3 : specialPositionPanel.gainedFocus(); break;
    }
  }

  public void lostFocus() {
    try {
      switch ( currentTab ) {
        case 0 : cameraPanel.lostFocus(); break;
        case 1 : fitsTechPanel.lostFocus(); break;
        case 2 : polarPanel.lostFocus(); break;
//        case 2 : motorPanel.lostFocus(); break;
//        case 3 : specialPositionPanel.lostFocus(); break;
      }
    }
    catch ( NumberFormatException ee) {
      JOptionPane.showMessageDialog(null, "Format error : numeric value expected.\n"
        + ee.getMessage(), "Error !", JOptionPane.ERROR_MESSAGE);
      currentTab += 100;
      jTabbedPane.setSelectedIndex(currentTab-100);
      ee.printStackTrace();
      return;
    }
    catch ( Exception ee) {
      JOptionPane.showMessageDialog(null, ee.getMessage(),
        "Error !", JOptionPane.ERROR_MESSAGE);
      currentTab += 100;
      jTabbedPane.setSelectedIndex(currentTab-100);
      ee.printStackTrace();
      return;
    }
  }

  void jTabbedPane_stateChanged() {
    lostFocus();
    currentTab = jTabbedPane.getSelectedIndex();
    gainedFocus();
  }
/*
  public void jButtonReset_actionPerformed(ActionEvent e) {
    JOptionPane.showMessageDialog(null, "This is not available yet.", "Sorry...",
      JOptionPane.INFORMATION_MESSAGE);
  }

  public void jButtonHelp_actionPerformed(ActionEvent e) {
    JOptionPane.showMessageDialog(null, "This is not available yet.", "Sorry...",
      JOptionPane.INFORMATION_MESSAGE);
  }*/
}
