
/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Grassin-Minec-Debin
 * @version 1.0
 */
package iu;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

public class PanelStart extends JPanel {
  FileIO fileIO;
  int currentTab = 0;

  JTabbedPane jTabbedPane = new JTabbedPane();
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  ObservationPanel observationPanel;
  ScriptEditorPanel scriptEditorPanel;
  JButton jButtonMenu = new JButton("menu");
  JLabel jLabelTitre = new JLabel("Start Observations");
  JButton jButtonLoad = new JButton("load");
  JButton jButtonSave = new JButton("save");

  public PanelStart() {
    try {
      fileIO = new FileIO();
      jbInit();
    }
    catch(Exception e) { e.printStackTrace(); }
  }

  private void jbInit() throws Exception {
/*    this.addFocusListener(new FocusListener() {
	    public void focusLost(FocusEvent e) { lostFocus(); }
	    public void focusGained(FocusEvent e) { 
        UserParameters.paramObservationStructure.genereScripts();
        gainedFocus(); 
      }
    });*/
    
    observationPanel = new ObservationPanel();
    scriptEditorPanel = new ScriptEditorPanel();

    jTabbedPane.addChangeListener(new javax.swing.event.ChangeListener() {
      public void stateChanged(ChangeEvent e) { jTabbedPane_stateChanged(); }
    });
    this.setLayout(gridBagLayout1);
    jLabelTitre.setFont(new java.awt.Font("Dialog", 1, 20));
    jLabelTitre.setHorizontalAlignment(SwingConstants.CENTER);
    jLabelTitre.setHorizontalTextPosition(SwingConstants.LEADING);
    jButtonLoad.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        fileIO.jButtonLoad_actionPerformed();
        gainedFocus();
      }
    });
    jButtonSave.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
//        jTabbedPane_stateChanged();
        lostFocus();
        fileIO.jButtonSave_actionPerformed();
      }
    });

    add(jTabbedPane, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

    jTabbedPane.add(observationPanel, "Observation");
    jTabbedPane.add(scriptEditorPanel, "Script edition");

    this.add(jButtonMenu, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    add(jLabelTitre, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
    add(jButtonLoad, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    add(jButtonSave, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
  }

  public void gainedFocus() {
    switch ( currentTab ) {
      case 1 : scriptEditorPanel.gainedFocus(); break;
      case 0 : observationPanel.gainedFocus(); break;
    }
  }

  public void lostFocus() {
    try {
      switch ( currentTab ) {
        case 1 : scriptEditorPanel.lostFocus(); break;
        case 0 : observationPanel.lostFocus(); break;
      }
    }
    catch ( NumberFormatException ee) {
      JOptionPane.showMessageDialog(null, "Format error : numeric value expected.\n"
        + ee.getMessage(), "Error !", JOptionPane.ERROR_MESSAGE);
      currentTab += 100;
      jTabbedPane.setSelectedIndex(currentTab-100);
      ee.printStackTrace();
      return;
    }
    catch ( Exception ee) {
      JOptionPane.showMessageDialog(null, ee.getMessage(),
        "Error !", JOptionPane.ERROR_MESSAGE);
      currentTab += 100;
      jTabbedPane.setSelectedIndex(currentTab-100);
      ee.printStackTrace();
      return;
    }
  }

  void jTabbedPane_stateChanged() {
    lostFocus();
    currentTab = jTabbedPane.getSelectedIndex();
    gainedFocus();
  }
}
