/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Grassin-Minec-Debin
 * @version 1.0
 */

package iu;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.filechooser.*;

public class PanelObs extends JPanel {
  FileIO fileIO;
  int currentTab = 0;

  JTabbedPane jTabbedPane = new JTabbedPane();

  TuningPanel tuningPanel;
  WindowsConfigPanel windowsConfigPanel;
  FitsPanel fitsParametersPanel;
  TargetsPanel targetsPanel;
  FlatFieldPanel flatFieldPanel;
//  FieldStopPanel fieldStopPanel;
  DarkPanel darkPanel;
//  ObservationModePanel observationModePanel;
  ObservationStructurePanel observationStructurePanel;
//  ScriptEditorPanel scriptEditorPanel = new ScriptEditorPanel();

  GridBagLayout gridBagLayout1 = new GridBagLayout();
//  JPanel jPanelHaut = new JPanel();
  JButton jButtonMenu = new JButton("menu");
  JLabel jLabelTitre = new JLabel("Observation settings");
  JButton jButtonLoad = new JButton("load");
  JButton jButtonSave = new JButton("save");
//  JButton jButtonReset = new JButton("reset");
//  JButton jButtonHelp = new JButton("help");

  public PanelObs() {
    try {
      fileIO = new FileIO();
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
/*    this.addFocusListener(new FocusListener() {
	    public void focusLost(FocusEvent e) { lostFocus(); }
	    public void focusGained(FocusEvent e) { 
        gainedFocus(); 
      }
    });*/
    
    tuningPanel = new TuningPanel();
    windowsConfigPanel = new WindowsConfigPanel();
    fitsParametersPanel = new FitsPanel(Keyword.SOURCEOBS);
    targetsPanel = new TargetsPanel();
    darkPanel = new DarkPanel();
    flatFieldPanel = new FlatFieldPanel();
//    fieldStopPanel = new FieldStopPanel();
//    observationModePanel = new ObservationModePanel();
    observationStructurePanel = new ObservationStructurePanel();

//    jTabbedPane.setTabPlacement(JTabbedPane.LEFT);
    jTabbedPane.addChangeListener(new javax.swing.event.ChangeListener() {
      public void stateChanged(ChangeEvent e) { jTabbedPane_stateChanged(); }
    });
    this.setLayout(gridBagLayout1);
    jLabelTitre.setFont(new java.awt.Font("Dialog", 1, 20));
    jButtonLoad.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        fileIO.jButtonLoad_actionPerformed();
        gainedFocus();
      }
    });
    jButtonSave.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        lostFocus();
        fileIO.jButtonSave_actionPerformed();
      }
    });
/*    jButtonReset.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonReset_actionPerformed(); }
    });
    jButtonHelp.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonHelp_actionPerformed(); }
    });*/

    add(jTabbedPane, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0,
      GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jTabbedPane.addTab("Windows configuration", windowsConfigPanel);
    jTabbedPane.addTab("FITS parameters", fitsParametersPanel);
    jTabbedPane.addTab("Tuning", tuningPanel);
    jTabbedPane.addTab("Targets", targetsPanel);
    jTabbedPane.addTab("Extra dark current", darkPanel);
    jTabbedPane.addTab("Extra flat field", flatFieldPanel);
//    jTabbedPane.addTab("Field stop", fieldStopPanel);
//    jTabbedPane.addTab("Observation mode", observationModePanel);
    jTabbedPane.addTab("Observing structure", observationStructurePanel);
//    jTabbedPane.addTab("Script editor", scriptEditorPanel);

    add(jButtonMenu, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0,
      GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    add(jLabelTitre, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0,
      GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    add(jButtonLoad, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0,
      GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    add(jButtonSave, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0,
      GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
//    jPanelHaut.add(jButtonReset);
//    jPanelHaut.add(jButtonHelp);
/*    this.add(jPanelHaut, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0,
      GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));*/
  }

  void gainedFocus() {
    switch ( currentTab ) {
      case 0 : windowsConfigPanel.gainedFocus(); break;
      case 1 : fitsParametersPanel.gainedFocus(); break;
      case 2 : tuningPanel.gainedFocus(); break;
      case 3 : targetsPanel.gainedFocus(); break;
      case 4 : darkPanel.gainedFocus(); break;
      case 5 : flatFieldPanel.gainedFocus(); break;
      case 6 : observationStructurePanel.gainedFocus(); break;
    }
  }

  void lostFocus() {
    try {
      switch ( currentTab ) {
        case 0 : windowsConfigPanel.lostFocus(); break;
        case 1 : fitsParametersPanel.lostFocus(); break;
        case 2 : tuningPanel.lostFocus(); break;
        case 3 : targetsPanel.lostFocus(); break;
        case 4 : darkPanel.lostFocus(); break;
        case 5 : flatFieldPanel.lostFocus(); break;
        case 6 : observationStructurePanel.lostFocus(); break;
      }
    }
/**
 * Attention, subtilit : pour revenir au panel currentTab, il faut faire
 *       jTabbedPane.setSelectedIndex(currentTab);
 * Mais alors jTabbedPane_stateChanged() est rappel, avec currentTab inchang, donc
 * le {currentTab}.lostFocus() est rappel. Rsultat, on a 2 fois le message d'erreur.
 * Astuce : on change la valeur de currentTab, mais on passe la vrai valeur en
 * paramtre de jTabbedPane.setSelectedIndex().
 * currentTab est alors actualis par jTabbedPane_stateChanged().
 */
    catch ( NumberFormatException ee) {
      JOptionPane.showMessageDialog(null, "Format error : numeric value expected.\n"
        + ee.getMessage(), "Error !", JOptionPane.ERROR_MESSAGE);
      currentTab += 100;
      jTabbedPane.setSelectedIndex(currentTab-100);
      ee.printStackTrace();
      return;
    }
    catch ( Exception ee) {
      JOptionPane.showMessageDialog(null, ee.getMessage(),
        "Error !", JOptionPane.ERROR_MESSAGE);
      currentTab += 100;
      jTabbedPane.setSelectedIndex(currentTab-100);
      ee.printStackTrace();
      return;
    }
  }

  void jTabbedPane_stateChanged() {
    lostFocus();
    currentTab = jTabbedPane.getSelectedIndex();
    gainedFocus();
  }

}
