/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Grassin-Minec-Debin
 * @version 1.0
 */

package iu;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.filechooser.*;

public class PanelData extends JPanel {
//  FileIO fileIO;
  int currentTab = 0;

  JTabbedPane jTabbedPane = new JTabbedPane();
  SequencePanel sequencePanel;


  GridBagLayout gridBagLayout1 = new GridBagLayout();

  JButton jButtonMenu = new JButton("menu");
  JLabel jLabelTitre = new JLabel("Data Utilities");




  public PanelData() {
    try {
//      fileIO = new FileIO();
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    sequencePanel = new SequencePanel();


    jTabbedPane.addChangeListener(new javax.swing.event.ChangeListener() {
      public void stateChanged(ChangeEvent e) { jTabbedPane_stateChanged(); }
    });
    this.setLayout(gridBagLayout1);
    jLabelTitre.setFont(new java.awt.Font("Dialog", 1, 20));
    jLabelTitre.setHorizontalAlignment(SwingConstants.CENTER);
    jLabelTitre.setHorizontalTextPosition(SwingConstants.LEADING);


    add(jTabbedPane, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jTabbedPane.addTab("Data Utilities", sequencePanel);


    add(jButtonMenu, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    add(jLabelTitre, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));


  }

  void gainedFocus() {
    switch ( currentTab ) {
      case 0 : sequencePanel.gainedFocus(); break;

    }
  }

  public void lostFocus() {
    try {
      switch ( currentTab ) {
        case 0 : sequencePanel.lostFocus(); break;
      }
    }
    catch ( NumberFormatException ee) {
      JOptionPane.showMessageDialog(null, "Format error : numeric value expected.\n"
        + ee.getMessage(), "Error !", JOptionPane.ERROR_MESSAGE);
      currentTab = -currentTab;
      jTabbedPane.setSelectedIndex(-currentTab);
      ee.printStackTrace();
      return;
    }
    catch ( Exception ee) {
      JOptionPane.showMessageDialog(null, ee.getMessage(),
        "Error !", JOptionPane.ERROR_MESSAGE);
      currentTab = -currentTab;
      jTabbedPane.setSelectedIndex(-currentTab);
      ee.printStackTrace();
      return;
    }
  }

  void jTabbedPane_stateChanged() {
    lostFocus();
    currentTab = jTabbedPane.getSelectedIndex();
    gainedFocus();
  }

}
