/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Grassin-Minec-Debin
 * @version 1.0
 */

package iu;

import java.awt.*;
import java.awt.event.*;
import java.text.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.AbstractTableModel;

public class ObservationStructurePanel extends JPanel {
  BorderLayout borderLayoutThis = new BorderLayout();

  GridBagLayout gridBagLayoutGlobalSequence = new GridBagLayout();
  GridBagLayout gridBagLayout2 = new GridBagLayout();
  JScrollPane jScrollPaneGlobalSequence = new JScrollPane();
  JPanel jPanelGlobalSequence = new JPanel();
  JPanel jPanelDefinition = new JPanel();
//  DessinPanel jPanelDessin = new DessinPanel();
  JLabel jLabelGlobal = new JLabel("global sequence x ");
  JTable jTableGlobalSequence;
  JTextField jTextFieldNb = new JTextField("1", 2);
  ObservationStructureTableModel observationStructureTableModel;
  String[] noList;
  JComboBox jComboBoxNoList;
  JButton jButtonInsert = new JButton("insert");
  JButton jButtonDown = new JButton("down");
  JButton jButtonUp = new JButton("up");
  JButton jButtonDelete = new JButton("delete");
  JButton jButtonGetScript = new JButton("show script");
  JButton jButtonGetFits = new JButton("show FITS keywords");

  public ObservationStructurePanel() {
    try { jbInit(); }
    catch(Exception e) { e.printStackTrace(); }
  }

  private void jbInit() throws Exception {
    initComponents();

    setLayout(borderLayoutThis);
    jPanelGlobalSequence.setLayout(gridBagLayoutGlobalSequence);
    jPanelGlobalSequence.setBorder(BorderFactory.createRaisedBevelBorder());
    jPanelDefinition.setLayout(gridBagLayout2);
    jPanelDefinition.setBorder(BorderFactory.createEtchedBorder());
    Font fontDialog = new Font("Dialog", 1, 20);

    jLabelGlobal.setFont(fontDialog);
    jButtonInsert.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonInsert_actionPerformed(); }
    });
    jButtonDown.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonDown_actionPerformed(); }
    });
    jButtonUp.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonUp_actionPerformed(); }
    });
    jButtonDelete.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonDelete_actionPerformed(); }
    });
    jButtonGetScript.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jButtonGetScript_actionPerformed(getSelectedCible());
      }
    });
    jButtonGetFits.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jButtonGetFits_actionPerformed(getSelectedCible());
      }
    });
    this.add(jPanelGlobalSequence, BorderLayout.CENTER);
    jPanelDefinition.add(jButtonInsert, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDefinition.add(jButtonDelete, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDefinition.add(jButtonUp, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDefinition.add(jButtonDown, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDefinition.add(jButtonGetScript, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDefinition.add(jButtonGetFits, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDefinition.add(jLabelGlobal, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDefinition.add(jTextFieldNb, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

    jPanelGlobalSequence.add(jPanelDefinition, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelGlobalSequence.add(jScrollPaneGlobalSequence, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
/*    jPanelGlobalSequence.add(jPanelDessin, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 
      GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5,5,5,5), 
      DessinPanel.DIM, DessinPanel.DIM));*/
//    jPanelDessin.repaint();
  }

  private void initComponents() {
    observationStructureTableModel = new ObservationStructureTableModel();
    jTableGlobalSequence = new JTable(observationStructureTableModel);
    jTableGlobalSequence.getColumnModel().getColumn(0).setPreferredWidth(200);
    jTableGlobalSequence.getColumnModel().getColumn(1).setPreferredWidth(50);
    jTableGlobalSequence.getColumnModel().getColumn(2).setPreferredWidth(50);
    jTableGlobalSequence.getColumnModel().getColumn(3).setPreferredWidth(50);
    observationStructureTableModel.addTableModelListener(new javax.swing.event.TableModelListener() {
      public void tableChanged(TableModelEvent e) { observationStructureTableModel_tableChanged(e); }
    });
    jScrollPaneGlobalSequence.getViewport().add(jTableGlobalSequence, null);
  }

  private void initCombos() {
    int j=0;
    Observation obs = UserParameters.observation;
    noList = new String[obs.nbCibles*3+obs.nbDarks+obs.nbFlats];
    for( int i = 0 ; i < obs.nbCibles ; i++ ) {
      noList[j++] = obs.tabCibles[i].getDesc(i);
      noList[j++] = obs.tabDarks[i].getDesc(i);
      noList[j++] = obs.tabFlats[i].getDesc(i);
/*      noList[ j++ ] = obs.tabCibles[i].obs_mode.getValeur()+" - "+Integer.toString(i+1)+" - "+obs.tabCibles[i].customName;
      noList[ j++ ] = "DARK CURRENT - "+Integer.toString(i+1)+" - "+obs.tabDarks[i].customName;
      noList[ j++ ] = "FLAT FIELD - "+Integer.toString(i+1)+" - "+obs.tabFlats[i].customName;*/
    }
    for( int i = 0 ; i < obs.nbDarks ; i++ )
      noList[ j++ ] = "extra "+obs.extraDarks[i].getDesc(i);//"extra DARK CURRENT - "+Integer.toString(i+1)+" - "+obs.extraDarks[ i ].customName;
    for( int i = 0 ; i < obs.nbFlats ; i++ )
      noList[ j++ ] = "extra "+obs.extraFlats[i].getDesc(i);//"extra FLAT FIELD - "+Integer.toString(i+1)+" - "+obs.extraFlats[ i ].customName;

    jComboBoxNoList = new JComboBox(noList);
  }

  private void setTable() {
    int t, p;
    ParamObservationStructure param = UserParameters.paramObservationStructure;
    Observation obs = UserParameters.observation;
    observationStructureTableModel.nbRow = param.nbSequence;
    for (int i = 0 ; i < param.nbSequence ; i++ ) {
      t = param.sequences[ i ].target;
      p = param.sequences[ i ].phase;

      if (p==Cible.TARGET) {
        observationStructureTableModel.data[ i ][ 1 ] = obs.tabCibles[ t ].object.getValeur();
        observationStructureTableModel.data[ i ][ 2 ] = obs.tabCibles[ t ].obj_id.getValeur();
      } else {
        observationStructureTableModel.data[ i ][ 1 ] = "";
        observationStructureTableModel.data[ i ][ 2 ] = "";
      }
      //((JComboBox)observationStructureTableModel.data[ i ][ 0 ]).setSelectedItem(param.sequences[ i ].getDesc());
      observationStructureTableModel.data[ i ][ 0 ] = param.sequences[ i ].getDesc();
      observationStructureTableModel.data[ i ][ 3 ] = new Integer(param.sequences[ i ].loops);
    }
    if (param.nbSequence>0) jTableGlobalSequence.setRowSelectionInterval(0,0);
  }

  private void getTable() {
    ParamObservationStructure param = UserParameters.paramObservationStructure;
    param.nbSequence = observationStructureTableModel.nbRow;
    for ( int i = 0 ; i < observationStructureTableModel.nbRow ; i++ ) {
      String s = (String)observationStructureTableModel.data[ i ][ 0 ];

      param.sequences[ i ].target = getNoCible(s);
      param.sequences[ i ].phase = getPhase(s);
      param.sequences[ i ].loops = ((Integer)(observationStructureTableModel.data[ i ][ 3 ])).intValue();
      param.sequences[ i ].extra = s.substring(0, 5).equals("extra");
    }
  }

  public void gainedFocus() {
    try { Cible.setFilterCh(); }
    catch (BadValeurException e) { System.err.println(e); }
    initCombos();
    jTableGlobalSequence.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(jComboBoxNoList));
    setTable();
    observationStructureTableModel.fireTableDataChanged();
    jTextFieldNb.setText(Integer.toString(UserParameters.paramObservationStructure.nbRepetitions));
  }

  public void lostFocus() {
    getTable();
    UserParameters.paramObservationStructure.nbRepetitions = Integer.parseInt(jTextFieldNb.getText());
  }

  private int getPhase(String s) {
    MessageFormat form1 = new MessageFormat("{0} - {1,number}");
    Object[] constr = form1.parse(s,new ParsePosition(0));
    if (constr[0].toString().endsWith("DARK CURRENT")) return Cible.DARK;
    if (constr[0].equals("SCAN") || constr[0].equals("CALIB")) return Cible.TARGET;
    if (constr[0].toString().endsWith("FLAT FIELD")) return Cible.FLATFIELD;
    return Cible.NONE;
  }

  private int getNoCible(String s) {
    MessageFormat form1 = new MessageFormat("{0} - {1,number}");
    Object[] constr = form1.parse(s,new ParsePosition(0));
    return Integer.parseInt(constr[1].toString())-1;
  }

  public void observationStructureTableModel_tableChanged(TableModelEvent e) {
    Object[][] data = observationStructureTableModel.data;
    if (  e.getType() == e.UPDATE && e.getColumn() == 0 ) {
      int i = e.getFirstRow();
      String ch = (String)data[ i ][ 0 ];
      if (getPhase(ch) == Cible.TARGET) {
        Cible c = UserParameters.observation.tabCibles[getNoCible(ch)];
        data[ i ][ 1 ] = c.object.getValeur();
        data[ i ][ 2 ] = c.obj_id.getValeur();
      } else {
        data[ i ][ 1 ] = "";
        data[ i ][ 2 ] = "";
      }
      jTableGlobalSequence.setRowSelectionInterval(i,i);
      observationStructureTableModel.fireTableDataChanged();
    }
//    if ( data[ observationStructureTableModel.nbRow - 1 ][ 0 ].equals(new String("none")) == false ) {
//      observationStructureTableModel.nbRow++;
//      observationStructureTableModel.fireTableDataChanged();
//    }
  }

  public void jButtonInsert_actionPerformed() {
    int i = jTableGlobalSequence.getSelectedRow();
    observationStructureTableModel.insert(i);
    if (i<0) i=0; 
    jTableGlobalSequence.setRowSelectionInterval(i,i);
  }

  void jButtonDelete_actionPerformed() {
    observationStructureTableModel.delete(jTableGlobalSequence.getSelectedRow());
  }

  private Cible getSelectedCible() {
    Cible cible;
    int i = jTableGlobalSequence.getSelectedRow();
    if (i < 0) return null; // rien n'est slectionn
    String s = (String)observationStructureTableModel.data[i][0];
    int target = getNoCible(s);
    int phase = getPhase(s);
    boolean extra = s.startsWith("extra");

    switch (phase) {
      case Cible.TARGET :
        cible = UserParameters.observation.tabCibles[target];
        break;
      case Cible.DARK :
        if (extra) cible = UserParameters.observation.extraDarks[target];
        else cible = UserParameters.observation.tabDarks[target];
        break;
      case Cible.FLATFIELD :
        if (extra) cible = UserParameters.observation.extraFlats[target];
        else cible = UserParameters.observation.tabFlats[target];
        break;
      default :
        cible = null;
    }
    return cible;
  }

  void jButtonGetScript_actionPerformed(Cible cible) {
    if ( cible != null ) {
      lostFocus();
      try {
        cible.genereScript();
        JTextArea jta = new JTextArea();
        Object[] tab = cible.scriptIO.toArray();
        for (int i=0; i<tab.length; i++)
          jta.append( "-------- "+((Instruction)tab[i]).getMachine()+" --------\n"
            +((Instruction)tab[i]).getScript()+"\n" );
        jta.setFont(new Font("DialogInput", Font.PLAIN, 12));
        jta.setEditable(false);
        JScrollPane jsp = new JScrollPane(jta);
        jsp.setPreferredSize(new Dimension(400, 600));
          
        JOptionPane pane = new JOptionPane(jsp, JOptionPane.PLAIN_MESSAGE); 
        pane.createDialog(null, "Script of '"
          +(String)observationStructureTableModel.data[jTableGlobalSequence
            .getSelectedRow()][0]+"'").show();
      }
      catch (BadValeurException e) { System.err.println(e); }
    } else {
	AppIU.setStatus("Select a line first.");
	 JOptionPane.showMessageDialog(null, "No line selected.","Error", JOptionPane.ERROR_MESSAGE);
      }

  }

  void jButtonGetFits_actionPerformed(Cible cible) {
    if ( cible != null ) {
      lostFocus();
      String s = (String)observationStructureTableModel.data[jTableGlobalSequence.getSelectedRow()][0];
      try {
        JTextArea jta = new JTextArea(cible.getmotcle(false).texte);
        jta.setEditable(false);
        jta.setFont(new Font("DialogInput", Font.PLAIN, 12));
        JScrollPane jsp = new JScrollPane(jta);
        jsp.setPreferredSize(new Dimension(400, 600));

        JOptionPane pane = new JOptionPane(jsp, JOptionPane.PLAIN_MESSAGE);
        pane.createDialog(null, "FITS keywords of '"+s+"'").show();
      }
      catch (BadValeurException e) {
        AppIU.setStatus("Error in the FITS keyword of '"+s+"'");
        JOptionPane.showMessageDialog(null, e.getMessage(),
          "Error in the FITS keyword of '"+s+"'", JOptionPane.ERROR_MESSAGE);
      }
    } else  {
	AppIU.setStatus("Select a line first.");
	JOptionPane.showMessageDialog(null, "No line selected.",
        "Error", JOptionPane.ERROR_MESSAGE);
	}
  }

  void jButtonUp_actionPerformed() {
    int nb = jTableGlobalSequence.getSelectedRow();
    if ( observationStructureTableModel.moveUp(nb) )
      jTableGlobalSequence.setRowSelectionInterval(nb - 1, nb - 1);
  }

  void jButtonDown_actionPerformed() {
    int nb = jTableGlobalSequence.getSelectedRow();
    if ( observationStructureTableModel.moveDown(nb) )
      jTableGlobalSequence.setRowSelectionInterval(nb + 1, nb + 1);
  }

  private class ObservationStructureTableModel extends AbstractTableModel {
    int nbRow = 0; //correspond au nombre de ligne affichee = nb ligne remplie + 1 ligne free
    final String[] columnNames = {"phase - target# - custom name","name","ident.#","loops"};
    public final static int NB_SEQUENCE_MAX = ParamObservationStructure.NB_SEQUENCE_MAX;
    public final Object[][] data = new Object[ NB_SEQUENCE_MAX ][ 4 ];

    public int getColumnCount() { return columnNames.length; }

    public int getRowCount() { return nbRow; }

    public String getColumnName(int col) { return columnNames[col]; }

    public Object getValueAt(int row, int col) { return data[row][col]; }

    public Class getColumnClass(int c) {
      return getValueAt(0, c).getClass();
    }

    public boolean isCellEditable(int row, int col) {
      if ( col == 1 || col == 2 ) return false;
      else return true;
    }

    public void setValueAt(Object value, int row, int col) {
      if (data[0][col] instanceof Integer && !(value instanceof Integer)) {
        try {
          data[row][col] = new Integer(value.toString());
          fireTableCellUpdated(row, col);
        } catch (NumberFormatException e) {
          AppIU.setStatus("The \"" + getColumnName(col)
          + "\" column accepts only integer values.");
          JOptionPane.showMessageDialog(null,
          "The \"" + getColumnName(col)
          + "\" column accepts only integer values.");
        }
      } else {
        data[row][col] = value;
        fireTableCellUpdated(row, col);
      }
    }

    private void init(int nb) {
      Cible c = UserParameters.observation.tabCibles[ 0 ];
      data[ nb ][ 0 ] = c.obs_mode.getValeur()+" - 1 - "+c.customName;
      data[ nb ][ 1 ] = c.object.getValeur();
      data[ nb ][ 2 ] = c.obj_id.getValeur();
      data[ nb ][ 3 ] = new Integer(1);
    }

    private void copy(int nb1, int nb2) {
      data[ nb1 ][ 0 ] = data[ nb2 ][ 0 ];
      data[ nb1 ][ 1 ] = data[ nb2 ][ 1 ];
      data[ nb1 ][ 2 ] = data[ nb2 ][ 2 ];
      data[ nb1 ][ 3 ] = data[ nb2 ][ 3 ];
    }

    private void swapLine(int nb1, int nb2) {
      for(int i=0;i<4;i++) {
        Object t = data[nb1][i];
        data[nb1][i] = data[nb2][i];
        data[nb2][i] = t;
      }
    }

    public boolean moveUp(int nb1) {
      int nb2 = nb1 - 1;
      if (nb2 < 0) return false;
      swapLine(nb1,nb2);
      fireTableDataChanged();
      return true;
    }

    public boolean moveDown(int nb1) {
      int nb2 = nb1 + 1;
      if (nb2 > nbRow - 1) return false;
      swapLine(nb1,nb2);
      fireTableDataChanged();
      return true;
    }

    public void delete(int nb) {
      if (nb == -1) return;
      for ( int i = nb ; i < nbRow - 1 ; i++ )
        copy(i, i + 1);
      if ( --nbRow < 0 ) nbRow = 0;
      init(nbRow);
      fireTableDataChanged();
    }

    public void insert(int nb) {
      if (nbRow == 0) nb = -1;

      for ( int i = nbRow ; i > nb + 1 ; i-- )
        copy(i, i - 1);
      init(nb + 1);
      nbRow++;
      fireTableDataChanged();
    }
  }
}
/*
class DessinPanel extends JPanel {
    public static final int DIM = 400;

    public DessinPanel() {
    }

    public void paint(Graphics g) {
      super.paint(g);

      g.setColor(Color.yellow);
      g.setPaintMode();
      g.fillArc(0, 0, DIM, DIM, 0, 360);
      g.setColor(Color.black);
      g.drawArc(0, 0, DIM, DIM, 0, 360);
      g.drawRect();

    }
}
*/
