
/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Grassin-Minec-Debin
 * @version 1.0
 */
package iu;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;

public class ObservationPanel extends JPanel {

  static public final int ABORT = 0;
  static public final int RETRY = 1;
  static public final int CONTINUE = 2;
  private ProgObservation prog = null;

  BorderLayout borderLayout1 = new BorderLayout();
  JPanel jPanel1 = new JPanel();
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  JPanel jPanel2 = new JPanel();
  JPanel jPanel3 = new JPanel();
  JPanel jPanel4 = new JPanel();
  Border border1;
  TitledBorder titledBorder1;
  Border border2;
  TitledBorder titledBorder2;
  Border border3;
  TitledBorder titledBorder3;
  GridBagLayout gridBagLayout2 = new GridBagLayout();
  JPanel jPanel5 = new JPanel();
  ButtonGroup buttonGroupError = new ButtonGroup();
  JRadioButton jRadioButtonAbort = new JRadioButton("Abort observation", true);
  JRadioButton jRadioButtonRetry = new JRadioButton("Retry same observation", false);
  JRadioButton jRadioButtonContinue = new JRadioButton("Continue if possible", false);
  GridBagLayout gridBagLayout3 = new GridBagLayout();
  JCheckBox jCheckBoxFits = new JCheckBox("FITS", false);
  JCheckBox jCheckBoxTargets = new JCheckBox("Targets", false);
  JCheckBox jCheckBoxCameras = new JCheckBox("Cameras", false);
  JCheckBox jCheckBoxStructure = new JCheckBox("Observation structure", false);
  JPanel jPanel6 = new JPanel();
//  JPanel jPanelMessages = new JPanel();
  JPanel jPanel8 = new JPanel();
  JPanel jPanelProgress = new JPanel();
  GridBagLayout gridBagLayout4 = new GridBagLayout();
  Border border4;
  TitledBorder titledBorderMessages;
  BorderLayout borderLayout2 = new BorderLayout();
  JScrollPane jScrollPane1 = new JScrollPane();
//  JPanel jPanel9 = new JPanel();
  JLabel jLabelSeqNb = new JLabel("Sequence number ");
  JLabel jLabel1 = new JLabel();
  JLabel jLabelType = new JLabel("Type");
  JLabel jLabelFits = new JLabel("FITS");
  JLabel jLabel5 = new JLabel();
  JLabel jLabel6 = new JLabel();
  JLabel jLabel7 = new JLabel();
  JLabel jLabelOfLoop = new JLabel("of");
  JLabel jLabelOfPhase = new JLabel("of");
  JLabel jLabelOfSeq = new JLabel("of");
  JTextField jTextFieldTotalLoop = new JTextField("0", 3);
  JTextField jTextFieldTotalPhase = new JTextField("0", 3);
  JTextField jTextFieldTotalSeq = new JTextField("0", 3);
  JTextField jTextFieldFits = new JTextField("");
//  JTextField jTextField2 = new JTextField();
  JTextField jTextFieldPhaseName = new JTextField("");
  JTextField jTextFieldType = new JTextField("");
  JTextField jTextFieldNoPhase = new JTextField("0", 3);
  JTextField jTextFieldNoSeq = new JTextField("0", 3);
  JTextField jTextFieldNoLoop = new JTextField("0", 3);
  JTextArea jTextAreaMessages = new JTextArea(6, 34);
  JProgressBar jProgressBar1 = new JProgressBar();
  GridBagLayout gridBagLayout5 = new GridBagLayout();
  JButton jButtonStop = new JButton("stop");
//  JButton jButtonReset = new JButton("reset");
  JButton jButtonStart = new JButton("start");
//  JButton jButtonFormatage = new JButton("formatage");
  JLabel jLabelEndTime = new JLabel("estimated end time");
  JLabel jLabelStartTime = new JLabel("start time");
  JTextField jTextFieldEndTime = new JTextField("00:00:00", 6);
  JTextField jTextFieldStartTime = new JTextField("00:00:00", 6);
  JTextField jTextFieldSeq = new JTextField("1", 5);
  GridBagLayout gridBagLayout6 = new GridBagLayout();

  public ObservationPanel() {
    try { jbInit(); }
    catch(Exception e) { e.printStackTrace(); }
  }

  private void jbInit() throws Exception {
    border1 = BorderFactory.createEtchedBorder();//Color.white,new Color(142, 142, 142));
    titledBorder1 = new TitledBorder(border1,"Check parameters");
    border2 = BorderFactory.createEtchedBorder(/*Color.white,new Color(142, 142, 142)*/);
    titledBorder2 = new TitledBorder(border2,"On error");
    border3 = BorderFactory.createEtchedBorder(/*Color.white,new Color(142, 142, 142)*/);
    titledBorder3 = new TitledBorder(border3,"Observation status");
    border4 = BorderFactory.createEtchedBorder(/*Color.white,new Color(142, 142, 142)*/);
    titledBorderMessages = new TitledBorder(border4,"Messages");
    this.setLayout(borderLayout1);
    jPanel1.setLayout(gridBagLayout1);
    jPanel2.setBorder(titledBorder1);
    jPanel2.setLayout(gridBagLayout2);
    jPanel3.setBorder(titledBorder2);
    jPanel3.setLayout(gridBagLayout3);
    jPanel4.setBorder(titledBorder3);
    jPanel4.setLayout(gridBagLayout4);
    buttonGroupError.add(jRadioButtonRetry);
//    jRadioButtonRetry.setEnabled(false);
    buttonGroupError.add(jRadioButtonAbort);
    buttonGroupError.add(jRadioButtonContinue);
    jCheckBoxFits.setEnabled(false);
    jCheckBoxTargets.setEnabled(false);
    jCheckBoxCameras.setEnabled(false);
    jCheckBoxStructure.setEnabled(false);
    jTextAreaMessages.setEditable(false);
    jTextAreaMessages.setPreferredSize(new Dimension(250, 100));
//    jTextAreaMessages.setBackground(SystemColor.info);
//    jPanelMessages.setBorder(titledBorderMessages);
//    jPanelMessages.setLayout(borderLayout2);
    jLabel1.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabel1.setText("Loop");
    jLabelType.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabelFits.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabel5.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabel5.setText("Custom name");
    jLabel6.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabel6.setText("Phase");
    jLabel7.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabel7.setText("Global sequence");
    jTextFieldFits.setEditable(false);
    jTextFieldNoLoop.setEditable(false);
    jTextFieldPhaseName.setEditable(false);
    jTextFieldPhaseName.setPreferredSize(new Dimension(150,20));
    jTextFieldPhaseName.setMinimumSize(new Dimension(150,20));
    jTextFieldType.setEditable(false);
    jTextFieldNoPhase.setEditable(false);
    jTextFieldNoSeq.setEditable(false);
    jTextFieldTotalLoop.setEditable(false);
    jTextFieldTotalPhase.setEditable(false);
    jTextFieldTotalSeq.setEditable(false);

    jProgressBar1.setMinimum(0);
    jProgressBar1.setStringPainted(true);

    jPanel8.setLayout(gridBagLayout5);
    jPanelProgress.setLayout(gridBagLayout5);
//    jButtonFormatage.setEnabled(false);
    jButtonStop.setEnabled(false);
//    jButtonStop.setMargin(new Insets(2, 10, 2, 10));
//    jButtonReset.setMargin(new Insets(2, 10, 2, 10));
//    jButtonStart.setMargin(new Insets(2, 10, 2, 10));
    jButtonStart.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonStart_actionPerformed(); }
    });
//    jButtonFormatage.setMargin(new Insets(2, 10, 2, 10));
/*    jButtonFormatage.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonFormatage_actionPerformed(); }
    });*/
    jButtonStop.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonStop_actionPerformed(); }
    });
/*    jButtonReset.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonReset_actionPerformed(); }
    });*/
    jTextFieldEndTime.setEditable(false);
    jTextFieldStartTime.setEditable(false);

    jTextFieldSeq.setInputVerifier(new Verif(Verif.TYPEINT, 0));

    jTextFieldSeq.addFocusListener(new FocusAdapter() {
      public void focusLost(FocusEvent e) { 
        if ( Integer.parseInt(jTextFieldSeq.getText())
          < ((Integer)UserParameters.paramFits.getKeyword("SEQ_IND").getValeur())
            .intValue() )
          if (JOptionPane.showConfirmDialog(null, "The sequence index you entered "
            +"is lower than the previous one. Please confirm this change.", 
            "Warning !",  JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE) 
            == JOptionPane.YES_OPTION)
            UserParameters.observation.setSeqInd(new Integer(jTextFieldSeq.getText()).intValue());
          else jTextFieldSeq.setText(UserParameters.paramFits.getKeyword("SEQ_IND")
            .getValeur().toString());
      }
    });

    jPanel6.setLayout(gridBagLayout6);
    this.add(jPanel1, BorderLayout.CENTER);
    jPanel1.add(jLabelSeqNb,new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanel1.add(jTextFieldSeq,new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanel1.add(jPanel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel2.add(jCheckBoxFits, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanel2.add(jCheckBoxTargets, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanel2.add(jCheckBoxCameras, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanel2.add(jCheckBoxStructure, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanel2.add(jPanel5, new GridBagConstraints(0, 4, 2, 2, 0.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanel1.add(jPanel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel3.add(jRadioButtonAbort, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanel3.add(jRadioButtonRetry, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanel3.add(jRadioButtonContinue, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanel1.add(jPanel4, new GridBagConstraints(1, 1, 1, 2, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel4.add(jPanel8, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));

//    jPanel8.add(jTextField2, new GridBagConstraints(1, 4, 5, 1, 1.0, 0.0
//            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jLabel7, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jTextFieldNoSeq, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jLabelOfSeq, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jTextFieldTotalSeq, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jLabel6, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jTextFieldNoPhase, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jLabelOfPhase, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jTextFieldTotalPhase, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jLabelType, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jTextFieldType, new GridBagConstraints(5, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jLabel5, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jTextFieldPhaseName, new GridBagConstraints(1, 2, 5, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jLabel1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jTextFieldNoLoop, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jLabelOfLoop, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jTextFieldTotalLoop, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jLabelFits, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel8.add(jTextFieldFits, new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));

    jPanel4.add(jPanelProgress, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelProgress.add(jProgressBar1, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelProgress.add(jLabelStartTime, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelProgress.add(jTextFieldStartTime, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelProgress.add(jLabelEndTime, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelProgress.add(jTextFieldEndTime, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));

    jScrollPane1.getViewport().add(jTextAreaMessages/*, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0)*/);
    jPanel4.add(jScrollPane1, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
//    jPanelMessages.add(jScrollPane1, BorderLayout.CENTER);

    jPanel4.add(jPanel6, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
/*    jPanel6.add(jButtonFormatage, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
*/
    jPanel6.add(jButtonStart, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel6.add(jButtonStop, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
/*    jPanel6.add(jButtonReset, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));*/
  }

  public void gainedFocus() {
    ParamObservationStructure structure = UserParameters.paramObservationStructure;

    UserParameters.observation.setProgNum(false);
    estimationFin(UserParameters.observation);
//    jTextFieldEndTime.setText();
    jTextFieldSeq.setText(((Integer)UserParameters.paramFits.getKeyword("SEQ_IND").getValeur()).toString());
    System.out.println("[ObservationPanel.gainedFocus] seq_ind="
		      + UserParameters.paramFits.getKeyword("SEQ_IND").getValeur());

    jTextFieldTotalPhase.setText(Integer.toString(structure.nbSequence));
    jTextFieldTotalSeq.setText(Integer.toString(structure.nbRepetitions));
    if (prog!= null) if (!prog.threadRunning) {
      jTextFieldTotalLoop.setText("0");
      jTextFieldNoLoop.setText("0");
      jTextFieldNoPhase.setText("0");
      jTextFieldNoSeq.setText("0");
      jTextFieldPhaseName.setText("");
      jTextFieldType.setText("");
      jTextFieldFits.setText("");
      jProgressBar1.setValue(0);
      jTextFieldStartTime.setText("");
//      jTextFieldEndTime.setText("");
      jTextAreaMessages.setText("");
      jCheckBoxFits.setSelected(false);
      jCheckBoxStructure.setSelected(false);
    }

  }

  public void lostFocus() {
    jCheckBoxTargets.setSelected(false);
    jCheckBoxFits.setSelected(false);
    jCheckBoxStructure.setSelected(false);
    jCheckBoxCameras.setSelected(false);
    jTextAreaMessages.setText("");

    try { 
      UserParameters.observation.setSeqInd(new Integer(jTextFieldSeq.getText()).intValue());
    System.out.println("[ObservationPanel.lostFcous] seq_ind="
		      + UserParameters.paramFits.getKeyword("SEQ_IND").getValeur());
    }
    catch (NumberFormatException e) {
      AppIU.setStatus(e.getMessage());
 JOptionPane.showMessageDialog(null, "Format error, see status bar.","Error", JOptionPane.ERROR_MESSAGE);
    }

  }

  public int getOnError() {
    if (jRadioButtonAbort.isSelected()) return ABORT;
    if (jRadioButtonRetry.isSelected()) return RETRY;
    if (jRadioButtonContinue.isSelected()) return CONTINUE;
    return 0;
  }

  void jButtonStart_actionPerformed() {
/*    System.out.println("[ObservationPanel.jButtonStart_actionPerformed] thread==null? "
      + String.valueOf(prog == null));*/
    if (prog!= null) {
/*      System.out.println("[ObservationPanel.jButtonStart_actionPerformed] running="
        + String.valueOf(prog.threadRunning) + ", suspended="
        + String.valueOf(prog.threadSuspended));*/
      if (prog.threadRunning) // pause/resume
        prog.suspendre();
      else start();
    }
    else start(); 
  }
  
  private void start() {
    jButtonStop.setEnabled(true);
    if (checkParameters()) {
      System.out.println("[ObservationPanel.jButtonStart_actionPerformed] START");
      
      UserParameters.paramFits.getKeyword("SEQ_IND").setValeur(jTextFieldSeq.getText());

      setFileAcq();
      
      new FileIO().save(new java.io.File(FileIO.REPERTOIRESAUVEGARDE 
        +UserParameters.paramFits.getKeyword("FILEACQ").getValeur()));

      bouclesObservation();
    }
  }

  private void setFileAcq() {
//    UserParameters.paramFits.getKeyword("SEQ_IND").setValeur(jTextFieldSeq.getText());
    String fileacq = (String)UserParameters.paramFits.getKeyword("PROG_ID").getValeur()
      +"_"+((Integer)(UserParameters.paramFits.getKeyword("PROG_NUM").getValeur())).toString()
      +"_"+((Integer)(UserParameters.paramFits.getKeyword("SEQ_IND").getValeur())).toString();
//System.out.println("[ObservationPanel.setFileAcq] fileacq="+fileacq);
    UserParameters.paramFits.getKeyword("FILEACQ").setValeur(fileacq);
  }

  void jButtonStop_actionPerformed() { prog.arreter(); }

  void jButtonReset_actionPerformed() { ; }

  private void estimationFin(Observation observation) {
    java.text.SimpleDateFormat formatter = new java.text.SimpleDateFormat ("HH:mm:ss");
    Date startTime, currentTime;

    startTime = new Date();
    jTextFieldStartTime.setText( formatter.format(startTime) );
    Calendar cal = Calendar.getInstance();

    cal.add(Calendar.MILLISECOND, estimationDuree(observation));
    currentTime = cal.getTime();
    jTextFieldEndTime.setText( formatter.format(currentTime) );
  }

  private int estimationDuree(Observation observation) {
    int noCam, noWin, tintg, nbpol, dt=0;
//    int nbScan=0;
    Cible cible;
    ParamObservationStructure.Sequence sequence;
    ParamObservationStructure structure = UserParameters.paramObservationStructure;

    for (int nSeq = 0; nSeq < structure.nbSequence; nSeq++) {
      sequence = structure.sequences[nSeq];

      cible = structure.getCible(nSeq);
    // noCam = numro de camra associ  la cible
    // noWin = numro de fenetre associ  la cible
      for (noWin=0; (noWin<ListeWindow.NB_MAX_WIN) 
	&& !cible.winUsed[UserParameters.acquisition.listeWin.getWin(noWin)]; noWin++);
	System.out.println("[ObservationPanel.estimationDuree] noWin="+noWin+",getWin="+UserParameters.acquisition.listeWin.getWin(noWin));
      // pas de fenetre ?
      if (noWin==ListeWindow.NB_MAX_WIN) return 0;

      noCam = UserParameters.paramWindowsConf.tableWindows[noWin].camera;
    // tintg =  temps d'intgration de la camra
      tintg = cible.integrationTime[UserParameters.acquisition.listeWin.getWin(noWin)];

    // nbpol = nombre de polarisations
      nbpol = ((String)cible.sequence.getValeur()).length(); //approximation -> '-'
      if (nbpol == 0) nbpol = 1;
System.out.println("[ObservationPanel.estimationDuree] tintg="+tintg+", nbpol="+nbpol);

    // dure estime pour la cible
      dt += ( (250 + tintg + cible.getNbCamUsed()*80 + 700) * nbpol
	      * ((Integer)cible.nbstep_x.getValeur()).intValue()
	      * ((Integer)cible.nbstep_y.getValeur()).intValue() )
	* sequence.loops;
//      nbScan += sequence.loops;
    }
    dt *= structure.nbRepetitions;
//    nbScan *= structure.nbRepetitions;

System.out.println("[ObservationPanel.estimationDuree] dt="+dt+"ms="+dt/60000+"min");
    return dt;
  }

  boolean checkParameters() {
    int n = checkFits();
    if (n == -1) 
	jCheckBoxFits.setSelected(true);
    else {
      /*
      if (JOptionPane.showConfirmDialog(this,
        "A mandatory FITS keyword has not been filled up :'"
        + UserParameters.paramFits.keywordList[n].getKeyword()
        + "'.\nYou should go to the FITS panel and fill in the keyword.\n"
        + "Do you want to continue anyway ?", "A keyword is missing",
        JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE) == JOptionPane.NO_OPTION)
	*/

      AppIU.setStatus("Cannot start observation, you might go to the Fits Panel to fill the missing mandatory keyword");
      JOptionPane.showMessageDialog(null, "Mandatory keyword missing, see status bar.","Error", JOptionPane.ERROR_MESSAGE);
        return false;
    }
    if (checkStructure()) jCheckBoxStructure.setSelected(true);
    else {
      if (JOptionPane.showConfirmDialog(this,
        "You should go to the 'observation structure' panel and correct it.\n"
        + "Do you want to continue anyway ?", "Incoherent observation structure",
        JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE) == JOptionPane.NO_OPTION)
        return false;
    }
    n = checkCooling();
    if (n == -1) jCheckBoxCameras.setSelected(true);
    else {
      if (JOptionPane.showConfirmDialog(this,
        "A camera in phase "+n+" has not been cooled.\nYou should go to the "
        +"'Technical Parameters/Cameras' panel and start cooling.\n"
        + "Do you want to continue anyway ?", "Camera cooling problem",
        JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE) == JOptionPane.NO_OPTION)
        return false;
    }
    n = checkCibles();
    if (n == -1) jCheckBoxTargets.setSelected(true);
    else {
      if (JOptionPane.showConfirmDialog(this, "A target is not properly configured :'"
        + UserParameters.paramObservationStructure.sequences[n].getDesc()
        /*+ ObservationStructurePanel.getDesc(UserParameters.paramObservationStructure.sequences[n].target,
          UserParameters.paramObservationStructure.sequences[n].phase)*/
        + "'.\nYou should go to the target panel and correct it. "
        + "Do you want to continue anyway ?", "Bad parameters in a target",
        JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE) == JOptionPane.NO_OPTION)
        return false;
    }
    return true;
  }

  private int checkCibles() {
    ParamObservationStructure structure = UserParameters.paramObservationStructure;

    for (int i=0; i<structure.nbSequence; i++)
      if (!structure.getCible(i).checkCameras()) return i;

    return -1;
  }

  private int checkCooling() {
    ParamObservationStructure structure = UserParameters.paramObservationStructure;
    Observation observation = UserParameters.observation;

    for (int i=0; i<structure.nbSequence; i++)
      if (!structure.getCible(i).isCooled()) return i;
    return -1;
  }

  /**
   * Il faut au moins une cible dans la structure.
   */
  boolean checkStructure() {
    ParamObservationStructure structure = UserParameters.paramObservationStructure;
    Cible[] cibles = UserParameters.observation.tabCibles;
    int nbSequence = structure.nbSequence;

    if (nbSequence < 1) return false;
/*
    String instrume = (String)(cibles[ structure.sequences[0].target ].instrume.getValeur());
    for( int i = 1; i < nbSequence; i++){
//System.out.println("[ObservationPanel:checkStructure] cible n" + i + " : " + cibles[ structure.sequences[i].target ].instrume.getValeur());
      if ( (cibles[ structure.sequences[i].target ].type == Cible.TARGET) &&
        !cibles[ structure.sequences[i].target ].instrume.getValeur().equals(instrume) )
        return false;
    }*/
    return true;
  }

  /**
   * Il faut que tous les mots-cles obligatoires soient remplis.
   */
  int checkFits() {
    ListeKeyword liste = UserParameters.paramFits;
    int nbFits = liste.getNbKeyword();

    for (int i = 0; i < nbFits; i++)
      if ( liste.keywordList[i].isObligatoire() )
        if ( !liste.keywordList[i].isAffecte() ) return i;
    return -1;
  }

/**
 * C'est desormais une autre thread qui effectue les observations : cf. ProgObservation
 */

  void bouclesObservation() {
    prog = new ProgObservation(this);
    jProgressBar1.setValue(0);

    estimationFin(UserParameters.observation);
    prog.start();

  }
}
