/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Grassin-Minec-Debin
 * @version 1.0
 */

package iu;

import java.awt.*;
import javax.swing.*;
import javax.swing.border.*;
import java.awt.event.*;
import javax.swing.event.*;

public class ObservationModePanel extends JPanel {
  BorderLayout borderLayoutThis = new BorderLayout();
  TitledBorder titledBorder1;
  JPanel jPanelObservationMode = new JPanel();
  JPanel jPanelMtr = new JPanel();
  JPanel jPanelDpsm = new JPanel();
  TitledBorder titledBorder2;
  GridBagLayout gridBagLayoutObservationMode = new GridBagLayout();
  GridBagLayout gridBagLayoutMtr = new GridBagLayout();
  GridBagLayout gridBagLayoutDpsm = new GridBagLayout();
  JPanel jPanelMtrPredisperser = new JPanel();
  JPanel jPanelDpsmPredisperser = new JPanel();
  JPanel jPanelFilterStart = new JPanel();
  Border border2;
  TitledBorder titledBorder8;
  Border border3;
  TitledBorder titledBorder9;
  GridBagLayout gridBagLayoutFilterStart = new GridBagLayout();
  GridBagLayout gridBagLayoutDpsmPredisperser = new GridBagLayout();
  Border border7;
  TitledBorder titledBorder10;
  JRadioButton jRadioButtonMtrUseWaveLength = new JRadioButton();
  JRadioButton jRadioButtonMtrUseDefault = new JRadioButton();
  GridBagLayout gridBagLayoutMtrPredisperser = new GridBagLayout();
  JRadioButton jRadioButtonDpsmUseDefault = new JRadioButton();
  JRadioButton jRadioButtonDpsmUseWaveLength = new JRadioButton();
  JComboBox jComboBoxFilterStart;
  ButtonGroup groupMtr = new ButtonGroup();
  ButtonGroup groupDpsm = new ButtonGroup();

  public ObservationModePanel() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    initComponents();

    titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142)),"MTR");
    titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142)),"DPSM");
    border2 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
    titledBorder8 = new TitledBorder(border2,"Predisperser Positions");
    border3 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
    titledBorder9 = new TitledBorder(border3,"Predisperser Positions");
    border7 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
    titledBorder10 = new TitledBorder(border7,"Filter start position");
    setLayout(borderLayoutThis);
    jPanelMtr.setBorder(titledBorder1);
    jPanelMtr.setLayout(gridBagLayoutMtr);
    jPanelObservationMode.setLayout(gridBagLayoutObservationMode);
    jPanelDpsm.setBorder(titledBorder2);
    jPanelDpsm.setLayout(gridBagLayoutDpsm);
    jPanelMtrPredisperser.setBorder(titledBorder8);
    jPanelMtrPredisperser.setLayout(gridBagLayoutMtrPredisperser);
    jPanelDpsmPredisperser.setLayout(gridBagLayoutDpsmPredisperser);
    jPanelDpsmPredisperser.setBorder(titledBorder9);
    jPanelFilterStart.setLayout(gridBagLayoutFilterStart);
    jPanelFilterStart.setBorder(titledBorder10);
    jRadioButtonMtrUseWaveLength.setText("Use wavelength attributes");
    jRadioButtonMtrUseDefault.setText("Use default");
    jRadioButtonDpsmUseDefault.setText("Use default");
    jRadioButtonDpsmUseWaveLength.setText("Use wavelength attributes");
    this.add(jPanelObservationMode, BorderLayout.NORTH);
    jPanelObservationMode.add(jPanelDpsm, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelDpsm.add(jPanelDpsmPredisperser, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelDpsmPredisperser.add(jRadioButtonDpsmUseDefault, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDpsmPredisperser.add(jRadioButtonDpsmUseWaveLength, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelDpsm.add(jPanelFilterStart, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelFilterStart.add(jComboBoxFilterStart, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelObservationMode.add(jPanelMtr, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelMtr.add(jPanelMtrPredisperser, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.NORTH, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelMtrPredisperser.add(jRadioButtonMtrUseDefault, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelMtrPredisperser.add(jRadioButtonMtrUseWaveLength, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    groupDpsm.add(jRadioButtonDpsmUseDefault);
    groupDpsm.add(jRadioButtonDpsmUseWaveLength);
    groupMtr.add(jRadioButtonMtrUseDefault);
    groupMtr.add(jRadioButtonMtrUseWaveLength);

    setValues();
  }

  static final String[] FILTER = {"sodium","Halpha","roger rabbit"};

  private void initComponents() {
    jComboBoxFilterStart = new JComboBox(FILTER);
  }

  public void gainedFocus() {
    setValues();
  }

  public void lostFocus() throws NumberFormatException {
    getValues();
  }

  private void setValues() {
    jComboBoxFilterStart.setSelectedIndex(UserParameters.paramObservationMode.filterStart);
    jRadioButtonMtrUseDefault.setSelected(UserParameters.paramObservationMode.mtrUseDefault);
    jRadioButtonMtrUseWaveLength.setSelected(UserParameters.paramObservationMode.mtrUseWaveLength);
    jRadioButtonDpsmUseDefault.setSelected(UserParameters.paramObservationMode.dpsmUseDefault);
    jRadioButtonDpsmUseWaveLength.setSelected(UserParameters.paramObservationMode.dpsmUseWaveLength);
  }

  private void getValues() throws NumberFormatException {
    UserParameters.paramObservationMode.filterStart = jComboBoxFilterStart.getSelectedIndex();
    UserParameters.paramObservationMode.mtrUseDefault = jRadioButtonMtrUseDefault.isSelected();
    UserParameters.paramObservationMode.mtrUseWaveLength = jRadioButtonMtrUseWaveLength.isSelected();
    UserParameters.paramObservationMode.dpsmUseDefault = jRadioButtonDpsmUseDefault.isSelected();
    UserParameters.paramObservationMode.dpsmUseWaveLength = jRadioButtonDpsmUseWaveLength.isSelected();
  }
}