
// cree le 24/5/2000 par CM

package iu;

import java.util.*;
import java.io.*;
import java.text.*;

public class Observation implements Sauvegardable //, Formatable
{
  public static final int NB_MAX_OBTU = 64;
  public static final int NB_TARGET_MAX = 64;
  public static final int NB_DARK_MAX = 16;
  public static final int NB_FLAT_FIELD_MAX = 16;

  ListeInstruction acqFormatInstr;
  ListeInstruction ucciInstr;
  String formatResult;

  public ListeInstruction listeInstruction = new ListeInstruction();

  public int nbCibles;
  public Cible[] tabCibles;
  public Cible[] tabDarks;
  public Cible[] tabFlats;

  public int nbDarks;
  public Cible[] extraDarks;

  public int nbFlats;
  public Cible[] extraFlats;

  public Observation() {
      tabCibles = new Cible[NB_TARGET_MAX];
      tabDarks = new Cible[NB_TARGET_MAX];
      tabFlats = new Cible[NB_TARGET_MAX];
      nbCibles = 1;
      tabCibles[0] = new Cible(Cible.TARGET);
      tabDarks[0] = new Cible(Cible.DARK);
      tabFlats[0] = new Cible(Cible.FLATFIELD);

      extraDarks = new Cible[NB_DARK_MAX];
      nbDarks = 1;
      extraDarks[0] = new Cible(Cible.DARK);

      extraFlats = new Cible[NB_FLAT_FIELD_MAX];
      nbFlats = 1;
      extraFlats[0] = new Cible(Cible.FLATFIELD);
    }

  void setProgNum(boolean incSeqInd) {
    ListeKeyword fits = UserParameters.paramFits;
    int prognum = 0;
    int seq_ind = 1;//((Integer)fits.getKeyword("SEQ_IND").getValeur()).intValue();
    String progid = (String)fits.getKeyword("PROG_ID").getValeur();

    try {
      Object constr[];
      MessageFormat formatNum = UserParameters.formatNum;
      BufferedReader in = new BufferedReader(new FileReader(UserParameters.numFile));
      String tostudy = new String(in.readLine());
      in.close();
      ParsePosition status = new ParsePosition(0);

      // lecture du fichier
      constr = formatNum.parse(tostudy, status);
      if (status.getErrorIndex()>-1)
        throw new IOException("dans "+UserParameters.numFile+" : erreur au caractere "+status.getErrorIndex());

      // si PROGID n'a pas change
      if ((constr[1]).toString().equals(progid)) {
        GregorianCalendar ancien = new GregorianCalendar();
        ancien.setTime((Date)constr[0]);
        GregorianCalendar aujourdhui = new GregorianCalendar();
        aujourdhui.setTime(new Date());
        int djour = aujourdhui.get(Calendar.DAY_OF_YEAR) - ancien.get(Calendar.DAY_OF_YEAR);
	// PROGNUM=ancien+(nb jours ecoules)
        prognum = ((Long)constr[2]).intValue() + djour;
	// si meme jour, SEQ_IND est incremente (sinon =1) 
        if (djour == 0) seq_ind = ((Long)constr[3]).intValue()+(incSeqInd?1:0);
      }
      // sinon PROGNUM=1 (et SEQ_IND=1) 
      else prognum = 1;

      fits.getKeyword("SEQ_IND").setValeur(String.valueOf(seq_ind));      
      fits.getKeyword("PROG_NUM").setValeur(String.valueOf(prognum));
//System.out.println("[Observation.setProgNum] prognum="+prognum+", seq_ind="+seq_ind);

      // ecriture sur le fichier (maj)
      BufferedWriter out = new BufferedWriter(new FileWriter(UserParameters.numFile));
      constr = new Object[] { new Date(), progid, new Integer(prognum), new Integer(seq_ind) };
      out.write(formatNum.format(constr));
      out.close();
    }
    catch (IOException e) { System.err.println(e); }
  }

  void setSeqInd(int seq_ind) {
    ListeKeyword fits = UserParameters.paramFits;
    int prognum = 0;
    String progid = (String)fits.getKeyword("PROG_ID").getValeur();

    try {
      Object constr[];
      MessageFormat formatNum = UserParameters.formatNum;
      BufferedReader in = new BufferedReader(new FileReader(UserParameters.numFile));
      String tostudy = new String(in.readLine());
      in.close();
      ParsePosition status = new ParsePosition(0);

      // lecture du fichier
      constr = formatNum.parse(tostudy, status);
      if (status.getErrorIndex()>-1)
        throw new IOException("dans "+UserParameters.numFile+" : erreur au caractere "+status.getErrorIndex());

      // si PROGID n'a pas change
      if ((constr[1]).toString().equals(progid)) {
        GregorianCalendar ancien = new GregorianCalendar();
        ancien.setTime((Date)constr[0]);
        GregorianCalendar aujourdhui = new GregorianCalendar();
        aujourdhui.setTime(new Date());
        int djour = aujourdhui.get(Calendar.DAY_OF_YEAR) - ancien.get(Calendar.DAY_OF_YEAR);
	// PROGNUM=ancien+(nb jours ecoules)
        prognum = ((Long)constr[2]).intValue() + djour;
      }
      // sinon PROGNUM=1 (et SEQ_IND=1) 
      else prognum = 1;

      fits.getKeyword("SEQ_IND").setValeur(String.valueOf(seq_ind));      
      fits.getKeyword("PROG_NUM").setValeur(String.valueOf(prognum));
//System.out.println("[Observation.setProgNum] prognum="+prognum+", seq_ind="+seq_ind);

      // ecriture sur le fichier (maj)
      BufferedWriter out = new BufferedWriter(new FileWriter(UserParameters.numFile));
      constr = new Object[] { new Date(), progid, new Integer(prognum), new Integer(seq_ind) };
      out.write(formatNum.format(constr));
      out.close();
    }
    catch (IOException e) { System.err.println(e); }
  }
/*
  public void addCible(Cible cible) {
    if(nbCibles < NB_TARGET_MAX) {
      this.tabCibles[nbCibles] = cible;
      nbCibles++;
    }
  }

  public void addCible(Cible cible, int indice) {
    int length;

    if((nbCibles < ParamTargets.NB_TARGET_MAX)&&(indice <=nbCibles)) {
      if(indice == nbCibles)
	addCible(cible);
      else {
	length = nbCibles - indice;
	System.arraycopy(tabCibles,indice,tabCibles,(indice+1),length);
	this.tabCibles[indice] = cible;
	nbCibles++;
      }
    }
  }

  public void removeCible(int indice) {
    int length;
    if(indice < nbCibles) {
      length = nbCibles - indice - 1;
      System.arraycopy(tabCibles,(indice+1),tabCibles,indice,length);
      nbCibles--;
    }
 }
*/
   public void append(int type) {
     Cible nouvelle = tabCibles[nbCibles], ancienne = tabCibles[nbCibles-1];
     switch (type) {
       case Cible.TARGET :
         if (nbCibles < NB_TARGET_MAX) {
           nbCibles++;
           tabCibles[nbCibles-1] = new Cible(Cible.TARGET);
           tabDarks[nbCibles-1] = new Cible(Cible.DARK);
           tabFlats[nbCibles-1] = new Cible(Cible.FLATFIELD);
           nouvelle = tabCibles[nbCibles-1];
           ancienne = tabCibles[nbCibles-2];
         }
         break;
       case Cible.FLATFIELD :
         if (nbFlats < NB_FLAT_FIELD_MAX) {
           nbFlats++;
           extraFlats[nbFlats-1] = new Cible(Cible.FLATFIELD);
           nouvelle = extraFlats[nbFlats-1];
           ancienne = extraFlats[nbFlats-2];
         }
         break;
       case Cible.DARK :
         if (nbDarks < NB_DARK_MAX) {
           nbDarks++;
           extraDarks[nbDarks-1] = new Cible(Cible.DARK);
           nouvelle = extraDarks[nbDarks-1];
           ancienne = extraDarks[nbDarks-2];
         }
         break;
      }
      nouvelle.fitsMode = ancienne.fitsMode;
      int num;
      for (int i=0 ; i<ListeWindow.NB_MAX_WIN-1; i++) {
	num = UserParameters.acquisition.listeWin.getWin(i);
	nouvelle.winUsed[num] = true;
        nouvelle.integrationTime[num] = ancienne.integrationTime[num];
      }
   }

   public void delete(int type, int nb) {
     switch (type) {
       case Cible.TARGET :
         for ( int i = nb ; i < nbCibles ; i++ ) {
           tabCibles[i] = tabCibles[i+1];
           tabDarks[i] = tabDarks[i+1];
           tabFlats[i] = tabFlats[i+1];
         }
         if ( --nbCibles < 1 ) nbCibles = 1;
         tabCibles[ nbCibles ] = new Cible(Cible.TARGET);
         tabDarks[ nbCibles ] = new Cible(Cible.DARK);
         tabFlats[ nbCibles ] = new Cible(Cible.FLATFIELD);
         break;
       case Cible.FLATFIELD :
         for ( int i = nb ; i < nbFlats ; i++ )
           extraFlats[i] = extraFlats[i+1];
         if ( --nbFlats < 1 ) nbFlats = 1;
         extraFlats[ nbFlats ] = new Cible(Cible.FLATFIELD);
         break;
       case Cible.DARK :
         for ( int i = nb ; i < nbDarks ; i++ )
           extraDarks[i] = extraDarks[i+1];
         if ( --nbDarks < 1 ) nbDarks = 1;
         extraDarks[ nbDarks ] = new Cible(Cible.DARK);
         break;
     }
   }

  private static String sauvFormat = "'{'{0,number}'}' \n";
  private static String readFormat = "'{'{0,number}'}' '}' ";
  private static String separateur1_cib = "{CIB}\n";
  private static String separateur2_cib = "{/CIB}\n";
  private static String separateur1_dar = "{DAR}\n";
  private static String separateur2_dar = "{/DAR}\n";
  private static String separateur1_fla = "{FLA}\n";
  private static String separateur2_fla = "{/FLA}\n";
  private static String separateur1_sto = "{STO}\n";
  private static String separateur2_sto = "{/STO}\n";

  public void setObject_to_file(BufferedWriter out) throws IOException {
      MessageFormat form = new MessageFormat(sauvFormat);
      Object[] info;
      String resultat;

    // cibles
      out.write(separateur1_cib);
      info = new Object[] {new Integer(nbCibles)};
      resultat = new String(form.format(info));
      out.write(resultat,0,resultat.length());
      for (int i=0; i<nbCibles; i++) {
        tabCibles[i].setObject_to_file(out);
        tabDarks[i].setObject_to_file(out);
        tabFlats[i].setObject_to_file(out);
      }
      out.write(separateur2_cib);

    // darks
      out.write(separateur1_dar);
      info = new Object[] {new Integer(nbDarks)};
      resultat = new String(form.format(info));
      out.write(resultat,0,resultat.length());
      for (int i=0; i<nbDarks; i++) extraDarks[i].setObject_to_file(out);
      out.write(separateur2_dar);

    // flat fields
      out.write(separateur1_fla);
      info = new Object[] {new Integer(nbFlats)};
      resultat = new String(form.format(info));
      out.write(resultat,0,resultat.length());
      for (int i=0; i<nbFlats; i++) extraFlats[i].setObject_to_file(out);
      out.write(separateur2_fla);
    }

  /** passage de l'index de la cible du tableau tabCibles */
  public void format(int indcible) throws BadValeurException {
    tabCibles[indcible].getmotcle(false);
  }

  public void getObject_from_File(BufferedReader in) throws IOException {
    getObject_from_File(in, new boolean[] { true, true });
  }

  public void getObject_from_File(BufferedReader in, boolean[] parties) throws IOException {
      Object constr[];
      int i, n;
      ParsePosition status = new ParsePosition(0);
      String tostudy;
      MessageFormat form1 = new MessageFormat("'{'{0,number}'}' ");

    // cibles
      in.readLine(); // lecture de CIB
      tostudy =  new String(in.readLine());
      constr = form1.parse(tostudy,status);
      n = Integer.parseInt(constr[0].toString());
      if (parties[1]) {
        nbCibles = n;
        for (i=0; i<n; i++) {
          tabCibles[i] = new Cible(Cible.TARGET);
          tabCibles[i].getObject_from_File(in);
          tabDarks[i] = new Cible(Cible.DARK);
          tabDarks[i].getObject_from_File(in);
          tabFlats[i] = new Cible(Cible.FLATFIELD);
          tabFlats[i].getObject_from_File(in);
        }
      }
      else for (i=0; i<3*n; i++) in.readLine(); 
      in.readLine(); // fin de lecture de CIB

    // darks
      in.readLine(); // debut de lecture de DAR
      tostudy =  new String(in.readLine());
      status.setIndex(0);
      constr = form1.parse(tostudy,status);
      n = Integer.parseInt(constr[0].toString());
      if (parties[1]) {
        nbDarks = n;
        for (i=0; i<n; i++) {
          extraDarks[i] = new Cible(Cible.DARK);
          extraDarks[i].getObject_from_File(in);
        }
      }
      else for (i=0; i<n; i++) { in.readLine(); in.readLine(); }
      in.readLine(); // fin de lecture de DAR

    // flats
      in.readLine(); // debut de lecture de FLA
      tostudy =  new String(in.readLine());
      status.setIndex(0);
      constr = form1.parse(tostudy,status);
      n = Integer.parseInt(constr[0].toString());
      if (parties[1]) {
        nbFlats = n;
        for (i=0; i<n; i++) {
          extraFlats[i] = new Cible(Cible.FLATFIELD);
          extraFlats[i].getObject_from_File(in);
        }
      }
      else for (i=0; i<n; i++) { in.readLine(); in.readLine(); }
      in.readLine(); // fin de lecture de FLA
    }

/*   public int[] getTabObtu() {
     int i,j;
     int[] tabObtu = new int[NB_MAX_OBTU];
     for (i=0;i<NB_MAX_OBTU;i++) tabObtu[i] = -1;
//     for (i=0;i<nbCibles;i++)
//       for (j=0;j<ListeCamera.NB_MAX_CAM;j++)
//         if ( tabCibles[i].camUsed[j] == true ) {
//           int nbObtu = UserParameters.acquisition.listeCam.listeCamera[j].numShutter.intValue();
//           tabObtu[nbObtu] = tabCibles[i].integrationTime[j];
//         }
     return tabObtu;
   }*/
}


