/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Grassin-Minec-Debin
 * @version 1.0
 */

package iu;

import java.awt.*;
import java.awt.event.*;
import java.util.Enumeration;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.*;

public class MotorPanel extends JPanel {
  Border border6;
  TitledBorder titledBorder2;
  TitledBorder titledBorder3;
  TitledBorder titledBorder6;
  JPanel jPanelMotors = new JPanel();
  JPanel jPanelMessages = new JPanel();
  JPanel jPanelDefaultPositions = new JPanel();
  JPanel jPanelControlMap = new JPanel();
  JScrollPane jScrollPaneMessages = new JScrollPane();
  JScrollPane jScrollPaneControlMap = new JScrollPane();
  JScrollPane jScrollPaneDefaultPositions = new JScrollPane();
  JTextArea jTextAreaMessages = new JTextArea();
  JButton jButtonInit = new JButton("start init");
  GridBagLayout gridBagLayoutMessages = new GridBagLayout();
  GridBagLayout gridBagLayoutControlMap = new GridBagLayout();
  GridBagLayout gridBagLayoutMotors = new GridBagLayout();
  GridBagLayout gridBagLayoutDefaultPositions = new GridBagLayout();
  BorderLayout borderLayoutThis = new BorderLayout();
  JTable jTableDefaultPositions;
  JTree jTreeControlMap = new JTree();
  DefaultPositionsTableModel defaultPositionsTableModel;

  public MotorPanel() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    initComponents();

    border6 = BorderFactory.createEtchedBorder(Color.white, Color.gray);
    jButtonInit.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonInitActive(); }
    });
    titledBorder2 = new TitledBorder(border6, "Messages");
    titledBorder3 = new TitledBorder(border6, "Controle command motorisation map");
    titledBorder6 = new TitledBorder(border6, "Default motors position");
    jTextAreaMessages.setEditable(false);
    jTextAreaMessages.setPreferredSize(new Dimension(150, 100));
    jTextAreaMessages.setBackground(SystemColor.info);
//    jTextAreaMessages.setBorder(BorderFactory.createLoweredBevelBorder());
//    jTextAreaMessages.setMinimumSize(new Dimension(150, 100));
    jPanelMessages.setLayout(gridBagLayoutMessages);
//    jPanelMessages.setName("");
    jPanelMessages.setBorder(titledBorder2);
//    jPanelControlMap.setName("");
    jPanelControlMap.setBorder(titledBorder3);
    jPanelControlMap.setLayout(gridBagLayoutControlMap);
    jPanelMotors.setLayout(gridBagLayoutMotors);
    jPanelDefaultPositions.setBorder(titledBorder6);
    jPanelDefaultPositions.setLayout(gridBagLayoutDefaultPositions);
    this.setLayout(borderLayoutThis);
    this.add(jPanelMotors, BorderLayout.CENTER);

    jPanelDefaultPositions.add(jScrollPaneDefaultPositions, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelMessages.add(jScrollPaneMessages, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jScrollPaneMessages.getViewport().add(jTextAreaMessages, null);
    jPanelControlMap.add(jScrollPaneControlMap, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jScrollPaneControlMap.getViewport().add(jTreeControlMap, null);
    jPanelMotors.add(jPanelDefaultPositions, new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelMotors.add(jButtonInit, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelMotors.add(jPanelMessages, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelMotors.add(jPanelControlMap, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
  }

  private void initComponents() {
    defaultPositionsTableModel = new DefaultPositionsTableModel();
    setTable();
    jTableDefaultPositions = new JTable(defaultPositionsTableModel);
    jTableDefaultPositions.setColumnSelectionAllowed(true);
    jTableDefaultPositions.setRowSelectionAllowed(false);
    jTableDefaultPositions.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    jScrollPaneDefaultPositions.getViewport().add(jTableDefaultPositions, null);

    jTableDefaultPositions.getColumnModel().getColumn(0).setPreferredWidth(10);
    jTableDefaultPositions.getColumnModel().getColumn(1).setPreferredWidth(150);
    jTableDefaultPositions.getColumnModel().getColumn(2).setPreferredWidth(10);
    jTableDefaultPositions.getColumnModel().getColumn(3).setPreferredWidth(10);
    jTableDefaultPositions.getColumnModel().getColumn(4).setPreferredWidth(10);
    jTableDefaultPositions.getColumnModel().getColumn(5).setPreferredWidth(5);

    construireArbre();
  }

  private void construireArbre() {
    int A, T, M;
    DefaultMutableTreeNode base = new DefaultMutableTreeNode();

    for (A = 0; A < UserParameters.listeMoteur.getNbArmoire(); A++) {
      DefaultMutableTreeNode armoire
        = new DefaultMutableTreeNode (UserParameters.listeMoteur.getArmoires()[A]);
      base.add(armoire);
      for (T = 0; T < UserParameters.listeMoteur.getArmoires()[A].nbTiroir; T++) {
        DefaultMutableTreeNode tiroir = new DefaultMutableTreeNode
          (UserParameters.listeMoteur.getArmoires()[A].tiroirs[T]);
        armoire.add(tiroir);
        for (M = 0; M < UserParameters.listeMoteur.getArmoires()[A].tiroirs[T].nbMoteur; M++) {
          DefaultMutableTreeNode moteur = new DefaultMutableTreeNode
            (UserParameters.listeMoteur.getArmoires()[A].tiroirs[T].moteurs[M]);
          tiroir.add(moteur);
        }
      }
    }

    jTreeControlMap = new JTree(base);
    jTreeControlMap.putClientProperty("JTree.lineStyle", "Angled");
/*
          JPopupMenu jPopupMenu = new JPopupMenu("Command");
          jPopupMenu.setInvoker(jButtonInit);
          jPopupMenu.add("START");
          jPopupMenu.add("PMVTECHO");
          jPopupMenu.addSeparator();
          jPopupMenu.add("INFO");
          jPopupMenu.addPopupMenuListener(new PopupMenuListener() {
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
          });
*/
    DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
    renderer.setLeafIcon(null);
    renderer.setOpenIcon(null);
    renderer.setClosedIcon(null);
    jTreeControlMap.setCellRenderer(renderer);

    jTreeControlMap.getSelectionModel().setSelectionMode (TreeSelectionModel.SINGLE_TREE_SELECTION);
    //Listen for when the selection changes.
    jTreeControlMap.addTreeSelectionListener(new TreeSelectionListener() {
      public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)
          jTreeControlMap.getLastSelectedPathComponent();
        if (node == null) return;
        if (node.isLeaf())
          changeInitMoteur(node);
        else if (node.getUserObject() instanceof Tiroir)
          changeInitTiroir(node);
        else if (node.getUserObject() instanceof Armoire)
          changeInitArmoire(node);
      }
    });
  }

  private void changeInitArmoire(DefaultMutableTreeNode node) {
    Enumeration enum = node.children();
    for ( enum = node.children(); enum.hasMoreElements();  )
      changeInitTiroir((DefaultMutableTreeNode)enum.nextElement());
  }

  private void changeInitTiroir(DefaultMutableTreeNode node) {
    Enumeration enum;
    for ( enum = node.children(); enum.hasMoreElements();  )
      changeInitMoteur((DefaultMutableTreeNode)enum.nextElement());
  }

  private void changeInitMoteur(DefaultMutableTreeNode node) {
    int l;
    boolean init;
    String nodeInfo = node.getUserObject().toString();
    l = getTableLine(nodeInfo);

    init = ! ( ( (Boolean)( defaultPositionsTableModel.getValueAt(l, 5) ) ).booleanValue() );
    defaultPositionsTableModel.setValueAt(new Boolean(init), l, 5 );
  }

  private int getTableLine(String nom) {
    int l;
    for ( l = 0; l < defaultPositionsTableModel.getRowCount(); l++ )
      if ( defaultPositionsTableModel.getValueAt(l,0).equals(nom) )
        break;
    return l;
  }

  private void setTable() {
    int i = 0;
    ListeMoteur liste = UserParameters.listeMoteur;

    for (int a = 0; a < liste.getNbArmoire(); a++)
      for (int t = 0; t < liste.getArmoires()[a].nbTiroir; t++)
        for (int m = 0; m < liste.getArmoires()[a].tiroirs[t].nbMoteur; m++) {
          defaultPositionsTableModel.data[i][0] = new
            String(liste.getArmoires()[a].tiroirs[t].moteurs[m].toString());
          defaultPositionsTableModel.data[i][1] = new
            String(liste.getArmoires()[a].tiroirs[t].moteurs[m].fonction);
          defaultPositionsTableModel.data[i][2] = new
            Float(liste.getArmoires()[a].tiroirs[t].moteurs[m].defautDPSM);
          defaultPositionsTableModel.data[i][3] = new
            Float(liste.getArmoires()[a].tiroirs[t].moteurs[m].defautMTR);
          defaultPositionsTableModel.data[i][4] = new
            Float(liste.getArmoires()[a].tiroirs[t].moteurs[m].defautIPM);
          defaultPositionsTableModel.data[i][5] = new
            Boolean(liste.getArmoires()[a].tiroirs[t].moteurs[m].init);
          i++;
        }
//    jTableDefaultPositions.paint();
  }

  private void getTable() {
    for ( int i = 0; i < defaultPositionsTableModel.getRowCount(); i++ ) {
      UserParameters.listeMoteur.getMoteur(defaultPositionsTableModel.data[i][0].toString())
        .setValeur(defaultPositionsTableModel.data[i][2], defaultPositionsTableModel.data[i][3],
          defaultPositionsTableModel.data[i][4], defaultPositionsTableModel.data[i][5]);
/*      System.out.println("i=" + i + ", nom=" + defaultPositionsTableModel.data[i][0] + ", init=" +
        defaultPositionsTableModel.data[i][5]);*/
    }
  }

  public void gainedFocus() {
    setTable();
  }

  public void lostFocus() {
    getTable();
  }

  public void jButtonInitActive(){
    Communication comm;
    String resultat = "", message = "";

    getTable();
    try { comm = new Communication(20000, "ariel"); }
    catch (java.io.IOException e) {
      jTextAreaMessages.append("Communication with UCCI is impossible : "
        + e + "\n");
      return;
    }
    for ( int i = 0; i < defaultPositionsTableModel.getRowCount(); i++ ) {
      Moteur moteur = UserParameters.listeMoteur.
        getMoteur( defaultPositionsTableModel.data[i][0].toString() );
      if ( moteur.init )
        message += moteur.start().getScript() + Communication.SEP_UCCI;
    }
    if ( message.length() > 0 ) {
      jTextAreaMessages.append(message);
      try { resultat = comm.envoiMessage(message); }
      catch (java.io.IOException e) {
        jTextAreaMessages.append("A problem occured while sending instructions to UCCI : "
          + e + "\n");
        return;
      }
      jTextAreaMessages.append(resultat + "\n");
    }
  }

  private class DefaultPositionsTableModel extends AbstractTableModel {
    final String[] columnNames = { "name", "fonction", "DPSM", "MTR", "IPM", "init" };
    public int nbMoteur = UserParameters.listeMoteur.nbMoteur;
//    public final Object[][] data = new Object[ NB_MOTOR_MAX ][ 6 ];
    public final Object[][] data = new Object[ nbMoteur ][6];
    public int getColumnCount() { return columnNames.length; }

//    public int getRowCount() { return NB_MOTOR_MAX; }
    public int getRowCount() { return nbMoteur; }

    public String getColumnName(int col) { return columnNames[col]; }

    public Object getValueAt(int row, int col) { return data[row][col]; }

    public Class getColumnClass(int c) { return getValueAt(0, c).getClass(); }

    public boolean isCellEditable(int row, int col) {
      if ( col > 1 ) return true;
      else return false;
    }

    public void setValueAt(Object value, int row, int col) {
      if ( col == 5 ) {
        data[row][col] = value;
        fireTableCellUpdated(row, col);
      }
/*      else if (data[row][col] instanceof Integer) {
        if (!(value instanceof Integer)) {
          try {
            data[row][col] = new Integer(value.toString());
            fireTableCellUpdated(row, col);
          } catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "The \"" + getColumnName(col) + "\" column accepts only integer values.");
          }
        }
        else {
          data[row][col] = value;
          fireTableCellUpdated(row, col);
        }
      }
*/      else /*if (data[row][col] instanceof Float) */{
        if (!(value instanceof Float)) {
          try {
            data[row][col] = new Float(value.toString());
            fireTableCellUpdated(row, col);
          } catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "The \"" + getColumnName(col) + "\" column accepts only float values.");
          }
        }
        else {
          data[row][col] = value;
          fireTableCellUpdated(row, col);
        }
      }
    }
  }
}