package iu;

import java.lang.*;
import java.util.*;

/** Objet pere pour tous les moteurs de base */

public class MoteurBase extends Moteur {

  public MoteurBase(String nomMoteur, String type, String fonction, String unite,
    float limiteMoins, float limitePlus) {
    super(nomMoteur, type, fonction, unite, limiteMoins, limitePlus);
  }

  public Instruction pmvtecho() {
    return(new Instruction(UserRessource.motor_pmvtecho + "_" + nomMoteur,
      UserRessource.motor_pmvtecho + "(" + nomMoteur + ")",
      UserRessource.motor_pmvtecho_c + nomMoteur, Communication.UCCI));
  }

  public Instruction pmvt(Float position) {
    return(new Instruction(UserRessource.motor_pmvt + "_" + nomMoteur + "_" + position,
      UserRessource.motor_pmvt + "(" + nomMoteur + "," + position + ")",
      UserRessource.motor_pmvt_c + nomMoteur + "," + position, Communication.UCCI));
  }

  public Instruction dmvt(Float position) {
    return(new Instruction(UserRessource.motor_dmvt + "_" + nomMoteur + "_" + position,
      UserRessource.motor_dmvt + "(" + nomMoteur + ","+position + ")",
      UserRessource.motor_dmvt_c + nomMoteur + "," + position, Communication.UCCI));
  }

  public Instruction imvt() {
    return(new Instruction(" "," "," ", Communication.UCCI));
  }
}
