package iu;

import java.lang.*;
import java.util.*;
import java.text.*;
import java.io.*;

/** Objet pere pour tous les moteurs */

public class Moteur implements Sauvegardable {

//  static final int NB_MAX_MOTEUR = 45;

  // proprietes - lus dans moteur.txt
  protected String nomMoteur; // nom ucci du moteur, ex : EM30
  private String type;      // type : MoteurBase, MoteurVitesse, CapotVolet, Roue, Sonde
  protected String fonction;  // nom usuel du moteur
  private String unite;     // deg, mm, min, pos
  private float limiteMoins;
  private float limitePlus;
  float defautDPSM; // position par defaut en mode DPSM
  float defautMTR;  // position par defaut en mode MTR
  float defautIPM;  // position par defaut en mode IPM

  // parametres
  float position;
  boolean init;         // initialisation a effectuer

  // autres variables
  static final MessageFormat formatSauv
    = new MessageFormat("'{'{0}'}' '{'{1,number}'}' '{'{2,number}'}' '{'{3,number}'}' '{'{4}'}'");

  static final String TYPEBASE = "MoteurBase";
  static final String TYPEVITESSE = "MoteurVitesse";
  static final String TYPECAPOT = "CapotVolet";
  static final String TYPEROUE = "Roue";
  static final String TYPESONDE = "Sonde";

//  public Moteur() {}

  public Moteur(String nomMoteur, String type, String fonction, String unite,
    float limiteMoins, float LimitePlus) {
    this.nomMoteur = nomMoteur;
    this.type = type;
    this.fonction = fonction;
    this.unite = unite;
    this.limiteMoins = limiteMoins;
    this.limitePlus = limitePlus;
  }

  public String toString() {
    return nomMoteur;
  }

  public Instruction limite() {
    return(new Instruction(UserRessource.motor_limite + "_" + nomMoteur,
      UserRessource.motor_limite + "(" + nomMoteur + ")",
      UserRessource.motor_limite_c + nomMoteur, Communication.UCCI));
  }

  public Instruction generalhalt() {
    return(new Instruction(UserRessource.motor_halt,
      UserRessource.motor_halt+"()",
      UserRessource.motor_halt_c+UserRessource.motor_all, Communication.UCCI));
  }

  public Instruction halt() {
    return(new Instruction(UserRessource.motor_halt+"_"+nomMoteur,
      UserRessource.motor_halt+"("+nomMoteur+")",
      UserRessource.motor_halt_c+nomMoteur, Communication.UCCI));
  }

  public void in() {
  }

  public void out() {
  }

  public Instruction stop() {
    return(new Instruction(UserRessource.motor_stop+"_"+nomMoteur,
      UserRessource.motor_stop+"("+nomMoteur+")",
      UserRessource.motor_stop_c+nomMoteur, Communication.UCCI));
  }

  public Instruction start() {
    return(new Instruction(UserRessource.motor_start+"_"+nomMoteur,
      UserRessource.motor_start+"("+nomMoteur+")",
      UserRessource.motor_start_c+nomMoteur, Communication.UCCI));
  }

  void setValeur(Object dDPSM, Object dMTR, Object dIPM, Object init) {
    this.defautDPSM = Float.parseFloat(dDPSM.toString());
    this.defautMTR = Float.parseFloat(dMTR.toString());
    this.defautIPM = Float.parseFloat(dIPM.toString());
    this.init = init.toString().equals("true");
  }

  public void setObject_to_file(BufferedWriter out) throws IOException {
    Object[] info = { nomMoteur, new Float(defautDPSM), new Float(defautMTR),
      new Float(defautIPM), new Boolean(init) };

    String resultat = new String(formatSauv.format(info));

    out.write(resultat, 0, resultat.length());
    out.newLine();
  }

  public void getObject_from_File(BufferedReader in) throws IOException {
/*    Object constr[];
    String nom;
    String tostudy = new String(in.readLine());
    MessageFormat form1 = new MessageFormat("'{'{0}'}' ");
    ParsePosition status = new ParsePosition(0);

    constr = form1.parse(tostudy,status);
    nom = new String((constr[0]).toString());

    constr=  form1.parse(tostudy,status);
    numBuffer= new Integer((constr[0]).toString());

    constr=  form1.parse(tostudy,status);
    numShutter= new Integer((constr[0]).toString());

    constr=  form1.parse(tostudy,status);
    temperature = new Integer((constr[0]).toString());

    constr=  form1.parse(tostudy,status);
    wavelength= new Float((constr[0]).toString());

    constr=  form1.parse(tostudy,status);
    imageHeight= new Float((constr[0]).toString());

    form1 = new MessageFormat("'{'{0}'}' ");
    constr=  form1.parse(tostudy,status);
    stokesType= new String((constr[0]).toString());

    form1 = new MessageFormat("'{'{0,number}'}' ");

    constr=  form1.parse(tostudy,status);
    spectralPixel= new Float((constr[0]).toString());

    constr=  form1.parse(tostudy,status);
    defaultIntegrationTime= new Integer((constr[0]).toString());
*/  }
/*
  public void getLine(BufferedReader in) throws IOException {
    Object constr[];
    ParsePosition status = new ParsePosition(0);
    String tostudy = new String(in.readLine());

//System.out.println("[Moteur:getLine] " + tostudy);
    constr = formatLigne.parse(tostudy, status);

    nomMoteur = new String((constr[0]).toString());
    type = new String((constr[1]).toString());
    fonction = new String((constr[2]).toString());
    unite = new String((constr[3]).toString());
    limiteMoins = Integer.parseInt(constr[4].toString());
    limitePlus = Integer.parseInt(constr[5].toString());
//System.out.println("[Moteur:getLine] " + nomMoteur + type + fonction + unite + limiteMoins + limitePlus);
    if (type.equals(TYPEBASE)) {
      this = new MoteurBase(nomMoteur);
    }
    else if (type.equals(TYPEVITESSE)) {
    }
    else if (type.equals(TYPECAPOT)) {
    }
    else if (type.equals(TYPEROUE)) {
    }
    else if (type.equals(TYPESONDE)) {
    }
    else throw new IOException(type + ":type de moteur inconnu");
  }
*/
}
