package iu;

import javax.swing.*;
import java.sql.*;

// Notice, do not import org.gjt.mm.mysql.*
// or you will have problems!

public class LoadDriver {
  // ne se connecte pas a la base si DEBUG
    private static final boolean DEBUG = false;
    private Connection connexion;
    private Statement stmt;

    /**
     * @return l'information de la base pour le pi voulu :
     * OBS_PROG, CONTACT & AUTHOR, INSTITUT, EMAIL, PROG_ID, CMP_TYPE
     * @param indice est la ligne du tableau selectionnee (commence a 1)
     */
  public String[] select(int indice) throws SQLException {
    int i;
    String idCamp;
    String[] resultat = new String[6];

    ResultSet RsSelect = stmt.executeQuery("SELECT id_pi,camp.id,titlep,fsname,lsname,instit,pemail,login FROM camp,pi WHERE pi.id = camp.id_pi");
    //On suppose que la numerotation du tableau textfield commence a 1
//    for (i=0; i<indice+1; i++, RsSelect.next());
    i=0;
    while(i!= indice+1)  {
      RsSelect.next();
      i++;
    }
    idCamp = new String(RsSelect.getString(2));

    resultat[0] = RsSelect.getString(3); // OBS_PROG
    String prenom = RsSelect.getString(4).toUpperCase();
    resultat[1] = ""+prenom.charAt(0);
    for (i=0; i<prenom.length(); i++) {
      if (!Character.isLetter(prenom.charAt(i))) // cas ' ' et '-'
        if (prenom.length() > i)
          if (Character.isLetter(prenom.charAt(i+1)))
            resultat[1] += prenom.charAt(i+1);
    }/*
    if ((i=prenom.indexOf('-')) > 0) {
      resultat[1] += prenom.charAt(i+1);
    }*/
    resultat[1] += "_" + RsSelect.getString(5).toUpperCase(); // CONTACT & AUTHOR
    resultat[2] = RsSelect.getString(6); // INSTITUT
    resultat[3] = RsSelect.getString(7); // EMAIL
    RsSelect.close();

    ResultSet RsCamp = stmt.executeQuery("SELECT id,titlep,camtyp FROM camp WHERE id="+idCamp);
    RsCamp.next();

    resultat[4] = ((String)UserParameters.paramFits.getKeyword("PROG_ID")
		   .getValeur()).substring(0,7) + RsCamp.getString(1);
    // pour recuperer "T_2001_" // PROG_ID
    resultat[5] = RsCamp.getString(3); // CMP_TYPE

    RsCamp.close();

    return resultat;
  }

/**
 * @return un <code>String[]</code>, chaque chaine etant :
 * "titlep fsname lsname"
 */
  public Object[] getList() throws SQLException {
    // comme on ne connait pas la taille a priori, il m'a paru + simple
    // d'utiliser un ArrayList, qui est + souple que Array.
    java.util.ArrayList liste = new java.util.ArrayList();

    if (DEBUG) return null;
    ResultSet RS = stmt.executeQuery("SELECT id_pi,camp.id,titlep,fsname,lsname FROM camp,pi WHERE pi.id = camp.id_pi");
    int nbLig;
    String ligne;
    for (nbLig=0; RS.next(); nbLig++) {
      ligne = RS.getString(4)+" "+RS.getString(5)+" : ";
      ligne += RS.getString(3);
      liste.add(ligne);
    }
    RS.close();

    return liste.toArray() ;
  }

/**
 * Se deconnecte de la base
 */
  public void deconnect() {
    if (DEBUG) return;
    try {
        stmt.close();
        connexion.close();
    }
    catch (SQLException E) {
      System.err.println("SQLException: " + E.getMessage());
      System.err.println("SQLState:     " + E.getSQLState());
      System.err.println("VendorError:  " + E.getErrorCode());
    }
  }

/**
 * Se connecte a la base
 */
  public void connect() {
    if (DEBUG) return;
    AppIU.setStatus("Retrieving the campaigns description from the database...");
    try {
      Class.forName("org.gjt.mm.mysql.Driver").newInstance();

      try {
        connexion = DriverManager.getConnection("jdbc:mysql://161.72.34.134/prop2001?user=joe&password=themis01");
        stmt = connexion.createStatement();
	stmt.setQueryTimeout(10);
      }
      catch (SQLException E) {
        System.err.println("SQLException: " + E.getMessage());
        System.err.println("SQLState:     " + E.getSQLState());
        System.err.println("VendorError:  " + E.getErrorCode());
      }
    }
    catch (Exception E) {
      AppIU.setStatus("Unable to load campaign database.");
      JOptionPane.showMessageDialog(null, "Cannot connect to data base"+"\nask system administrator.","Error", JOptionPane.ERROR_MESSAGE);
      E.printStackTrace();
    }
  }
}

