package iu;

import java.lang.*;
import java.io.*;
import java.text.*;


public class ListeWindow implements Sauvegardable
{
  public static final int NB_MAX_WIN = 40;

  private int nbWindow;
  private Window[] listeWin;

  private static String sauvFormat = "'{'{0,number}'}' \n";
  private static String readFormat = "'{'{0,number}'}' '}' ";
  private static String separateur1 = "{WIN}\n";
  private static String separateur2 = "{/WIN}\n";

  public ListeWindow() {
    nbWindow =0;
    listeWin = new Window[NB_MAX_WIN];
    listeWin[NB_MAX_WIN-1] = new Window(); // sert pour CameraPanel.getImg()
    listeWin[NB_MAX_WIN-1].num = new Integer(NB_MAX_WIN-1);
  }

  public Window[] getListe() {
    return(listeWin);
  }

  public int getNbWin() {
    return(nbWindow);
  }

  public int getWin(int i) {
    int num;
    try { num = listeWin[i].num.intValue(); }
    catch(NullPointerException e) { num = 0; }
    return num; // risque d'erreur ici
  }
/*  public int getWin(int num) {
    for(int i=0; i<nbWindow; i++)
      if (listeWin[i].num.intValue()==num) return i;
    return 0; // risque d'erreur ici
  }*/

  public void addWindow(Window win) {
    if(nbWindow < NB_MAX_WIN) {
      this.listeWin[nbWindow] = win;
      nbWindow++;
    }
  }

  public void addWindow(Window win, int indice) {
    int length;

    if((nbWindow < NB_MAX_WIN)&&(indice <= nbWindow)) {
      if(indice == nbWindow)
	addWindow(win);
      else {
	length = nbWindow - indice;

	System.arraycopy(listeWin,indice,listeWin,(indice+1),length);
	listeWin[indice]=win;
	nbWindow++;
      }
    }
  }

  public void removeWindow(int indice) {
      int length;
      if(indice < nbWindow) {
	length = nbWindow - indice - 1;
	System.arraycopy(listeWin,(indice+1),listeWin,indice,length);
	nbWindow--;
      }
  }

  public String[] getWaveString() {
    String[] waveString = new String[nbWindow];
    for(int i=0; i<nbWindow; i++)
      waveString[i] = "("+i+") "+listeWin[i].wavelength.floatValue()+" "
        +UserParameters.acquisition.listeCam.listeCamera[listeWin[i].getCam()].stokesType;
    return waveString;
  }

  public void setObject_to_file(BufferedWriter out) throws IOException {
    Integer nbwin = new Integer(nbWindow);
    Object[] info = {nbwin};
    MessageFormat form = new MessageFormat(sauvFormat);
    String resultat = new String(form.format(info));
    int i;

    //System.out.println("[ListeWindow:setObject_to_file] nbWindow a sauver=" + Integer.toString(nbWindow));

    out.write(separateur1);
    out.write(resultat,0,resultat.length());

    for(i=0;i<nbWindow;i++) {
      listeWin[i].setObject_to_file(out);
    }
    out.write(separateur2);
  }

   /** Demande la position en fin de ligne de debut de section  */
  public void getObject_from_File(BufferedReader in) throws IOException {
    getObject_from_File(in, new boolean[] { true, true });
  }

  public void getObject_from_File(BufferedReader in, boolean[] parties) throws IOException {
    Object constr[];
    Integer nbvaleur;
    int i,tailletab_win;
    String tostudy;
    ParsePosition status = new ParsePosition(0);
    Window win;

    in.readLine(); // lecture de WIN
    tostudy = new String(in.readLine());
    MessageFormat form1 = new MessageFormat("'{'{0,number}'}' ");

//    System.out.println(tostudy);

    constr=  form1.parse(tostudy,status);
    nbvaleur=new Integer((constr[0]).toString());

//    System.out.println("[ListeWindow:getObject_from_File] nb window a charger=" + nbvaleur.toString());

    if (parties[1]) {
      this.nbWindow = nbvaleur.intValue();

      for (i=0; i<nbWindow; i++) {
        win = new Window();
        win.getObject_from_File(in);
	win.num=new Integer(i);
        this.listeWin[i]=win;
      }
    }
    else for (i=0; i<nbvaleur.intValue(); i++) in.readLine();

    in.readLine(); // lecture de /WIN
  }
}
