package iu;

import java.lang.*;
import java.io.*;
import java.text.*;

public class ListePolar implements Sauvegardable
{
  public int nbPolar = 1;
  public Polar listePolar[];

  public static int NB_MAX_POL = 32;

  private static String sauvFormat = "'{'{0,number}'}' \n";
  private static String readFormat = "'{'{0,number}'}' ";
  private static String separateur1 = "{POL}\n";
  private static String separateur2 = "{/POL}\n";

  public ListePolar() {
    listePolar = new Polar[NB_MAX_POL];
    for( int i = 0 ; i < NB_MAX_POL ; i++ ) {
      listePolar[i] = new Polar();
    }
  }

  public Polar[] getListe() {
    return(listePolar);
  }

  public Object[] getStringListe() {
    java.util.ArrayList liste = new java.util.ArrayList();

    for (int i=0; i<nbPolar; i++) 
      liste.add(listePolar[i].name);

    liste.trimToSize();
    return liste.toArray() ;
  }

  public Polar getPolar(String name) {
    for (int i=0; i<nbPolar; i++)
      if (listePolar[i].name.toLowerCase().equals(name.toLowerCase())) 
        return listePolar[i];
    return null;
  }

  public int getNbPol() {
    return(nbPolar);
  }

  public void addPolar(Polar pol) {
    if(nbPolar < NB_MAX_POL) {
      listePolar[nbPolar]=pol;
      nbPolar++;
    }
  }

  /** indice commence a 0... */
  public void addPolar(Polar pol, int indice) {

    int length;

    if((nbPolar <  NB_MAX_POL) &&(indice <= nbPolar)) {
      if(indice == nbPolar)
	addPolar(pol);
      else {
	length = nbPolar - indice;

	System.arraycopy(listePolar,indice,listePolar,(indice+1),length);
	listePolar[indice]=pol;
	nbPolar++;
      }
    }
  }

  public void removePolar(int indice) {
    int length;
    if(indice < nbPolar) {
      length = nbPolar - indice - 1;
      System.arraycopy(listePolar,(indice+1),listePolar,indice,length);
      nbPolar--;
    }
  }

  public void setObject_to_file(BufferedWriter out) throws IOException {
    Integer nbpol = new Integer(nbPolar);
    Object[] info = {nbpol,nbpol};
    MessageFormat form = new MessageFormat(sauvFormat);
    String resultat = new String(form.format(info));
    int i;

    out.write(separateur1);
    out.write(resultat,0,resultat.length());

    for(i=0;i<nbPolar;i++) {
      listePolar[i].setObject_to_file(out);
    }
    out.write(separateur2);
  }

  /**   */
  public void getObject_from_File(BufferedReader in) throws IOException {
    getObject_from_File(in, new boolean[] { true, true });
  }

  public void getObject_from_File(BufferedReader in, boolean[] parties) 
    throws IOException {
    Object constr[];
    int i,nbValue;
    ParsePosition status = new ParsePosition(0);
    Polar pol;
    String tostudy;
    MessageFormat form1;

    in.readLine(); // lecture de POL

    tostudy =  new String(in.readLine());
    form1= new MessageFormat("'{'{0,number}'}' ");

    constr = form1.parse(tostudy,status);

    nbValue = Integer.parseInt(constr[0].toString());

    if (parties[0]) {
      listePolar = new Polar[NB_MAX_POL];
      nbPolar = 0;

      for(i=0;i<nbValue;i++) {
        pol = new Polar();
        pol.getObject_from_File(in);
        this.addPolar(pol);
      }
    }
    else for(i=0; i<nbValue; i++) in.readLine();
    in.readLine(); // lecture de /POL
  }

}
