/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Grassin-Minec-Debin
 * @version 1.0
 */

package iu;

import java.text.*;
import java.io.*;

public class ListeMoteur implements Sauvegardable {

  int nbMoteur = 0;
  private int nbArmoire = 0;
  private Armoire[] armoires;

  static final MessageFormat formatLigne
    = new MessageFormat("{0}\t{1}\t{2}\t{3}\t{4,number}\t{5,number}");
    // nom  type  fonction  unite limite- limite+

  static final MessageFormat formatEntete = new MessageFormat("{0} {1}:{2,number}");
  private static final MessageFormat formatNombre = new MessageFormat("'{'{0,number}'}'");

  private static String sauvFormat = "'{'{0,number}'}' \n";
  private static String readFormat = "'{'{0,number}'}' ";
  private static String separateur1 = "{MOT}\n";
  private static String separateur2 = "{/MOT}\n";

  public ListeMoteur() {
    try {
      readMoteurFile();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  public int getNbArmoire() {
    return nbArmoire;
  }

  public Armoire[] getArmoires() {
    return armoires;
  }

  public Moteur getMoteur(String nom) {
    for (int a = 0; a < nbArmoire; a++){//System.out.println("[ListeMoteur:getMoteur] a=" + a);
      for (int t = 0; t < armoires[a].nbTiroir; t++)
        for (int m = 0; m < armoires[a].tiroirs[t].nbMoteur; m++)
          if ( armoires[a].tiroirs[t].moteurs[m].nomMoteur.equals(nom) )
            return armoires[a].tiroirs[t].moteurs[m];}
    return null;
  }

  public void setObject_to_file(BufferedWriter out) throws IOException {
    Integer nbMot = new Integer(nbMoteur);
    Object[] info = { nbMot };

    out.write(separateur1);
    out.write( formatNombre.format(info) );
    out.newLine();
    for (int a = 0; a < nbArmoire; a++)
      armoires[a].setObject_to_file(out);
    out.write(separateur2);
  }

  public void getObject_from_File(BufferedReader in) throws IOException {
    getObject_from_File(in, new boolean[] { true, true });
  }

  public void getObject_from_File(BufferedReader in, boolean[] parties) throws IOException {
    Integer nbvaleur = new Integer(0);
    Object constr[];
    int i, j;
    Moteur moteur;
    ParsePosition status = new ParsePosition(0);

    // lecture de debut de zone
    in.readLine();

    String tostudy = new String(in.readLine());
    constr = formatNombre.parse(tostudy, status);
    nbvaleur = new Integer((constr[0]).toString());
//System.out.println("[ListeMoteur:getObject_from_File] nb de moteurs du fichier : " + nbvaleur);
    for( i = 0; i < nbvaleur.intValue(); i++ ) {
      tostudy = in.readLine();
      if (parties[0]) {
        try { constr = Moteur.formatSauv.parse(tostudy); }
        catch ( ParseException e ) { throw(new IOException("Invalid parameter file")); }
        moteur = this.getMoteur((String)constr[0]);
        if (moteur == null)
          System.err.println("Error : motor " + (String)constr[0] + " is not in "
            + UserParameters.moteurFile);
        else
          moteur.setValeur(constr[1], constr[2], constr[3], constr[4]);
      }
    }
    // lecture de fin de zone
    in.readLine();
  }

/**
 * lit le fichier moteur.txt
 * --------------------------------------------------------------------
 * attention : lit les lignes jusqu' rencontrer une erreur :
 * EOF ou mauvaise expression
 */
  public void readMoteurFile() throws Exception {
    boolean continueLecture = true;

    System.out.println("[ListeMoteur:readMoteurFile] lecture de " + UserParameters.moteurFile);
    nbMoteur = 0;
    nbArmoire = 0;

    BufferedReader in = new BufferedReader(new FileReader(UserParameters.moteurFile));

    armoires = new Armoire[Armoire.NB_MAX_ARMOIRES];
    while ( continueLecture ) {
//System.out.println("[ListeMoteur:readMoteurFile] numero d'armoire=" + nbArmoire);
      try {
        armoires[nbArmoire] = new Armoire();
        armoires[nbArmoire].getArmoire( in );
      }
      catch (Exception e) {
        continueLecture = false;
//        e.printStackTrace();
      }
      if ( continueLecture ) {
        for ( int T = 0; T < armoires[nbArmoire].nbTiroir; T++ )
          nbMoteur += armoires[nbArmoire].tiroirs[T].nbMoteur;
        nbArmoire++;
      }
    }
//System.out.println("[ListeMoteur:readMoteurFile] nbArmoire=" + nbArmoire);
  }

}