// maintenu par Damien Debin
// corrige par Jerome Minec
// cree le 4/4/2000

package iu;

import java.io.*;
import java.text.*;

public class ListeKeyword implements Sauvegardable {
  private static final int NB_MAX_KEYWORD = 256;
  public Keyword[] keywordList = new Keyword[ NB_MAX_KEYWORD ];
  private int nbKeyword = 0;
  private int nbKeywordObs = 0;
  private int nbKeywordTec = 0;
  private int nbKeywordIU = 0;
  private int nbKeywordAcq = 0;

  private static final MessageFormat formatNombre = new MessageFormat("'{'{0,number}'}'");
  private static final MessageFormat formatChaine = new MessageFormat("'{'{0}'}' ");
//  private static final MessageFormat formatSauv = new MessageFormat("'{'{0}'}' '{'{1}'}'");
  private static String separateur1 = "{KEYWORD}\n";
  private static String separateur2 = "{/KEYWORD}\n";

  public ListeKeyword() {
    try {
      readFitsFile();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  public int getNbKeyword() { return nbKeyword; }

  /**
   * @param identifiant chaine representant le motcle a chercher
   * @return            la liste des choix possible pour un mot-cle donne
   */
  public Object[] getChoice(String identifiant) {
    Keyword keyword;

    keyword = getKeyword( identifiant );
    if ( keyword == null )  return new String[] { "0", "1", "2", "3", "4" };
    else return keyword.listeValeurpossible;
  }

  /**
   * @param identifiant chaine representant le motcle a chercher
   * @return            le mot-cle dont l'identifiant est passe en parametre ou
   *                    <code>null</code> si le mot-cle n'est pas trouve
   */
  public Keyword getKeyword(String identifiant) {
    for ( int i = 0; i < nbKeyword; i++ )
      if ( keywordList[i].keyword.equals(identifiant) ) return keywordList[i];

    System.err.println("Error : keyword " + identifiant + " is not in "
      + UserParameters.fitsFile);
    return null;
  }

  public void getObject_from_File(BufferedReader in) throws IOException {
    getObject_from_File(in, new boolean[] { true, true });
  }

  public void getObject_from_File(BufferedReader in, boolean[] parties) throws IOException {
    Integer nbvaleur = new Integer(0);
    Object constr[];
    int i, j;
    ParsePosition status = new ParsePosition(0);
    Keyword aKeyword;
    MessageFormat format;

    // lecture de debut de zone
    in.readLine();

    String tostudy = new String(in.readLine());
    constr = formatNombre.parse(tostudy, status);
    nbvaleur = new Integer((constr[0]).toString());
//System.out.println("[ListeKeyword:getObject_from_File] nb de keywords du fichier : " + nbvaleur);

    // au cas ou le Keyword lu n'existe pas dans fits.txt, il faudra le signaler...
    for( i = 0; i < nbvaleur.intValue(); i++ ) {
      tostudy = in.readLine();
      status.setIndex(0);
      constr = formatChaine.parse(tostudy, status);

      //pour TYPETEXT : lire eventuellement sur plusieurs lignes  jusqu'a '}'
      while (tostudy.lastIndexOf("}") < status.getIndex())
        tostudy += "\n" + in.readLine();

      aKeyword = getKeyword((String)constr[0]);
      if (aKeyword == null)
        System.err.println("Error : keyword " + (String)constr[0] + " is not in "
          + UserParameters.fitsFile);
      else if ( ( aKeyword.source.equals(Keyword.SOURCETEC) && parties[0] )
        || ( aKeyword.source.equals(Keyword.SOURCEOBS) && parties[1] ) ) {
        switch( aKeyword.getType() ) {
          case Keyword.TYPEINT:
            format = new MessageFormat("'{'{0,number}'}'"); break;
          case Keyword.TYPEFLOAT:
            format = new MessageFormat("'{'{0,number}'}'"); break;
          default:
            format = new MessageFormat("'{'{0}'}'"); break;
        }
        constr = format.parse(tostudy, status);

        try { aKeyword.setValeur( constr[0].toString() ); }
        catch (NumberFormatException e) { System.err.println("Error with keyword "
          + aKeyword.getKeyword() + " : " + e); }
      } // else if
    } // for i

    // lecture de fin de zone
    in.readLine();
  }

  public void setObject_to_file(BufferedWriter out) throws IOException {
    Integer nb = new Integer(nbKeyword);
    Object[] info = { nb };
//    String resultat = new String(formatNombre.format(info));

    out.write(separateur1);
//    out.write( resultat );
    out.write( formatNombre.format(info));
    out.newLine();

    for ( int i = 0; i < nbKeyword; i++ )
      keywordList[ i ].setObject_to_file(out);

    out.write(separateur2);
  }

/**
 * Lit le fichier fits.txt.
 * Attention : lit les lignes de mot-cles jusqu' rencontrer une erreur :
 * EOF ou mauvaise expression
 */
  public void readFitsFile() throws java.io.FileNotFoundException {
    boolean continueLecture = true;

    System.out.println("[ListeKeyword:readFitsFile] lecture de " + UserParameters.fitsFile);
    nbKeyword = 0;
    nbKeywordObs = 0;
    nbKeywordTec = 0;
    nbKeywordIU = 0;

    BufferedReader in = new BufferedReader(new FileReader(UserParameters.fitsFile));
/* attention : lit les lignes de mot-cles jusqu' rencontrer une erreur,
  EOF ou mauvaise expression */
    while ( continueLecture ) {
      keywordList[ nbKeyword ] = new Keyword();
      try {
        keywordList[ nbKeyword ].getFitsLine( in );
      }
      catch (NullPointerException e) {
        continueLecture = false;
//        e.printStackTrace();
      }
      catch (java.io.IOException e) {
        e.printStackTrace();
      }
      if ( continueLecture ) {
        if ( keywordList[nbKeyword].source.equals(Keyword.SOURCEIU) ) nbKeywordIU++;
        else if ( keywordList[nbKeyword].source.equals(Keyword.SOURCEOBS) ) nbKeywordObs++;
        else if ( keywordList[nbKeyword].source.equals(Keyword.SOURCETEC) ) nbKeywordTec++;
        else if ( keywordList[nbKeyword].source.equals(Keyword.SOURCEACQ) ) nbKeywordAcq++;
        nbKeyword++;
        if (nbKeyword >= NB_MAX_KEYWORD) {
          continueLecture = false;
        }
      }
    }
System.out.println("[ListeKeyword:readFitsFile] nbKeyword=" + nbKeyword);
  }

  /**
   * @exception BadValeurException Lors du formatage.
   */
  public KeywordText getAllOtherKeywords() throws BadValeurException {
    KeywordText resul = new KeywordText(0, "");
    for (int i = 0; i < nbKeyword; i++)
      if (keywordList[i].source.equals(Keyword.SOURCETEC)
        || keywordList[i].source.equals(Keyword.SOURCEOBS)
        || keywordList[i].source.equals(Keyword.SOURCEIU))
          resul = resul.add(keywordList[i].getmotcle());
    return resul;
  }
}
