package iu;

import java.lang.*;
import java.io.*;
import java.text.*;

/** Objet Script prevu pour se chainer avec les autres */
/** pour avoir un programme d'observation */


public class ListeCamera implements Sauvegardable
{
  public int nbCamera = 1;
  public Camera listeCamera[];

  public static int NB_MAX_CAM = 32;

  private static String sauvFormat = "'{'{0,number}'}' \n";
  private static String readFormat = "'{'{0,number}'}' ";
  private static String separateur1 = "{CAM}\n";
  private static String separateur2 = "{/CAM}\n";

  public ListeCamera() {
    nbCamera = 1;
    listeCamera = new Camera[NB_MAX_CAM];
    for( int i = 0 ; i < NB_MAX_CAM ; i++ ) {
      listeCamera[i] = new Camera();
    }
  }

/**
 * @param numRep le numero de la camera
 * @return l'indice de la camera dans le tableau listeCamera[]
 **/
  public int getCam(int numRep) {
    for (int i=0; i<nbCamera; i++)
      if (listeCamera[i].numRep.intValue()==numRep) return i;
    return -1;
  }

  public Camera[] getListe() {
    return(listeCamera);
  }

  public int getNbCam() {
    return(nbCamera);
  }

  public String[] getWaveString() {
    String[] waveString = new String[nbCamera];
    for(int i=0; i<nbCamera; i++)
      waveString[i] = "("+listeCamera[i].numRep+") "+listeCamera[i].wavelength.toString()+" "
        +listeCamera[i].stokesType;
    return waveString;
  }

  public void addCamera(Camera cam) {
    if(nbCamera < NB_MAX_CAM) {
      listeCamera[nbCamera]=cam;
      nbCamera++;
    }
  }

  /** indice commence a 0... */
  public void addCamera(Camera cam, int indice) {

    int length;

    if((nbCamera <  NB_MAX_CAM) &&(indice <= nbCamera)) {
      if(indice == nbCamera)
	addCamera(cam);
      else {
	length = nbCamera - indice;

	System.arraycopy(listeCamera,indice,listeCamera,(indice+1),length);
	listeCamera[indice]=cam;
	nbCamera++;
      }
    }
  }

  public void removeCamera(int indice) {
    int length;
    if(indice < nbCamera) {
      length = nbCamera - indice - 1;
      System.arraycopy(listeCamera,(indice+1),listeCamera,indice,length);
      nbCamera--;
    }
  }

  public void setObject_to_file(BufferedWriter out) throws IOException {
    Integer nbcam = new Integer(nbCamera);
    Object[] info = {nbcam,nbcam};
    MessageFormat form = new MessageFormat(sauvFormat);
    String resultat = new String(form.format(info));
    int i;

    out.write(separateur1);
    out.write(resultat,0,resultat.length());

    for(i=0;i<nbCamera;i++) {
      listeCamera[i].setObject_to_file(out);
    }
    out.write(separateur2);
  }

  /**   */
  public void getObject_from_File(BufferedReader in) throws IOException {
    getObject_from_File(in, new boolean[] { true, true });
  }

  public void getObject_from_File(BufferedReader in, boolean[] parties) throws IOException {
    Object constr[];
    int i,nbValue;
    ParsePosition status = new ParsePosition(0);
    Camera cam;
    String tostudy;
    MessageFormat form1;

    in.readLine(); // lecture de CAM

    tostudy =  new String(in.readLine());
    form1= new MessageFormat("'{'{0,number}'}' ");

    constr = form1.parse(tostudy,status);

    nbValue = Integer.parseInt(constr[0].toString());

    if (parties[0]) {
System.out.println("[ListeCamera:getObject_from_File] nb de cameras du fichier : " + nbValue);
      listeCamera = new Camera[NB_MAX_CAM];
      nbCamera = 0;

      for(i=0;i<nbValue;i++) {
        cam = new Camera();
        cam.getObject_from_File(in);
        this.addCamera(cam);
      }
    }
    else for(i=0; i<nbValue; i++) in.readLine();
    in.readLine(); // lecture de /CAM
  }

}
