/*
  corrig par Jrome, juin 2000
*/

package iu;

import java.lang.*;
import java.util.*;
import java.text.*;
import java.io.*;

public class Keyword implements Sauvegardable, Formatable {

  public static final int TAILLEMOTCLE = 8;
  public static final int TAILLETEXTMAX = 5;

  public static final String NOSOURCE = "";
// calcul par l'IU
  public static final String SOURCEIU = "IU";
//  remplir par le technicien
  public static final String SOURCETEC = "TEC";
//  remplir par l'observateur
  public static final String SOURCEOBS = "OBS";
// spcifique au prog d'acq,  remplir par l'IU dans Cible.format
  public static final String SOURCEACQ = "ACQ";

  public static final int NOTYPE = 0;
  public static final int TYPEINT = 1;
  public static final int TYPEFLOAT = 2;
  public static final int TYPESTRING = 3;
  public static final int TYPECHAR = 4;
  /**
   * plusieurs lignes de texte, pour COMMENT par exemple
   */
  public static final int TYPETEXT = 5;
/**
 *                             fits.txt
 * localisation : meme repertoire que l'io
 * structure de ce fichier : 1 mot-cle / ligne, avec pour chaque ligne 
 *   les champs suivants separes par des tabulations :
 *   source : OBS/IU/AUT
 *   nom : 8 caracteres max, en majuscules
 *   description : chane de caracteres
 *   obligatoire? : 0/1
 *   type : 0/1/2/3/4 : no/int/float/string/char
 *   modifiable? : 0/1
 *   nb_valeurs_possibles : entier=>0
 *   valeur_possible...
 *   (avec une tabulation en fin de ligne)
 */
  private static final MessageFormat formatLigne
    = new MessageFormat("{0}\t{1}\t{2}\t{3,number}\t{4,number}\t{5,number}\t{6,number}\t");
  private static final MessageFormat formatNombre = new MessageFormat("{0,number}\t");
  private static final MessageFormat formatChaine = new MessageFormat("{0}\t");
/**
 * Pour la sauvegarde sur fichier :
 * {keyword, chane} {valeur}
 */
  private static final MessageFormat formatSauv = new MessageFormat("'{'{0}'}' '{'{1}'}'");

  public String source;
  public String keyword;
  public String signification;
  private Integer obligatoire;
  private Integer type;
  public Integer modifiable;
  public Integer nbvaleurpossible;
  public Object listeValeurpossible[];
  private Object valeur;
//  public int      indice;

  public Keyword() {
    nbvaleurpossible= new Integer(0);
  }

  public Keyword(Keyword aKeyword) {
    if (aKeyword == null) aKeyword = new Keyword();
    this.source = new String(aKeyword.source);
    this.keyword = new String(aKeyword.keyword);
    this.signification = new String(aKeyword.signification);
    this.obligatoire = new Integer(aKeyword.obligatoire.intValue());
    this.type = new Integer(aKeyword.type.intValue());
    this.modifiable = new Integer(aKeyword.modifiable.intValue());
    this.nbvaleurpossible = new Integer(aKeyword.nbvaleurpossible.intValue());
    this.setValeur(aKeyword.getValeur().toString());
  }

  public Keyword(String keyword, int type, String valeur) {
    this.source = null;
    this.keyword = new String(keyword);
    this.signification = null;
    this.obligatoire = null;
    this.type = new Integer(type);
    this.modifiable = null;
    this.nbvaleurpossible = new Integer(0);
    this.setValeur(valeur);
  }

  public String getKeyword() { return keyword; }

  public Object getValeur() { return valeur; }

  public int getType() { return type.intValue(); }

  public int getNbVal() { return nbvaleurpossible.intValue(); }

  public boolean isModifiable() { return (modifiable.intValue()==1); }

  public boolean isObligatoire() { return (obligatoire.intValue()==1); }

  public boolean isAffecte() {
    switch(type.intValue()) {
      case TYPESTRING:
        if (((String)valeur).length() > 0) return true;
        else return false;
      case TYPETEXT:
        if (((String)valeur).length() > 0) return true;
        else return false;
      default:
        return true;
    }
  }

  public void setValeur(int i) throws NumberFormatException {
    setValeur(listeValeurpossible[i].toString());
  }

/**
  * Pour les String, il ne faut pas de caractere "'" : le prog 
  * d'acquisition l'interprete comme la fin de la chaine.
  */
  public void setValeur(String ch) throws NumberFormatException, IllegalArgumentException  {
//System.out.println("[Keyword:setValeur] " + keyword + ".setValeur(\"" + ch + "\")" );
    switch(type.intValue()) {
      case TYPEINT:
        valeur = new Integer(Integer.parseInt(ch)); break;
      case TYPEFLOAT:
        valeur = new Float(Float.parseFloat(ch)); 
        break;
      case TYPESTRING:
        valeur = new String(ch.replace('\'', ' ').replace('\n', ' ')
			    .toUpperCase()); break;
      case TYPECHAR:
        valeur = new Character(ch.charAt(0)); break;
      case TYPETEXT:
        valeur = new String(ch.replace('\'', ' ')); break;
    }
  }

  public void setObject_to_file(BufferedWriter out) throws IOException {
    Object[] info = { keyword, valeur };

    String resultat = new String(formatSauv.format(info));

    out.write(resultat, 0, resultat.length());
    out.newLine();
  }

  public void getObject_from_File(BufferedReader in) throws IOException {
    throw new IOException("Ne pas appeler cette methode.");
  }

  public void getFitsLine(BufferedReader in) throws IOException {
    int i;
    Object constr[];// = { source, keyword, signification, obligatoire, type, modifiable, nbvaleurpossible };
    ParsePosition status = new ParsePosition(0);
    String tostudy = new String(in.readLine());

    constr = formatLigne.parse(tostudy, status);

//System.out.println("toStudy="+tostudy+", status="+status);
    if (status.getErrorIndex() > -1) {
      System.err.print("[Keyword.getFitsLine] erreur au caractere "+status.getErrorIndex());
      if (status.getErrorIndex() > 0)
        System.err.println(" (apres '"+tostudy.charAt(status.getErrorIndex()-1)+"'), ligne='"+tostudy+"'");
      else System.err.println(" (au 1er caractere), ligne='"+tostudy+"'");

      source = "";
      keyword = "";
      signification = "";
      obligatoire = new Integer(0);
      type = new Integer(0);
      modifiable = new Integer(0);
      nbvaleurpossible = new Integer(0);
      return;
    }

    this.source = new String((constr[0]).toString());
    this.keyword = new String((constr[1]).toString());
    this.signification = new String((constr[2]).toString());
    this.obligatoire = new Integer((constr[3]).toString());
    this.type = new Integer((constr[4]).toString());
    this.modifiable = new Integer((constr[5]).toString());
    this.nbvaleurpossible = new Integer((constr[6]).toString());

    try { switch(type.intValue()) {
      case TYPEINT: {
        listeValeurpossible = new Integer[nbvaleurpossible.intValue()];
	for(i=0; i<nbvaleurpossible.intValue(); i++) {
	  constr = formatNombre.parse(tostudy, status);
	  listeValeurpossible[i] = new Integer((constr[0]).toString());
        }
        if ( nbvaleurpossible.intValue() > 0 )
          valeur = new Integer( ((Integer)(listeValeurpossible[0])).intValue() );
        else valeur = new Integer(0);
	break;
	}
	case TYPEFLOAT: {
	  listeValeurpossible = new Float[nbvaleurpossible.intValue()];
	  for(i=0; i<nbvaleurpossible.intValue(); i++) {
            constr = formatNombre.parse(tostudy, status);
	    listeValeurpossible[i] = new Float((constr[0]).toString());
	  }
          if ( nbvaleurpossible.intValue() > 0 )
            valeur = new Float( ((Float)(listeValeurpossible[0])).floatValue() );
          else valeur = new Float(0.0);
	  break;
        }
	case TYPESTRING: {
	  listeValeurpossible = new String[nbvaleurpossible.intValue()];
	  for(i=0; i<nbvaleurpossible.intValue(); i++) {
	   constr = formatChaine.parse(tostudy, status);
	   listeValeurpossible[i] = new String((constr[0]).toString()).toUpperCase();
//    System.out.println(i+" - "+listeValeurpossible[i]);
	  }
          if ( nbvaleurpossible.intValue() > 0 )
            valeur = new String( (String)(listeValeurpossible[0]) );
          else valeur = new String("");
	  break;
        }
	case TYPECHAR: {
	  listeValeurpossible = new Character[nbvaleurpossible.intValue()];
	  for(i = 0; i<nbvaleurpossible.intValue(); i++) {
	    constr = formatChaine.parse(tostudy, status);
	    listeValeurpossible[i] = new Character(((constr[0]).toString()).charAt(0));
//    System.out.print(i+" - "+listeValeurpossible[i]);
	  }
          if ( nbvaleurpossible.intValue() > 0 )
            valeur = new Character( ((Character)listeValeurpossible[0]).charValue() );
          else valeur = new Character('\0');
	  break;
        }
	case TYPETEXT: {
	  listeValeurpossible = new String[nbvaleurpossible.intValue()];
	  for(i=0; i<nbvaleurpossible.intValue(); i++) {
	   constr = formatChaine.parse(tostudy, status);
	   listeValeurpossible[i] = new String((constr[0]).toString());
	  }
          if ( nbvaleurpossible.intValue() > 0 )
            valeur = new String( (String)(listeValeurpossible[0]) );
          else valeur = new String("");
	  break;
        }
      } // switch
      } // try
      catch (NullPointerException e) {
        System.err.println(e.toString() + " ligne " + tostudy);
      }
  }

  public KeywordText getmotcle() throws BadValeurException {
    Integer intVal = new Integer(0);
    KeywordText resul = new KeywordText();
    if (getType()==Keyword.TYPETEXT) {
      String chaine = new String((String)valeur);
      String ligne;
      int i=0, j=0;
      
      // le mot-cle doit apparaitre, meme si valeur=""
      if (chaine.length()==0) 
        return Formatage.motcle(keyword,intVal,false,"");
//System.out.println("keyword="+keyword+" est vide");}
      else for (int n=0; (n<TAILLETEXTMAX)&&(i<chaine.length()); n++) {
        j = chaine.indexOf("\n", i);
        if (j == -1) j = chaine.length();
        j = Math.min(j, i+Formatage.TAILLEMAX);
        ligne = chaine.substring(i, j);
        resul = resul.add(Formatage.motcle(keyword,intVal,false,ligne));
        i = j;
        if (i < chaine.length()) if (chaine.charAt(i)=='\n') i++;
      }
    }
    else resul = Formatage.motcle(keyword,intVal,false,valeur);
    return resul;
  }

}
