package iu;

import java.lang.*;
import java.util.*;
import java.math.*;
import java.text.*;

/** Objets de methode de classes pour la manipulation et le */
/** formatage de chaine de caracteres */

public class Formatage
{
  private static final char zero[] = {'0','0','0','0','0','0','0','0'};
  private static final int zeroLength = 8;
  private static final String BLANC = "                                                                                            ";
  public static final int TAILLEMAX = 68;

  //** Mehode pour les format "***.** /

  private static String setModelDec(BigDecimal value,int scale,int index)
    throws BadValeurException
    {
      int i,diff;
      BigDecimal limiteSup = new BigDecimal(1);
      BigDecimal limiteInf = new BigDecimal(1);
      BigDecimal base = new BigDecimal(10);
      StringBuffer result;
      i=0;

      while(i<index)
	{
	  limiteSup = limiteSup.multiply(base);
	  i++;
	}
      limiteInf =(limiteSup.divide(base,limiteSup.ROUND_UNNECESSARY)).negate();

      //Si c'est positif et rentre dans le format

      if((value.compareTo(limiteSup) < 0 )&&(value.signum() ==1))
	{
	  result = new StringBuffer((value.setScale(scale,
		       			    value.ROUND_DOWN)).toString());
	  diff= scale+index+1- result.length();

	  if((diff > 0)&&(diff<=zeroLength))
	      result.insert(0,zero,0,diff);
	  return(result.toString());
	}
      //Si c'est negatif et rentre dans le format

      if((value.compareTo(limiteInf) >0)&&(value.signum() == -1))
	{
	  result = new StringBuffer((value.setScale(scale,
					     value.ROUND_DOWN)).toString());
	  diff = scale+index+1 - result.length();
	  if (( diff > 0)&&(diff <= zeroLength))
	      result.insert(1,zero,0,diff);
	  return(result.toString());
	}
      throw new BadValeurException("BadValeurExceptionNotFit");
      //      return("");
    }


  //* Methode pour les formats "***" */
  private static String setModelEnt(BigDecimal value, int scale)
    throws BadValeurException
    {
      int i=0,diff;
      BigDecimal limiteSup  = new BigDecimal(1);
      BigDecimal limiteInf  = new BigDecimal(1);
      BigDecimal base = new BigDecimal(10);
      StringBuffer result;

      while(i<scale)
	{
	  limiteSup = limiteSup.multiply(base);
	  i++;
	}

      limiteInf =(limiteSup.divide(base,limiteSup.ROUND_UNNECESSARY)).negate();

      // Si positif et entre dans le format
      if((value.compareTo(limiteSup) < 0)&&(value.signum() ==1))
	{
	  result= new StringBuffer((value.setScale(0,
					   value.ROUND_DOWN)).toString());
	  diff = scale - result.length();
	  if (( diff > 0)&&(diff <= zeroLength))
	      result.insert(0,zero,0,diff);

	  return(result.toString());
	}
      // Si Negatif et entre dans le format
      if((value.compareTo(limiteInf) > 0)&&(value.signum() == -1))
	{
	  result = new StringBuffer((value.setScale(0,
					     value.ROUND_DOWN)).toString());
	  diff =scale -result.length();

	  if(( diff > 0)&&(diff <= zeroLength))
	      result.insert(1,zero,0,diff);

	  return result.toString();
	}

      throw new BadValeurException("BadValeurExceptionNotFit");
      //      return "";

    }
  //* Retourne la valeur en String au format "***.**" en parametre */


  public static String setModel(BigDecimal value,String format)
    throws BadValeurException
    {
      int scale,index,i;
      BigDecimal limiteInf = new BigDecimal(1);

      index=format.indexOf(".");

      if(index != -1)
	{
	  scale=format.length()- format.indexOf(".")-1;

	  try{return(setModelDec(value,scale,index)); }
	  catch(BadValeurException e)
	    {
	      throw(e);
	    }
	}
      else
	{
	  //Si pas de virgule desire

	  try{return(setModelEnt(value,format.length()));}
	  catch(BadValeurException e)
	    {
	      throw(e);
	    }
	}
    }

  /** cree une ligne de formatage pour les FITS
    param 1 keyword
    param 2 indice de la valeur
    param 3 indice present ou pas (true ou false)
    param 4 la valeur
    */

  public static KeywordText motcle(String keyword,Integer ind,boolean indicepresent,Object valeur)
    throws BadValeurException
    {
      String resultat= new String("_"+keyword);
      int i,diff,typevaleur=-1;
      String strIndice;
      String strValeur;

      if (indicepresent)
	{
	  strIndice = new String(ind.toString());
	  diff = 9-strIndice.length()-resultat.length();

	  if(diff < 0)
	      throw new BadValeurException("indexed keyword '"+keyword+"', string too long : '"+valeur.toString()+"'");
	  else
	      resultat=resultat.concat(BLANC.substring(0,diff)+strIndice);
	}
      else
	{
	  diff= 9 - resultat.length();
	  resultat=resultat.concat(BLANC.substring(0,diff));
	}

      resultat=resultat.concat("=");

      if(valeur instanceof String) { typevaleur = 3; }
      else if(valeur instanceof Character) { typevaleur = 2; }
      else if(valeur instanceof Float) {  typevaleur = 1; }
      else if(valeur instanceof Integer) { typevaleur = 0; }
      else throw new BadValeurException("keyword '"+keyword+"', unknown type");

      if (typevaleur == 3) {
        strValeur = (String)valeur;
	diff = TAILLEMAX - strValeur.length();
        if (diff < 0) throw new BadValeurException("keyword '"+keyword+"', string too long : '"+valeur.toString()+"'");
        else resultat= resultat.concat("'"+strValeur+"'\n"/*\r"*/);
      } else {
        if (typevaleur == 1)
          strValeur = (new DecimalFormat("#######.##")).format((Float)valeur);
        else strValeur = valeur.toString();
	diff=21-strValeur.length();
        resultat=resultat.concat(BLANC.substring(0,diff));
	resultat=resultat.concat(strValeur+"\n"/*\r"*/);
      }
/*
      switch(typevaleur)
	{
	case 0:
	case 1:
	case 2:
	    strValeur = valeur.toString();

	    diff=21-strValeur.length();
	    resultat=resultat.concat(BLANC.substring(0,diff));
	    resultat=resultat.concat(strValeur+"\n\r");
	    break;
	case 3:
	    strValeur = (String)valeur;
	    diff = TAILLEMAX - strValeur.length();
	    if(diff < 0)
	      throw new BadValeurException("BadValeurExceptionNotFit");
	    else
	      resultat= resultat.concat("'"+strValeur+"'\n\r");
	    break;
	default:
	    throw new BadValeurException("BadValeurException");
	}*/
      return new KeywordText(1, resultat);
    }
}
