
/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Grassin-Minec-Debin
 * @version 1.0
 */
package iu;

import java.awt.*;
import javax.swing.*;
import javax.swing.border.*;
import java.awt.event.*;
import javax.swing.event.*;

public class FlatFieldPanel extends JPanel {
  int flatFieldNumber = 0;
  int nbWave = 0;
  WaveLine[] waveLines;

  TitledBorder titledBorder1;
  JPanel jPanelFlatField = new JPanel();
  JPanel jPanelPosition = new JPanel();
  JPanel jPanelActionProgram = new JPanel();
  TitledBorder titledBorder2;
  TitledBorder titledBorder3;
  GridBagLayout gridBagLayoutFlatField = new GridBagLayout();
  GridBagLayout gridBagLayoutPosition = new GridBagLayout();
  JButton jButtonGetItFromTracking = new JButton("Get it from tracking !");
  JTextField jTextFieldLongitude = new JTextField();
  JTextField jTextFieldLatitude = new JTextField();
  java.util.ArrayList polar = new java.util.ArrayList();
  JComboBox jComboBoxPolar;
  JButton jButtonAdd = new JButton("add");
  JTextField jTextFieldSequence = new JTextField("");
  JButton jButtonResetAll = new JButton("Reset");
  JLabel jLabelSeq = new JLabel("Sequence :");
  JRadioButton jRadioButtonCentered = new JRadioButton("Centered");
  JRadioButton jRadioButtonUserSpecified = new JRadioButton("User specified");
  GridBagLayout gridBagLayoutActionProgram = new GridBagLayout();
  JButton jButtonDebut = new JButton();
  JButton jButtonFin = new JButton();
  JButton jButtonApres = new JButton();
  JButton jButtonAvant = new JButton();
  GridBagLayout gridBagLayoutControlButtons = new GridBagLayout();
  GridBagLayout gridBagLayoutControlBar = new GridBagLayout();
  JPanel jPanelControlBar = new JPanel();
  JPanel jPanelControlButtons = new JPanel();
  JLabel jLabelFitsMode = new JLabel("Fits Mode");
  JComboBox jComboBoxFitsMode;
  GridBagLayout gridBagLayoutThis = new GridBagLayout();
  JTextField jTextField20 = new JTextField();
  JLabel jLabelLatitude = new JLabel("X");
  JLabel jLabelLongitude = new JLabel("Y");
  JLabel jLabelHaxis = new JLabel("h axis (arcsec)");
  JTextField jTextFieldHaxis = new JTextField();
  JLabel jLabelCustomName = new JLabel("Custom name");
  JPanel jPanelElipse;
  JTextField jTextFieldCustomName = new JTextField();
  JPanel jPanelParameters = new JPanel();
  JRadioButton jRadioButtonTrackingSettings = new JRadioButton("Tracking settings");
  JRadioButton jRadioButtonUserSettings = new JRadioButton("User settings");
  GridBagLayout gridBagLayoutParameters = new GridBagLayout();
  JLabel jLabelAngle = new JLabel("Angle");
  JTextField jTextFieldAngle = new JTextField();
  JLabel jLabelLaxis = new JLabel("l axis (arcsec)");
  JTextField jTextFieldLaxis = new JTextField();
  ButtonGroup groupParameters = new ButtonGroup();
  ButtonGroup groupPosition = new ButtonGroup();

  JPanel jPanel20 = new JPanel();
  JButton jButtonDel = new JButton("del");
  GridBagLayout gridBagLayout18 = new GridBagLayout();
  JPanel jPanel6 = new JPanel();
  GridBagLayout gridBagLayout14 = new GridBagLayout();
  JPanel jPanelUsedWaveLength = new JPanel();
  JScrollPane jScrollPane2 = new JScrollPane();
  JLabel jLabel29 = new JLabel("Used wave length");
  JLabel jLabel30 = new JLabel("Integration time (ms)");
  JTextField jTextFieldNumberOfCycles = new JTextField();
  JLabel jLabelNumberOfCycles = new JLabel("Number of images");

  public FlatFieldPanel() {
    try { jbInit(); }
    catch(Exception e) { e.printStackTrace(); }
  }

  private void jbInit() throws Exception {
    initComponents();

    jTextFieldSequence.setEditable(false);

    jButtonAdd.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonAdd_actionPerformed(); }
    });
    jButtonResetAll.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { 
	polar.clear();
        jTextFieldSequence.setText(""); }
    });
    jButtonResetAll.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jTextFieldSequence.setText(""); }
    });

    titledBorder1 = new TitledBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED,Color.white,Color.white,new Color(142, 142, 142),new Color(99, 99, 99)),"Parameters");
    titledBorder2 = new TitledBorder("Position");
    titledBorder3 = new TitledBorder("Polarization settings");
    setLayout(gridBagLayoutThis);
    titledBorder1.setBorder(BorderFactory.createEtchedBorder());
    jPanelFlatField.setLayout(gridBagLayoutFlatField);
    jPanelPosition.setBorder(titledBorder2);
    jPanelPosition.setLayout(gridBagLayoutPosition);
    titledBorder2.setBorder(BorderFactory.createEtchedBorder());
    jPanelActionProgram.setBorder(titledBorder3);
    jPanelActionProgram.setLayout(gridBagLayoutActionProgram);
    titledBorder3.setBorder(BorderFactory.createEtchedBorder());
    jButtonGetItFromTracking.setBorder(BorderFactory.createRaisedBevelBorder());
    jButtonGetItFromTracking.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonGetIt_actionPerformed(); }
    });
    jTextField20.setMaximumSize(new Dimension(100, 37));
    jTextField20.setMinimumSize(new Dimension(100, 37));
    jTextField20.setPreferredSize(new Dimension(100, 37));
    jTextField20.setEditable(false);
    jPanel6.setLayout(gridBagLayout14);
    jPanelUsedWaveLength.setLayout(gridBagLayout18);
    jLabel30.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabelNumberOfCycles.setHorizontalAlignment(SwingConstants.RIGHT);
    groupPosition.add(jRadioButtonCentered);
    groupPosition.add(jRadioButtonUserSpecified);

    jButtonDebut.setMargin(new Insets(0, 0, 0, 0));
    jButtonDebut.setIcon(new ImageIcon(FlatFieldPanel.class.getResource("premier.gif")));
    jButtonDebut.setBorder(null);
    jButtonFin.setMargin(new Insets(0, 0, 0, 0));
    jButtonFin.setIcon(new ImageIcon(FlatFieldPanel.class.getResource("dernier.gif")));
    jButtonFin.setBorder(null);
    jButtonApres.setMargin(new Insets(0, 0, 0, 0));
    jButtonApres.setIcon(new ImageIcon(FlatFieldPanel.class.getResource("apres.gif")));
    jButtonApres.setBorder(null);
    jButtonAvant.setMargin(new Insets(0, 0, 0, 0));
    jButtonAvant.setIcon(new ImageIcon(FlatFieldPanel.class.getResource("avant.gif")));
    jButtonAvant.setBorder(null);
    jPanelControlBar.setLayout(gridBagLayoutControlBar);
    jPanelControlButtons.setLayout(gridBagLayoutControlButtons);
    jLabelFitsMode.setHorizontalAlignment(SwingConstants.RIGHT);
    jTextField20.setFont(new java.awt.Font("Dialog", 1, 25));
    jTextField20.setForeground(Color.red);
    jTextField20.setText("1 of 1");
    jTextField20.setHorizontalAlignment(SwingConstants.CENTER);

    jLabelLatitude.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabelLatitude.setHorizontalTextPosition(SwingConstants.LEFT);
    jLabelLongitude.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabelHaxis.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabelCustomName.setHorizontalAlignment(SwingConstants.RIGHT);
    jPanelElipse.setBorder(BorderFactory.createLoweredBevelBorder());
    jPanelElipse.setMaximumSize(new Dimension(100, 100));
    jPanelElipse.setMinimumSize(new Dimension(100, 100));
    jPanelParameters.setForeground(Color.lightGray);
    jPanelParameters.setBorder(titledBorder1);
    jPanelParameters.setLayout(gridBagLayoutParameters);
    jRadioButtonTrackingSettings.setHorizontalAlignment(SwingConstants.RIGHT);
    jRadioButtonUserSettings.setHorizontalAlignment(SwingConstants.RIGHT);
    groupParameters.add(jRadioButtonTrackingSettings);
    groupParameters.add(jRadioButtonUserSettings);
    jLabelAngle.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabelLaxis.setHorizontalAlignment(SwingConstants.RIGHT);
    jButtonDel.setMargin(new Insets(0, 5, 0, 5));
    jRadioButtonUserSpecified.addChangeListener(new javax.swing.event.ChangeListener() {
      public void stateChanged(ChangeEvent e) { jRadioButtonUserSpecified_stateChanged(e); }
    });
    jRadioButtonUserSettings.addChangeListener(new javax.swing.event.ChangeListener() {
      public void stateChanged(ChangeEvent e) { jRadioButtonUserSettings_stateChanged(e); }
    });
    jButtonDebut.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonDebut_actionPerformed(e); }
    });
    jButtonFin.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonFin_actionPerformed(e); }
    });
    jButtonApres.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonApres_actionPerformed(e); }
    });
    jButtonAvant.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonAvant_actionPerformed(e); }
    });
    jButtonDel.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) { jButtonDel_actionPerformed(e); }
    });
    this.add(jPanelFlatField, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelFlatField.add(jPanelActionProgram, new GridBagConstraints(2, 0, 1, 2, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelFlatField.add(jPanelPosition, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelPosition.add(jLabelLatitude, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelPosition.add(jLabelLongitude, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 0), 0, 0));
    jPanelPosition.add(jRadioButtonCentered, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelPosition.add(jRadioButtonUserSpecified, new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelPosition.add(jButtonGetItFromTracking, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelPosition.add(jTextFieldLongitude, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelPosition.add(jTextFieldLatitude, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelFlatField.add(jPanelParameters, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

    jPanelActionProgram.add(jLabelSeq, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    jPanelActionProgram.add(jTextFieldSequence, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelActionProgram.add(jButtonAdd, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    jPanelActionProgram.add(jButtonResetAll, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

    jPanelParameters.add(jRadioButtonTrackingSettings, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelParameters.add(jRadioButtonUserSettings, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelParameters.add(jLabelAngle, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelParameters.add(jTextFieldAngle, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelParameters.add(jLabelHaxis, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelParameters.add(jTextFieldHaxis, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelParameters.add(jLabelLaxis, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    jPanelParameters.add(jTextFieldLaxis, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelParameters.add(jPanelElipse, new GridBagConstraints(2, 0, 1, 5, 5.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 100, 100));
    jPanelParameters.add(jLabelCustomName, new GridBagConstraints(0, 5, 1, 1, 0.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanelParameters.add(jTextFieldCustomName, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelParameters.add(jLabelNumberOfCycles, new GridBagConstraints(0, 6, 1, 1, 0.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanelParameters.add(jTextFieldNumberOfCycles, new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));

    jPanelFlatField.add(jPanel6, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanel6.add(jLabel29, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 0, 5), 0, 0));
    jPanel6.add(jScrollPane2, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    jPanel6.add(jLabel30, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(5, 5, 0, 5), 0, 0));
    jScrollPane2.getViewport().add(jPanelUsedWaveLength, null);

    this.add(jPanelControlBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
    jPanelControlBar.add(jLabelFitsMode, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelControlBar.add(jComboBoxFitsMode, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.VERTICAL, new Insets(5, 5, 5, 5), 0, 0));
    jPanelControlBar.add(jPanelControlButtons, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    jPanelControlButtons.add(jButtonDebut, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));
    jPanelControlButtons.add(jButtonFin, new GridBagConstraints(5, 0, 1, 2, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));
    jPanelControlButtons.add(jButtonApres, new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));
    jPanelControlButtons.add(jButtonAvant, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));
    jPanelControlButtons.add(jTextField20, new GridBagConstraints(3, 0, 1, 2, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));
    jPanelControlButtons.add(jButtonDel, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
  }

  private void initJComboBoxPolar() {
    if (jComboBoxPolar != null) jPanelActionProgram.remove(jComboBoxPolar);
    jComboBoxPolar = new JComboBox(UserParameters.listePolar.getStringListe());
    jPanelActionProgram.add(jComboBoxPolar, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
  }

  private void initComponents() {
    jComboBoxFitsMode = new JComboBox( (Integer[])UserParameters.paramFits
      .getChoice("THEMISFF") );

    jPanelElipse = new JPanel() {
      public void paint(Graphics g) {
//        g.drawArc(0, 0, , , 0, 360);
      }
    };
    waveLines = new WaveLine[ ListeCamera.NB_MAX_CAM ];
    litWave();

    jTextFieldAngle.setInputVerifier(new Verif(Verif.TYPEINT,-180,360));
    jTextFieldHaxis.setInputVerifier(new Verif(Verif.TYPEINT,0));
    jTextFieldLaxis.setInputVerifier(new Verif(Verif.TYPEINT,0));
    jTextFieldLatitude.setInputVerifier(new Verif(Verif.TYPEFLOAT));
    jTextFieldLongitude.setInputVerifier(new Verif(Verif.TYPEFLOAT));

    jTextFieldNumberOfCycles.setInputVerifier(new Verif(Verif.TYPEINT,0));

    initJComboBoxPolar();

//    setValues( flatFieldNumber );
  }

  public void jButtonGetIt_actionPerformed() {
    String resultat = "";
    String longitude;
    String latitude;

    try {
      Communication comm = new Communication(Communication.UCCI);
      resultat = comm.envoiMessage("DA2()");
    }
    catch (java.io.IOException e) {
//      jTextAreaActionProgram.append("Communication with UCCI is impossible : " + e + "\n");
      return;
    }
//    jTextAreaActionProgram.append(resultat + "\n");
// Pour le format de la chaine renvoyee, voir document "Commandes UCCI", annexeII

    if(resultat.indexOf("Erreur") == -1) { 
      try {
	latitude = resultat.substring(67, 74);
	longitude = resultat.substring(75, 82);
      }
      catch (java.lang.StringIndexOutOfBoundsException e) {
	//      jTextAreaActionProgram.append("Format error in the UCCI string : " + e.getMessage() + "\n");
	return;
      }

      jTextFieldLatitude.setText(latitude);
      jTextFieldLongitude.setText(longitude);
    }
    else
      {
	AppIU.setStatus("Format Error"+resultat);
	JOptionPane.showMessageDialog(null, "Format Error, see Status bar","Error", JOptionPane.ERROR_MESSAGE);
      }
  }

  public void jButtonDel_actionPerformed(ActionEvent e) {
    UserParameters.observation.delete(Cible.FLATFIELD, flatFieldNumber );
    if ( flatFieldNumber >= UserParameters.observation.nbFlats ) flatFieldNumber = UserParameters.observation.nbFlats-1;
    setValues(flatFieldNumber);
  }

  public void jButtonApres_actionPerformed(ActionEvent e) {
    try { getValues(flatFieldNumber); }
    catch(NumberFormatException ee) {
      JOptionPane.showMessageDialog(null, ee.toString(), "Error!", JOptionPane.ERROR_MESSAGE);
      return;
    }
    flatFieldNumber++;
    if ( flatFieldNumber >= UserParameters.observation.NB_FLAT_FIELD_MAX ) 
      flatFieldNumber = UserParameters.observation.NB_FLAT_FIELD_MAX-1;
    if ( UserParameters.observation.nbFlats <= flatFieldNumber ) 
      UserParameters.observation.append(Cible.FLATFIELD);
    setValues(flatFieldNumber);
  }

  public void jButtonAvant_actionPerformed(ActionEvent e) {
    try { getValues(flatFieldNumber); }
    catch(NumberFormatException ee) {
      JOptionPane.showMessageDialog(null, ee.toString(), "Error!", JOptionPane.ERROR_MESSAGE);
      return;
    }
    flatFieldNumber--;
    if ( flatFieldNumber < 0 ) flatFieldNumber = 0;
    setValues(flatFieldNumber);
  }

  public void jButtonDebut_actionPerformed(ActionEvent e) {
    try { getValues(flatFieldNumber); }
    catch(NumberFormatException ee) {
      JOptionPane.showMessageDialog(null, ee.toString(), "Error!", JOptionPane.ERROR_MESSAGE);
      return;
    }
    flatFieldNumber = 0;
    setValues(flatFieldNumber);
  }

  public void jButtonFin_actionPerformed(ActionEvent e) {
    try { getValues(flatFieldNumber); }
    catch(NumberFormatException ee) {
      JOptionPane.showMessageDialog(null, ee.toString(), "Error!", JOptionPane.ERROR_MESSAGE);
      return;
    }
    flatFieldNumber = UserParameters.observation.nbFlats - 1;
    if ( flatFieldNumber < 0 ) flatFieldNumber = 0;
    setValues(flatFieldNumber);
  }

  private void setValues(int number) {
    Cible flatField = UserParameters.observation.extraFlats[ number ];
    jTextField20.setText(Integer.toString(number+1)+" of "+Integer.toString(UserParameters.observation.nbFlats));
    jComboBoxFitsMode.setSelectedItem(new Integer(flatField.fitsMode));

    boolean noanalyzer = UserParameters.paramFits.getKeyword("ANALYS").getValeur().toString().equals("NOANALYZER");
    if (noanalyzer) jTextFieldSequence.setText("");
    else jTextFieldSequence.setText(flatField.loopAnalyser);
    if (jComboBoxPolar != null) jComboBoxPolar.setEnabled(!noanalyzer);
    jButtonAdd.setEnabled(!noanalyzer);
    jButtonResetAll.setEnabled(!noanalyzer);
    polar = flatField.polar;

    jButtonResetAll.setEnabled(!noanalyzer);

    jRadioButtonTrackingSettings.setSelected(flatField.trackingSettings);
    jRadioButtonCentered.setSelected(flatField.centered);

    jTextFieldAngle.setText(Integer.toString(flatField.ang));
    jTextFieldHaxis.setText(Integer.toString(flatField.h));
    jTextFieldLaxis.setText(Integer.toString(flatField.l));
    jTextFieldLatitude.setText(flatField.latirc.getValeur().toString());
    jTextFieldLongitude.setText(flatField.longtrc.getValeur().toString());

    jTextFieldCustomName.setText(flatField.customName);
    jTextFieldNumberOfCycles.setText(Integer.toString(flatField.nbacquisition));

    int num;
    for (int i = 0 ; i < nbWave ; i++) {
      String tps;
      num = UserParameters.acquisition.listeWin.getWin(i);
      if (flatField.integrationTime[ i ]==-1)
        tps = "300"; 
      else
        tps = Integer.toString(flatField.integrationTime[num]);
      waveLines[ i ].jTextFieldTime.setText(tps);
      waveLines[ i ].jCheckBoxWave.setSelected(flatField.winUsed[num]);
      checkIntgTime(waveLines[i].jTextFieldTime);
    }

    jRadioButtonUserSettings_stateChanged(null);
    jRadioButtonUserSpecified_stateChanged(null);
  }

  private void getValues(int number) {
    Cible flatField = UserParameters.observation.extraFlats[ number ];
    flatField.fitsMode = ((Integer)(jComboBoxFitsMode.getSelectedItem())).intValue();

    flatField.trackingSettings = jRadioButtonTrackingSettings.isSelected();
    flatField.centered = jRadioButtonCentered.isSelected();

    flatField.ang = Integer.parseInt(jTextFieldAngle.getText());
    flatField.h = Integer.parseInt(jTextFieldHaxis.getText());
    flatField.l = Integer.parseInt(jTextFieldLaxis.getText());
    flatField.latirc.setValeur(jTextFieldLatitude.getText());
    flatField.longtrc.setValeur(jTextFieldLongitude.getText());
    flatField.latstart.setValeur(jTextFieldLatitude.getText());
    flatField.lngstart.setValeur(jTextFieldLongitude.getText());
    flatField.loopAnalyser = jTextFieldSequence.getText();
    flatField.sequence.setValeur(jTextFieldSequence.getText());
    flatField.customName = jTextFieldCustomName.getText();
    flatField.nbacquisition = Integer.parseInt(jTextFieldNumberOfCycles.getText());

    int num;
    for (int i = 0 ; i < nbWave ; i++) {
      num = UserParameters.acquisition.listeWin.getWin(i);
      flatField.winUsed[num] = waveLines[ i ].jCheckBoxWave.isSelected();
      flatField.integrationTime[num] = Integer.parseInt(waveLines[ i ].jTextFieldTime.getText());
    }
  }

  public void gainedFocus() {
    jPanelUsedWaveLength.removeAll();
    initJComboBoxPolar();
    litWave();
    jPanelFlatField.validate();
    setValues(flatFieldNumber);
  }

  public void lostFocus() throws NumberFormatException {
    getValues(flatFieldNumber);
  }

  private void litWave() {
    int i;
    String[] waveString = UserParameters.acquisition.listeWin.getWaveString();
    Cible flatField = UserParameters.observation.extraFlats[ flatFieldNumber ];
    int num;
    for (i = 0 ; i < UserParameters.acquisition.listeWin.getNbWin() ; i++) {
      num = UserParameters.acquisition.listeWin.getWin(i);
      waveLines[ i ] = new WaveLine(flatField.winUsed[num], waveString[ i ], flatField.integrationTime[num]);
      jPanelUsedWaveLength.add(waveLines[ i ], new GridBagConstraints(0, i, 1, 1, 0.0, 0.0
              ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
      JTextField jtf = waveLines[i].jTextFieldTime;
      jtf.setInputVerifier(new Verif(Verif.TYPEINT,0));
      jtf.addFocusListener(new java.awt.event.FocusAdapter() {
	public void focusLost(FocusEvent e) { checkIntgTime(e.getComponent()); }
      });
    }
    jPanelUsedWaveLength.add(jPanel20, new GridBagConstraints(0, i, 1, 1, 1.0, 1.0,
      GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    nbWave = i;
  }

/**
 * Cette fonction s'assure :
 * - qu'il n'y a pas des temps d'int\uFFE9gration diff\uFFE9rents pour un m\uFFEAme
 * obturateur. Remarque : des cam\uFFE9ras diff\uFFE9rentes peuvent avoir le
 * m\uFFEAme obturateur.
 * - tintg > 300 pour l'obtu 7 et > 10 pour les autres.
 * Cette fonction est appel\uFFE9 d\uFFE8s qu'un jTextFieldTime perd le focus.
 */
  private void checkIntgTime(Component c) {
    int i;
    int obtu1 = 0, obtu2 = 0;
    int time1 = Integer.parseInt( ((JTextField)c).getText() ), time2 = 0;

  // on r\uFFE9cup\uFFE8re le num\uFFE9ro de waveline = le num\uFFE9ro de cam\uFFE9ra
    for (i = 0 ; i < nbWave ; i++)
      if (waveLines[i].jTextFieldTime == c) break;
    obtu1 = UserParameters.acquisition.listeCam.getListe()[UserParameters.acquisition.listeWin.getListe()[i].getCam()].numShutter.intValue();

    if (time1 < 10) time1 = 10;
    if ((obtu1 == 7) && (time1 < 300)) time1=300; 
    
  // boucle : si on trouve une autre cam\uFFE9ra avec le m\uFFEAme obturateur, on v\uFFE9rifie le temps
    for (int j = 0; j < nbWave ; j++) {
      obtu2 = UserParameters.acquisition.listeCam.getListe()[UserParameters.acquisition.listeWin.getListe()[j].getCam()].numShutter.intValue();
      if (obtu1 == obtu2) {
        time2 = Integer.parseInt(waveLines[j].jTextFieldTime.getText());
        if (time2 != time1) 
          waveLines[j].jTextFieldTime.setText(Integer.toString(time1));
      }
    }
  }

  void jButtonAdd_actionPerformed() {
    polar.add(jComboBoxPolar.getSelectedItem());
    jTextFieldSequence.setText(jTextFieldSequence.getText()
      +jComboBoxPolar.getSelectedItem()+" | ");
  }
/*
  void jButtonAnalyser_actionPerformed(String polari) {
    jTextFieldSequence.setText(jTextFieldSequence.getText()+polari);
  }
*/
  private void jRadioButtonUserSettings_stateChanged(ChangeEvent e) {
    boolean v = jRadioButtonUserSettings.isSelected();
    jTextFieldAngle.setEnabled(v);
    jTextFieldHaxis.setEnabled(v);
    jTextFieldLaxis.setEnabled(v);
  }

  private void jRadioButtonUserSpecified_stateChanged(ChangeEvent e) {
    boolean v = jRadioButtonUserSpecified.isSelected();
    jTextFieldLatitude.setEnabled(v);
    jTextFieldLongitude.setEnabled(v);
  }
}
