/**
 * Title:        Interface-Utilisateur<p>
 * Description:  Programmation d'une interface-utilisateur pour le telescope.<p>
 * Copyright:    Copyright (c) Miguel-Grassin-Minec-Debin<p>
 * Company:      Themis<p>
 * @author Miguel-Grassin-Minec-Debin
 * @version 1.0
 */

package iu;

import java.awt.*;
import java.text.*;
import javax.swing.*;
import javax.swing.border.*;

public class FitsPanel extends JPanel {
//  GridBagLayout gridBagLayout1 = new GridBagLayout();
  BorderLayout borderLayoutThis = new BorderLayout();
  JScrollPane jScrollPaneFits = new JScrollPane();
  JPanel jPanelFits = new JPanel();
  GridBagLayout gridBagLayout2 = new GridBagLayout();
  ParamLine[] listeParamLine = new ParamLine[ 256 ];
  JComboBox jComboBoxSel;
  JLabel[] listeLabel = new JLabel[ 256 ];
  String type;
  LoadDriver loadDriver;

  public FitsPanel(String type) {
    this.type = type;
    try { jbInit(); }
    catch(Exception e) { e.printStackTrace(); }
  }

  private void jbInit() throws Exception {
    setLayout(borderLayoutThis);
    jPanelFits.setLayout(gridBagLayout2);

    jScrollPaneFits.getViewport().add(jPanelFits, null);
    this.add(jScrollPaneFits);

    construitListe();
  }

  /**
   * Ne sont pas affiches les mots-cles a valeur fixe, c'est-a-dire :
   * nbValeursPossibles=1 et modifiable=false
   */
  private void construitListe() throws java.sql.SQLException {
    int j = 0;

    // menu deroulant permettant de choisir directement
    if (type.equals(Keyword.SOURCEOBS)) {
      loadDriver = new LoadDriver();
      loadDriver.connect();
      jComboBoxSel = new JComboBox( loadDriver.getList() );
      jPanelFits.add(jComboBoxSel, new GridBagConstraints(0, j, 2, 1, 1.0, 0.0
        ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
      j++;
      jComboBoxSel.addItemListener(new java.awt.event.ItemListener() {
        public void itemStateChanged(java.awt.event.ItemEvent e) {
          if (e.getStateChange()==java.awt.event.ItemEvent.SELECTED) selection(true);
        }
      });
    }

    for ( int i = 0 ; i < UserParameters.paramFits.getNbKeyword() ; i++ ) {
      Keyword keyword = UserParameters.paramFits.keywordList[i];
      if ( keyword.source.equals( type ) &&
        !((keyword.nbvaleurpossible.intValue()==1) && !keyword.isModifiable()) ) {
        j++;
        listeLabel[i] = new JLabel(keyword.signification);
        jPanelFits.add(listeLabel[i],
          new GridBagConstraints(0, j, 1, 1, 1.0, 0.0, GridBagConstraints.EAST,
          GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        listeLabel[i].setToolTipText(keyword.keyword);
        if (keyword.getType() == Keyword.TYPETEXT)
        // TYPETEXT : TextArea
          listeParamLine[i] = new ParamLine( keyword.keyword);
        // autres cas : suivant le nombre de valeurs possibles (TextField ou ComboBox)
        else switch ( keyword.nbvaleurpossible.intValue() ) {
          case 0 :
            listeParamLine[i] = new ParamLine( keyword.keyword,
              keyword.modifiable.intValue(), new String("") );
            break;
          case 1 :
            //if (keyword.isModifiable())
            listeParamLine[i] = new ParamLine( keyword.keyword,
              keyword.modifiable.intValue(), keyword.listeValeurpossible[0] );
            break;
          default :
	    if ((keyword.getType()==keyword.TYPEINT)||(keyword.getType()==keyword.TYPEFLOAT))
	      listeParamLine[i] = new ParamLine( keyword.keyword,
                keyword.modifiable.intValue(), keyword.listeValeurpossible[0] );
	    else
	      listeParamLine[i] = new ParamLine( keyword.keyword,
                keyword.modifiable.intValue(), keyword.listeValeurpossible );
            break;
        }
        //cif (listeParamLine[i] != null)
	jPanelFits.add(listeParamLine[i], new GridBagConstraints(1, j, 1, 1, 1.0, 0.0
          ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
	  
	switch (keyword.getType()) {
	case Keyword.TYPEINT :
	  listeParamLine[i].jComponent.setInputVerifier(new Verif(keyword.getType(),
            ((Integer)keyword.listeValeurpossible[1]).intValue(), 
            ((Integer)keyword.listeValeurpossible[2]).intValue()));
	  break;
	case Keyword.TYPEFLOAT :
	  ((JTextField)listeParamLine[i].jComponent).setInputVerifier(new Verif(Verif.TYPEFLOAT,
            ((Float)keyword.listeValeurpossible[1]).floatValue(), 
            ((Float)keyword.listeValeurpossible[2]).floatValue()));
	  break;
	}
      }
    }

    // selection par defaut
    if (type.equals(Keyword.SOURCEOBS)) { 
      selection(false);
      loadDriver.deconnect();
    }
  }

  private void selection(boolean set) {
    try {
      String[] sel = loadDriver.select( jComboBoxSel.getSelectedIndex() );
/* OBS_PROG, CONTACT & AUTHOR, INSTITUT, EMAIL, PROG_ID, CMP_TYPE */

      UserParameters.paramFits.getKeyword("OBS_PROG").setValeur(sel[0]);
      UserParameters.paramFits.getKeyword("CONTACT").setValeur(sel[1]);
      UserParameters.paramFits.getKeyword("AUTHOR").setValeur(sel[1]);
      UserParameters.paramFits.getKeyword("INSTITUT").setValeur(sel[2]);
      UserParameters.paramFits.getKeyword("EMAIL").setValeur(sel[3]);
      if(set)
	UserParameters.paramFits.getKeyword("PROG_ID").setValeur(sel[4]);
      else
	UserParameters.paramFits.getKeyword("PROG_ID").setValeur(sel[4].substring(0,(sel[4]).length()-1));
      UserParameters.paramFits.getKeyword("CMP_TYPE").setValeur(sel[5]);
      actualiseListe();
    }
    catch (java.sql.SQLException e) { System.err.println(e); }
  }

  private void actualiseListe() {
    for ( int i = 0 ; i < UserParameters.paramFits.getNbKeyword() ; i++ )
      if ( UserParameters.paramFits.keywordList[i].source.equals( type ) )
        if ( listeParamLine[i] != null )
          listeParamLine[i].setText(UserParameters.paramFits.keywordList[i].getValeur());
  }

  public void gainedFocus() {
    if (type.equals(Keyword.SOURCEOBS)) loadDriver.connect(); 
    actualiseListe();
  }

  public void lostFocus() throws Exception {
    if (type.equals(Keyword.SOURCEOBS)) loadDriver.deconnect();
//    catch (NullPointerException e) { AppIU.setStatus("Error : "+e.getMessage()); }
    getValues();
  }

  private void getValues() throws Exception {
    String chaine = "";
    ListeKeyword fits = UserParameters.paramFits;
    for ( int i = 0 ; i < fits.getNbKeyword() ; i++ )
      if ( fits.keywordList[i].source.equals( type ) )
        if ( listeParamLine[i] != null ) {
          chaine = new String(listeParamLine[i].getText());
          if (chaine.length() > Formatage.TAILLEMAX) {
            ( (JTextField)(listeParamLine[i].jComponent) ).selectAll();
            throw new Exception("The string is too long.");
          }
          try { fits.keywordList[i].setValeur( listeParamLine[i].getText() ); }
          catch (NumberFormatException e) {
            ( (JTextField)(listeParamLine[i].jComponent) ).selectAll();
            throw new NumberFormatException(fits.keywordList[i].keyword+"="+chaine);
        }
      }
  }

}
